/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cmd;

import oracle.sysman.ccr.collector.cmd.CipherTextRegistrationInfo;
import oracle.sysman.ccr.collector.cmd.CollectorCmd;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.security.AuthenticationFailure;
import oracle.sysman.ccr.collector.security.CSIAuthenticationKey;
import oracle.sysman.ccr.collector.security.SecurityMgr;
import oracle.sysman.ccr.collector.util.UplinkSystemConfig;
import oracle.sysman.ccr.collector.util.UplinkSystemConfigWriter;
import oracle.sysman.ccr.common.ConfigWriter;
import oracle.sysman.ccr.common.FileReadException;
import oracle.sysman.ccr.common.FileWriteException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.OCMEndPoint;
import oracle.sysman.ccr.netmgr.RegistrationKeyDoc;

public class CSIRegistrationInfo
extends CipherTextRegistrationInfo {
    private static final Logger s_logger = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$cmd$CSIRegistrationInfo == null ? (class$oracle$sysman$ccr$collector$cmd$CSIRegistrationInfo = CSIRegistrationInfo.class$("oracle.sysman.ccr.collector.cmd.CSIRegistrationInfo")) : class$oracle$sysman$ccr$collector$cmd$CSIRegistrationInfo));
    private String m_strCSI;
    private String m_strMLID;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$cmd$CSIRegistrationInfo;

    CSIRegistrationInfo(String string, String string2, int n, String string3) {
        super(string3);
        this.m_strCSI = string;
        this.m_strMLID = string2;
    }

    CSIRegistrationInfo(String string, String string2, String string3) {
        super(string3);
        this.m_strCSI = string;
        this.m_strMLID = string2;
    }

    CSIRegistrationInfo(String string, String string2) {
        super(string2);
        this.m_strCSI = string;
        this.m_strMLID = "UNKNOWN";
    }

    public String getCSI() {
        return this.m_strCSI;
    }

    public String getMLID() {
        return this.m_strMLID;
    }

    public int registrationType() {
        return 2;
    }

    public int getCountryCode() {
        return -99;
    }

    public static CSIRegistrationInfo authenticateAndPersist(String string, String string2) throws NetworkException, CommandException, FileWriteException, FileReadException {
        OCMEndPoint oCMEndPoint = new OCMEndPoint(CollectorCmd.getEndpointAddr());
        String string3 = oCMEndPoint.authenticateUser(string, string2);
        CSIRegistrationInfo.persistRegistrationInfo(string2, string3);
        UplinkSystemConfig.reload();
        return new CSIRegistrationInfo(string2, string, string3);
    }

    public static CSIRegistrationInfo persist(String string, String string2) throws NetworkException, CommandException, FileWriteException, FileReadException {
        CSIRegistrationInfo.persistRegistrationInfo(string, string2);
        return new CSIRegistrationInfo(string, string2);
    }

    static void persistRegistrationInfo(String string, String string2) throws FileReadException, FileWriteException {
        ConfigWriter configWriter = UplinkSystemConfigWriter.getInstance();
        configWriter.remove("ccr.metalink_id", true);
        configWriter.remove("ccr.support_id", true);
        configWriter.remove("ccr.country_code", true);
        configWriter.setProperty("ccr.registration_mode", "csi");
        configWriter.setProperty("ccr.support_id", string);
        configWriter.setProperty("ccr.registration_ct", string2);
        configWriter.persistProperties();
    }

    public void registerInstallation(OCMEndPoint oCMEndPoint, String string, String string2, String string3) throws AuthenticationFailure, NetworkException {
        SecurityMgr securityMgr = SecurityMgr.getInstance();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)"Registering in CSI mode");
        }
        RegistrationKeyDoc registrationKeyDoc = oCMEndPoint.registerUser(this.getCipherText(), string, string2, string3);
        securityMgr.setAuthenticationKey(new CSIAuthenticationKey(registrationKeyDoc, this));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

