/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cmd;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cmd.CollectCommandException;
import oracle.sysman.ccr.collector.cmd.CollectorCmd;
import oracle.sysman.ccr.collector.cmd.CollectorCmdMsgID;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.cmd.CommandQualifier;
import oracle.sysman.ccr.collector.collectionMgr.CollectionMgr;
import oracle.sysman.ccr.collector.security.AuthenticationFailure;
import oracle.sysman.ccr.collector.softwareMgr.SoftwareMgr;
import oracle.sysman.ccr.collector.targets.TargetManager;
import oracle.sysman.ccr.collector.util.Hostname;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.ocmSDK.component.Component;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;

public class CollectCmd
extends CollectorCmd {
    static Logger s_log = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$cmd$CollectCmd == null ? (class$oracle$sysman$ccr$collector$cmd$CollectCmd = CollectCmd.class$("oracle.sysman.ccr.collector.cmd.CollectCmd")) : class$oracle$sysman$ccr$collector$cmd$CollectCmd));
    static MessageBundle s_msgBundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.cmd.CollectorCmd");
    private static final String DEFAULT_DISCONNECTED_CONFIG_JAR = "ocmconfig.jar";
    public static final String COMMAND = "collect";
    public static final String ANNOTATION_QUALIFIER = "annotation";
    public static final String PATH_QUALIFIER = "jarfile";
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$cmd$CollectCmd;

    public CollectCmd() {
    }

    public CollectCmd(boolean bl) {
        super(bl);
    }

    public int processRequest() throws CommandException {
        Object object;
        try {
            this.preProcessRequest();
        }
        catch (AuthenticationFailure authenticationFailure) {
            throw new CollectCommandException("Unable to perform a configuration collection.", (Throwable)((Object)authenticationFailure));
        }
        TargetManager targetManager = TargetManager.getInstance();
        CollectionMgr collectionMgr = CollectionMgr.getInstance();
        collectionMgr.clearCollectionUpload();
        collectionMgr.clearCollectionReviewFiles();
        File file = null;
        String string = null;
        if (Collector.isDisconnected()) {
            collectionMgr.clearCollectionState();
            if (Collector.qualifierSpecified(PATH_QUALIFIER)) {
                object = Collector.getQualifier(PATH_QUALIFIER);
                string = ((CommandQualifier)object).getQualifierValue();
                if (string == null) {
                    throw new CollectCommandException(s_msgBundle.getMessage(CollectorCmdMsgID.FILE_NOT_SPECIFIED, false));
                }
                file = new File(string);
            } else {
                object = FileSpec.catfile((String[])new String[]{Collector.getCCRConfigHome(), UplinkPath.STATE_UPLOAD_PATH});
                file = new File((String)object, DEFAULT_DISCONNECTED_CONFIG_JAR);
            }
            if (file.exists()) {
                if (file.isDirectory()) {
                    object = s_msgBundle.getMessage(CollectorCmdMsgID.DISCONNECTED_CONFIG_ISDIR, false, new Object[]{string});
                    throw new CollectCommandException((String)object);
                }
                file.delete();
            }
        }
        targetManager.processTargets();
        targetManager.processTargetMetadata();
        collectionMgr.processCollections();
        collectionMgr.collectConfigMetricData();
        if (Collector.isDisconnected()) {
            object = null;
            try {
                try {
                    object = new FileOutputStream(file);
                    CollectCmd.createConfigJar((FileOutputStream)object, string);
                }
                catch (SecurityException securityException) {
                    collectionMgr.clearCollectionUpload();
                    throw new CommandException(s_msgBundle.getMessage(CollectorCmdMsgID.UPLOAD_DIR_ACCESS, false, new Object[]{string}), (Throwable)securityException);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    collectionMgr.clearCollectionUpload();
                    throw new CommandException(s_msgBundle.getMessage(CollectorCmdMsgID.JARFILE_NOT_FOUND, false, new Object[]{string}), (Throwable)fileNotFoundException);
                }
                finally {
                    if (object != null) {
                        ((FileOutputStream)object).close();
                    }
                }
            }
            catch (IOException iOException) {
                collectionMgr.clearCollectionUpload();
                throw new CommandException(s_msgBundle.getMessage(CollectorCmdMsgID.IO_ERR_CLOSING_JAR, false, new Object[]{string}), (Throwable)iOException);
            }
            targetManager.clearTemporaryCollectionState();
        }
        return 0;
    }

    public String toString() {
        return COMMAND;
    }

    private static void createConfigJar(FileOutputStream fileOutputStream, String string) throws CommandException {
        String string2 = FileSpec.catfile((String[])new String[]{Collector.getCCRConfigHome(), UplinkPath.STATE_UPLOAD_PATH});
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".ser");
            }
        };
        FilenameFilter filenameFilter2 = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".xml");
            }
        };
        SoftwareMgr softwareMgr = SoftwareMgr.getInstance();
        Component[] componentArray = softwareMgr.getDeployedComponents();
        StringBuffer stringBuffer = new StringBuffer("Manifest-Version: 1.0\n");
        for (int i = 0; i < componentArray.length; ++i) {
            stringBuffer.append(componentArray[i].getComponentName()).append("-version: ").append(componentArray[i].getComponentVersion()).append("\n");
        }
        String string3 = System.getProperty("os.name");
        if (string3.startsWith("Windows")) {
            string3 = "Windows";
        }
        stringBuffer.append("OracleHome: ").append(System.getProperty("ORACLE_HOME")).append("\n").append("HostName: ").append(Hostname.getHostname()).append("\n").append("OracleConfigHome: ").append(Collector.getConfigHome()).append("\n").append("platform: ").append(string3).append("\n").append("platform-version: ").append(System.getProperty("os.version")).append("\n").append("platform-arch: ").append(System.getProperty("os.arch")).append("\n").append("java-version: ").append(System.getProperty("java.version")).append("\n");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes());
        try {
            File file = new File(string2);
            File[] fileArray = file.listFiles(filenameFilter2);
            File[] fileArray2 = file.listFiles(filenameFilter);
            byte[] byArray = new byte[512];
            JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)fileOutputStream, new Manifest(byteArrayInputStream));
            for (int i = 0; i < fileArray.length; ++i) {
                int n;
                JarEntry jarEntry = new JarEntry(fileArray[i].getName());
                jarEntry.setTime(fileArray[i].lastModified());
                jarOutputStream.putNextEntry(jarEntry);
                FileInputStream fileInputStream = new FileInputStream(fileArray[i]);
                while ((n = fileInputStream.read(byArray)) > 0) {
                    jarOutputStream.write(byArray, 0, n);
                }
                fileInputStream.close();
                fileArray[i].deleteOnExit();
                fileArray2[i].deleteOnExit();
            }
            jarOutputStream.close();
        }
        catch (ZipException zipException) {
            throw new CommandException(s_msgBundle.getMessage(CollectorCmdMsgID.ERR_CREATING_JAR, false, new Object[]{string}), (Throwable)zipException);
        }
        catch (IOException iOException) {
            throw new CommandException(s_msgBundle.getMessage(CollectorCmdMsgID.IO_ERR_CREATING_JAR, false, new Object[]{string}), (Throwable)iOException);
        }
        catch (Exception exception) {
            throw new CommandException(s_msgBundle.getMessage(CollectorCmdMsgID.CREATE_CONFIG_ERR, false, new Object[]{string}), (Throwable)exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

