/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cmd;

import HTTPClient.ParseException;
import HTTPClient.URI;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cmd.CollectorCmdMsgID;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.cmd.InvalidQualifierException;
import oracle.sysman.ccr.collector.security.AuthenticationFailure;
import oracle.sysman.ccr.collector.security.SecurityMgr;
import oracle.sysman.ccr.collector.softwareMgr.SoftwareMgr;
import oracle.sysman.ccr.collector.softwareMgr.SoftwareUpdateException;
import oracle.sysman.ccr.collector.util.UplinkSystemConfig;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.CSIMismatchException;
import oracle.sysman.ccr.common.exception.CredentialsNotFoundException;
import oracle.sysman.ccr.common.exception.InternalException;
import oracle.sysman.ccr.common.exception.InvalidCredentialsException;
import oracle.sysman.ccr.common.exception.InvalidEndPointException;
import oracle.sysman.ccr.common.exception.InvalidRequestException;
import oracle.sysman.ccr.common.exception.InvalidSRException;
import oracle.sysman.ccr.common.exception.KeyMismatchException;
import oracle.sysman.ccr.common.exception.MessageFormatException;
import oracle.sysman.ccr.common.exception.NoSuchReqException;
import oracle.sysman.ccr.common.exception.SRClosedException;
import oracle.sysman.ccr.common.exception.SRFormatException;
import oracle.sysman.ccr.common.exception.network.InvalidResponseException;
import oracle.sysman.ccr.common.exception.network.InvalidSessionException;
import oracle.sysman.ccr.common.exception.network.NotSupportedException;
import oracle.sysman.ccr.common.exception.network.ServerException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.diagnostic.common.exception.AlreadyUploadedException;
import oracle.sysman.ccr.diagnostic.common.exception.DuplicateUploadException;
import oracle.sysman.ccr.diagnostic.common.exception.UploadReqExistsException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.InvalidPackageException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.PackageAccessException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.PackageModifiedException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.PackageNotFoundException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.InvalidStateException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.StateAccessException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.StateCreationException;
import oracle.sysman.ccr.netmgr.EndPointAddr;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.SessionTimeoutLimitException;
import oracle.sysman.ccr.ocmSDK.component.Component;
import oracle.sysman.ccr.ocmSDK.component.ComponentStateException;

public abstract class CollectorCmd {
    private boolean m_bExplicitlyRequested;
    private static MessageBundle m_bundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.cmd.CollectorCmd");
    private static Logger s_log = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$cmd$CollectorCmd == null ? (class$oracle$sysman$ccr$collector$cmd$CollectorCmd = CollectorCmd.class$("oracle.sysman.ccr.collector.cmd.CollectorCmd")) : class$oracle$sysman$ccr$collector$cmd$CollectorCmd));
    public static final int CCR_SUCC = 0;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$cmd$CollectorCmd;

    public CollectorCmd() {
        this.m_bExplicitlyRequested = false;
    }

    public CollectorCmd(boolean bl) {
        this.m_bExplicitlyRequested = bl;
    }

    protected boolean cmdExplicitlyRequested() {
        return this.m_bExplicitlyRequested;
    }

    public boolean isInternalCommand() {
        return false;
    }

    public abstract int processRequest() throws CommandException, InvalidQualifierException, SRFormatException, PackageNotFoundException, InternalException, StateCreationException, StateAccessException, UploadReqExistsException, DuplicateUploadException, InvalidEndPointException, NetworkException, KeyMismatchException, AlreadyUploadedException, PackageAccessException, PackageModifiedException, InvalidResponseException, SessionTimeoutLimitException, InvalidStateException, InvalidRequestException, ServerException, InvalidSessionException, InvalidSRException, MessageFormatException, NoSuchReqException, NotSupportedException, CredentialsNotFoundException, InvalidCredentialsException, UploadReqExistsException, SRClosedException, CSIMismatchException, InvalidPackageException;

    public abstract String toString();

    protected URI getEndpointUri(String string) throws CommandException {
        URI uRI = CollectorCmd.getEndpointUri();
        URI uRI2 = null;
        try {
            uRI2 = new URI(uRI.getScheme(), uRI.getHost(), uRI.getPort(), string);
        }
        catch (ParseException parseException) {
            throw new CommandException("Unable to construct URI for Oracle Configuration Manager connection", (Throwable)parseException);
        }
        return uRI2;
    }

    public static URI getEndpointUri() throws CommandException {
        try {
            EndPointAddr endPointAddr = UplinkSystemConfig.getOCMServiceEndPoint();
            String string = endPointAddr.getEndPointString();
            if (string == null) {
                throw new CommandException("Oracle Configuration Manager endpoint unknown");
            }
            return endPointAddr.getURI();
        }
        catch (ParseException parseException) {
            throw new CommandException("Invalid Oracle Configuration Manager endpoint.");
        }
    }

    public static EndPointAddr getEndpointAddr() throws CommandException {
        try {
            EndPointAddr endPointAddr = UplinkSystemConfig.getOCMServiceEndPoint();
            if (endPointAddr == null) {
                throw new CommandException("Oracle Configuration Manager endpoint unknown");
            }
            return endPointAddr;
        }
        catch (ParseException parseException) {
            throw new CommandException("Invalid Oracle Configuration Manager endpoint.");
        }
    }

    public static boolean getEndpointIsRepeater() throws CommandException {
        try {
            EndPointAddr endPointAddr = UplinkSystemConfig.getOCMServiceEndPoint();
            boolean bl = endPointAddr.getIsRepeater();
            return bl;
        }
        catch (ParseException parseException) {
            throw new CommandException("Invalid Oracle Configuration Manager endpoint.");
        }
    }

    protected void preProcessRequest() throws CommandException, AuthenticationFailure {
        SecurityMgr.getInstance().getAuthenticationKey();
        if (!Collector.isDisconnected()) {
            this.checkMandPackagesAvailable();
        }
    }

    protected void checkMandPackagesAvailable() throws CommandException {
        SoftwareMgr softwareMgr = SoftwareMgr.getInstance();
        Component[] componentArray = null;
        try {
            componentArray = softwareMgr.getComponentDownloadList();
        }
        catch (NetworkException networkException) {
            throw new CommandException(m_bundle.getMessage(CollectorCmdMsgID.MAND_PACKAGE_UNKNOWN_AVAIL_ERR, false), (Throwable)networkException);
        }
        catch (SoftwareUpdateException softwareUpdateException) {
            throw new CommandException(m_bundle.getMessage(CollectorCmdMsgID.MAND_PACKAGE_UNKNOWN_AVAIL_ERR, false), (Throwable)((Object)softwareUpdateException));
        }
        try {
            if (softwareMgr.containsMandatoryComponent(componentArray)) {
                String string = SoftwareMgr.formatComponentList(componentArray);
                if (s_log.isEnabledFor(Logger.ERROR)) {
                    s_log.error(CollectorCmdMsgID.MAND_PACK_NAME_PENDING_DOWNLOAD, (Object[])new String[]{string});
                }
                String string2 = m_bundle.getMessage(CollectorCmdMsgID.MAND_PACK_PENDING_DOWNLOAD, false);
                throw new CommandException(string2);
            }
        }
        catch (ComponentStateException componentStateException) {
            throw new CommandException(m_bundle.getMessage(CollectorCmdMsgID.INTERNAL_ERR, false), (Throwable)componentStateException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

