/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cmd;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.TargetHomeManager;
import oracle.sysman.ccr.collector.cmd.CollectCmd;
import oracle.sysman.ccr.collector.cmd.CollectorCmd;
import oracle.sysman.ccr.collector.cmd.CollectorCmdMsgID;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.cmd.DesignateCentralCollectorCmd;
import oracle.sysman.ccr.collector.cmd.DiagClearCmd;
import oracle.sysman.ccr.collector.cmd.DiagStatusCmd;
import oracle.sysman.ccr.collector.cmd.DiagUploadCmd;
import oracle.sysman.ccr.collector.cmd.DiscoverCmd;
import oracle.sysman.ccr.collector.cmd.RegisterCmd;
import oracle.sysman.ccr.collector.cmd.RelinquishCentralCollectorCmd;
import oracle.sysman.ccr.collector.cmd.RemoveFromCentralPropsCmd;
import oracle.sysman.ccr.collector.cmd.ShowCentralCollectionCmd;
import oracle.sysman.ccr.collector.cmd.TestCmd;
import oracle.sysman.ccr.collector.cmd.UpdateCmd;
import oracle.sysman.ccr.collector.cmd.UploadCmd;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.CCRException;
import oracle.sysman.ccr.common.logging.Logger;

public class CommandDispatcher {
    private static MessageBundle s_bundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.cmd.CollectorCmd");
    private static Logger s_log = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$cmd$CommandDispatcher == null ? (class$oracle$sysman$ccr$collector$cmd$CommandDispatcher = CommandDispatcher.class$("oracle.sysman.ccr.collector.cmd.CommandDispatcher")) : class$oracle$sysman$ccr$collector$cmd$CommandDispatcher));
    private static CommandDispatcher m_instance = null;
    private ArrayList m_listCmds = new ArrayList();
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$cmd$CommandDispatcher;

    public static synchronized CommandDispatcher getInstance() {
        if (m_instance == null) {
            m_instance = new CommandDispatcher();
        }
        return m_instance;
    }

    public void addCommand(String[] stringArray) throws CommandException {
        if (stringArray.length == 0) {
            this.addCommand(new UpdateCmd());
            this.addCommand(new DiscoverCmd());
            this.addCommand(new CollectCmd());
            this.addCommand(new UploadCmd());
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                this.addCommand(stringArray[i], true);
            }
        }
    }

    public void addCommand(String string, boolean bl) throws CommandException {
        s_log.info(CollectorCmdMsgID.RECVD_COMMAND, (Object[])new String[]{string});
        if (string.equalsIgnoreCase("collect")) {
            this.addCommand(new CollectCmd(bl));
        } else if (string.equalsIgnoreCase("getupdates")) {
            this.addCommand(new UpdateCmd(bl));
        } else if (string.equalsIgnoreCase("upload")) {
            if (Collector.qualifierSpecified("diagnostic")) {
                this.addCommand(new DiagUploadCmd());
            } else {
                this.addCommand(new UploadCmd(bl));
            }
        } else if (string.equalsIgnoreCase("discover")) {
            this.addCommand(new DiscoverCmd(bl));
        } else if (string.equalsIgnoreCase("register")) {
            this.addCommand(new RegisterCmd(bl));
        } else if (string.equalsIgnoreCase("test")) {
            this.addCommand(new TestCmd(bl));
        } else if (string.equalsIgnoreCase("clear")) {
            this.addCommand(new DiagClearCmd());
        } else if (string.equalsIgnoreCase("status")) {
            this.addCommand(new DiagStatusCmd());
        } else if (string.equalsIgnoreCase("designate_as_central_collector")) {
            this.addCommand(new DesignateCentralCollectorCmd());
        } else if (string.equalsIgnoreCase("relinquish_as_central_collector")) {
            this.addCommand(new RelinquishCentralCollectorCmd());
        } else if (string.equalsIgnoreCase("remove_from_central_props")) {
            this.addCommand(new RemoveFromCentralPropsCmd());
        } else if (string.equalsIgnoreCase("show_central_collection")) {
            this.addCommand(new ShowCentralCollectionCmd());
        } else {
            throw new CommandException("Invalid collector command specified. Commands must be in the set: register, discover, collect, getupdates, upload, test, clear, status, designate_as_central_collector, relinquish_as_central_collector, remove_from_central_props, show_central_collection");
        }
    }

    private void addCommand(CollectorCmd collectorCmd) {
        s_log.info(CollectorCmdMsgID.ADDING_COMMAND, (Object[])new String[]{collectorCmd.toString()});
        this.m_listCmds.add(collectorCmd);
    }

    public int processRequests() throws CCRException {
        int n = 0;
        Iterator iterator = ((AbstractList)this.m_listCmds).iterator();
        while (iterator.hasNext() && n == 0) {
            CollectorCmd collectorCmd = (CollectorCmd)iterator.next();
            if (!(collectorCmd instanceof RegisterCmd)) {
                TargetHomeManager.syncCentralProperty();
            }
            n = collectorCmd.processRequest();
        }
        return n;
    }

    public boolean hasInternalCommand() {
        Iterator iterator = ((AbstractList)this.m_listCmds).iterator();
        while (iterator.hasNext()) {
            CollectorCmd collectorCmd = (CollectorCmd)iterator.next();
            if (!collectorCmd.isInternalCommand()) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

