/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cmd;

import java.io.File;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cmd.CollectorCmdMsgID;
import oracle.sysman.ccr.collector.cmd.DiagnosticCmd;
import oracle.sysman.ccr.collector.cmd.InvalidQualifierException;
import oracle.sysman.ccr.collector.diagnosticUpload.UploadState;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.NoSuchReqException;
import oracle.sysman.ccr.common.exception.SRFormatException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.diagnostic.common.DiagState;
import oracle.sysman.ccr.diagnostic.common.DiagnosticUtil;
import oracle.sysman.ccr.diagnostic.common.UploaderMsgID;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.InvalidStateException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.StateAccessException;

public class DiagClearCmd
extends DiagnosticCmd {
    private static Logger s_logger = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$cmd$DiagClearCmd == null ? (class$oracle$sysman$ccr$collector$cmd$DiagClearCmd = DiagClearCmd.class$("oracle.sysman.ccr.collector.cmd.DiagClearCmd")) : class$oracle$sysman$ccr$collector$cmd$DiagClearCmd));
    private static MessageBundle s_msgBundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.diagnostic.common.Uploader");
    private static MessageBundle s_cmdMsgBundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.cmd.CollectorCmd");
    public static final String COMMAND = "clear";
    private File m_stateFile = null;
    private UploadState m_state = null;
    private boolean actionTaken = false;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$cmd$DiagClearCmd;

    public int processRequest() throws InvalidQualifierException, SRFormatException, InvalidStateException, StateAccessException, NoSuchReqException {
        this.preProcessRequest();
        this.initializeParams();
        boolean bl = Collector.qualifierSpecified("completed");
        boolean bl2 = Collector.qualifierSpecified("force");
        if (this.m_SRNumber != null && this.m_pkgName != null) {
            DiagnosticUtil.validateSRFormat((String)this.m_SRNumber, (String)this.m_pkgName);
            this.m_stateFile = new File(UploadState.getStateFilePath(this.m_SRNumber, this.m_pkgName));
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)("Processing state file: " + this.m_stateFile.getAbsolutePath()), (String)this.m_SRNumber, (String)this.m_pkgName));
            }
            try {
                this.m_state = new UploadState(this.m_stateFile);
            }
            catch (NoSuchReqException noSuchReqException) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)noSuchReqException.getMessage());
                }
                String string = s_msgBundle.getMessage(UploaderMsgID.NO_SUCH_REQ, false);
                throw new NoSuchReqException(DiagnosticUtil.prefixMsg((String)string, (String)this.m_SRNumber, (String)this.m_pkgName));
            }
            catch (InvalidStateException invalidStateException) {
                if (bl2) {
                    this.clear();
                }
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)invalidStateException.getMessage());
                }
                String string = s_cmdMsgBundle.getMessage(CollectorCmdMsgID.CLEAR_FAILED, false);
                throw new InvalidStateException(DiagnosticUtil.prefixMsg((String)string, (String)this.m_SRNumber, (String)this.m_pkgName));
            }
            this.clear();
            File file = this.m_stateFile.getParentFile();
            if (!file.delete()) {
                file.deleteOnExit();
            }
        } else {
            if (!Collector.qualifierSpecified("diagnostic")) {
                String string = s_msgBundle.getMessage(UploaderMsgID.INVALID_COMMAND_NO_DIAG_QUAL, false);
                throw new InvalidQualifierException(string);
            }
            DiagState diagState = null;
            if (this.m_SRNumber != null) {
                DiagnosticUtil.validateSRFormat((String)this.m_SRNumber, (String)this.m_pkgName);
                diagState = new DiagState(Collector.getCCRConfigHome(), this.m_SRNumber, true);
            } else {
                diagState = new DiagState(Collector.getCCRConfigHome(), true);
            }
            while ((this.m_stateFile = diagState.getNextStateFile()) != null) {
                try {
                    this.m_state = new UploadState(this.m_stateFile);
                    if (bl && !this.m_state.getState().equals("COMPLETED")) continue;
                    this.clear();
                }
                catch (InvalidStateException invalidStateException) {
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)invalidStateException.getMessage());
                    }
                    if (bl2) {
                        this.clear();
                        continue;
                    }
                    String string = s_cmdMsgBundle.getMessage(CollectorCmdMsgID.CLEAR_FAILED, false);
                    String string2 = this.m_stateFile.getName().substring(0, this.m_stateFile.getName().lastIndexOf("."));
                    String string3 = DiagnosticUtil.prefixMsg((String)string, (String)this.m_stateFile.getParentFile().getName(), (String)string2);
                    System.err.println(string3);
                    s_logger.error(CollectorCmdMsgID.EXIT_ERROR_WRAPPER, (Object[])new String[]{string3});
                }
                catch (StateAccessException stateAccessException) {
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)stateAccessException.getMessage());
                    }
                    this.clear();
                }
                catch (NoSuchReqException noSuchReqException) {
                    if (!s_logger.isDebugEnabled()) continue;
                    s_logger.debug((Object)noSuchReqException.getMessage());
                }
            }
        }
        if (bl && !this.actionTaken) {
            System.out.println();
            System.out.println(s_cmdMsgBundle.getMessage(CollectorCmdMsgID.NO_COMP_UPLOAD_REQ, false));
        } else if (!this.actionTaken) {
            System.out.println();
            System.out.println(s_cmdMsgBundle.getMessage(CollectorCmdMsgID.NO_UPLOAD_REQ, false));
        } else {
            System.out.println();
            System.out.println(s_cmdMsgBundle.getMessage(CollectorCmdMsgID.CMD_SUCCESS, false));
        }
        return 0;
    }

    private void clear() {
        this.actionTaken = true;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Clearing state file: " + this.m_stateFile.getAbsolutePath()));
        }
        if (!this.m_stateFile.delete()) {
            this.m_stateFile.deleteOnExit();
        }
    }

    public String toString() {
        return COMMAND;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

