/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cmd;

import java.io.File;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cmd.CollectorCmdMsgID;
import oracle.sysman.ccr.collector.cmd.DiagnosticCmd;
import oracle.sysman.ccr.collector.cmd.InvalidQualifierException;
import oracle.sysman.ccr.collector.cmd.UploadStatus;
import oracle.sysman.ccr.collector.diagnosticUpload.UploadState;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.NoSuchReqException;
import oracle.sysman.ccr.common.exception.SRFormatException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.diagnostic.common.DiagState;
import oracle.sysman.ccr.diagnostic.common.DiagnosticUtil;
import oracle.sysman.ccr.diagnostic.common.UploaderMsgID;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.InvalidStateException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.StateAccessException;

public class DiagStatusCmd
extends DiagnosticCmd {
    private static Logger s_logger = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$cmd$DiagStatusCmd == null ? (class$oracle$sysman$ccr$collector$cmd$DiagStatusCmd = DiagStatusCmd.class$("oracle.sysman.ccr.collector.cmd.DiagStatusCmd")) : class$oracle$sysman$ccr$collector$cmd$DiagStatusCmd));
    private static MessageBundle s_msgBundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.diagnostic.common.Uploader");
    private static MessageBundle s_cmdMsgBundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.cmd.CollectorCmd");
    public static final String COMMAND = "status";
    private File m_stateFile = null;
    private UploadState m_state = null;
    private boolean actionTaken = false;
    private HashMap m_uploadStatus = null;
    private int m_startTimeLen = 0;
    private int m_submitTimeLen = 0;
    private int m_updateTimeLen = 0;
    private int m_SRLen = 0;
    private int m_pkgNameLen = 0;
    private int m_restartCntLen = 0;
    private int m_statusLen = 0;
    private int m_timeElapsedLen = 0;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$cmd$DiagStatusCmd;

    public int processRequest() throws InvalidQualifierException, SRFormatException, InvalidStateException, StateAccessException, NoSuchReqException {
        this.preProcessRequest();
        this.initializeParams();
        if (this.m_SRNumber != null && this.m_pkgName != null) {
            DiagnosticUtil.validateSRFormat((String)this.m_SRNumber, (String)this.m_pkgName);
            this.m_stateFile = new File(UploadState.getStateFilePath(this.m_SRNumber, this.m_pkgName));
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)("Processing state file: " + this.m_stateFile.getAbsolutePath()), (String)this.m_SRNumber, (String)this.m_pkgName));
            }
            try {
                this.m_state = new UploadState(this.m_stateFile);
            }
            catch (NoSuchReqException noSuchReqException) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)noSuchReqException.getMessage());
                }
                String string = s_msgBundle.getMessage(UploaderMsgID.NO_SUCH_REQ, false);
                throw new NoSuchReqException(DiagnosticUtil.prefixMsg((String)string, (String)this.m_SRNumber, (String)this.m_pkgName));
            }
            catch (InvalidStateException invalidStateException) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)invalidStateException.getMessage());
                }
                String string = s_msgBundle.getMessage(UploaderMsgID.INVALID_UPLOAD_STATE, false);
                throw new InvalidStateException(DiagnosticUtil.prefixMsg((String)string, (String)this.m_SRNumber, (String)this.m_pkgName));
            }
            this.printStatus();
        } else {
            if (!Collector.qualifierSpecified("diagnostic")) {
                String string = s_msgBundle.getMessage(UploaderMsgID.INVALID_COMMAND_NO_DIAG_QUAL, false);
                throw new InvalidQualifierException(string);
            }
            DiagState diagState = null;
            if (this.m_SRNumber != null) {
                DiagnosticUtil.validateSRFormat((String)this.m_SRNumber, (String)this.m_pkgName);
                diagState = new DiagState(Collector.getCCRConfigHome(), this.m_SRNumber, false);
            } else {
                diagState = new DiagState(Collector.getCCRConfigHome(), false);
            }
            this.m_stateFile = diagState.getNextStateFile();
            if (this.m_stateFile != null) {
                String string = null;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                String string8 = null;
                this.m_uploadStatus = new HashMap();
                string6 = s_cmdMsgBundle.getMessage(CollectorCmdMsgID.TOTAL_RESTARTS_TOP, false);
                this.m_restartCntLen = string6.length();
                string5 = s_cmdMsgBundle.getMessage(CollectorCmdMsgID.PACKAGE_NAME_TOP, false);
                this.m_pkgNameLen = string5.length();
                string = s_cmdMsgBundle.getMessage(CollectorCmdMsgID.START_TIME_TOP, false);
                this.m_startTimeLen = string.length();
                string2 = s_cmdMsgBundle.getMessage(CollectorCmdMsgID.SUBMIT_TIME_TOP, false);
                this.m_submitTimeLen = string2.length();
                string3 = s_cmdMsgBundle.getMessage(CollectorCmdMsgID.UPDATE_TIME_TOP, false);
                this.m_updateTimeLen = string3.length();
                string8 = s_cmdMsgBundle.getMessage(CollectorCmdMsgID.TIME_ELAPSED_TOP, false);
                this.m_timeElapsedLen = string8.length();
                string7 = s_cmdMsgBundle.getMessage(CollectorCmdMsgID.STATUS_TOP, false);
                this.m_statusLen = string7.length();
                string4 = s_cmdMsgBundle.getMessage(CollectorCmdMsgID.SR_NUMBER_TOP, false);
                this.m_SRLen = string4.length();
                this.m_uploadStatus.put("", new UploadStatus(string, string2, string3, string4, string5, string6, string7, string8));
                do {
                    try {
                        this.m_state = new UploadState(this.m_stateFile);
                        this.storeStatus();
                    }
                    catch (InvalidStateException invalidStateException) {
                        if (s_logger.isDebugEnabled()) {
                            s_logger.debug((Object)invalidStateException.getMessage());
                        }
                        this.storeInvalidStatus();
                    }
                    catch (StateAccessException stateAccessException) {
                        if (s_logger.isDebugEnabled()) {
                            s_logger.debug((Object)stateAccessException.getMessage());
                        }
                        this.storeAccessDeniedStatus();
                    }
                    catch (NoSuchReqException noSuchReqException) {
                        if (!s_logger.isDebugEnabled()) continue;
                        s_logger.debug((Object)noSuchReqException.getMessage());
                    }
                } while ((this.m_stateFile = diagState.getNextStateFile()) != null);
                if (this.actionTaken) {
                    this.printStatusTable();
                }
            }
        }
        if (!this.actionTaken) {
            System.out.println();
            System.out.println(s_cmdMsgBundle.getMessage(CollectorCmdMsgID.NO_UPLOAD_REQ, false));
        }
        return 0;
    }

    private void printStatus() throws InvalidStateException {
        this.actionTaken = true;
        System.out.println(s_cmdMsgBundle.getMessage(CollectorCmdMsgID.SR_NUMBER, false, new Object[]{this.m_stateFile.getParentFile().getName()}));
        System.out.println(s_cmdMsgBundle.getMessage(CollectorCmdMsgID.PACKAGE_NAME, false, new Object[]{this.m_state.getPackageName()}));
        System.out.println(s_cmdMsgBundle.getMessage(CollectorCmdMsgID.START_TIME, false, new Object[]{this.m_state.getStartTime()}));
        System.out.println(s_cmdMsgBundle.getMessage(CollectorCmdMsgID.SUBMIT_TIME, false, new Object[]{this.m_state.getSubmitTime()}));
        System.out.println(s_cmdMsgBundle.getMessage(CollectorCmdMsgID.UPDATE_TIME, false, new Object[]{this.m_state.getUpdateTime()}));
        System.out.println(s_cmdMsgBundle.getMessage(CollectorCmdMsgID.TOTAL_RESTARTS, false, new Object[]{Integer.toString(this.m_state.getRestartCount())}));
        System.out.println(s_cmdMsgBundle.getMessage(CollectorCmdMsgID.STATUS, false, new Object[]{this.getUploadStatus()}));
        try {
            System.out.println(s_cmdMsgBundle.getMessage(CollectorCmdMsgID.TIME_ELAPSED, false, new Object[]{this.getTimeElapsed()}));
        }
        catch (ParseException parseException) {
            s_logger.error((Throwable)parseException);
            String string = s_cmdMsgBundle.getMessage(UploaderMsgID.INVALID_UPLOAD_STATE, false);
            throw new InvalidStateException(DiagnosticUtil.prefixMsg((String)string, (String)this.m_stateFile.getParentFile().getName(), (String)this.m_state.getPackageName()));
        }
    }

    private void printStatusTable() {
        UploadStatus uploadStatus = null;
        Object[] objectArray = this.m_uploadStatus.keySet().toArray();
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            int n;
            uploadStatus = (UploadStatus)this.m_uploadStatus.get(objectArray[i]);
            System.out.print(uploadStatus.m_SR);
            for (n = 0; n < this.m_SRLen - uploadStatus.m_SR.length(); ++n) {
                System.out.print(" ");
            }
            System.out.print("  ");
            System.out.print(uploadStatus.m_pkgName);
            for (n = 0; n < this.m_pkgNameLen - uploadStatus.m_pkgName.length(); ++n) {
                System.out.print(" ");
            }
            System.out.print("  ");
            System.out.print(uploadStatus.m_startTime);
            for (n = 0; n < this.m_startTimeLen - uploadStatus.m_startTime.length(); ++n) {
                System.out.print(" ");
            }
            System.out.print("  ");
            System.out.print(uploadStatus.m_submitTime);
            for (n = 0; n < this.m_submitTimeLen - uploadStatus.m_submitTime.length(); ++n) {
                System.out.print(" ");
            }
            System.out.print("  ");
            System.out.print(uploadStatus.m_updateTime);
            for (n = 0; n < this.m_updateTimeLen - uploadStatus.m_updateTime.length(); ++n) {
                System.out.print(" ");
            }
            System.out.print("  ");
            System.out.print(uploadStatus.m_restartCnt);
            for (n = 0; n < this.m_restartCntLen - uploadStatus.m_restartCnt.length(); ++n) {
                System.out.print(" ");
            }
            System.out.print("  ");
            System.out.print(uploadStatus.m_status);
            for (n = 0; n < this.m_statusLen - uploadStatus.m_status.length(); ++n) {
                System.out.print(" ");
            }
            System.out.print("  ");
            System.out.print(uploadStatus.m_timeElapsed);
            System.out.println();
        }
    }

    private void storeStatus() {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        this.actionTaken = true;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)("Retrieving data from state file: " + this.m_stateFile.getAbsolutePath()), (String)this.m_stateFile.getParentFile().getName(), (String)this.m_state.getPackageName()));
        }
        if ((string = this.m_state.getStartTime()).length() > this.m_startTimeLen) {
            this.m_startTimeLen = string.length();
        }
        if ((string2 = this.m_state.getSubmitTime()).length() > this.m_submitTimeLen) {
            this.m_submitTimeLen = string2.length();
        }
        if ((string3 = this.m_state.getUpdateTime()).length() > this.m_updateTimeLen) {
            this.m_updateTimeLen = string3.length();
        }
        if ((string4 = this.m_stateFile.getParentFile().getName()).length() > this.m_SRLen) {
            this.m_SRLen = string4.length();
        }
        if ((string5 = this.m_state.getPackageName()).length() > this.m_pkgNameLen) {
            this.m_pkgNameLen = string5.length();
        }
        string6 = Integer.toString(this.m_state.getRestartCount());
        String string9 = this.getUploadStatus();
        string7 = string9;
        if (string7.length() > this.m_statusLen) {
            this.m_statusLen = string7.length();
        }
        try {
            string9 = this.getTimeElapsed();
        }
        catch (ParseException parseException) {
            s_logger.error((Throwable)parseException);
            string9 = "-";
        }
        string8 = string9;
        if (string8.length() > this.m_timeElapsedLen) {
            this.m_timeElapsedLen = string8.length();
        }
        this.storeInHashMap(new UploadStatus(string, string2, string3, string4, string5, string6, string7, string8));
    }

    private void storeInHashMap(UploadStatus uploadStatus) {
        String string = uploadStatus.m_SR;
        int n = 0;
        while (this.m_uploadStatus.containsKey(string)) {
            string = string + n;
            ++n;
        }
        this.m_uploadStatus.put(string, uploadStatus);
    }

    private void storeInvalidStatus() {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        this.actionTaken = true;
        String string9 = this.m_stateFile.getName().substring(0, this.m_stateFile.getName().lastIndexOf("."));
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)("Handling invalid state file: " + this.m_stateFile.getAbsolutePath()), (String)this.m_stateFile.getParentFile().getName(), (String)string9));
        }
        string = "";
        string2 = "";
        string3 = "";
        string4 = this.m_stateFile.getParentFile().getName();
        if (string4.length() > this.m_SRLen) {
            this.m_SRLen = string4.length();
        }
        if ((string5 = string9).length() > this.m_pkgNameLen) {
            this.m_pkgNameLen = string5.length();
        }
        string6 = "";
        String string10 = s_cmdMsgBundle.getMessage(CollectorCmdMsgID.INVALID_STATE, false);
        string7 = string10;
        if (string7.length() > this.m_statusLen) {
            this.m_statusLen = string7.length();
        }
        string8 = "";
        this.storeInHashMap(new UploadStatus(string, string2, string3, string4, string5, string6, string7, string8));
    }

    private void storeAccessDeniedStatus() {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        this.actionTaken = true;
        String string9 = this.m_stateFile.getName().substring(0, this.m_stateFile.getName().lastIndexOf("."));
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)("Handling inaccessible state: " + this.m_stateFile.getAbsolutePath()), (String)this.m_stateFile.getParentFile().getName(), (String)string9));
        }
        string = "";
        string2 = "";
        string3 = "";
        string4 = this.m_stateFile.getParentFile().getName();
        if (string4.length() > this.m_SRLen) {
            this.m_SRLen = string4.length();
        }
        if ((string5 = string9).length() > this.m_pkgNameLen) {
            this.m_pkgNameLen = string5.length();
        }
        string6 = "";
        String string10 = s_cmdMsgBundle.getMessage(CollectorCmdMsgID.ACCESS_DENIED, false);
        string7 = string10;
        if (string7.length() > this.m_statusLen) {
            this.m_statusLen = string7.length();
        }
        string8 = "";
        this.storeInHashMap(new UploadStatus(string, string2, string3, string4, string5, string6, string7, string8));
    }

    private String getUploadStatus() {
        if (this.m_state.getState().equals("COMPLETED")) {
            return this.m_state.getState();
        }
        double d = (double)this.m_state.getProgress() / (double)this.m_state.getPackageSize() * 100.0;
        DecimalFormat decimalFormat = new DecimalFormat("##.##");
        String string = decimalFormat.format(d);
        if (this.m_state.getState().equals("STARTED")) {
            return string + "% DONE";
        }
        return this.m_state.getState() + " at " + string + "%";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getTimeElapsed() throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
        Date date = null;
        Date date2 = simpleDateFormat.parse(this.m_state.getSubmitTime());
        if (this.m_state.getState().equals("COMPLETED")) {
            if (this.m_state.getEndTime() == null) return "-";
            date = simpleDateFormat.parse(this.m_state.getEndTime());
        } else {
            date = new Date();
        }
        long l = date.getTime() - date2.getTime();
        long l2 = l / 3600000L;
        long l3 = (l %= 3600000L) / 60000L;
        long l4 = (l %= 60000L) / 1000L;
        DecimalFormat decimalFormat = new DecimalFormat("00");
        return new String(decimalFormat.format(l2) + ":" + decimalFormat.format(l3) + ":" + decimalFormat.format(l4));
    }

    public String toString() {
        return COMMAND;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

