/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cmd;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Properties;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cmd.CollectorCmdMsgID;
import oracle.sysman.ccr.collector.cmd.DiagnosticCmd;
import oracle.sysman.ccr.collector.cmd.InvalidQualifierException;
import oracle.sysman.ccr.collector.diagnosticUpload.Uploader;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.CSIMismatchException;
import oracle.sysman.ccr.common.exception.CredentialsNotFoundException;
import oracle.sysman.ccr.common.exception.InternalException;
import oracle.sysman.ccr.common.exception.InvalidCredentialsException;
import oracle.sysman.ccr.common.exception.InvalidEndPointException;
import oracle.sysman.ccr.common.exception.InvalidRequestException;
import oracle.sysman.ccr.common.exception.InvalidSRException;
import oracle.sysman.ccr.common.exception.KeyMismatchException;
import oracle.sysman.ccr.common.exception.MessageFormatException;
import oracle.sysman.ccr.common.exception.NoSuchReqException;
import oracle.sysman.ccr.common.exception.SRClosedException;
import oracle.sysman.ccr.common.exception.SRFormatException;
import oracle.sysman.ccr.common.exception.network.InvalidResponseException;
import oracle.sysman.ccr.common.exception.network.InvalidSessionException;
import oracle.sysman.ccr.common.exception.network.NotSupportedException;
import oracle.sysman.ccr.common.exception.network.ServerException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.diagnostic.common.DiagnosticUtil;
import oracle.sysman.ccr.diagnostic.common.UploaderMsgID;
import oracle.sysman.ccr.diagnostic.common.exception.AlreadyUploadedException;
import oracle.sysman.ccr.diagnostic.common.exception.DuplicateUploadException;
import oracle.sysman.ccr.diagnostic.common.exception.UploadReqExistsException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.InvalidPackageException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.PackageAccessException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.PackageModifiedException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.PackageNotFoundException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.InvalidStateException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.StateAccessException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.StateCreationException;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.SessionTimeoutLimitException;
import oracle.sysman.ccr.netmgr.ValidationRequest;
import oracle.sysman.ccr.util.SecurePrompter;
import oracle.sysman.ccr.util.Utils;

public class DiagUploadCmd
extends DiagnosticCmd {
    private static Logger s_logger = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$cmd$DiagUploadCmd == null ? (class$oracle$sysman$ccr$collector$cmd$DiagUploadCmd = DiagUploadCmd.class$("oracle.sysman.ccr.collector.cmd.DiagUploadCmd")) : class$oracle$sysman$ccr$collector$cmd$DiagUploadCmd));
    private static MessageBundle s_msgBundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.diagnostic.common.Uploader");
    private static MessageBundle s_cmdMsgBundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.cmd.CollectorCmd");
    private PrintStream Stdout = new PrintStream(System.out, true);
    public static final String COMMAND = "diagupload";
    private static final String DEFAULT_VERSION = "1.0";
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$cmd$DiagUploadCmd;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processRequest() throws InvalidQualifierException, SRFormatException, PackageNotFoundException, InternalException, StateCreationException, StateAccessException, UploadReqExistsException, DuplicateUploadException, InvalidEndPointException, NetworkException, KeyMismatchException, AlreadyUploadedException, PackageAccessException, PackageModifiedException, InvalidResponseException, SessionTimeoutLimitException, InvalidStateException, InvalidRequestException, ServerException, InvalidSessionException, InvalidSRException, MessageFormatException, NoSuchReqException, NotSupportedException, CredentialsNotFoundException, InvalidCredentialsException, UploadReqExistsException, SRClosedException, CSIMismatchException, InvalidPackageException {
        File file;
        String string;
        int n;
        try {
            Object object;
            this.preProcessRequest();
            this.initializeParams();
            if (this.m_SRNumber == null && this.m_pkgName == null) {
                String string2 = s_msgBundle.getMessage(UploaderMsgID.INVALID_COMMAND_NO_SR_FILE, false);
                throw new InvalidQualifierException(string2);
            }
            if (this.m_pkgName == null) {
                String string3 = s_msgBundle.getMessage(UploaderMsgID.INVALID_COMMAND_NO_FILE, false);
                throw new InvalidQualifierException(string3);
            }
            DiagnosticUtil.validateSRFormat((String)this.m_SRNumber, (String)this.m_pkgName);
            if (Collector.qualifierSpecified("restart")) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)"Restarting diagnsotic upload.", (String)this.m_SRNumber, (String)this.m_pkgName));
                }
                object = new Uploader(this.m_SRNumber, this.m_pkgName);
                ((Uploader)((Object)object)).restart();
            } else {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)"Starting diagnsotic upload.", (String)this.m_SRNumber, (String)this.m_pkgName));
                }
                object = new ValidationRequest();
                this.prepareValidationRequest(this.m_SRNumber, (ValidationRequest)object);
                Uploader uploader = new Uploader(this.m_SRNumber, this.m_pkgName);
                uploader.start((ValidationRequest)object);
            }
            System.out.println();
            System.out.println(s_cmdMsgBundle.getMessage(CollectorCmdMsgID.CMD_SUCCESS, false));
            n = 0;
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            block9: {
                File file2;
                String string4;
                Object var4_7 = null;
                if (this.m_SRNumber == null || (string4 = DiagnosticCmd.getCRDFilePath(this.m_SRNumber)) == null || (file2 = new File(string4)).delete()) break block9;
                file2.deleteOnExit();
            }
            throw throwable;
        }
        if (this.m_SRNumber != null && (string = DiagnosticCmd.getCRDFilePath(this.m_SRNumber)) != null && !(file = new File(string)).delete()) {
            file.deleteOnExit();
        }
        return n;
    }

    private void prepareValidationRequest(String string, ValidationRequest validationRequest) throws CredentialsNotFoundException, InvalidCredentialsException, NotSupportedException {
        Properties properties = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        char[] cArray = null;
        String string6 = null;
        if (Collector.qualifierSpecified("nointeractive")) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)"nointeractive qualifier specified. Loading CRD file.");
            }
            if ((string2 = (properties = Utils.getCredInfo((String)DiagnosticCmd.getCRDFilePath(string))).getProperty("CRD_VERSION")) == null) {
                string2 = DEFAULT_VERSION;
            }
            string3 = properties.getProperty("METALINK_USER");
            string5 = properties.getProperty("METALINK_PSWD");
            string6 = properties.getProperty("CRYPT_SEED");
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)"Credentials information loaded.");
                s_logger.debug((Object)("user name: " + string3 + ", encrypted passwd: " + string5 + ", encryption key: " + string6 + ", version: " + string2));
            }
            if (string3 == null || string5 == null || string6 == null) {
                throw new InvalidCredentialsException("Invalid credentials information.");
            }
            try {
                string4 = new String(Utils.decryptValue((String)string3, (String)string6));
                cArray = Utils.decryptValue((String)string5, (String)string6);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new InvalidCredentialsException("Error occurred while de-obfuscating credentials information. Please make sure the obfuscated information is correctly provided.");
            }
        }
        string2 = DEFAULT_VERSION;
        try {
            this.Stdout.println();
            string4 = this.promptForInput(s_msgBundle.getMessage(UploaderMsgID.ML_USERNAME_PROMPT, false));
            cArray = SecurePrompter.readResponse((String)s_msgBundle.getMessage(UploaderMsgID.ML_PASSWORD_PROMPT, false));
        }
        catch (IOException iOException) {
            throw new CredentialsNotFoundException("Could not obtain credentials information.", (Throwable)iOException);
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)"Credentials information obtained and validated. Preparing validation request XML.");
        }
        validationRequest.createValidationXML(string2, string4, cArray);
    }

    String promptForInput(String string) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        this.Stdout.print(string);
        this.Stdout.flush();
        return bufferedReader.readLine().trim();
    }

    public String toString() {
        return COMMAND;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

