/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cmd;

import oracle.sysman.ccr.collector.cmd.CipherTextRegistrationInfo;
import oracle.sysman.ccr.collector.cmd.CollectorCmdMsgID;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.security.AuthenticationFailure;
import oracle.sysman.ccr.collector.security.EmailAuthenticationKey;
import oracle.sysman.ccr.collector.security.SecurityMgr;
import oracle.sysman.ccr.collector.util.UplinkSystemConfigWriter;
import oracle.sysman.ccr.common.ConfigWriter;
import oracle.sysman.ccr.common.FileReadException;
import oracle.sysman.ccr.common.FileWriteException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.OCMEndPoint;
import oracle.sysman.ccr.netmgr.RegistrationKeyDoc;

public class EmailRegistrationInfo
extends CipherTextRegistrationInfo {
    private static final Logger s_logger = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$cmd$EmailRegistrationInfo == null ? (class$oracle$sysman$ccr$collector$cmd$EmailRegistrationInfo = EmailRegistrationInfo.class$("oracle.sysman.ccr.collector.cmd.EmailRegistrationInfo")) : class$oracle$sysman$ccr$collector$cmd$EmailRegistrationInfo));
    private String m_strMetaLinkEmail;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$cmd$EmailRegistrationInfo;

    EmailRegistrationInfo(String string, String string2) {
        super(string2);
        this.m_strMetaLinkEmail = string;
    }

    public int registrationType() {
        return 0;
    }

    public String getMetaLinkEmailID() {
        return this.m_strMetaLinkEmail;
    }

    void registerInstallation(OCMEndPoint oCMEndPoint, String string, String string2, String string3) throws AuthenticationFailure, NetworkException, CommandException {
        SecurityMgr securityMgr = SecurityMgr.getInstance();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)"Registering in EMAIL mode");
        }
        RegistrationKeyDoc registrationKeyDoc = oCMEndPoint.registerUser(this.getCipherText(), string, string2, string3);
        securityMgr.setAuthenticationKey(new EmailAuthenticationKey(registrationKeyDoc, this));
        if (Boolean.TRUE.equals(registrationKeyDoc.holdsUniqueCSI())) {
            try {
                ConfigWriter configWriter = UplinkSystemConfigWriter.getInstance();
                configWriter.remove("ccr.support_id", true);
                configWriter.setProperty("ccr.support_id", registrationKeyDoc.getCSI());
                configWriter.persistProperties();
            }
            catch (FileWriteException fileWriteException) {
                throw new CommandException(CollectorCmdMsgID.ERR_WRITING, (Throwable)fileWriteException);
            }
            catch (FileReadException fileReadException) {
                throw new CommandException(CollectorCmdMsgID.ERR_READING, (Throwable)fileReadException);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

