/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cmd;

import oracle.sysman.ccr.collector.cmd.AnonRegistrationInfo;
import oracle.sysman.ccr.collector.cmd.CSIRegistrationInfo;
import oracle.sysman.ccr.collector.cmd.CollectorCmdMsgID;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.cmd.EmailRegistrationInfo;
import oracle.sysman.ccr.collector.security.AuthenticationFailure;
import oracle.sysman.ccr.collector.util.UplinkSystemConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.FileReadException;
import oracle.sysman.ccr.common.FileWriteException;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.OCMEndPoint;

public abstract class RegistrationInfo {
    static final int REGISTRATION_MODE_EMAIL = 0;
    static final int REGISTRATION_MODE_ANONYMOUS = 1;
    static final int REGISTRATION_MODE_CSI = 2;
    static final int REGISTRATION_MODE_UNKNOWN = -1;

    int registrationType() {
        return -1;
    }

    public static RegistrationInfo getRegistrationInfo() throws CommandException {
        Config config = UplinkSystemConfig.getInstance();
        String string = config.getProperty("ccr.registration_mode");
        RegistrationInfo registrationInfo = null;
        if (string == null) {
            String string2 = config.getProperty("ccr.support_id");
            String string3 = config.getProperty("ccr.metalink_id");
            try {
                registrationInfo = CSIRegistrationInfo.authenticateAndPersist(string3, string2);
            }
            catch (NetworkException networkException) {
                throw new CommandException(CollectorCmdMsgID.ERR_AUTHENTICATING_REGISTRATION, (Throwable)networkException);
            }
            catch (FileWriteException fileWriteException) {
                throw new CommandException(CollectorCmdMsgID.ERR_WRITING, (Throwable)fileWriteException);
            }
            catch (FileReadException fileReadException) {
                throw new CommandException(CollectorCmdMsgID.ERR_READING, (Throwable)fileReadException);
            }
        } else if (string.equals("csi")) {
            String string4 = config.getProperty("ccr.support_id");
            String string5 = config.getProperty("ccr.registration_ct");
            if (string4 != null && string5 != null) {
                registrationInfo = new CSIRegistrationInfo(string4, string5);
            }
        } else if (string.equals("email")) {
            String string6 = config.getProperty("ccr.metalink_email.address");
            String string7 = config.getProperty("ccr.registration_ct");
            registrationInfo = new EmailRegistrationInfo(string6, string7);
        } else if (string.equals("anon")) {
            String string8 = config.getProperty("ccr.metalink_email.address");
            registrationInfo = new AnonRegistrationInfo(string8);
        }
        return registrationInfo;
    }

    abstract void registerInstallation(OCMEndPoint var1, String var2, String var3, String var4) throws AuthenticationFailure, NetworkException, CommandException;
}

