/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cmd;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.sysman.ccr.collector.TargetHome;
import oracle.sysman.ccr.collector.TargetHomeManager;
import oracle.sysman.ccr.collector.cmd.CollectorCmd;
import oracle.sysman.ccr.collector.cmd.CollectorCmdMsgID;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.cmd.EstablishCentralCollectorCommandException;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.ResourceID;
import oracle.sysman.ccr.common.exception.CCRException;
import oracle.sysman.ccr.dsf.DsfConfigHomeNotFoundException;
import oracle.sysman.ccr.dsf.OCMCollector;

public class ShowCentralCollectionCmd
extends CollectorCmd {
    static MessageBundle s_msgBundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.cmd.CollectorCmd");
    public static final String COMMAND = "show_central_collection";

    public ShowCentralCollectionCmd() {
    }

    public ShowCentralCollectionCmd(boolean bl) {
        super(bl);
    }

    public boolean isInternalCommand() {
        return true;
    }

    public int processRequest() throws CommandException {
        TargetHomeManager targetHomeManager = TargetHomeManager.createTargetHomeManager();
        final ArrayList arrayList = new ArrayList();
        final ArrayList arrayList2 = new ArrayList();
        final ArrayList arrayList3 = new ArrayList();
        final ArrayList arrayList4 = new ArrayList();
        try {
            targetHomeManager.populateTargetHomes(false);
            if (!targetHomeManager.isDesignatedCollector() || targetHomeManager.isAnonymousCollector() && System.getProperty("ccrtest_show_anonymous_central_collection") == null) {
                return 0;
            }
            targetHomeManager.processOtherTargetHomesToBeDiscovered(new TargetHomeManager.ITargetHomeCollectionVisitor(){

                public void processTargetHomeDiscovery(TargetHome targetHome, OCMCollector oCMCollector) throws CCRException {
                    if (!targetHome.isCollectorSetup()) {
                        arrayList.add(targetHome);
                        return;
                    }
                    if (targetHome.hasUnknownCollector()) {
                        arrayList2.add(targetHome);
                        return;
                    }
                    try {
                        if (oCMCollector.isDisconnected()) {
                            arrayList3.add(oCMCollector);
                        } else if (oCMCollector.isUnauthenticated()) {
                            arrayList4.add(oCMCollector);
                        }
                    }
                    catch (DsfConfigHomeNotFoundException dsfConfigHomeNotFoundException) {
                        throw new CCRException("Internal Error", (Throwable)dsfConfigHomeNotFoundException);
                    }
                }
            }, true);
            System.out.println();
            System.out.println(s_msgBundle.getMessage(CollectorCmdMsgID.CC_PROLOG, false, (Object[])new String[]{targetHomeManager.getInputSourcesID()}));
            if (targetHomeManager.isAnonymousCollector() && System.getProperty("ccrtest_show_anonymous_central_collection") != null) {
                System.out.println("SHOWING ANONYMOUS CENTRAL COLLECTION");
            }
            if (arrayList.isEmpty() && arrayList2.isEmpty() && arrayList3.isEmpty() && arrayList4.isEmpty()) {
                System.out.println(s_msgBundle.getMessage(CollectorCmdMsgID.CC_NOTHING_TO_COLLECT, false, (Object[])new String[]{targetHomeManager.getInputSourcesID()}));
            } else {
                this.showTargetHomes(arrayList, CollectorCmdMsgID.CC_HOMES_TO_BE_COLLECTED_NOT_SETUP);
                this.showCollectors(arrayList3, CollectorCmdMsgID.CC_HOMES_TO_BE_COLLECTED_DISCONNECTED);
                this.showCollectors(arrayList4, CollectorCmdMsgID.CC_HOMES_TO_BE_COLLECTED_UNAUTHORIZED);
                this.showTargetHomes(arrayList2, CollectorCmdMsgID.CC_HOMES_TO_BE_COLLECTED_UNKNOWN);
            }
            System.out.println(s_msgBundle.getMessage(CollectorCmdMsgID.CC_EPILOG, false));
            System.out.println();
        }
        catch (Exception exception) {
            throw new EstablishCentralCollectorCommandException(s_msgBundle.getMessage(CollectorCmdMsgID.CC_SHOW_CENTRAL_COLLECTOR_ERR, false), (Throwable)exception);
        }
        return 0;
    }

    public String toString() {
        return COMMAND;
    }

    private void showTargetHomes(List list, ResourceID resourceID) {
        if (!list.isEmpty()) {
            System.out.println(s_msgBundle.getMessage(resourceID, false));
            for (int i = 0; i < list.size(); ++i) {
                TargetHome targetHome = (TargetHome)list.get(i);
                System.out.println("    " + targetHome.getLocation() + " - " + targetHome.getName());
            }
        }
    }

    private void showCollectors(List list, ResourceID resourceID) {
        if (!list.isEmpty()) {
            System.out.println(s_msgBundle.getMessage(resourceID, false));
            for (int i = 0; i < list.size(); ++i) {
                OCMCollector oCMCollector = (OCMCollector)list.get(i);
                String string = oCMCollector.getLocation() + File.separator + "ccr";
                String string2 = oCMCollector.getConfigHome();
                System.out.println("    " + s_msgBundle.getMessage(CollectorCmdMsgID.CC_COLLECTOR_DESCRIPTION, false, (Object[])new String[]{oCMCollector.getTargetHome().getLocation() + " - " + oCMCollector.getName(), oCMCollector.getConfigHome()}));
            }
        }
    }
}

