/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cmd;

import HTTPClient.HTTPConnection;
import HTTPClient.URI;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cmd.CollectorCmd;
import oracle.sysman.ccr.collector.cmd.CollectorCmdMsgID;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.cmd.RegisterCmd;
import oracle.sysman.ccr.collector.cmd.TestCmdException;
import oracle.sysman.ccr.collector.util.UplinkSystemConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.OCMEndPoint;

public class TestCmd
extends CollectorCmd {
    private static Logger s_log = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$cmd$TestCmd == null ? (class$oracle$sysman$ccr$collector$cmd$TestCmd = TestCmd.class$("oracle.sysman.ccr.collector.cmd.TestCmd")) : class$oracle$sysman$ccr$collector$cmd$TestCmd));
    static final String COMMAND = "test";
    private static final String TEST_URI = "/em/upload";
    private static final MessageBundle s_bundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.cmd.CollectorCmd");
    public static final String REGISTER_QUALIFIER = "register";
    public static final String VERBOSE_QUALIFIER = "verbose";
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$cmd$TestCmd;

    public TestCmd() {
    }

    public TestCmd(boolean bl) {
        super(bl);
    }

    public String toString() {
        return COMMAND;
    }

    public int processRequest() throws CommandException {
        UplinkSystemConfig.getInstance();
        if (Collector.qualifierSpecified(VERBOSE_QUALIFIER)) {
            System.setProperty("HTTPClient.log.mask", Integer.toString(-1));
        }
        this.execute();
        System.out.println();
        System.out.println(s_bundle.getMessage(CollectorCmdMsgID.CMD_SUCCESS, false));
        return 0;
    }

    private void execute() throws CommandException {
        String string = "Configuration Manager";
        if (CollectorCmd.getEndpointIsRepeater()) {
            string = "Support Hub";
        }
        URI uRI = null;
        System.out.println(s_bundle.getMessage(CollectorCmdMsgID.VERIFY_PROXY, false));
        this.verifyProxy();
        try {
            uRI = CollectorCmd.getEndpointUri();
            System.out.println(s_bundle.getMessage(CollectorCmdMsgID.CCR_SERVER, false, (Object[])new String[]{string, uRI.getHost()}));
        }
        catch (CommandException commandException) {
            throw new TestCmdException(s_bundle.getMessage(CollectorCmdMsgID.SERVER_ADDR_ERR, false, (Object[])new String[]{string}), (Throwable)((Object)commandException));
        }
        try {
            Config config = UplinkSystemConfig.getInstance();
            String string2 = config.getProperty("http.proxyHost");
            if (string2 == null) {
                System.out.println(s_bundle.getMessage(CollectorCmdMsgID.RESOLVE_SERVER_ADDR, false, (Object[])new String[]{string}));
                this.resolveAddr(uRI.getHost());
            } else {
                System.out.println(s_bundle.getMessage(CollectorCmdMsgID.SKIP_SERVER_ADDR_RESOLVE, false, (Object[])new String[]{string}));
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new TestCmdException(s_bundle.getMessage(CollectorCmdMsgID.SERVER_ADDR_LOOKUP_ERR, false, (Object[])new String[]{string}));
        }
        System.out.println(s_bundle.getMessage(CollectorCmdMsgID.CONNECT_SERVER, false, (Object[])new String[]{string}));
        this.connect(string);
        if (Collector.qualifierSpecified(REGISTER_QUALIFIER)) {
            System.out.println(s_bundle.getMessage(CollectorCmdMsgID.REGISTERING, false));
            new RegisterCmd().processRequest();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OCMEndPoint connect(String string) throws TestCmdException {
        OCMEndPoint oCMEndPoint = null;
        try {
            oCMEndPoint = new OCMEndPoint(CollectorCmd.getEndpointAddr());
        }
        catch (CommandException commandException) {
            throw new TestCmdException(s_bundle.getMessage(CollectorCmdMsgID.SERVER_ADDR_ERR, false, (Object[])new String[]{string}), (Throwable)((Object)commandException));
        }
        catch (NetworkException networkException) {
            throw new TestCmdException(s_bundle.getMessage(CollectorCmdMsgID.SERVER_CONNECT_ERR, false, (Object[])new String[]{string}), (Throwable)networkException);
        }
        InputStream inputStream = null;
        try {
            try {
                if (CollectorCmd.getEndpointIsRepeater()) {
                    String string2 = oCMEndPoint.processRepeaterTestRequest();
                    System.out.println(string2);
                } else {
                    inputStream = oCMEndPoint.getFile(TEST_URI);
                }
            }
            catch (NetworkException networkException) {
                throw new TestCmdException(s_bundle.getMessage(CollectorCmdMsgID.REQUEST_ERR, false), (Throwable)networkException);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new TestCmdException(s_bundle.getMessage(CollectorCmdMsgID.TEST_URI_GET_ERR, false), (Throwable)fileNotFoundException);
            }
            catch (CommandException commandException) {
                throw new TestCmdException(s_bundle.getMessage(CollectorCmdMsgID.REQUEST_ERR, false), (Throwable)((Object)commandException));
            }
            Object var6_10 = null;
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            try {
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (inputStream == null) return oCMEndPoint;
        inputStream.close();
        return oCMEndPoint;
    }

    private InetAddress resolveAddr(String string) throws TestCmdException, UnknownHostException {
        if (string == null) {
            throw new TestCmdException(s_bundle.getMessage(CollectorCmdMsgID.NO_HOSTNAME, false));
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (SecurityException securityException) {
            System.out.println(s_bundle.getMessage(CollectorCmdMsgID.NO_ADDR_LOOKUP_ALLOWED, false));
        }
        return inetAddress;
    }

    private void verifyProxy() throws TestCmdException {
        HTTPConnection hTTPConnection = null;
        hTTPConnection = new HTTPConnection("");
        String string = hTTPConnection.getProxyHost();
        if (string != null) {
            int n = hTTPConnection.getProxyPort();
            System.out.println(s_bundle.getMessage(CollectorCmdMsgID.PROXY_SETTINGS, false, (Object[])new String[]{string, String.valueOf(n)}));
            try {
                this.resolveAddr(string);
            }
            catch (UnknownHostException unknownHostException) {
                throw new TestCmdException(s_bundle.getMessage(CollectorCmdMsgID.PROXY_ADDR_LOOKUP_ERR, false));
            }
            try {
                hTTPConnection.connect();
            }
            catch (Exception exception) {
                throw new TestCmdException(s_bundle.getMessage(CollectorCmdMsgID.NO_CONNECTIVITY, false), (Throwable)exception);
            }
        }
        System.out.println(s_bundle.getMessage(CollectorCmdMsgID.NO_PROXY, false));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

