/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cmd;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cmd.CollectorCmd;
import oracle.sysman.ccr.collector.cmd.CollectorCmdMsgID;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.cmd.UploadCommandException;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResultList;
import oracle.sysman.ccr.collector.security.AuthenticationFailure;
import oracle.sysman.ccr.collector.security.AuthenticationKey;
import oracle.sysman.ccr.collector.security.SecurityMgr;
import oracle.sysman.ccr.collector.targets.Target;
import oracle.sysman.ccr.collector.targets.TargetManager;
import oracle.sysman.ccr.collector.util.AgentConfig;
import oracle.sysman.ccr.collector.util.Hostname;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.OCMEndPoint;
import oracle.sysman.ccr.netmgr.RegistrationKeyDoc;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;

public class UploadCmd
extends CollectorCmd {
    private static Logger s_log = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$cmd$UploadCmd == null ? (class$oracle$sysman$ccr$collector$cmd$UploadCmd = UploadCmd.class$("oracle.sysman.ccr.collector.cmd.UploadCmd")) : class$oracle$sysman$ccr$collector$cmd$UploadCmd));
    private static MessageBundle s_bundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.cmd.CollectorCmd");
    private static final String UPLOAD_URI = "/em/upload";
    public static final String COMMAND = "upload";
    private AuthenticationKey mAuthenticationKey;
    private boolean mAnonAuthenticationKeysWereAdded;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$cmd$UploadCmd;

    public UploadCmd() {
    }

    public UploadCmd(boolean bl) {
        super(bl);
    }

    public int processRequest() throws CommandException {
        try {
            this.preProcessRequest();
        }
        catch (AuthenticationFailure authenticationFailure) {
            throw new UploadCommandException("Unable to upload the collected configuration information.", (Throwable)((Object)authenticationFailure));
        }
        String[] stringArray = this.getXMLFileNames();
        if (stringArray.length > 0 || this.hasGCDir()) {
            Object object;
            int n;
            for (n = 0; n < stringArray.length; ++n) {
                object = new File(FileSpec.catfile((String[])new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_UPLOAD_PATH, stringArray[n]}));
                if (!((File)object).exists()) continue;
                this.uploadXMLFile((File)object);
                this.replaceFullCollection(stringArray[n], null, null);
            }
            if (this.hasGCDir()) {
                for (n = 0; n < 11; ++n) {
                    object = "" + n;
                    String[] stringArray2 = this.getGCXMLFileNames((String)object);
                    for (int i = 0; i < stringArray2.length; ++i) {
                        File file;
                        if (s_log.isEnabledFor(Logger.INFO)) {
                            s_log.info(CollectorCmdMsgID.UPLOADING_FILE, (Object[])new String[]{stringArray2[i] + " (gc)"});
                        }
                        if (!(file = new File(FileSpec.catfile((String[])new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_UPLOAD_PATH, "external", object, stringArray2[i]}))).exists()) continue;
                        this.createSerUploadingFile(stringArray2[i], String.valueOf(n));
                        this.uploadXMLFile(file);
                        this.replaceFullCollection(stringArray2[i], String.valueOf(n), "external");
                    }
                }
            }
        }
        if (this.mAnonAuthenticationKeysWereAdded) {
            try {
                this.mAuthenticationKey.persistKeyFile();
            }
            catch (AuthenticationFailure authenticationFailure) {
                throw new UploadCommandException("Unable to upload the collected configuration information.", (Throwable)((Object)authenticationFailure));
            }
        }
        TargetManager targetManager = TargetManager.getInstance();
        targetManager.clearTemporaryCollectionState();
        return 0;
    }

    public String toString() {
        return COMMAND;
    }

    private void createSerUploadingFile(String string, String string2) {
        String string3 = string.substring(0, string.lastIndexOf(".xml"));
        File file = this.createCollectionState(UplinkPath.STATE_UPLOAD_PATH, "external", string3, string2, ".ser");
        if (!file.exists()) {
            return;
        }
        File file2 = this.createCollectionState(UplinkPath.STATE_UPLOAD_PATH, "external", string3, string2, ".ser.uploading");
        file.renameTo(file2);
    }

    private void replaceFullCollection(String string, String string2, String string3) {
        String string4 = string.substring(0, string.lastIndexOf(".xml"));
        File file = this.createCollectionState(UplinkPath.STATE_PREVIOUS_PATH, string3, string4, string2, ".ser");
        String string5 = string3 == null ? ".ser" : ".ser.uploading";
        File file2 = this.createCollectionState(UplinkPath.STATE_UPLOAD_PATH, string3, string4, string2, string5);
        if (file2.exists()) {
            if (file.exists() && !file.delete()) {
                System.gc();
                file.delete();
            }
            this.moveState(file2, file);
        }
    }

    private File createCollectionState(String string, String string2, String string3, String string4, String string5) {
        if (string2 == null) {
            return new File(FileSpec.catfile((String[])new String[]{AgentConfig.getRootStateDir(), string, string3 + string5}));
        }
        return new File(FileSpec.catfile((String[])new String[]{AgentConfig.getRootStateDir(), string, string2, string4, string3 + string5}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void moveState(File file, File file2) {
        block29: {
            IOException iOException2222;
            FilterOutputStream filterOutputStream;
            BufferedInputStream bufferedInputStream;
            block27: {
                block26: {
                    bufferedInputStream = null;
                    filterOutputStream = null;
                    FileInputStream fileInputStream = new FileInputStream(file);
                    bufferedInputStream = new BufferedInputStream(fileInputStream);
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    filterOutputStream = new BufferedOutputStream(fileOutputStream);
                    int n = 0;
                    byte[] byArray = new byte[8192];
                    while ((n = bufferedInputStream.read(byArray)) > 0) {
                        ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
                    }
                    bufferedInputStream.close();
                    bufferedInputStream = null;
                    if (file.delete()) break block26;
                    System.gc();
                    if (file.delete()) break block26;
                    file.deleteOnExit();
                }
                Object var11_11 = null;
                if (filterOutputStream == null) break block27;
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException2222) {}
            }
            break block29;
            {
                catch (FileNotFoundException fileNotFoundException) {
                    IOException iOException32222;
                    if (!Collector.silentMode()) {
                        System.err.println("Unable to save collection uploaded collection state");
                        System.err.println(fileNotFoundException.getMessage());
                    }
                    Object var11_12 = null;
                    if (filterOutputStream != null) {
                        try {
                            filterOutputStream.close();
                        }
                        catch (IOException iOException32222) {
                            // empty catch block
                        }
                    }
                    if (bufferedInputStream != null) {
                        try {
                            bufferedInputStream.close();
                        }
                        catch (IOException iOException32222) {}
                    }
                    break block29;
                }
                catch (IOException iOException4) {
                    IOException iOException52222;
                    if (s_log.isEnabledFor(Logger.DEBUG)) {
                        s_log.error(CollectorCmdMsgID.STATE_COPY_ERR, (Throwable)iOException4);
                    }
                    if (!Collector.silentMode()) {
                        System.err.println("Unable to save collection upload collection state.");
                        System.err.println(iOException4.getMessage());
                    }
                    Object var11_13 = null;
                    if (filterOutputStream != null) {
                        try {
                            filterOutputStream.close();
                        }
                        catch (IOException iOException52222) {
                            // empty catch block
                        }
                    }
                    if (bufferedInputStream != null) {
                        try {
                            bufferedInputStream.close();
                        }
                        catch (IOException iOException52222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException iOException62222;
                Object var11_14 = null;
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (IOException iOException62222) {
                        // empty catch block
                    }
                }
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException62222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private String[] getXMLFileNames() {
        String string = FileSpec.catfile((String[])new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_UPLOAD_PATH});
        File file = new File(string);
        String[] stringArray = file.list(new XMLFileFilter());
        return stringArray;
    }

    private String[] getGCXMLFileNames(String string) {
        String[] stringArray = new String[]{};
        String string2 = FileSpec.catfile((String[])new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_UPLOAD_PATH, "external", string});
        File file = new File(string2);
        if (file.exists()) {
            stringArray = file.list(new XMLFileFilter());
        }
        return stringArray;
    }

    private boolean hasGCDir() {
        String string = FileSpec.catfile((String[])new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_UPLOAD_PATH, "external"});
        File file = new File(string);
        return file.exists();
    }

    private void uploadXMLFile(File file) throws CommandException {
        SecurityMgr securityMgr;
        OCMEndPoint oCMEndPoint;
        String string;
        CollectionResultList collectionResultList = null;
        boolean bl = true;
        try {
            string = file.getAbsolutePath();
            collectionResultList = CollectionResultList.inflate(string.substring(0, string.length() - 3) + "ser");
        }
        catch (FileNotFoundException fileNotFoundException) {
            s_log.debug((Object)("State file " + file.getAbsolutePath() + " does not exist to upload"), (Throwable)fileNotFoundException);
            bl = false;
        }
        catch (IOException iOException) {
            s_log.debug((Object)("Inflating state file " + file.getAbsolutePath() + " failed"), (Throwable)iOException);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            s_log.debug((Object)("Inflating state file " + file.getAbsolutePath() + " failed"), (Throwable)classNotFoundException);
            return;
        }
        string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            oCMEndPoint = new OCMEndPoint(CollectorCmd.getEndpointAddr());
        }
        catch (NetworkException networkException) {
            throw new UploadCommandException("Registering as anonymous to upload as anonymous central collector failed", (Throwable)networkException);
        }
        Target target = null;
        if (bl) {
            target = collectionResultList.getTargetInstance();
        }
        if (bl && target.isCollectedByAnonymousCentralCollector()) {
            s_log.debug((Object)(file.getAbsolutePath() + " will be uploaded by central anonymous collector."));
            securityMgr = this.getAnonymousRegistrationKey(target, oCMEndPoint);
            string3 = securityMgr.getKey();
            string4 = securityMgr.getGCID();
            string = target.getTargetHome();
            string2 = target.getConfigHome();
            s_log.debug((Object)(file.getAbsolutePath() + " uploaded by central anonymous collector: " + securityMgr));
        } else {
            string = Collector.getOracleHome();
            string2 = Collector.getConfigHome();
            securityMgr = SecurityMgr.getInstance();
            string3 = securityMgr.getAuthenticationKeyString();
            string4 = securityMgr.getCustomerOrgId();
        }
        try {
            if (s_log.isEnabledFor(Logger.INFO)) {
                s_log.info(CollectorCmdMsgID.UPLOADING_FILE, (Object[])new String[]{file.getName()});
            }
            oCMEndPoint.sendContent(file, string3, string4, Hostname.getHostname(), string, string2);
            if (!file.delete()) {
                System.gc();
                if (!file.delete()) {
                    file.deleteOnExit();
                }
            }
        }
        catch (NetworkException networkException) {
            throw new UploadCommandException("Error encountered attempting to upload to Oracle Configuration Manager content receiver", (Throwable)networkException);
        }
    }

    private RegistrationKeyDoc getAnonymousRegistrationKey(Target target, OCMEndPoint oCMEndPoint) throws CommandException {
        RegistrationKeyDoc registrationKeyDoc;
        block7: {
            registrationKeyDoc = null;
            try {
                String string;
                String string2 = target.getTargetHome();
                String string3 = target.getConfigHome();
                if (string3 == null) {
                    string3 = "";
                }
                if (this.mAuthenticationKey == null) {
                    this.mAuthenticationKey = AuthenticationKey.instantiate();
                }
                if ((string = this.mAuthenticationKey.getAnonymousColRegInfo(string2, string3)) != null) {
                    registrationKeyDoc = new RegistrationKeyDoc();
                    registrationKeyDoc.setKey(this.mAuthenticationKey.getAnonymousColRegKey(string));
                    registrationKeyDoc.setGCID(this.mAuthenticationKey.getAnonymousColRegId(string));
                    break block7;
                }
                try {
                    registrationKeyDoc = oCMEndPoint.registerAnonymous(null, Hostname.getHostname(), string2, string3);
                }
                catch (NetworkException networkException) {
                    throw new UploadCommandException("Registering as anonymous to upload as anonymous central collector failed", (Throwable)networkException);
                }
                this.mAuthenticationKey.setAnonymousColRegInfo(string2, string3, registrationKeyDoc.getKey(), registrationKeyDoc.getGCID());
                this.mAnonAuthenticationKeysWereAdded = true;
            }
            catch (AuthenticationFailure authenticationFailure) {
                throw new UploadCommandException("Registering as anonymous to upload as anonymous central collector failed", (Throwable)((Object)authenticationFailure));
            }
        }
        return registrationKeyDoc;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class XMLFileFilter
    implements FilenameFilter {
        XMLFileFilter() {
        }

        public boolean accept(File file, String string) {
            boolean bl = true;
            int n = string.lastIndexOf(".");
            if (n != -1) {
                String string2 = string.substring(n);
                bl = string2.equals(".xml");
            } else {
                bl = false;
            }
            return bl;
        }
    }
}

