/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.collectionMgr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.collectionMgr.Collection;
import oracle.sysman.ccr.collector.collectionMgr.CollectionMgr;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.PluginsMetadata;
import oracle.sysman.ccr.util.UplinkPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CollectionList
extends Vector {
    private static Logger s_log = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$collectionMgr$CollectionList == null ? (class$oracle$sysman$ccr$collector$collectionMgr$CollectionList = CollectionList.class$("oracle.sysman.ccr.collector.collectionMgr.CollectionList")) : class$oracle$sysman$ccr$collector$collectionMgr$CollectionList));
    private String m_strTargetType;
    private String m_strName;
    private String m_strLevel;
    public static final String TAGNAME = "TargetCollection";
    public static final String ATTR_NAME = "NAME";
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$collectionMgr$CollectionList;

    public CollectionList(String string) throws SAXException, FileNotFoundException {
        this.m_strTargetType = string;
        Document document = this.parseCollection();
        Element element = this.getRootElement(document);
        this.getCollectionItems(element);
    }

    private Document parseCollection() throws SAXException, FileNotFoundException {
        String string = null;
        try {
            string = PluginsMetadata.getPluginId((String)this.m_strTargetType);
        }
        catch (RuntimeException runtimeException) {
            throw new SAXException("Error reading plugins metadata for type \"" + this.m_strTargetType + "\". " + runtimeException.getMessage(), runtimeException);
        }
        File file = new File(FileSpec.catfile((String[])new String[]{Collector.getCCRRoot(), UplinkPath.getDefaultCollectionPath((String)string), this.m_strTargetType + ".xml"}));
        Document document = null;
        try {
            if (s_log.isEnabledFor(Logger.DEBUG)) {
                s_log.debug((Object)("Parsing default collection file for " + this.m_strTargetType));
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            InputSource inputSource = new InputSource(fileInputStream);
            inputSource.setSystemId(this.getSystemId(string));
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(inputSource);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (SAXException sAXException) {
            throw new SAXException("Default Collection parser failure\n" + sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new SAXException("IO Error parsing default collection for " + this.m_strTargetType + "\n" + iOException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException("Problem with configuring parser for defaultCollection for " + this.m_strTargetType + "\n" + parserConfigurationException.getMessage());
        }
        return document;
    }

    private Element getRootElement(Document document) throws SAXException {
        Element element = null;
        NodeList nodeList = document.getChildNodes();
        for (int i = 0; i < nodeList.getLength() && element == null; ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(TAGNAME) || (element2 = (Element)node).hasAttribute(ATTR_NAME)) continue;
            element = element2;
        }
        if (element == null) {
            throw new SAXException("TargetCollection root element for default collection for type " + this.m_strTargetType + " not found.");
        }
        return element;
    }

    private String getSystemId(String string) throws SAXException {
        String string2 = null;
        try {
            String[] stringArray = new String[]{Collector.getCCRRoot(), UplinkPath.getDefaultCollectionPath((String)string)};
            File file = new File(FileSpec.catfile((String[])stringArray));
            string2 = file.toURL().toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            throw new SAXException("Error in constructing URL for metadata SystemID\n" + malformedURLException.getMessage());
        }
        return string2;
    }

    private void getCollectionItems(Element element) throws SAXException {
        NodeList nodeList = element.getElementsByTagName("CollectionItem");
        CollectionMgr collectionMgr = CollectionMgr.getInstance();
        String string = null;
        boolean bl = false;
        String string2 = null;
        try {
            string2 = collectionMgr.getCollectionTargetType();
            if (string2 != null && this.m_strTargetType.equals(string2)) {
                string = collectionMgr.getCollectionItem();
            }
        }
        catch (CommandException commandException) {
            throw new SAXException(((Throwable)((Object)commandException)).getMessage());
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string3;
            Element element2;
            if (nodeList.item(i).getNodeType() != 1 || !(element2 = (Element)nodeList.item(i)).hasAttribute("AGENT_MODE") || !Collector.isApplicableForOcm(string3 = element2.getAttribute("AGENT_MODE"))) continue;
            if (string != null) {
                String string4 = element2.getAttribute(ATTR_NAME);
                if (!string.equals(string4)) continue;
                this.addCollection(new Collection(element2));
                bl = true;
                break;
            }
            this.addCollection(new Collection(element2));
        }
        if (string != null && !bl) {
            throw new SAXException("CollectionItem " + string + " not found in default collection for type " + this.m_strTargetType);
        }
    }

    private void addCollection(Collection collection) {
        this.add(collection);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

