/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.collectionMgr;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.TargetHomeManager;
import oracle.sysman.ccr.collector.cmd.CollectCommandException;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.cmd.CommandQualifier;
import oracle.sysman.ccr.collector.collectionMgr.Collection;
import oracle.sysman.ccr.collector.collectionMgr.CollectionList;
import oracle.sysman.ccr.collector.collectionMgr.CollectionMgrMsgID;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResult;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResultList;
import oracle.sysman.ccr.collector.collectionMgr.MetricCollectionLimiterMgr;
import oracle.sysman.ccr.collector.collectionMgr.XMLReviewWriter;
import oracle.sysman.ccr.collector.collectionMgr.XMLUploadWriter;
import oracle.sysman.ccr.collector.fetchlets.FetchletException;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.targets.Target;
import oracle.sysman.ccr.collector.targets.TargetManager;
import oracle.sysman.ccr.collector.targets.metadata.Metric;
import oracle.sysman.ccr.collector.targets.metadata.OCheckMetric;
import oracle.sysman.ccr.collector.targets.metadata.TargetMetadata;
import oracle.sysman.ccr.collector.util.AgentConfig;
import oracle.sysman.ccr.collector.util.Hostname;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.CCRException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.ocmSDK.component.ComponentVersion;
import oracle.sysman.ccr.ocmSDK.component.InvalidComponentVersionException;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.xml.sax.SAXException;

public class CollectionMgr {
    private static CollectionMgr s_instance = null;
    private HashMap m_hashConfigCollectionList = null;
    private Logger m_log = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$collectionMgr$CollectionMgr == null ? (class$oracle$sysman$ccr$collector$collectionMgr$CollectionMgr = CollectionMgr.class$("oracle.sysman.ccr.collector.collectionMgr.CollectionMgr")) : class$oracle$sysman$ccr$collector$collectionMgr$CollectionMgr));
    private MessageBundle m_bundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.collectionMgr.CollectionMgr");
    private final String REVIEW_TARGETS_XSL_FORMAT = "<?xml-stylesheet type=\"text/xsl\" href=\"{0}/ccr/admin/xsl/preview_targets.xsl\"?>";
    private static String s_strUploadPath = null;
    private boolean m_diagcheckDeployed = false;
    private boolean m_diagcheckJavaVersionNotSupported = false;
    private boolean m_diagcheckDisabled = false;
    private static SimpleDateFormat m_dateFormat;
    private static final String UPLOADFILE_QUALIFIER = "uploadfile";
    private String m_uploadFile = null;
    private int m_uploadFileCounter = 1;
    private static final String TARGET_COLLECTION_QUALIFIER = "collection";
    private static final String TARGET_COLLECTION_QUALIFIER_USAGE = "\nUsage: -collection=<target_name>,<target_type>[,<collection>]";
    private static final int TARGET_COLLECTION_MIN_ARGS = 2;
    private static final int TARGET_COLLECTION_MAX_ARGS = 3;
    private static final int TARGET_COLLECTION_TARGET_NAME = 0;
    private static final int TARGET_COLLECTION_TARGET_TYPE = 1;
    private static final int TARGET_COLLECTION_COLLECTION_ITEM = 2;
    private boolean m_bCollectionQualifierParsed = false;
    private Target m_collectionTarget = null;
    private String m_collectionTargetName = null;
    private String m_collectionTargetType = null;
    private String m_collectionItem = null;
    private static String XMLPATTERN;
    private static RE m_collectionSplitPattern;
    private String m_previousTarget = new String("");
    private String m_printable = null;
    private String m_morecolls = null;
    final String tailmsg = "  </Target>";
    private static final String DIAGCHECKERR_BAK = "diagchecks.err.bak";
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$collectionMgr$CollectionMgr;

    public void clearCollectionReviewFiles() {
        String string = FileSpec.catfile((String[])new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_REVIEW_PATH});
        File file = new File(string);
        String[] stringArray = file.list(new CollectionFileFilter());
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(FileSpec.catfile((String[])new String[]{string, stringArray[i]}));
            file2.delete();
        }
    }

    public void clearCollectionState() {
        String string = FileSpec.catfile((String[])new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_PREVIOUS_PATH});
        File file = new File(string);
        String[] stringArray = file.list(new CollectionStateFilter());
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(FileSpec.catfile((String[])new String[]{string, stringArray[i]}));
            file2.delete();
        }
    }

    public void clearCollectionUpload() {
        String string = FileSpec.catfile((String[])new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_UPLOAD_PATH});
        File file = new File(string);
        String[] stringArray = file.list(new CollectionFileFilter());
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(FileSpec.catfile((String[])new String[]{string, stringArray[i]}));
            file2.delete();
        }
    }

    private PrintWriter openTargetMap() throws CollectCommandException {
        File file = new File(FileSpec.catfile((String[])new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_REVIEW_PATH, "targetMap.xml"}));
        PrintWriter printWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            printWriter = new PrintWriter(fileOutputStream);
            printWriter.println(MessageFormat.format("<?xml-stylesheet type=\"text/xsl\" href=\"{0}/ccr/admin/xsl/preview_targets.xsl\"?>", Collector.getCCRRoot()));
            printWriter.println("<Targets collection_time=\"" + m_dateFormat.format(new Date()) + "\" host_name=\"" + Hostname.getHostname() + "\">");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CollectCommandException("Unable to open target Map", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new CollectCommandException("Unable to write to targetMap file", (Throwable)iOException);
        }
        return printWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeTargetMap(PrintWriter printWriter) {
        try {
            if (printWriter != null) {
                printWriter.println("</Targets>");
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    private void checkDiagcheckDeployed() {
        this.m_diagcheckDeployed = false;
        File file = new File(Collector.getCCRRoot(), UplinkPath.DIAGCHECKS_PATH);
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory() || fileArray[i].getName().equals("scripts")) continue;
            this.m_diagcheckDeployed = true;
            break;
        }
    }

    private void checkDiagcheckJavaVersionReq() {
        this.m_diagcheckJavaVersionNotSupported = true;
        String string = System.getProperty("java.version");
        try {
            int n = string.indexOf(95);
            if (n != -1) {
                string = string.substring(0, n);
            }
            this.m_diagcheckJavaVersionNotSupported = ComponentVersion.compare((String)string, (String)"1.4.2") < 0;
            this.m_log.debug((Object)("Ocheck supported java : ver=" + string + "," + !this.m_diagcheckJavaVersionNotSupported));
        }
        catch (InvalidComponentVersionException invalidComponentVersionException) {
            // empty catch block
        }
        if (!this.m_diagcheckDisabled && this.m_diagcheckDeployed && this.m_diagcheckJavaVersionNotSupported) {
            this.m_log.warn(CollectionMgrMsgID.DIAGCHECK_JAVA_VERSION_REQ, (Object[])new String[]{string});
            String string2 = this.m_bundle.getMessage(CollectionMgrMsgID.DIAGCHECK_JAVA_VERSION_REQ, false, (Object[])new String[]{string});
            System.err.println(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectConfigMetricData() throws CommandException {
        block9: {
            Object object;
            TargetManager targetManager = TargetManager.getInstance();
            String[] stringArray = null;
            String string = this.getCollectionTargetType();
            stringArray = string != null ? new String[]{string} : targetManager.getTargetTypes();
            PrintWriter printWriter = null;
            printWriter = this.openTargetMap();
            try {
                if (this.m_diagcheckDisabled) {
                    this.m_log.debug((Object)"Diagchecks have been disabled");
                }
                this.checkDiagcheckJavaVersionReq();
                for (int i = 0; i < stringArray.length; ++i) {
                    object = stringArray[i];
                    TargetMetadata targetMetadata = targetManager.getTargetMetadata((String)object);
                    CollectionList collectionList = (CollectionList)this.m_hashConfigCollectionList.get(object);
                    if (collectionList == null || targetMetadata == null || !targetMetadata.supportsConfigMetrics()) continue;
                    this.collectConfigMetricData((String)object, printWriter);
                }
            }
            finally {
                this.closeTargetMap(printWriter);
            }
            String string2 = FileSpec.catfile((String[])new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_PREVIOUS_PATH, DIAGCHECKERR_BAK});
            try {
                object = new File(string2);
                if (((File)object).exists()) {
                    ((File)object).delete();
                }
            }
            catch (Exception exception) {
                if (!this.m_log.isDebugEnabled()) break block9;
                this.m_log.debug((Object)("File not found " + string2 + exception.getMessage()));
            }
        }
    }

    private CollectionList getConfigCollections(String string) throws SAXException {
        CollectionList collectionList = null;
        try {
            collectionList = new CollectionList(string);
            if (collectionList.size() == 0) {
                collectionList = null;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            collectionList = null;
        }
        return collectionList;
    }

    private CollectionList getCollectionList(String string) {
        return (CollectionList)this.m_hashConfigCollectionList.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CollectionMgr getInstance() {
        if (s_instance == null) {
            Class clazz = class$oracle$sysman$ccr$collector$collectionMgr$CollectionMgr == null ? (class$oracle$sysman$ccr$collector$collectionMgr$CollectionMgr = CollectionMgr.class$("oracle.sysman.ccr.collector.collectionMgr.CollectionMgr")) : class$oracle$sysman$ccr$collector$collectionMgr$CollectionMgr;
            synchronized (clazz) {
                if (s_instance == null) {
                    s_instance = new CollectionMgr();
                }
            }
        }
        return s_instance;
    }

    public void processCollections() throws CommandException {
        TargetManager targetManager = TargetManager.getInstance();
        String[] stringArray = targetManager.getTargetTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            CollectionList collectionList = null;
            try {
                collectionList = this.getConfigCollections(string);
            }
            catch (SAXException sAXException) {
                throw new CommandException("Unable to process the default collection for " + string, (Throwable)sAXException);
            }
            if (collectionList == null) continue;
            this.m_hashConfigCollectionList.put(string, collectionList);
        }
    }

    private CollectionMgr() {
        this.m_hashConfigCollectionList = new HashMap();
        Config config = UplinkHomeConfig.getInstance();
        this.m_diagcheckDisabled = config.getProperty("diagcheck.disable", false);
        this.checkDiagcheckDeployed();
    }

    private void collectConfigMetricData(Target target, PrintWriter printWriter) throws SAXException, CommandException {
        Collection collection;
        String string = target.getTargetType();
        TargetManager targetManager = TargetManager.getInstance();
        TargetMetadata targetMetadata = targetManager.getTargetMetadata(string);
        CollectionList collectionList = this.getCollectionList(target.getTargetType());
        String string2 = FileSpec.catfile((String[])new String[]{Collector.getCCRRoot(), UplinkPath.DIAGCHECKS_PATH, string});
        File file = new File(string2);
        if (!this.m_diagcheckDisabled && file.exists() && !this.m_diagcheckJavaVersionNotSupported) {
            collection = new Collection("OCHECK");
            collection.addMetric("OCHECK");
            collectionList.add(collection);
            if (this.m_log.isDebugEnabled()) {
                this.m_log.debug((Object)("OCHECK metric added for target [" + target.getTargetName() + ", " + target.getTargetType() + "]"));
            }
        } else if (this.m_log.isDebugEnabled()) {
            this.m_log.debug((Object)("OCHECK metric not added for target [" + target.getTargetName() + ", " + target.getTargetType() + "]. Diagchecks disabled: " + this.m_diagcheckDisabled + ", diagchecks deployed: " + file.exists() + ", java version not supported: " + this.m_diagcheckJavaVersionNotSupported));
        }
        collection = null;
        Iterator iterator = ((AbstractList)collectionList).iterator();
        while (iterator.hasNext()) {
            Collection collection2 = collection;
            collection = (Collection)iterator.next();
            String string3 = collection.getCollectionName();
            if (string3 != null && "DiscoverTargets".equals(string3)) {
                collection = collection2;
                continue;
            }
            CollectionResultList collectionResultList = new CollectionResultList(target, collection.getCollectionName(), targetMetadata.getMetadataVersion());
            Vector vector = collection.getMetrics();
            Iterator iterator2 = ((AbstractList)vector).iterator();
            while (iterator2.hasNext()) {
                String string4 = (String)iterator2.next();
                if (this.m_log.isDebugEnabled()) {
                    this.m_log.debug((Object)("Metric name for anonymous ocm collection is: " + string4 + " And the target type is this: " + target.getTargetType()));
                }
                MetricCollectionLimiterMgr metricCollectionLimiterMgr = MetricCollectionLimiterMgr.getInstance();
                try {
                    if (!metricCollectionLimiterMgr.isMetricCollectionAllowed(target.getTargetType(), string4)) continue;
                    Metric metric = null;
                    if (string4.equals("OCHECK")) {
                        metric = OCheckMetric.getOCheckMetric();
                        if (collection2 != null) {
                            OCheckMetric.setConfigCollectionName(collection2.getCollectionName());
                        }
                    } else {
                        if (this.m_log.isDebugEnabled()) {
                            this.m_log.debug((Object)("Metric name for this target: " + target.getTargetName() + "is " + string4));
                        }
                        metric = targetMetadata.getMetric(string4, target);
                    }
                    if (metric != null) {
                        if (this.m_log.isDebugEnabled()) {
                            this.m_log.debug((Object)("Metric is: " + metric));
                        }
                        if (this.m_log.isEnabledFor(Logger.INFO)) {
                            this.m_log.info(CollectionMgrMsgID.PROCESSING_METRIC, (Object[])new String[]{string4, target.getTargetName(), target.getTargetType()});
                        }
                        MetricResult metricResult = null;
                        try {
                            metricResult = metric.collect(target);
                            CollectionResult collectionResult = new CollectionResult(string4, metric.isIncremental(), metric.isCmdbFormat(), metric.getTblDesc(), metricResult);
                            if (string4.equals("OCHECK")) {
                                collectionResultList.setMetadataVersion(OCheckMetric.getMetadataVersion());
                            }
                            collectionResultList.put(string4, collectionResult);
                        }
                        catch (FetchletException fetchletException) {
                            if (target.isCollectedByAnonymousCentralCollector() && System.getProperty(TargetHomeManager.ccrtest_do_not_silence_anonymous_central_collector) == null) continue;
                            CollectCommandException collectCommandException = new CollectCommandException("Error in processing " + metric.getMetricId() + " metric collection for " + target.getTargetName(), (Throwable)((Object)fetchletException));
                            if (Collector.failOnError()) {
                                throw collectCommandException;
                            }
                            Collector.logExceptionChainToStderr(collectCommandException);
                        }
                        continue;
                    }
                    if (collection.getCollectionName().equals(string4)) continue;
                    this.m_log.debug((Object)this.m_bundle.getMessage(CollectionMgrMsgID.COLLECTION_METADATA_MISMATCH, false, (Object[])new String[]{collection.getCollectionName(), string, string4}));
                }
                catch (CCRException cCRException) {
                    throw new CommandException("Internal Error", (Throwable)cCRException);
                }
            }
            this.persistReviewFile(collectionResultList, printWriter);
            this.persistCollectionForUpload(collectionResultList);
            CollectionResult.s_isOCheckCollection = false;
        }
        if (this.m_morecolls != null) {
            printWriter.print(this.m_morecolls);
            this.m_morecolls = null;
            printWriter.println("  </Target>");
            this.m_printable = null;
        }
        if (this.m_printable != null) {
            printWriter.println("  </Target>");
            this.m_printable = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectConfigMetricData(String string, PrintWriter printWriter) throws CommandException {
        TargetManager targetManager = TargetManager.getInstance();
        TargetMetadata targetMetadata = targetManager.getTargetMetadata(string);
        boolean bl = false;
        if (targetMetadata != null) {
            bl = targetMetadata.getIsUniqueIdReqd();
        }
        Target[] targetArray = null;
        Target target = this.getCollectionTarget();
        targetArray = target != null ? new Target[]{target} : targetManager.getTargetInstances(string);
        try {
            for (int i = 0; i < targetArray.length; ++i) {
                Object var15_15;
                Target target2 = targetArray[i];
                boolean bl2 = false;
                String string2 = target2.getUniqueId();
                if (string2 != null && !string2.equals("")) {
                    bl2 = true;
                }
                if (this.m_log.isDebugEnabled()) {
                    this.m_log.debug((Object)("For target (" + target2.getTargetName() + ", " + string + ") " + "isUniqueIdRequired = " + bl + ", isUniqueIdPresent = " + bl2));
                }
                if (bl ^ bl2) {
                    throw new CommandException("Target (" + target2.getTargetName() + ", " + string + ") does not obey the is_unique_id_required value in metadata.");
                }
                if (target2.isDisabled()) continue;
                PrintStream printStream = System.err;
                try {
                    if (target2.isCollectedByAnonymousCentralCollector() && System.getProperty(TargetHomeManager.ccrtest_do_not_silence_anonymous_central_collector) == null) {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        System.setErr(new PrintStream(byteArrayOutputStream));
                    }
                    this.collectConfigMetricData(target2, printWriter);
                    var15_15 = null;
                }
                catch (Throwable throwable) {
                    var15_15 = null;
                    if (target2.isCollectedByAnonymousCentralCollector() && System.getProperty(TargetHomeManager.ccrtest_do_not_silence_anonymous_central_collector) == null) {
                        System.setErr(printStream);
                    }
                    throw throwable;
                }
                if (!target2.isCollectedByAnonymousCentralCollector() || System.getProperty(TargetHomeManager.ccrtest_do_not_silence_anonymous_central_collector) != null) continue;
                System.setErr(printStream);
                {
                    continue;
                }
            }
        }
        catch (SAXException sAXException) {
            throw new CommandException("Unable to collect metric data", (Throwable)sAXException);
        }
    }

    private void persistReviewFile(CollectionResultList collectionResultList, PrintWriter printWriter) throws CollectCommandException {
        TargetManager targetManager = TargetManager.getInstance();
        Target target = collectionResultList.getTargetInstance();
        String string = target.getTargetType();
        TargetMetadata targetMetadata = targetManager.getTargetMetadata(string);
        String string2 = this.persistReviewFile(collectionResultList);
        if (!this.m_previousTarget.equals(target.getTargetName())) {
            if (this.m_morecolls != null) {
                printWriter.print(this.m_morecolls);
                this.m_morecolls = null;
                printWriter.println("  </Target>");
                this.m_printable = null;
            }
            if (this.m_printable != null) {
                printWriter.println("  </Target>");
                this.m_printable = null;
            }
            this.m_printable = MessageFormat.format("  <Target name=\"{0}\" type=\"{1}\">\n    <Collection name=\"{2}\" file=\"{3}\" collection_timestamp=\"{4}\"/>\n", target.getTargetName(), targetMetadata.getTypeDisplayString(), collectionResultList.getCollectionName(), string2, collectionResultList.getCollectionTSwTZ());
            printWriter.print(this.m_printable);
        } else {
            this.m_morecolls = this.m_morecolls != null ? this.m_morecolls + MessageFormat.format("    <Collection name=\"{0}\" file=\"{1}\" collection_timestamp=\"{2}\"/>\n", collectionResultList.getCollectionName(), string2, collectionResultList.getCollectionTSwTZ()) : MessageFormat.format("    <Collection name=\"{0}\" file=\"{1}\" collection_timestamp=\"{2}\"/>\n", collectionResultList.getCollectionName(), string2, collectionResultList.getCollectionTSwTZ());
        }
        this.m_previousTarget = target.getTargetName();
    }

    private String persistReviewFile(CollectionResultList collectionResultList) throws CollectCommandException {
        String string = collectionResultList.getObjectBaseFilename() + ".xml";
        String string2 = FileSpec.catfile((String[])new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_REVIEW_PATH, string});
        this.persistReviewFile(collectionResultList, string2, false, false);
        return string;
    }

    private void persistReviewFile(CollectionResultList collectionResultList, String string, boolean bl, boolean bl2) throws CollectCommandException {
        XMLReviewWriter xMLReviewWriter = null;
        try {
            xMLReviewWriter = new XMLReviewWriter(string, collectionResultList, bl, bl2);
            xMLReviewWriter.write();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CollectCommandException("Unable to open state directory for writing", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new CollectCommandException("Error writting review file " + string, (Throwable)iOException);
        }
        catch (SAXException sAXException) {
            throw new CollectCommandException("Error writting review file " + string, (Throwable)sAXException);
        }
    }

    private void persistCollectionForUpload(CollectionResultList collectionResultList) throws CollectCommandException {
        String string = null;
        String string2 = null;
        string = collectionResultList.getObjectBaseFilename() + ".xml";
        string2 = FileSpec.catfile((String[])new String[]{s_strUploadPath, string});
        this.persistCollectionForUpload(collectionResultList, string2, true, true, false);
    }

    private void persistCollectionForUpload(CollectionResultList collectionResultList, String string, boolean bl, boolean bl2, boolean bl3) throws CollectCommandException {
        boolean bl4 = bl;
        if (this.m_log.isDebugEnabled()) {
            this.m_log.debug((Object)("*** Writing out the file (" + string + ") for upload ***"));
        }
        try {
            if (bl2) {
                collectionResultList.deflate(s_strUploadPath, bl3);
                bl4 = this.filterCollection(collectionResultList, bl3);
            }
            XMLUploadWriter xMLUploadWriter = new XMLUploadWriter(string, collectionResultList, bl4, bl3);
            xMLUploadWriter.write();
            if (this.m_log.isDebugEnabled()) {
                this.m_log.debug((Object)"*** Completed writing out upload file ***");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CollectCommandException("Unable to open state directory for writing", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new CollectCommandException("Error writting upload file " + string, (Throwable)iOException);
        }
        catch (SAXException sAXException) {
            throw new CollectCommandException("Error writing CMDB Instance Data to upload file " + string, (Throwable)sAXException);
        }
    }

    public static boolean isGCUploaded(Target target, String string) {
        String string2 = CollectionResultList.getObjectBaseFilename(target, string) + ".xml";
        String string3 = CollectionResultList.getObjectBaseSubDir(target.getGUID());
        String string4 = FileSpec.catfile((String[])new String[]{s_strUploadPath, "external", string3, string2});
        File file = new File(string4);
        return !file.exists();
    }

    private String createUploadDirFile(CollectionResultList collectionResultList, String string) {
        return FileSpec.catfile((String[])new String[]{s_strUploadPath, "external", collectionResultList.getObjectBaseSubDir(), collectionResultList.getObjectBaseFilename() + string});
    }

    public void diffAndPersistCollectionForGCUpload(CollectionResultList collectionResultList) throws CollectCommandException {
        String string = this.createUploadDirFile(collectionResultList, ".xml");
        String string2 = this.createUploadDirFile(collectionResultList, ".inprocess");
        String string3 = this.createUploadDirFile(collectionResultList, ".ser");
        String string4 = this.createUploadDirFile(collectionResultList, ".ser.inprocess");
        this.persistCollectionForUpload(collectionResultList, string2, false, true, true);
        File file = new File(string2);
        File file2 = new File(string);
        File file3 = new File(string4);
        File file4 = new File(string3);
        boolean bl = false;
        if (!file2.exists()) {
            boolean bl2 = bl = file3.renameTo(file4) && file.renameTo(file2);
        }
        if (!bl) {
            if (!file.delete()) {
                System.gc();
                if (!file.delete()) {
                    file.deleteOnExit();
                }
            }
            if (!file3.delete()) {
                System.gc();
                if (!file3.delete()) {
                    file3.deleteOnExit();
                }
            }
            throw new CollectCommandException("Upload file( " + string + " ) not generated as it is already present.");
        }
    }

    public void persistCollectionForGCUpload(CollectionResultList collectionResultList, boolean bl) throws CollectCommandException {
        this.persistGCUploadFile(collectionResultList, !bl);
    }

    private void persistGCUploadFile(CollectionResultList collectionResultList, boolean bl) throws CollectCommandException {
        String string = FileSpec.catfile((String[])new String[]{s_strUploadPath, "external", collectionResultList.getObjectBaseSubDir(), collectionResultList.getObjectBaseFilename() + ".xml"});
        String string2 = FileSpec.catfile((String[])new String[]{s_strUploadPath, "external", collectionResultList.getObjectBaseSubDir(), collectionResultList.getObjectBaseFilename() + ".inprocess"});
        this.persistCollectionForUpload(collectionResultList, string2, bl, false, true);
        File file = new File(string2);
        File file2 = new File(string);
        boolean bl2 = false;
        if (!file2.exists()) {
            bl2 = file.renameTo(file2);
        }
        if (!bl2) {
            if (!file.delete()) {
                System.gc();
                if (!file.delete()) {
                    file.deleteOnExit();
                }
            }
            throw new CollectCommandException("Upload file( " + string + " ) not generated as it is already present.");
        }
    }

    public void clearGCCollectionUpload() throws CommandException {
        for (int i = 0; i < 11; ++i) {
            String string = FileSpec.catfile((String[])new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_UPLOAD_PATH, "external", "" + i});
            this.deleteSubDirFiles(string);
            String string2 = FileSpec.catfile((String[])new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_PREVIOUS_PATH, "external", "" + i});
            this.deleteSubDirFiles(string2);
        }
        String string = FileSpec.catfile((String[])new String[]{Collector.getCCRConfigHome(), UplinkPath.STATE_PREVIOUS_PATH});
        this.deleteFile(FileSpec.catfile((String[])new String[]{string, "gc_upload_marker"}));
        this.dumpGCFullCollTimestamp(string);
    }

    private void deleteSubDirFiles(String string) {
        String[] stringArray;
        File file = new File(string);
        if (file.exists() && (stringArray = file.list(new CollectionFileFilter())) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.deleteFile(FileSpec.catfile((String[])new String[]{string, stringArray[i]}));
            }
        }
    }

    private void dumpGCFullCollTimestamp(String string) throws CommandException {
        PrintWriter printWriter = null;
        try {
            String string2 = FileSpec.catfile((String[])new String[]{string, "gc_upload_timestamp"});
            printWriter = new PrintWriter(new FileOutputStream(string2));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            simpleDateFormat.setCalendar(calendar);
            String string3 = simpleDateFormat.format(new Date());
            printWriter.println(string3);
        }
        catch (IOException iOException) {
            throw new CommandException("Unable to create gc resync signal ( IOException: " + iOException + " )");
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    private void deleteFile(String string) {
        File file = new File(string);
        if (file.exists() && !file.delete()) {
            System.gc();
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
    }

    private boolean filterCollection(CollectionResultList collectionResultList, boolean bl) {
        String string = CollectionResultList.getSerializedObjectFilename(collectionResultList.getTargetInstance(), collectionResultList.getCollectionName());
        String string2 = null;
        string2 = !bl ? FileSpec.catfile((String[])new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_PREVIOUS_PATH, string}) : FileSpec.catfile((String[])new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_PREVIOUS_PATH, "external", collectionResultList.getObjectBaseSubDir(), string});
        try {
            String string3;
            Vector<String> vector = new Vector<String>();
            CollectionResultList collectionResultList2 = CollectionResultList.inflate(string2);
            if (collectionResultList2 == null || collectionResultList2.getMetadataVersion() == null || !collectionResultList2.getMetadataVersion().equals(collectionResultList.getMetadataVersion())) {
                return false;
            }
            Set set = collectionResultList.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                string3 = (String)iterator.next();
                CollectionResult collectionResult = collectionResultList.getResult(string3);
                CollectionResult collectionResult2 = null;
                collectionResult2 = collectionResultList2.getResult(string3);
                if (collectionResult2 == null) continue;
                if (collectionResult.equals(collectionResult2)) {
                    vector.add(string3);
                    continue;
                }
                if (!collectionResult.isIncrementalMetric()) continue;
                collectionResult.diffRows(collectionResult2);
            }
            for (int i = 0; i < vector.size(); ++i) {
                string3 = (String)vector.get(i);
                collectionResultList.remove(string3);
            }
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (this.m_log.isEnabledFor(Logger.DEBUG)) {
                Target target = collectionResultList.getTargetInstance();
                this.m_log.debug((Object)("Previous state file (" + string2 + ") does not exist for target (" + target.getTargetName() + "," + target.getTargetType() + ") and collection (" + collectionResultList.getCollectionName() + ")"));
            }
            return false;
        }
        catch (IOException iOException) {
            if (this.m_log.isEnabledFor(Logger.WARN)) {
                Target target = collectionResultList.getTargetInstance();
                this.m_log.warn(CollectionMgrMsgID.COLLECTION_INFLATION_ERR, (Object[])new String[]{target.getTargetName(), target.getTargetType(), collectionResultList.getCollectionName()});
            }
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.m_log.isEnabledFor(Logger.DEBUG)) {
                Target target = collectionResultList.getTargetInstance();
                this.m_log.debug((Object)("unable to re-instantiate the previous state file (" + string2 + ") for target (" + target.getTargetName() + "," + target.getTargetType() + ") and collection (" + collectionResultList.getCollectionName() + ")"));
            }
            return false;
        }
    }

    private void parseCollectionQualifier() throws CommandException {
        if (this.m_bCollectionQualifierParsed) {
            return;
        }
        this.m_bCollectionQualifierParsed = true;
        if (Collector.qualifierSpecified(TARGET_COLLECTION_QUALIFIER)) {
            CommandQualifier commandQualifier = Collector.getQualifier(TARGET_COLLECTION_QUALIFIER);
            String string = null;
            if (commandQualifier != null && (string = commandQualifier.getQualifierValue()) != null) {
                String[] stringArray = m_collectionSplitPattern.split(string);
                if (stringArray.length < 2 || stringArray.length > 3 || stringArray[0] == null || stringArray[1] == null) {
                    throw new CommandException("Error parsing -collection=" + string + TARGET_COLLECTION_QUALIFIER_USAGE);
                }
                this.m_collectionTargetName = stringArray[0].trim();
                this.m_collectionTargetType = stringArray[1].trim();
                if (stringArray.length == 3 && stringArray[2] != null) {
                    this.m_collectionItem = stringArray[2].trim();
                }
                TargetManager targetManager = TargetManager.getInstance();
                this.m_collectionTarget = targetManager.getTargetByNameType(this.m_collectionTargetName, this.m_collectionTargetType);
                if (this.m_collectionTarget == null) {
                    throw new CommandException("Unknown target specified in -collection=" + string + TARGET_COLLECTION_QUALIFIER_USAGE);
                }
            }
        }
    }

    private Target getCollectionTarget() throws CommandException {
        this.parseCollectionQualifier();
        return this.m_collectionTarget;
    }

    public String getCollectionTargetType() throws CommandException {
        this.parseCollectionQualifier();
        return this.m_collectionTargetType;
    }

    private String getCollectionTargetName() throws CommandException {
        this.parseCollectionQualifier();
        return this.m_collectionTargetName;
    }

    public String getCollectionItem() throws CommandException {
        this.parseCollectionQualifier();
        return this.m_collectionItem;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        s_strUploadPath = FileSpec.catfile((String[])new String[]{Collector.getCCRConfigHome(), UplinkPath.STATE_UPLOAD_PATH});
        m_dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        XMLPATTERN = ",";
        try {
            m_collectionSplitPattern = new RE(",");
        }
        catch (RESyntaxException rESyntaxException) {
            throw new RuntimeException("Invalid regular expression, " + XMLPATTERN);
        }
    }

    class CollectionFileFilter
    implements FilenameFilter {
        CollectionFileFilter() {
        }

        public boolean accept(File file, String string) {
            String string2;
            boolean bl = true;
            int n = string.lastIndexOf(".");
            bl = n != -1 ? (string2 = string.substring(n)).equals(".ser") || string2.equals(".xml") : false;
            return bl;
        }
    }

    class CollectionStateFilter
    implements FilenameFilter {
        CollectionStateFilter() {
        }

        public boolean accept(File file, String string) {
            boolean bl = true;
            int n = string.lastIndexOf(".");
            if (n != -1) {
                String string2 = string.substring(n);
                bl = string2.equals(".ser");
            } else {
                bl = false;
            }
            return bl;
        }
    }
}

