/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.collectionMgr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResult;
import oracle.sysman.ccr.collector.targets.Target;
import oracle.sysman.ccr.util.FileSpec;

public class CollectionResultList
extends HashMap
implements Serializable {
    private static final long serialVersionUID = 3757688827981178926L;
    private Target m_targetInstance = null;
    private String m_strCollectionName = null;
    private String m_strMetadataVersion = null;
    private transient Date m_dateCollection = new Date();
    private static final String SERIALIZED_EXTENSION = ".ser";
    private static final String INPROCESS_EXTENSION = ".inprocess";
    private static final transient SimpleDateFormat s_dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public CollectionResultList(Target target, String string, String string2) {
        this.m_targetInstance = target;
        this.m_strCollectionName = string;
        this.m_strMetadataVersion = string2;
    }

    private File createOutFile(String string, boolean bl) {
        if (!bl) {
            return new File(FileSpec.catfile((String[])new String[]{string, CollectionResultList.getSerializedObjectFilename(this.m_targetInstance, this.m_strCollectionName)}));
        }
        return new File(FileSpec.catfile((String[])new String[]{string, "external", this.getObjectBaseSubDir(), CollectionResultList.getSerializedObjectFilename(this.m_targetInstance, this.m_strCollectionName) + INPROCESS_EXTENSION}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void deflate(String string, boolean bl) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = null;
        File file = this.createOutFile(string, bl);
        try {
            fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this);
            Object var7_6 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public String getObjectBaseFilename() {
        return CollectionResultList.getObjectBaseFilename(this.m_targetInstance, this.m_strCollectionName);
    }

    public static String getObjectBaseFilename(Target target, String string) {
        StringBuffer stringBuffer = new StringBuffer(target.getGUID()).append("-").append(string);
        return stringBuffer.toString();
    }

    public String getObjectBaseSubDir() {
        return CollectionResultList.getObjectBaseSubDir(this.m_targetInstance.getGUID());
    }

    public static String getObjectBaseSubDir(String string) {
        BigInteger bigInteger = new BigInteger(string, 16);
        BigInteger bigInteger2 = bigInteger.remainder(new BigInteger("11"));
        return bigInteger2.toString();
    }

    public static String getSerializedObjectFilename(Target target, String string) {
        return CollectionResultList.getObjectBaseFilename(target, string) + SERIALIZED_EXTENSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CollectionResultList inflate(String string) throws FileNotFoundException, IOException, ClassNotFoundException {
        FileInputStream fileInputStream = null;
        CollectionResultList collectionResultList = null;
        File file = new File(string);
        fileInputStream = new FileInputStream(file);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        collectionResultList = (CollectionResultList)objectInputStream.readObject();
        Object var6_7 = null;
        if (fileInputStream == null) return collectionResultList;
        try {
            fileInputStream.close();
            return collectionResultList;
        }
        catch (IOException iOException) {}
        return collectionResultList;
        {
            catch (StreamCorruptedException streamCorruptedException) {
                streamCorruptedException.printStackTrace();
                Object var6_8 = null;
                if (fileInputStream == null) return collectionResultList;
                try {
                    fileInputStream.close();
                    return collectionResultList;
                }
                catch (IOException iOException) {}
                return collectionResultList;
            }
            catch (OptionalDataException optionalDataException) {
                optionalDataException.printStackTrace();
                Object var6_9 = null;
                if (fileInputStream == null) return collectionResultList;
                try {
                    fileInputStream.close();
                    return collectionResultList;
                }
                catch (IOException iOException) {}
                return collectionResultList;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public CollectionResult getResult(String string) {
        return (CollectionResult)this.get(string);
    }

    public String getCollectionName() {
        return this.m_strCollectionName;
    }

    public String getMetadataVersion() {
        return this.m_strMetadataVersion;
    }

    public void setMetadataVersion(String string) {
        this.m_strMetadataVersion = string;
    }

    public Target getTargetInstance() {
        return this.m_targetInstance;
    }

    public Date getCollectionTimestamp() {
        Date date = null;
        if (!CollectionResult.s_isOCheckCollection && !CollectionResult.s_isAdrInfoCollection) {
            date = this.m_targetInstance.getCollectionTimestampOverride();
        }
        if (date == null) {
            date = this.m_dateCollection;
        }
        return date;
    }

    public String getCollectionTSwTZ() {
        String string = s_dateFormat.format(this.getCollectionTimestamp());
        return string + " " + this.m_targetInstance.getTimeZone();
    }
}

