/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.collectionMgr;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.sysman.ccr.common.logging.Logger;
import org.apache.regexp.RE;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetricStore {
    private static final String TARGET_ELEMENT = "Target";
    private static final String METRIC_ELEMENT = "Metric";
    private static final String TARGET_ATTR_TYPE = "type";
    private static final String TARGET_ATTR_INHERIT_PARENT = "inheritParent";
    private static final String TARGET_ATTR_INCLUDE_ALL = "includeAll";
    private static final String ALL_METRICS = "__ALL";
    private static final String INCLUDE_PREFIX = "IN:";
    private static final String EXCLUDE_PREFIX = "EX:";
    private static boolean m_fileExists = true;
    private Logger m_log = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$collectionMgr$MetricStore == null ? (class$oracle$sysman$ccr$collector$collectionMgr$MetricStore = MetricStore.class$("oracle.sysman.ccr.collector.collectionMgr.MetricStore")) : class$oracle$sysman$ccr$collector$collectionMgr$MetricStore));
    Map targetMetricMap = new HashMap();
    Map targetTypeMetricListMap = new HashMap();
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$collectionMgr$MetricStore;

    public MetricStore(String string) {
        Map map;
        if (this.isFileExists(string) && (map = this.buildAllTargetMetrics(string)) != null) {
            this.targetMetricMap = map;
        }
    }

    private boolean isFileExists(String string) {
        block2: {
            try {
                File file = new File(string);
                m_fileExists = file.exists();
            }
            catch (Exception exception) {
                if (!this.m_log.isDebugEnabled()) break block2;
                exception.printStackTrace();
            }
        }
        return m_fileExists;
    }

    boolean isMetricPresent(String string, String string2) {
        boolean bl = true;
        List list = null;
        if (m_fileExists) {
            String string3 = string.toUpperCase();
            String string4 = string2.toUpperCase();
            if (this.targetTypeMetricListMap.containsKey(string3)) {
                list = (List)this.targetTypeMetricListMap.get(string3);
            } else {
                list = this.getMetricsForTarget(string3);
                this.targetTypeMetricListMap.put(string3, list);
            }
            bl = this.checkMetricListForMetric(string3, string4, list);
            return bl;
        }
        return bl;
    }

    private boolean checkMetricListForMetric(String string, String string2, List list) {
        boolean bl = true;
        if (this.m_log.isDebugEnabled()) {
            this.m_log.debug((Object)("Target type inside MetricStore Method" + string));
            this.m_log.debug((Object)("Metric name inside MetricStore method" + string2));
            this.m_log.debug((Object)("List of allowed metrics for this target type" + list));
            this.m_log.debug((Object)("is include all prefix set? " + list.contains("IN:__ALL")));
            this.m_log.debug((Object)("is this metric is exclude prefixed? " + list.contains(EXCLUDE_PREFIX + string2)));
            this.m_log.debug((Object)("is this metric is include prefixed? " + list.contains(INCLUDE_PREFIX + string2)));
        }
        if (!(list == null || list.contains("IN:__ALL") && !list.contains(EXCLUDE_PREFIX + string2) || !list.contains(EXCLUDE_PREFIX + string2) && list.contains(INCLUDE_PREFIX + string2))) {
            bl = false;
        }
        return bl;
    }

    private List getMetricsForTarget(String string) {
        List list = null;
        if (string != null) {
            string = string.toUpperCase();
            String string2 = this.getTargetType(string);
            list = (List)this.targetMetricMap.get(string2);
        }
        return list;
    }

    private String getTargetType(String string) {
        String string2 = "";
        Iterator iterator = this.targetMetricMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            try {
                RE rE = new RE("(\\.\\*)|(\\*)");
                String string4 = rE.subst(string3, "");
                if (string.equals(string4)) {
                    return string3;
                }
                RE rE2 = new RE(string4);
                if (!rE2.match(string) || rE2.getParenCount() <= 0 || string2.length() > rE2.getParen(0).length() || string.length() <= rE2.getParen(0).length()) continue;
                string2 = string3;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string2;
    }

    private Map buildAllTargetMetrics(String string) {
        Document document = this.createDocument(string);
        Map map = this.buildAllTargetMetrics(document);
        document = null;
        return map;
    }

    private Document createDocument(String string) {
        Document document = null;
        try {
            File file = new File(string);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(file);
            document.getDocumentElement().normalize();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return document;
    }

    private Map buildAllTargetMetrics(Document document) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (document != null) {
            NodeList nodeList = document.getElementsByTagName(TARGET_ELEMENT);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Object object;
                Element element = (Element)nodeList.item(i);
                String string = element.getAttribute(TARGET_ATTR_TYPE).toUpperCase();
                Element element2 = (Element)element.getParentNode();
                List list = null;
                if (TARGET_ELEMENT.equals(element2.getNodeName())) {
                    object = element2.getAttribute(TARGET_ATTR_TYPE).toUpperCase();
                    list = (List)hashMap.get(object);
                }
                object = this.populateMetrics(element, list);
                hashMap.put(string, object);
            }
        }
        return hashMap;
    }

    private List populateMetrics(Element element, List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (element != null) {
            boolean bl;
            String string = element.getAttribute(TARGET_ATTR_INHERIT_PARENT);
            String string2 = element.getAttribute(TARGET_ATTR_INCLUDE_ALL);
            boolean bl2 = !"false".equalsIgnoreCase(string);
            boolean bl3 = bl = "true".equalsIgnoreCase(string2);
            if (bl2 && list != null) {
                arrayList.addAll(list);
            }
            if (bl) {
                arrayList.clear();
                arrayList.add("IN:__ALL");
            }
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!METRIC_ELEMENT.equals(node.getNodeName())) continue;
                Element element2 = (Element)node;
                String string3 = element2.getAttribute("include").toUpperCase();
                String string4 = element2.getAttribute("exclude").toUpperCase();
                if (!"".equals(string3)) {
                    if (arrayList.contains(EXCLUDE_PREFIX + string3)) {
                        arrayList.remove(EXCLUDE_PREFIX + string3);
                    } else if (!arrayList.contains("IN:__ALL")) {
                        arrayList.add(INCLUDE_PREFIX + string3);
                    }
                }
                if ("".equals(string4)) continue;
                if (arrayList.contains(INCLUDE_PREFIX + string4)) {
                    arrayList.remove(INCLUDE_PREFIX + string4);
                }
                if (!arrayList.contains("IN:__ALL")) continue;
                arrayList.add(EXCLUDE_PREFIX + string4);
            }
        }
        return arrayList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

