/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.collectionMgr;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cmd.CommandQualifier;
import oracle.sysman.ccr.collector.collectionMgr.CollectionMgrMsgID;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResult;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResultList;
import oracle.sysman.ccr.collector.collectionMgr.TargetMapper;
import oracle.sysman.ccr.collector.collectionMgr.UploadTags;
import oracle.sysman.ccr.collector.collectionMgr.cmdb.CmdbInstanceDataParser;
import oracle.sysman.ccr.collector.collectionMgr.cmdb.GUID;
import oracle.sysman.ccr.collector.collectionMgr.cmdb.Instance;
import oracle.sysman.ccr.collector.collectionMgr.cmdb.Instances;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.fetchlets.MetricValue;
import oracle.sysman.ccr.collector.fetchlets.ValueRow;
import oracle.sysman.ccr.collector.gcontext.GCContextManager;
import oracle.sysman.ccr.collector.security.AnonAuthenticationKey;
import oracle.sysman.ccr.collector.security.AuthenticationFailure;
import oracle.sysman.ccr.collector.security.AuthenticationKey;
import oracle.sysman.ccr.collector.security.CSIAuthenticationKey;
import oracle.sysman.ccr.collector.security.CSIV2AuthenticationKey;
import oracle.sysman.ccr.collector.security.EmailAuthenticationKey;
import oracle.sysman.ccr.collector.security.SecurityMgr;
import oracle.sysman.ccr.collector.targets.Target;
import oracle.sysman.ccr.collector.targets.TargetManager;
import oracle.sysman.ccr.collector.targets.TargetsMsgID;
import oracle.sysman.ccr.collector.targets.metadata.CCRMetadataVer;
import oracle.sysman.ccr.collector.targets.metadata.ColumnDescriptor;
import oracle.sysman.ccr.collector.targets.metadata.TableDescriptor;
import oracle.sysman.ccr.collector.timezone.Timezone;
import oracle.sysman.ccr.collector.util.Hostname;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.UplinkPath;
import oracle.sysman.ccr.util.Utils;
import oracle.sysman.ccr.util.XMLOps;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUploadWriter
implements UploadTags {
    private boolean m_bCollectorFiltered = true;
    private boolean m_isGC = false;
    private CollectionResultList m_resultMap = null;
    private OutputStreamWriter m_printWriter = null;
    private static final Logger s_log = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$collectionMgr$XMLUploadWriter == null ? (class$oracle$sysman$ccr$collector$collectionMgr$XMLUploadWriter = XMLUploadWriter.class$("oracle.sysman.ccr.collector.collectionMgr.XMLUploadWriter")) : class$oracle$sysman$ccr$collector$collectionMgr$XMLUploadWriter));
    private static SimpleDateFormat s_dateFormat = null;
    private static String XMLPATTERN = "[&<>'\"]";
    private static Locale s_locale = Locale.US;
    public static final String ADHOC_COLLECTION_PROTOCOL_VERSION = "11.0.0.0.0";
    private static String s_protocolVersion;
    private static boolean s_protocolVersionSet;
    private static final String ASSOCIATED_TARGETS_TABLE = "MGMT_TARGETS";
    private static final String UNASSOCIATED_TARGETS_TABLE = "MGMT_VAGUE_TARGETS";
    private static final String IS_GC_FOR_GC = "TRUE";
    private static final String IS_GC_FOR_GC_FORCED = "GC_FORCE";
    private static String m_emdUrl;
    static final String DATE_VAR = "%DATE%";
    private static final String EMD_URL_QUALIFIER = "emdurl";
    private HashMap m_longText = new HashMap();
    private ArrayList m_cmdbInstanceTypes = new ArrayList();
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$collectionMgr$XMLUploadWriter;

    protected XMLUploadWriter(String string, CollectionResultList collectionResultList) throws FileNotFoundException, IOException {
        this.init(string, collectionResultList, false, false);
    }

    public XMLUploadWriter(String string, CollectionResultList collectionResultList, boolean bl) throws FileNotFoundException, IOException {
        this.init(string, collectionResultList, bl, false);
    }

    public XMLUploadWriter(String string, CollectionResultList collectionResultList, boolean bl, boolean bl2) throws FileNotFoundException, IOException {
        this.init(string, collectionResultList, bl, bl2);
    }

    private XMLUploadWriter(OutputStreamWriter outputStreamWriter, CollectionResultList collectionResultList) {
        this.m_resultMap = collectionResultList;
        this.m_bCollectorFiltered = false;
        this.m_isGC = false;
        this.m_printWriter = outputStreamWriter;
    }

    private void init(String string, CollectionResultList collectionResultList, boolean bl, boolean bl2) throws FileNotFoundException, IOException {
        this.m_resultMap = collectionResultList;
        this.m_bCollectorFiltered = bl;
        this.m_isGC = bl2;
        this.openFile(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProtocolVersion() {
        if (!s_protocolVersionSet) {
            Class clazz = class$oracle$sysman$ccr$collector$collectionMgr$XMLUploadWriter == null ? (class$oracle$sysman$ccr$collector$collectionMgr$XMLUploadWriter = XMLUploadWriter.class$("oracle.sysman.ccr.collector.collectionMgr.XMLUploadWriter")) : class$oracle$sysman$ccr$collector$collectionMgr$XMLUploadWriter;
            synchronized (clazz) {
                if (!s_protocolVersionSet) {
                    s_protocolVersion = UplinkPath.omsMode() ? ADHOC_COLLECTION_PROTOCOL_VERSION : CCRMetadataVer.getMetadataVer();
                    s_protocolVersionSet = true;
                }
            }
        }
        return s_protocolVersion;
    }

    private String beginRow() {
        return "  <ROW>\n";
    }

    private String endRow() {
        return "  </ROW>\n";
    }

    private String endRowSet() {
        return "</ROWSET>\n";
    }

    private String endUpload() {
        return "</UPLOAD>\n";
    }

    private String getLiveLinkTargetMapping() {
        Object object;
        String string = null;
        if (UplinkPath.isGCMode()) {
            string = GCContextManager.getGCContext().getOrgId();
        } else {
            object = SecurityMgr.getInstance();
            string = ((SecurityMgr)object).getCustomerOrgId();
        }
        object = this.m_resultMap.getTargetInstance();
        return this.getTargetMapping((Target)object, string, ((Target)object).getTimeZone());
    }

    private String getTargetMapping(Target target, String string, String string2) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(1);
        FieldPosition fieldPosition2 = new FieldPosition(1);
        FieldPosition fieldPosition3 = new FieldPosition(1);
        FieldPosition fieldPosition4 = new FieldPosition(1);
        FieldPosition fieldPosition5 = new FieldPosition(1);
        if (string == null || string.length() == 0) {
            string = "0";
        }
        String string3 = "";
        String string4 = null;
        String string5 = null;
        if (target.isProxyTarget()) {
            string4 = target.getTargetHost();
            string5 = target.getTargetHome();
        } else if (UplinkPath.isGCMode()) {
            string4 = GCContextManager.getGCContext().getHostName();
            string5 = GCContextManager.getGCContext().getOracleHome();
        } else {
            string4 = Hostname.getHostname();
            string5 = Collector.getOracleHome();
        }
        String string6 = target.getConfigHome();
        String string7 = target.getFullPath();
        if (!Collector.isDisconnected()) {
            string3 = target.getGUID();
        }
        String string8 = UNASSOCIATED_TARGETS_TABLE;
        if (UplinkPath.omsMode()) {
            string8 = "MGMT_CMDB_TARGETS";
        } else if (UplinkPath.isGCMode()) {
            if (GCContextManager.getGCContext().isAuthenticated() && GCContextManager.getGCContext().hasUniqueCSI()) {
                string8 = ASSOCIATED_TARGETS_TABLE;
            }
        } else {
            try {
                object = SecurityMgr.getInstance().getAuthenticationKey();
                if (object != null && !(object instanceof AnonAuthenticationKey)) {
                    if (object instanceof CSIV2AuthenticationKey || object instanceof CSIAuthenticationKey) {
                        string8 = ASSOCIATED_TARGETS_TABLE;
                    } else if (object instanceof EmailAuthenticationKey && ((AuthenticationKey)object).holdsUniqueCSI()) {
                        string8 = ASSOCIATED_TARGETS_TABLE;
                    }
                }
            }
            catch (AuthenticationFailure authenticationFailure) {
                string8 = ASSOCIATED_TARGETS_TABLE;
            }
        }
        object = new StringBuffer("");
        if (string7 != null && string7.length() > 0) {
            UploadTags.LIVELINK_FULL_PATH_FORMAT.format(new String[]{string7}, (StringBuffer)object, fieldPosition4);
        }
        UploadTags.LIVELINK_TARGET_ROW_FORMAT.format(new String[]{string3, string, string4, target.getTargetName(), target.getTargetType(), string5, string2 == null ? "" : string2, ((StringBuffer)object).toString()}, stringBuffer, fieldPosition2);
        if (string6 != null && string6.length() > 0 && !target.getTargetType().equals("oracle_home")) {
            UploadTags.LIVELINK_ORACLE_CFGHOME_FORMAT.format(new String[]{string6}, stringBuffer2, fieldPosition3);
        } else {
            stringBuffer2.append("");
        }
        String string9 = target.getUniqueId();
        if (string9 != null && string9.length() > 0) {
            UploadTags.LIVELINK_UNIQUE_ID_FORMAT.format(new String[]{string9}, stringBuffer4, fieldPosition5);
        } else {
            stringBuffer4.append("");
        }
        UploadTags.LIVELINK_MAPPING_FORMAT.format(new String[]{XMLUploadWriter.getProtocolVersion(), string8, stringBuffer.toString(), stringBuffer2.toString(), stringBuffer4.toString()}, stringBuffer3, fieldPosition);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Writing targetMapping for (" + target.getTargetName() + ", " + target.getTargetType() + ")"));
        }
        return stringBuffer3.toString();
    }

    private String getAnnotationRowset(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(1);
        stringBuffer.append("<ROWSET TABLE=\"MGMT_ECM_SNAPSHOT_ANNOTATION\">\n");
        stringBuffer.append("  <ROW>\n");
        MessageFormat messageFormat = null;
        if (XMLOps.hasInvalidCDATA((String)string)) {
            string = XMLOps.filterInvalidCDATA((String)string);
            s_log.warn(CollectionMgrMsgID.INVALID_CHARS);
        }
        messageFormat = XMLOps.hasSpecialChars((String)string) ? UploadTags.ROW_CDATA_FORMAT : UploadTags.ROW_FORMAT;
        messageFormat.format(new String[]{"ANNOTATION", string}, stringBuffer, fieldPosition);
        stringBuffer.append("  </ROW>\n");
        stringBuffer.append("</ROWSET>\n");
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Writing annotation rowset for \"" + string + "\""));
        }
        return stringBuffer.toString();
    }

    private String getBeginMetricRowset(String string, CollectionResult collectionResult) {
        StringBuffer stringBuffer = new StringBuffer();
        TableDescriptor tableDescriptor = collectionResult.getMetricTableDescriptor();
        String string2 = tableDescriptor.getTableName();
        String string3 = "FALSE";
        if (collectionResult.isIncrementalMetric()) {
            string3 = IS_GC_FOR_GC;
        }
        FieldPosition fieldPosition = new FieldPosition(1);
        String string4 = XMLUploadWriter.getProtocolVersion();
        if (tableDescriptor.isCmdbConfigurationItem()) {
            String string5 = tableDescriptor.getCmdbPackageName();
            String string6 = tableDescriptor.getCmdbTypeName();
            String string7 = tableDescriptor.getCmdbModelType();
            UploadTags.CMDB_BEGIN_ROWSET_FORMAT.format(new String[]{string4, string2, string, string3, string5, string6, string7}, stringBuffer, fieldPosition);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Writing metricRowset for CMDB configuration item " + string5 + "/" + string6 + "/" + string7));
            }
        } else {
            if (CollectionResult.s_isOCheckCollection) {
                UploadTags.OCHECK_BEGIN_ROWSET_FORMAT.format(new String[]{string4, string2.toUpperCase(s_locale), string, string3}, stringBuffer, fieldPosition);
            } else {
                UploadTags.BEGIN_ROWSET_FORMAT.format(new String[]{string4, string2.toUpperCase(s_locale), string, string3}, stringBuffer, fieldPosition);
            }
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Writing metricRowset for table " + string2.toUpperCase(s_locale)));
            }
        }
        return stringBuffer.toString();
    }

    private String getUploadPreamble() {
        String string;
        String string2;
        String string3;
        Serializable serializable;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(1);
        FieldPosition fieldPosition2 = new FieldPosition(1);
        String string4 = "";
        if (UplinkHomeConfig.getInstance().getProperty("generateTemplate", false)) {
            string4 = DATE_VAR;
        } else {
            serializable = this.m_resultMap.getCollectionTimestamp();
            string4 = s_dateFormat.format((Date)serializable);
        }
        serializable = this.m_resultMap.getTargetInstance();
        String string5 = "";
        if (((Target)serializable).isProxyTarget()) {
            string3 = new Boolean(((Target)serializable).isProxyTarget()).toString();
            string2 = ((Target)serializable).getTargetHost();
            string = ((Target)serializable).getTargetHome();
            UploadTags.PROXY_OPTIONAL_ATTRIBUTES.format(new String[]{string3, string2, string}, stringBuffer2, fieldPosition);
        }
        if (!Collector.isDisconnected()) {
            string5 = ((Target)serializable).getGUID();
        }
        string3 = Collector.getGridAgentOnTarget();
        string4 = string4 + " " + ((Target)serializable).getTimeZone();
        string2 = ((Target)serializable).getTargetProperty("OCM_CROSS_HOST");
        string2 = string2 == null || !string2.equalsIgnoreCase(IS_GC_FOR_GC) ? "FALSE" : IS_GC_FOR_GC;
        this.appendIsGCAttributeToExtraAttribute(stringBuffer2);
        this.appendMosMetalLevelToExtraAttribute(stringBuffer2);
        this.appendTargetPropertyToExtraAttribute(stringBuffer2);
        this.appendOldTargetGuidToExtraAttribute(stringBuffer2);
        string = stringBuffer2.toString();
        if (((Target)serializable).isMultiplexed()) {
            string = " MULTIPLEXED=\"TRUE\"" + string;
        }
        if (CollectionResult.s_isOCheckCollection) {
            UploadTags.OCHECK_UPLOAD_FORMAT.format(new String[]{XMLUploadWriter.getProtocolVersion(), XMLUploadWriter.getEmdUrl(), string4, string5, this.m_resultMap.getCollectionName(), this.m_resultMap.getMetadataVersion(), new Boolean(this.m_bCollectorFiltered).toString(), string3, string}, stringBuffer, fieldPosition2);
        } else {
            UploadTags.AGENT_UPLOAD_FORMAT.format(new String[]{XMLUploadWriter.getProtocolVersion(), XMLUploadWriter.getEmdUrl(), string4, string5, this.m_resultMap.getCollectionName(), new Boolean(this.m_bCollectorFiltered).toString(), string3, string2, string}, stringBuffer, fieldPosition2);
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Writing upload tag for (" + ((Target)serializable).getTargetName() + ", " + ((Target)serializable).getTargetType() + ") collection " + this.m_resultMap.getCollectionName()));
        }
        return stringBuffer.toString();
    }

    private String getUploadPreambleForImport(Target target, String string, String string2, String string3, String string4, String string5) throws SAXException {
        String string6;
        StringBuffer stringBuffer = new StringBuffer();
        if (string4 != null && string5 != null) {
            if (XMLUploadWriter.parseCollectionDate(string4) == null) {
                s_log.error(TargetsMsgID.INVALID_COLLECTION_TS, (Object[])new String[]{string4, target.getTargetName(), target.getTargetType(), s_dateFormat.toPattern()});
                throw new SAXException("Failed to parse collection timestamp: " + string4 + " for target " + target.getTargetName() + " of type " + target.getTargetType() + ". Expexted date pattern: " + s_dateFormat.toPattern());
            }
            string6 = string4 + " " + string5;
        } else {
            string6 = s_dateFormat.format(new Date()) + " " + Timezone.getInstance().getSupportedRegion();
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        UploadTags.PROXY_OPTIONAL_ATTRIBUTES.format(new String[]{"true", string2 == null ? "" : string2, string3 == null ? "" : string3}, stringBuffer2, new FieldPosition(1));
        this.appendIsGCAttributeToExtraAttribute(stringBuffer2);
        this.appendMosMetalLevelToExtraAttribute(stringBuffer2);
        this.appendTargetPropertyToExtraAttribute(stringBuffer2);
        this.appendOldTargetGuidToExtraAttribute(stringBuffer2);
        String string7 = stringBuffer2.toString();
        if (target.isMultiplexed()) {
            string7 = " MULTIPLEXED=\"TRUE\"" + string7;
        }
        UploadTags.AGENT_UPLOAD_FORMAT.format(new String[]{XMLUploadWriter.getProtocolVersion(), "ad hoc collection", string6, target.getGUID(), string, "false", "local", "FALSE", string7}, stringBuffer, new FieldPosition(1));
        return stringBuffer.toString();
    }

    protected void openFile(String string) throws FileNotFoundException, IOException {
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        this.m_printWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, "UTF-8");
    }

    public static Date parseCollectionDate(String string) {
        return s_dateFormat.parse(string, new ParsePosition(0));
    }

    public void write() throws IOException, SAXException {
        Object object;
        Object object2;
        this.write(this.getUploadPreamble());
        this.write(this.getLiveLinkTargetMapping());
        if (Collector.qualifierSpecified("annotation") && (object2 = ((CommandQualifier)(object = Collector.getQualifier("annotation"))).getQualifierValue()) != null) {
            this.write(this.getAnnotationRowset((String)object2));
        }
        object = this.m_resultMap.getMetadataVersion();
        object2 = this.m_resultMap.keySet();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            CollectionResult collectionResult = this.m_resultMap.getResult(string);
            if (collectionResult.isCmdbFormat()) {
                this.collectCmdbInstanceData(collectionResult, (String)object);
                continue;
            }
            this.write(collectionResult, (String)object);
        }
        this.writeCmdbInstanceData();
        this.writeLongText();
        this.write(this.endUpload());
        this.m_printWriter.close();
    }

    private void formatColumnValue(String string, String string2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (XMLOps.hasInvalidCDATA((String)string2)) {
            string2 = XMLOps.filterInvalidCDATA((String)string2);
            s_log.warn(CollectionMgrMsgID.INVALID_CHARS);
        }
        if (XMLOps.hasSpecialChars((String)string2)) {
            UploadTags.ROW_CDATA_FORMAT.format(new String[]{string, string2}, stringBuffer, fieldPosition);
        } else {
            UploadTags.ROW_FORMAT.format(new String[]{string, string2}, stringBuffer, fieldPosition);
        }
    }

    private void write(CollectionResult collectionResult, String string) throws IOException {
        Target target = this.m_resultMap.getTargetInstance();
        Date date = this.m_resultMap.getCollectionTimestamp();
        String string2 = s_dateFormat.format(date);
        string2 = string2 + " " + target.getTimeZone();
        String string3 = target.getTargetType();
        String string4 = collectionResult.getMetricCollectionName();
        TableDescriptor tableDescriptor = collectionResult.getMetricTableDescriptor();
        Vector vector = tableDescriptor.getColDescs();
        FieldPosition fieldPosition = new FieldPosition(1);
        MetricResult metricResult = collectionResult.getCollectionResult();
        Vector vector2 = null;
        if (metricResult == null || (vector2 = metricResult.getValueRows()) == null || vector2.size() == 0) {
            if (s_log.isEnabledFor(Logger.DEBUG)) {
                s_log.debug((Object)("No metric data found for metric " + collectionResult.getMetricCollectionName()));
            }
            if (!collectionResult.isIncrementalMetric()) {
                this.write(this.getBeginMetricRowset(string, collectionResult));
                this.write(this.endRowSet());
            }
            return;
        }
        String string5 = "ccr.metric." + string3.toLowerCase() + "." + string4.toLowerCase() + ".";
        if (TargetManager.m_maskedColumns.containsKey(string5) && metricResult != null) {
            if (s_log.isEnabledFor(Logger.DEBUG)) {
                s_log.debug((Object)("Masking metric column/s " + string5 + ((Vector)TargetManager.m_maskedColumns.get(string5)).toString()));
            }
            this.maskIfRequired(metricResult, vector, (Vector)TargetManager.m_maskedColumns.get(string5));
        }
        this.write(this.getBeginMetricRowset(string, collectionResult));
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector2.size(); ++i) {
            ValueRow valueRow = (ValueRow)vector2.get(i);
            stringBuffer.append(this.beginRow());
            if (tableDescriptor.isCmdbConfigurationItem()) {
                UploadTags.ROW_FORMAT.format(new String[]{"IVID", GUID.generateGuid()}, stringBuffer, fieldPosition);
            }
            if (CollectionResult.s_isOCheckCollection) {
                String string6 = target.getGUID();
                UploadTags.ROW_FORMAT.format(new String[]{"TARGET_GUID", string6}, stringBuffer, fieldPosition);
            }
            for (int j = 0; j < vector.size(); ++j) {
                String string7;
                ColumnDescriptor columnDescriptor = (ColumnDescriptor)vector.get(j);
                if (!columnDescriptor.isEnabled()) continue;
                String string8 = columnDescriptor.getColumnName();
                String string9 = valueRow.getValue(j);
                if (TargetManager.m_disabledColumns.containsKey("ccr.metric." + string3.toLowerCase() + "." + string4.toLowerCase() + "." + string8.toLowerCase())) {
                    string9 = null;
                }
                if (!tableDescriptor.isCmdbConfigurationItem()) {
                    string8 = string8.toUpperCase(s_locale);
                }
                if (string9 == null || string9.length() == 0) {
                    UploadTags.ROW_NOVALUE_FORMAT.format(new String[]{string8}, stringBuffer, fieldPosition);
                    continue;
                }
                if (columnDescriptor.isLongText()) {
                    string7 = null;
                    try {
                        string7 = Utils.getDigest((String)string9);
                        if (!this.m_longText.containsKey(string7)) {
                            this.m_longText.put(string7, string9);
                        }
                        UploadTags.ROW_FORMAT.format(new String[]{string8, string7}, stringBuffer, fieldPosition);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        this.formatColumnValue(string8, string9, stringBuffer, fieldPosition);
                    }
                    catch (DigestException digestException) {
                        this.formatColumnValue(string8, string9, stringBuffer, fieldPosition);
                    }
                    continue;
                }
                if (columnDescriptor.isToBeReadFromFile() && this.getClass().equals(class$oracle$sysman$ccr$collector$collectionMgr$XMLUploadWriter == null ? XMLUploadWriter.class$("oracle.sysman.ccr.collector.collectionMgr.XMLUploadWriter") : class$oracle$sysman$ccr$collector$collectionMgr$XMLUploadWriter)) {
                    string7 = string9.substring(0, string9.lastIndexOf("$FileDigest="));
                    String string10 = null;
                    try {
                        string10 = string7 == null ? "ERROR: File name is NULL" : Utils.getFileContent((File)new File(string7));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        string10 = "ERROR: File " + string7 + " was not found";
                    }
                    catch (IOException iOException) {
                        string10 = "ERROR: File " + string7 + " could not be read";
                    }
                    UploadTags.ROW_CDATA_FORMAT.format(new String[]{string8, string10}, stringBuffer, fieldPosition);
                    continue;
                }
                this.formatColumnValue(string8, string9, stringBuffer, fieldPosition);
            }
            if (CollectionResult.s_isOCheckCollection) {
                UploadTags.ROW_FORMAT.format(new String[]{"COLLECTION_TIME", string2}, stringBuffer, fieldPosition);
            }
            stringBuffer.append(this.endRow());
        }
        this.write(stringBuffer.toString());
        this.write(this.endRowSet());
    }

    private void maskIfRequired(MetricResult metricResult, Vector vector, Vector vector2) {
        int n = vector2.size();
        if (n != 0) {
            int[] nArray = new int[n];
            if (vector == null) {
                return;
            }
            block0: for (int i = 0; i < vector.size(); ++i) {
                ColumnDescriptor columnDescriptor = (ColumnDescriptor)vector.get(i);
                for (int j = 0; j < n; ++j) {
                    if (!columnDescriptor.getColumnName().toLowerCase().equals((String)vector2.get(j))) continue;
                    nArray[j] = i;
                    continue block0;
                }
            }
            Vector vector3 = metricResult.getValueRows();
            if (vector3 == null) {
                return;
            }
            for (int i = 0; i < vector3.size(); ++i) {
                ValueRow valueRow = (ValueRow)vector3.get(i);
                for (int j = 0; j < n; ++j) {
                    String string = valueRow.getValue(nArray[j]);
                    string = this.dataMask(string);
                    valueRow.setValue(nArray[j], string);
                }
            }
        }
    }

    private String dataMask(String string) {
        MessageDigest messageDigest = null;
        BigInteger bigInteger = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println("Cannot find digest algorithm");
        }
        byte[] byArray = string.getBytes();
        messageDigest.reset();
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        try {
            bigInteger = new BigInteger(1, byArray2);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("signum is not one of the three legal values (-1, 0, and 1)");
        }
        return bigInteger.toString(32).toUpperCase();
    }

    protected void write(String string) throws IOException {
        this.m_printWriter.write(string, 0, string.length());
    }

    private void collectCmdbInstanceData(CollectionResult collectionResult, String string) {
        MetricResult metricResult = collectionResult.getCollectionResult();
        if (metricResult == null) {
            return;
        }
        MetricValue metricValue = metricResult.getValue();
        if (metricValue == null) {
            return;
        }
        String string2 = metricValue.getContents();
        CmdbInstanceDataParser cmdbInstanceDataParser = new CmdbInstanceDataParser(string2, string);
        try {
            cmdbInstanceDataParser.parseInstanceData();
            this.m_cmdbInstanceTypes.add(cmdbInstanceDataParser.getInstanceTypes());
        }
        catch (SAXException sAXException) {
            Target target = this.m_resultMap.getTargetInstance();
            s_log.error(CollectionMgrMsgID.ERROR_PARSING_CMDB_INSTANCE_DATA, (Object[])new String[]{collectionResult.getMetricCollectionName(), target.getTargetName(), target.getTargetType(), sAXException.getMessage()});
        }
        catch (IOException iOException) {
            Target target = this.m_resultMap.getTargetInstance();
            s_log.error(CollectionMgrMsgID.ERROR_PARSING_CMDB_INSTANCE_DATA, (Object[])new String[]{collectionResult.getMetricCollectionName(), target.getTargetName(), target.getTargetType(), iOException.getMessage()});
        }
    }

    public static Object[] convertToAgentFormat(InputSource inputSource, OutputStreamWriter outputStreamWriter, TargetMapper targetMapper) throws IOException, SAXException {
        XMLUploadWriter xMLUploadWriter = new XMLUploadWriter(outputStreamWriter, null);
        xMLUploadWriter.convertToAgentFormat(inputSource, targetMapper);
        return null;
    }

    private void convertToAgentFormat(InputSource inputSource, TargetMapper targetMapper) throws IOException, SAXException {
        String[] stringArray;
        CmdbInstanceDataParser cmdbInstanceDataParser = new CmdbInstanceDataParser(null, "1");
        cmdbInstanceDataParser.parseInstanceData(inputSource);
        this.m_cmdbInstanceTypes.add(cmdbInstanceDataParser.getInstanceTypes());
        String string = cmdbInstanceDataParser.getTargetName();
        String string2 = cmdbInstanceDataParser.getTargetType();
        String string3 = cmdbInstanceDataParser.getCollectionGroupName();
        String string4 = cmdbInstanceDataParser.getHostName();
        String string5 = cmdbInstanceDataParser.getInstallLocation();
        String string6 = cmdbInstanceDataParser.getConfigLocation();
        String string7 = cmdbInstanceDataParser.getOrgId();
        String string8 = cmdbInstanceDataParser.getCollectionTS();
        String string9 = cmdbInstanceDataParser.getTimezone();
        if (string3 == null || string3.length() == 0) {
            string3 = "defaultCollectionGroup";
        }
        String string10 = null;
        if (targetMapper != null && string4 == null && string5 == null && string7 == null && (stringArray = targetMapper.map(new String[]{string, string2, string4, string5, string6, string7})) != null) {
            int n = 0;
            string10 = stringArray[n++];
            string = stringArray[n++];
            string2 = stringArray[n++];
            string4 = stringArray[n++];
            string5 = stringArray[n++];
            string6 = stringArray[n++];
            string7 = stringArray[n++];
        }
        stringArray = new Target(string, string2, false, string, true, null, string5 == null ? "" : string5, string6, true, string4 == null ? "" : string4, string9, "1");
        String string11 = stringArray.getTimeZone();
        if (string9 != null && string9.length() > 0 && string11 == null) {
            s_log.error(TargetsMsgID.INVALID_COLLECTION_TIMEZONE, (Object[])new String[]{string9, string, string2, Timezone.getTimezonesFilename()});
            throw new SAXException("Timezone " + string9 + " is not supported. See " + Timezone.getTimezonesFilename() + " for a list of suppored timezones.");
        }
        if (string10 != null) {
            stringArray.setGUID(string10);
        } else {
            stringArray.generateGUIDForImport(string7, string4);
        }
        this.m_resultMap = new CollectionResultList((Target)stringArray, string3, "1");
        this.write(this.getUploadPreambleForImport((Target)stringArray, string3, string4, string5, string8, string11));
        this.write(this.getTargetMapping((Target)stringArray, string7, string11));
        this.writeCmdbInstanceData();
        this.writeLongText();
        this.write(this.endUpload());
        this.m_printWriter.close();
    }

    private void writeCmdbInstanceData() throws IOException {
        ArrayList arrayList = Instances.mergeInstanceTypes(this.m_cmdbInstanceTypes);
        for (int i = 0; i < arrayList.size(); ++i) {
            Instances instances = (Instances)arrayList.get(i);
            ArrayList arrayList2 = instances.getInstances();
            if (arrayList2 == null) continue;
            String string = instances.getInstanceTypeStart();
            this.write(string);
            for (int j = 0; j < arrayList2.size(); ++j) {
                Instance instance = (Instance)arrayList2.get(j);
                string = instance.generateUploadXml();
                this.write(string);
            }
            string = instances.getInstanceTypeEnd();
            this.write(string);
        }
    }

    private void writeLongText() throws IOException {
        int n = this.m_longText.size();
        if (n == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(1);
        UploadTags.LONG_TEXT_ROWSET_HDR.format(new String[]{XMLUploadWriter.getProtocolVersion()}, stringBuffer, fieldPosition);
        Set set = this.m_longText.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.m_longText.get(string);
            stringBuffer.append("  <ROW>\n");
            UploadTags.ROW_FORMAT.format(new String[]{"DIGEST", string}, stringBuffer, fieldPosition);
            MessageFormat messageFormat = null;
            if (XMLOps.hasInvalidCDATA((String)string2)) {
                string2 = XMLOps.filterInvalidCDATA((String)string2);
                s_log.warn(CollectionMgrMsgID.INVALID_CHARS);
            }
            messageFormat = XMLOps.hasSpecialChars((String)string2) ? UploadTags.ROW_CDATA_FORMAT : UploadTags.ROW_FORMAT;
            messageFormat.format(new String[]{"PREFIX", string2}, stringBuffer, fieldPosition);
            stringBuffer.append("  </ROW>\n");
        }
        stringBuffer.append("</ROWSET>\n");
        this.write(stringBuffer.toString());
    }

    private void appendIsGCAttributeToExtraAttribute(StringBuffer stringBuffer) {
        if (this.m_isGC) {
            boolean bl = GCContextManager.getGCContext().isForceUpload();
            String string = GCContextManager.getGCContext().getHarvesterSource();
            String string2 = null;
            if (string != null) {
                if (string.equals("GC")) {
                    string2 = IS_GC_FOR_GC;
                    if (bl) {
                        string2 = IS_GC_FOR_GC_FORCED;
                    }
                } else {
                    string2 = string;
                    if (bl) {
                        string2 = string + "_FORCE";
                    }
                }
            }
            if (string2 != null) {
                UploadTags.IS_GC_FORMAT.format(new String[]{string2}, stringBuffer, (FieldPosition)null);
            }
        }
    }

    private void appendMosMetalLevelToExtraAttribute(StringBuffer stringBuffer) {
        Target target = this.m_resultMap.getTargetInstance();
        String string = target.getTargetProperty("METAL_LEVEL");
        if (null != string && string.length() > 0) {
            UploadTags.MOS_METAL_LEVEL.format(new String[]{string}, stringBuffer, (FieldPosition)null);
        }
    }

    private void appendTargetPropertyToExtraAttribute(StringBuffer stringBuffer) {
        Target target = this.m_resultMap.getTargetInstance();
        String string = target.getTargetProperty("orcl_ccr_lifecycle_status");
        String string2 = target.getTargetProperty("orcl_ccr_display_name");
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("TargetLifecycle property is: " + string + " and display name property is: " + string2));
        }
        if (string != null && string.length() > 0 || string2 != null && string2.length() > 0) {
            UploadTags.TARGET_PROPS.format(new String[]{string, string2}, stringBuffer, (FieldPosition)null);
        }
    }

    private void appendOldTargetGuidToExtraAttribute(StringBuffer stringBuffer) {
        if (this.m_bCollectorFiltered) {
            return;
        }
        Target target = this.m_resultMap.getTargetInstance();
        String string = null;
        String string2 = null;
        try {
            string = target.generateOldTargetGuid();
            string2 = target.getGUID();
            if (string == null) {
                return;
            }
            if (string.equals(string2)) {
                return;
            }
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("m_bCollectorFiltered: " + this.m_bCollectorFiltered));
                s_log.debug((Object)("oldTargetGuid: " + string));
            }
            if (string != null) {
                UploadTags.OLD_TARGET_GUID.format(new String[]{string}, stringBuffer, (FieldPosition)null);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            s_log.error(TargetsMsgID.OLD_TARGET_GUID_ERR, (Object[])new String[]{"Parsing error while trying to get the old target guid.", parserConfigurationException.getMessage()});
        }
        catch (SAXException sAXException) {
            s_log.error(TargetsMsgID.OLD_TARGET_GUID_ERR, (Object[])new String[]{"SAXException while trying to get the old target guid.", sAXException.getMessage()});
        }
        catch (IOException iOException) {
            s_log.error(TargetsMsgID.OLD_TARGET_GUID_ERR, (Object[])new String[]{"IOException while trying to get the old target guid.", iOException.getMessage()});
        }
    }

    private static String getEmdUrl() {
        if (m_emdUrl != null) {
            return m_emdUrl;
        }
        m_emdUrl = "http://" + Hostname.getHostname() + "/ccr";
        return m_emdUrl;
    }

    /*
     * Loose catch block
     */
    public static final void main(String[] stringArray) {
        block20: {
            if (stringArray.length < 2) {
                System.err.println("Did not find sourceFileName and outputFileName arguments on the command line.");
                return;
            }
            String string = stringArray[0];
            String string2 = stringArray[1];
            FileInputStream fileInputStream = null;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            FilterOutputStream filterOutputStream = null;
            try {
                fileInputStream = new FileInputStream(new File(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new RuntimeException("Source file is not found: '" + fileNotFoundException.getMessage() + "'; " + fileNotFoundException.toString());
            }
            catch (SecurityException securityException) {
                throw new RuntimeException("Security exception while opening source file: '" + securityException.getMessage() + "'; " + securityException.toString());
            }
            XMLUploadWriter.convertToAgentFormat(new InputSource(fileInputStream), new OutputStreamWriter((OutputStream)new BufferedOutputStream(byteArrayOutputStream), "UTF-8"), null);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            File file = new File(string2);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            filterOutputStream = new BufferedOutputStream(fileOutputStream);
            int n = 0;
            while ((n = byteArrayInputStream.read()) != -1) {
                ((BufferedOutputStream)filterOutputStream).write(n);
            }
            Object var11_13 = null;
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                break block20;
            }
            catch (Throwable throwable) {}
            break block20;
            {
                catch (Exception exception) {
                    throw new RuntimeException("Caught exception in main(): " + exception.getMessage() + "; " + exception.toString());
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                try {
                    if (filterOutputStream != null) {
                        filterOutputStream.close();
                    }
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        System.out.println("Finished conversion: success");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        s_dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        s_protocolVersion = null;
        s_protocolVersionSet = false;
        m_emdUrl = null;
    }
}

