/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.collectionMgr.cmdb;

import java.io.IOException;
import java.io.StringReader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import oracle.sysman.ccr.collector.collectionMgr.cmdb.GUID;
import oracle.sysman.ccr.collector.collectionMgr.cmdb.Instance;
import oracle.sysman.ccr.collector.collectionMgr.cmdb.Instances;
import oracle.sysman.ccr.common.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class CmdbInstanceDataParser
extends DefaultHandler {
    private static Logger s_log = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$collectionMgr$cmdb$CmdbInstanceDataParser == null ? (class$oracle$sysman$ccr$collector$collectionMgr$cmdb$CmdbInstanceDataParser = CmdbInstanceDataParser.class$("oracle.sysman.ccr.collector.collectionMgr.cmdb.CmdbInstanceDataParser")) : class$oracle$sysman$ccr$collector$collectionMgr$cmdb$CmdbInstanceDataParser));
    private static final String INSTANCES = "INSTANCES";
    private static final String INSTANCE = "INSTANCE";
    private static final String PROPERTY_VALUE = "PROPERTYVALUE";
    private static final String LIST = "LIST";
    private static final String ITEM = "ITEM";
    private static final String TYPE_NAME = "TYPE_NAME";
    private static final String PACKAGE_NAME = "PACKAGE_NAME";
    private static final String MODEL_TYPE = "MODEL_TYPE";
    private static final String PROPERTY = "PROPERTY";
    static final String CMDB_CLASS_TYPE = "CLASS";
    static final String CMDB_LIST_TYPE = "LIST";
    static final String CMDB_BASIC_TYPE = "BASIC";
    private static final String CMDB_LIST_PROPERTY = "value";
    private static final String DATA = "DATA";
    private static final String TGT_NAME = "TARGET_NAME";
    private static final String TGT_TYPE = "TARGET_TYPE";
    private static final String COLLECTION_GROUP_NAME = "COLLECTION_GROUP_NAME";
    private static final String HOST_NAME = "HOST_NAME";
    private static final String INSTALL_LOCATION = "INSTALL_LOCATION";
    private static final String CONFIG_LOCATION = "CONFIG_LOCATION";
    private static final String ORD_ID = "ORG_ID";
    private static final String COLLECTION_TS = "COLLECTION_TIMESTAMP";
    private static final String TZ = "TIMEZONE";
    private String m_xml = null;
    private String m_strMetadataVersion = null;
    private ArrayList m_instanceTypesArray = new ArrayList();
    private HashMap m_instanceTypes = new HashMap();
    private Stack m_instancesStack = new Stack();
    private Stack m_instanceStack = new Stack();
    private Stack m_propertyStack = new Stack();
    private Stack m_listStack = new Stack();
    private Stack m_posStack = new Stack();
    private StringBuffer m_buffer = null;
    private String m_lastElement = "";
    private boolean m_inProperty = false;
    private boolean m_inList = false;
    private String m_tgtName = null;
    private String m_tgtType = null;
    private String m_collectionGroupName = null;
    private String m_hostName = null;
    private String m_installLocation = null;
    private String m_configLocation = null;
    private String m_orgId = null;
    private String m_collectionTS = null;
    private String m_timezone = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$collectionMgr$cmdb$CmdbInstanceDataParser;

    public CmdbInstanceDataParser(String string, String string2) {
        this.m_xml = string;
        this.m_strMetadataVersion = string2;
    }

    public String getTargetName() {
        return this.m_tgtName;
    }

    public String getTargetType() {
        return this.m_tgtType;
    }

    public String getCollectionGroupName() {
        return this.m_collectionGroupName;
    }

    public String getHostName() {
        return this.m_hostName;
    }

    public String getInstallLocation() {
        return this.m_installLocation;
    }

    public String getConfigLocation() {
        return this.m_configLocation;
    }

    public String getOrgId() {
        return this.m_orgId;
    }

    public String getCollectionTS() {
        return this.m_collectionTS;
    }

    public String getTimezone() {
        return this.m_timezone;
    }

    public ArrayList getInstanceTypes() {
        return this.m_instanceTypesArray;
    }

    public void parseInstanceData() throws SAXException, IOException {
        this.parseInstanceData(new InputSource(new StringReader(this.m_xml)));
    }

    public void parseInstanceData(InputSource inputSource) throws SAXException, IOException {
        XMLReader xMLReader = XMLReaderFactory.createXMLReader("oracle.xml.parser.v2.SAXParser");
        xMLReader.setContentHandler(this);
        xMLReader.parse(inputSource);
    }

    public void startDocument() throws SAXException {
        if (s_log.isEnabledFor(Logger.DEBUG)) {
            s_log.debug((Object)"Starting to parse CMDB instance data");
            s_log.debug((Object)this.m_xml);
        }
    }

    public void endDocument() throws SAXException {
        if (s_log.isEnabledFor(Logger.DEBUG)) {
            s_log.debug((Object)"Finished parsing CMDB instace data");
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.m_buffer = new StringBuffer();
        if (string3.equalsIgnoreCase(INSTANCES)) {
            String string4 = attributes.getValue(PACKAGE_NAME);
            String string5 = attributes.getValue(TYPE_NAME);
            String string6 = attributes.getValue(MODEL_TYPE);
            if (string6 == null || string6.length() == 0) {
                string6 = CMDB_CLASS_TYPE;
            }
            this.createInstanceType(string4, string5, string6, this.m_strMetadataVersion);
            this.m_lastElement = INSTANCES;
            this.m_posStack.push(new Integer(0));
        } else if (string3.equalsIgnoreCase(INSTANCE)) {
            Instances instances = (Instances)this.m_instancesStack.peek();
            this.createInstance(instances);
            this.m_lastElement = INSTANCE;
        } else if (string3.equalsIgnoreCase(PROPERTY_VALUE)) {
            String string7 = attributes.getValue(PROPERTY);
            this.m_propertyStack.push(string7);
            this.m_lastElement = PROPERTY_VALUE;
            this.m_inProperty = true;
        } else if (string3.equalsIgnoreCase("LIST")) {
            String string8 = attributes.getValue(PACKAGE_NAME);
            String string9 = attributes.getValue(TYPE_NAME);
            String string10 = attributes.getValue(MODEL_TYPE);
            this.createInstanceType(string8, string9, string10, this.m_strMetadataVersion);
            this.m_lastElement = "LIST";
            this.m_inList = true;
            this.m_posStack.push(new Integer(0));
        } else if (string3.equalsIgnoreCase(ITEM)) {
            Instances instances = (Instances)this.m_instancesStack.peek();
            String string11 = instances.getModelType();
            if (CMDB_BASIC_TYPE.equalsIgnoreCase(string11)) {
                this.createInstance(instances);
            }
            this.m_lastElement = ITEM;
        } else if (string3.equalsIgnoreCase(DATA)) {
            this.m_tgtName = attributes.getValue(TGT_NAME);
            this.m_tgtType = attributes.getValue(TGT_TYPE);
            this.m_collectionGroupName = attributes.getValue(COLLECTION_GROUP_NAME);
            this.m_hostName = attributes.getValue(HOST_NAME);
            this.m_installLocation = attributes.getValue(INSTALL_LOCATION);
            this.m_configLocation = attributes.getValue(CONFIG_LOCATION);
            this.m_orgId = attributes.getValue(ORD_ID);
            this.m_collectionTS = attributes.getValue(COLLECTION_TS);
            this.m_timezone = attributes.getValue(TZ);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase(INSTANCES)) {
            Object e = this.m_instancesStack.pop();
            e = this.m_posStack.pop();
        } else if (string3.equalsIgnoreCase(INSTANCE)) {
            Object e = this.m_instanceStack.pop();
        } else if (string3.equalsIgnoreCase(PROPERTY_VALUE)) {
            String string4 = (String)this.m_propertyStack.pop();
            Instance instance = (Instance)this.m_instanceStack.peek();
            if (this.m_lastElement.equals(PROPERTY_VALUE)) {
                instance.addProperty(string4, this.m_buffer.toString());
            }
            this.m_inProperty = false;
        } else if (string3.equalsIgnoreCase("LIST")) {
            Object e = this.m_instancesStack.pop();
            if (this.m_lastElement.equals(ITEM)) {
                e = this.m_instanceStack.pop();
            }
            this.m_inList = false;
            e = this.m_posStack.pop();
        } else if (string3.equalsIgnoreCase(ITEM) && this.m_lastElement.equals(ITEM)) {
            Instance instance = (Instance)this.m_instanceStack.pop();
            instance.addProperty(CMDB_LIST_PROPERTY, this.m_buffer.toString());
        }
        this.m_lastElement = "";
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        this.m_buffer.append(string.trim());
    }

    private void initInstance(Instance instance) throws SAXException {
        Object object;
        String string = null;
        int n = this.m_instanceStack.indexOf(instance);
        if (n == -1) {
            throw new SAXException("Instance not found on stack");
        }
        try {
            string = GUID.generateGuid();
            instance.setGuid(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new SAXException("Error parsing Instance: " + unknownHostException.getMessage());
        }
        if (n > 0) {
            object = (Instance)this.m_instanceStack.get(n - 1);
            if (object == null) {
                throw new SAXException("Parent Instance not found on stack");
            }
            string = ((Instance)object).getGuid();
            instance.setParentGuid(string);
            instance.setParentPackageName(((Instance)object).getPackageName());
            instance.setParentTypeName(((Instance)object).getTypeName());
        }
        if (this.m_inProperty || this.m_inList) {
            instance.setParentProperty((String)this.m_propertyStack.peek());
        }
        if (this.m_inList) {
            object = (Integer)this.m_posStack.pop();
            int n2 = (Integer)object;
            instance.setListItem(n2);
            this.m_posStack.push(new Integer(n2 + 1));
        }
    }

    private void createInstanceType(String string, String string2, String string3, String string4) throws SAXException {
        String string5 = new String(string + string2 + string3);
        Instances instances = (Instances)this.m_instanceTypes.get(string5);
        if (instances == null) {
            instances = new Instances(string, string2, string3, this.m_strMetadataVersion);
            this.m_instanceTypes.put(string5, instances);
            this.m_instanceTypesArray.add(instances);
        }
        this.m_instancesStack.push(instances);
    }

    private void createInstance(Instances instances) throws SAXException {
        Instance instance = new Instance(instances);
        this.m_instanceStack.push(instance);
        try {
            this.initInstance(instance);
        }
        catch (SAXException sAXException) {
            Object e = this.m_instanceStack.pop();
            throw sAXException;
        }
        instances.addInstance(instance);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

