/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.diagcheck;

import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import oracle.security.misc.Checksum;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleWallet;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.diagcheck.DiagcheckException;
import oracle.sysman.ccr.collector.diagcheck.DiagcheckMsgID;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.collector.util.UplinkHomeConfigWriter;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.ConfigWriter;
import oracle.sysman.ccr.common.FileReadException;
import oracle.sysman.ccr.common.FileWriteException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;
import oracle.sysman.ccr.util.crypt.Crypt;

public class DiagcheckWallet {
    public static final int SEED_LENGTH = 20;
    private String m_walletLoc = FileSpec.catfile((String[])new String[]{Collector.getCCRConfigHome(), UplinkPath.DIAGCHECK_WALLET_PATH});
    private OracleWallet m_wallet = new OracleWallet();
    private boolean m_isWalletOpen = false;
    private Logger m_log = null;
    private static final String s_walletFile = "ewallet.p12";
    public static final DiagcheckWallet INSTANCE = new DiagcheckWallet();
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$diagcheck$DiagcheckWallet;

    private DiagcheckWallet() {
        DiagcheckWallet.configLogging();
        this.m_log = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$diagcheck$DiagcheckWallet == null ? (class$oracle$sysman$ccr$collector$diagcheck$DiagcheckWallet = DiagcheckWallet.class$("oracle.sysman.ccr.collector.diagcheck.DiagcheckWallet")) : class$oracle$sysman$ccr$collector$diagcheck$DiagcheckWallet));
    }

    public static DiagcheckWallet getInstance() {
        return INSTANCE;
    }

    private static void configLogging() {
        if (!Logger.isLoggingConfigured()) {
            Config config = UplinkHomeConfig.getInstance();
            Properties properties = config.getProperties();
            Logger.init((Properties)properties);
        }
    }

    private char[] createWallet() throws DiagcheckException {
        byte[] byArray;
        char[] cArray = DiagcheckWallet.generateRandomKey();
        try {
            this.m_wallet.create(cArray);
            this.m_wallet.saveAs(this.m_walletLoc);
            byArray = Checksum.MD5((byte[])new String(cArray).getBytes(), null);
        }
        catch (Exception exception) {
            throw new DiagcheckException("Failed to encrypt wallet password", exception);
        }
        String string = Crypt.byteArrayToAsciiString((byte[])byArray);
        try {
            ConfigWriter configWriter = UplinkHomeConfigWriter.getInstance();
            configWriter.setProperty("diagcheck.walletKey", string);
            configWriter.persistProperties();
        }
        catch (FileReadException fileReadException) {
            throw new DiagcheckException("Failed to open collector.properties file", fileReadException);
        }
        catch (FileWriteException fileWriteException) {
            throw new DiagcheckException("Failed to write diagcheck wallet key to collector.properties file", fileWriteException);
        }
        return cArray;
    }

    private boolean walletExists() {
        String string = FileSpec.catfile((String[])new String[]{this.m_walletLoc, s_walletFile});
        File file = new File(string);
        return file.exists();
    }

    private int openWallet(boolean bl) {
        char[] cArray = null;
        if (!this.m_isWalletOpen) {
            if (!this.walletExists()) {
                if (bl) {
                    if (this.m_log.isDebugEnabled()) {
                        this.m_log.debug((Object)"Wallet does not exist");
                    }
                    return -1;
                }
                try {
                    cArray = this.createWallet();
                }
                catch (DiagcheckException diagcheckException) {
                    this.m_log.warn(DiagcheckMsgID.WALLET_ERR_CREATE, (Object[])new String[]{((Throwable)((Object)diagcheckException)).getMessage()});
                    return -1;
                }
            }
            if (cArray == null) {
                ConfigWriter configWriter;
                try {
                    configWriter = UplinkHomeConfigWriter.getInstance();
                }
                catch (FileReadException fileReadException) {
                    this.m_log.warn(DiagcheckMsgID.WALLET_ERR_KEY_READ, (Object[])new String[]{fileReadException.getMessage()});
                    return -1;
                }
                String string = configWriter.propertyValue("diagcheck.walletKey");
                if (string != null) {
                    try {
                        cArray = new String(Checksum.SHA((byte[])Crypt.asciiStringToByteArray((String)string), null)).toCharArray();
                    }
                    catch (Exception exception) {
                        this.m_log.warn(DiagcheckMsgID.WALLET_ERR_KEY_READ, (Object[])new String[]{exception.getMessage()});
                        return -1;
                    }
                } else {
                    this.m_log.warn(DiagcheckMsgID.WALLET_ERR_KEY_MISSING);
                    return -1;
                }
            }
            try {
                this.m_wallet.open(this.m_walletLoc, cArray);
            }
            catch (IOException iOException) {
                this.m_log.warn(DiagcheckMsgID.WALLET_ERR_OPEN, (Object[])new String[]{iOException.getMessage()});
                return -1;
            }
            this.m_isWalletOpen = true;
            Arrays.fill(cArray, '\u0000');
        }
        return 0;
    }

    public String getProperty(String string, String string2, String string3) {
        String string4 = null;
        try {
            if (this.openWallet(true) != 0) {
                return null;
            }
            String string5 = string + "##" + string2 + "##" + string3;
            OracleSecretStore oracleSecretStore = this.m_wallet.getSecretStore();
            if (oracleSecretStore.containsAlias(string5)) {
                string4 = new String(oracleSecretStore.getSecret(string5));
            }
        }
        catch (Exception exception) {
            this.m_log.warn(DiagcheckMsgID.WALLET_ERR_READ, (Object[])new String[]{exception.getMessage()});
        }
        return string4;
    }

    public HashMap getProperties(String string, String string2, List list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        OracleSecretStore oracleSecretStore = null;
        if (string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
            return hashMap;
        }
        if (this.openWallet(true) != 0) {
            return hashMap;
        }
        try {
            oracleSecretStore = this.m_wallet.getSecretStore();
        }
        catch (Exception exception) {
            this.m_log.warn(DiagcheckMsgID.WALLET_ERR_READ, (Object[])new String[]{exception.getMessage()});
            return hashMap;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            String string4 = string + "##" + string2 + "##" + string3;
            try {
                if (!oracleSecretStore.containsAlias(string4)) continue;
                String string5 = new String(oracleSecretStore.getSecret(string4));
                hashMap.put(string3, string5);
            }
            catch (Exception exception) {
                this.m_log.warn(DiagcheckMsgID.WALLET_ERR_READ, (Object[])new String[]{exception.getMessage()});
            }
        }
        return hashMap;
    }

    public int setProperty(String string, String string2, String string3, char[] cArray) {
        int n = -1;
        if (string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
            if (this.m_log.isDebugEnabled()) {
                this.m_log.debug((Object)"setProperty: null or empty targetType/targetName");
            }
            return n;
        }
        try {
            String string4;
            if (this.openWallet(false) != 0) {
                return -1;
            }
            OracleSecretStore oracleSecretStore = this.m_wallet.getSecretStore();
            if (oracleSecretStore.containsAlias(string4 = string + "##" + string2 + "##" + string3) && this.m_log.isDebugEnabled()) {
                this.m_log.debug((Object)("Property value for " + string4 + " already exists." + "Overwrite the old value"));
            }
            oracleSecretStore.setSecret(string4, cArray);
            Arrays.fill(cArray, '\u0000');
            this.m_wallet.setSecretStore(oracleSecretStore);
            this.m_wallet.save();
            n = 0;
        }
        catch (Exception exception) {
            this.m_log.warn(DiagcheckMsgID.WALLET_ERR_WRITE, (Object[])new String[]{exception.getMessage()});
        }
        return n;
    }

    public int setProperties(String string, String string2, HashMap hashMap) {
        int n = -1;
        OracleSecretStore oracleSecretStore = null;
        if (string == null || string2 == null || string.length() == 0 || string2.length() == 0 || hashMap == null || hashMap.isEmpty()) {
            if (this.m_log.isDebugEnabled()) {
                this.m_log.debug((Object)"setProperties: null or empty targetType/targetName or empty porperty list");
            }
            return n;
        }
        if (this.openWallet(false) != 0) {
            return -1;
        }
        try {
            oracleSecretStore = this.m_wallet.getSecretStore();
        }
        catch (Exception exception) {
            this.m_log.warn(DiagcheckMsgID.WALLET_ERR_READ, (Object[])new String[]{exception.getMessage()});
            return n;
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            char[] cArray = (char[])hashMap.get(string3);
            String string4 = string + "##" + string2 + "##" + string3;
            try {
                if (oracleSecretStore.containsAlias(string4) && this.m_log.isDebugEnabled()) {
                    this.m_log.debug((Object)("Property value for " + string4 + " already " + "exists. Overwrite the old value"));
                }
                oracleSecretStore.setSecret(string4, cArray);
            }
            catch (Exception exception) {
                this.m_log.warn(DiagcheckMsgID.WALLET_ERR_WRITE, (Object[])new String[]{exception.getMessage()});
            }
            Arrays.fill(cArray, '\u0000');
        }
        try {
            this.m_wallet.setSecretStore(oracleSecretStore);
            this.m_wallet.save();
            n = 0;
        }
        catch (Exception exception) {
            this.m_log.warn(DiagcheckMsgID.WALLET_ERR_WRITE, (Object[])new String[]{exception.getMessage()});
        }
        return n;
    }

    public boolean isPropertyExist(String string, String string2, String string3) {
        if (string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
            if (this.m_log.isDebugEnabled()) {
                this.m_log.debug((Object)"isPropertyExist: null or empty targetType/targetName");
            }
            return false;
        }
        try {
            if (this.openWallet(true) != 0) {
                return false;
            }
            String string4 = string + "##" + string2 + "##" + string3;
            OracleSecretStore oracleSecretStore = this.m_wallet.getSecretStore();
            return oracleSecretStore.containsAlias(string4);
        }
        catch (Exception exception) {
            this.m_log.warn(DiagcheckMsgID.WALLET_ERR_READ, (Object[])new String[]{exception.getMessage()});
            return false;
        }
    }

    private static String getFixedLengthStr(String string, int n) {
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() > n) {
            string2 = string.substring(0, n);
        } else if (string.length() < n) {
            stringBuffer = stringBuffer.append(string);
            while (stringBuffer.length() < n) {
                stringBuffer = stringBuffer.append("0");
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private static char[] generateRandomKey() {
        String string = null;
        long l = new Date().getTime() + new SecureRandom().nextLong();
        Long l2 = new Long(l);
        if (l2 != null) {
            string = l2.toString();
        }
        if (string != null) {
            string = DiagcheckWallet.getFixedLengthStr(string, 20);
        }
        return string.toCharArray();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

