/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.diagnosticUpload;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.diagnosticUpload.UploadStateHandler;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.NoSuchReqException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.diagnostic.common.DiagUploadState;
import oracle.sysman.ccr.diagnostic.common.DiagnosticMsgID;
import oracle.sysman.ccr.diagnostic.common.UploaderMsgID;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.InvalidStateException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.StateAccessException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.StateCreationException;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;

public class UploadState
extends DiagUploadState {
    private static Logger s_logger = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$diagnosticUpload$UploadState == null ? (class$oracle$sysman$ccr$collector$diagnosticUpload$UploadState = UploadState.class$("oracle.sysman.ccr.collector.diagnosticUpload.UploadState")) : class$oracle$sysman$ccr$collector$diagnosticUpload$UploadState));
    private static MessageBundle s_msgBundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.diagnostic.common.Uploader");
    private static MessageBundle s_msgCommonBundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.diagnostic.common.Diagnostic");
    private StringBuffer m_uploadStateXML = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$diagnosticUpload$UploadState;

    public UploadState(String string, String string2, long l, String string3) throws StateCreationException, StateAccessException {
        super(string, string2, l, string3);
    }

    public UploadState(String string, String string2) throws NoSuchReqException, InvalidStateException, StateAccessException {
        this.m_serviceRequest = string;
        this.m_packageName = string2;
        this.load();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
        Date date = new Date();
        ++this.m_restartCount;
        this.m_startTime = simpleDateFormat.format(date);
        this.m_processID = -1;
    }

    public UploadState(File file) throws InvalidStateException, StateAccessException, NoSuchReqException {
        this.load(file);
    }

    public static String getStateFilePath(String string, String string2) {
        File file = new File(string2);
        return FileSpec.catfile((String[])new String[]{Collector.getCCRConfigHome(), UplinkPath.STATE_DIAGNOSTIC_PATH, string, file.getName() + ".xml"});
    }

    private String getStateFilePath() {
        return UploadState.getStateFilePath(this.m_serviceRequest, this.m_packageName);
    }

    private void load() throws InvalidStateException, StateAccessException, NoSuchReqException {
        File file = new File(this.getStateFilePath());
        this.load(file);
    }

    private void load(File file) throws InvalidStateException, StateAccessException, NoSuchReqException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)UploadState.prefixMsg("Loading upload state.", file.getAbsolutePath()));
        }
        UploadStateHandler uploadStateHandler = new UploadStateHandler(file);
        this.m_startTime = uploadStateHandler.getStartTime();
        this.m_submitTime = uploadStateHandler.getSubmitTime();
        this.m_updateTime = uploadStateHandler.getUpdateTime();
        this.m_packageName = uploadStateHandler.getPackageName();
        this.m_packageSize = uploadStateHandler.getPackageSize();
        this.m_packageDigest = uploadStateHandler.getPackageDigest();
        this.m_state = uploadStateHandler.getState();
        this.m_progress = uploadStateHandler.getProgress();
        this.m_processID = uploadStateHandler.getProcessID();
        this.m_restartCount = uploadStateHandler.getRestartCount();
        this.m_endTime = uploadStateHandler.getEndTime();
    }

    public void update(String string, long l) throws StateCreationException, StateAccessException {
        this.m_state = string;
        this.m_progress = l;
        if (this.m_state.equals("COMPLETED")) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
            this.m_endTime = simpleDateFormat.format(new Date());
        }
        this.writeUploadState();
    }

    private void setupStateDir() throws StateCreationException {
        File file = new File(this.getStateFilePath());
        File file2 = new File(file.getParent());
        if (!file2.exists()) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)UploadState.prefixMsg("Creating directory structure for upload state.", file.getAbsolutePath()));
            }
            if (!file2.mkdirs()) {
                String string = s_msgBundle.getMessage(UploaderMsgID.STATE_CREATION_ERROR, false);
                throw new StateCreationException(UploadState.prefixMsg(string, file.getAbsolutePath()));
            }
        }
    }

    private String getDTDPath() {
        return FileSpec.catfile((String[])new String[]{"file:" + Collector.getCCRRoot(), UplinkPath.DTD_HOME_PATH, "DiagnosticUpload.dtd"});
    }

    private void writeUploadState() throws StateCreationException, StateAccessException {
        try {
            Date date;
            this.setupStateDir();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
            this.m_updateDate = date = new Date();
            this.m_updateTime = simpleDateFormat.format(date);
            FileOutputStream fileOutputStream = new FileOutputStream(this.getStateFilePath());
            if (this.m_uploadStateXML == null) {
                this.m_uploadStateXML = new StringBuffer();
            }
            this.m_uploadStateXML.delete(0, this.m_uploadStateXML.length());
            this.m_uploadStateXML.append("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>\n<!DOCTYPE DiagnosticUpload SYSTEM \"" + this.getDTDPath() + "\">" + "<DiagnosticUpload SUBMITTIME=\"" + this.m_submitTime + "\" STARTTIME=\"" + this.m_startTime + "\" UPDATETIME=\"" + this.m_updateTime + "\"");
            if (this.m_endTime != null) {
                this.m_uploadStateXML.append(" ENDTIME=\"" + this.m_endTime + "\"");
            }
            this.m_uploadStateXML.append(">  <Package NAME=\"" + this.m_packageName + "\" SIZE=\"" + this.m_packageSize + "\" DIGEST=\"" + this.m_packageDigest + "\"/>" + "  <Upload STATE=\"" + this.m_state + "\" PROGRESS=\"" + this.m_progress + "\"/>" + "  <Process ID=\"" + this.m_processID + "\"/>" + "  <Restart COUNT=\"" + this.m_restartCount + "\"/>" + "</DiagnosticUpload>");
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)UploadState.prefixMsg("Writing upload state.", this.getStateFilePath()));
                s_logger.debug((Object)this.m_uploadStateXML.toString());
            }
            fileOutputStream.write(this.m_uploadStateXML.toString().getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = s_msgCommonBundle.getMessage(DiagnosticMsgID.STATE_ACCESS_ERROR, false, new Object[]{fileNotFoundException.getMessage()});
            throw new StateAccessException(UploadState.prefixMsg(string, this.getStateFilePath()));
        }
        catch (IOException iOException) {
            String string = s_msgCommonBundle.getMessage(DiagnosticMsgID.STATE_ACCESS_ERROR, false, new Object[]{iOException.getMessage()});
            throw new StateAccessException(UploadState.prefixMsg(string, this.getStateFilePath()));
        }
    }

    public static String prefixMsg(String string, String string2) {
        String string3 = "[STATE: " + string2 + "] - ";
        return string3 + string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

