/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.diagnosticUpload;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import oracle.sysman.ccr.collector.diagnosticUpload.UploadState;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.NoSuchReqException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.diagnostic.common.DiagnosticMsgID;
import oracle.sysman.ccr.diagnostic.common.UploaderMsgID;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.InvalidStateException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.StateAccessException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class UploadStateHandler
extends DefaultHandler {
    private static Logger s_logger = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$diagnosticUpload$UploadStateHandler == null ? (class$oracle$sysman$ccr$collector$diagnosticUpload$UploadStateHandler = UploadStateHandler.class$("oracle.sysman.ccr.collector.diagnosticUpload.UploadStateHandler")) : class$oracle$sysman$ccr$collector$diagnosticUpload$UploadStateHandler));
    private static MessageBundle s_msgBundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.diagnostic.common.Uploader");
    private static MessageBundle s_msgCommonBundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.diagnostic.common.Diagnostic");
    private File m_stateFile = null;
    private String m_packageName = null;
    private long m_packageSize = -1L;
    private String m_packageDigest = null;
    private String m_submitTime = null;
    private String m_startTime = null;
    private String m_endTime = null;
    private String m_updateTime = null;
    private String m_state = null;
    private long m_progress = -1L;
    private int m_processID = -1;
    private int m_restartCount = -1;
    private static final String EL_DIAGNOSTIC_UPOLOAD = "DIAGNOSTICUPLOAD";
    private static final String AT_SUBMIT_TIME = "SUBMITTIME";
    private static final String AT_START_TIME = "STARTTIME";
    private static final String AT_END_TIME = "ENDTIME";
    private static final String AT_UPDATE_TIME = "UPDATETIME";
    private static final String EL_PACKAGE = "PACKAGE";
    private static final String AT_PACKAGE_NAME = "NAME";
    private static final String AT_PACKAGE_SIZE = "SIZE";
    private static final String AT_PACKAGE_DIGEST = "DIGEST";
    private static final String EL_UPLOAD = "UPLOAD";
    private static final String AT_STATE = "STATE";
    private static final String AT_PROGRESS = "PROGRESS";
    private static final String EL_PROCESS = "PROCESS";
    private static final String AT_PROCESS_ID = "ID";
    private static final String EL_RESTART = "RESTART";
    private static final String AT_COUNT = "COUNT";
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$diagnosticUpload$UploadStateHandler;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UploadStateHandler(File file) throws InvalidStateException, StateAccessException, NoSuchReqException {
        FileInputStream fileInputStream = null;
        try {
            try {
                this.m_stateFile = file;
                fileInputStream = new FileInputStream(file);
                XMLReader xMLReader = XMLReaderFactory.createXMLReader("oracle.xml.parser.v2.SAXParser");
                xMLReader.setFeature("http://xml.org/sax/features/validation", true);
                xMLReader.setContentHandler(this);
                xMLReader.setErrorHandler(this);
                InputSource inputSource = new InputSource(fileInputStream);
                xMLReader.parse(inputSource);
            }
            catch (SAXException sAXException) {
                String string = s_msgBundle.getMessage(UploaderMsgID.INVALID_UPLOAD_STATE, false);
                throw new InvalidStateException(UploadState.prefixMsg(string, this.m_stateFile.getAbsolutePath()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.m_stateFile.exists()) {
                    String string = s_msgCommonBundle.getMessage(DiagnosticMsgID.STATE_ACCESS_ERROR, false, new Object[]{fileNotFoundException.getMessage()});
                    throw new StateAccessException(UploadState.prefixMsg(string, this.m_stateFile.getAbsolutePath()));
                }
                String string = s_msgBundle.getMessage(UploaderMsgID.NO_SUCH_REQ, false);
                throw new NoSuchReqException(UploadState.prefixMsg(string, this.m_stateFile.getAbsolutePath()));
            }
            catch (IOException iOException) {
                String string = s_msgCommonBundle.getMessage(DiagnosticMsgID.STATE_ACCESS_ERROR, false, new Object[]{iOException.getMessage()});
                throw new StateAccessException(UploadState.prefixMsg(string, this.m_stateFile.getAbsolutePath()));
            }
            Object var6_12 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_13 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        fileInputStream.close();
        return;
    }

    public void startDocument() throws SAXException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)UploadState.prefixMsg("Started parsing upload state.", this.m_stateFile.getAbsolutePath()));
        }
    }

    public void endDocument() throws SAXException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)UploadState.prefixMsg("End of upload state.", this.m_stateFile.getAbsolutePath()));
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase(EL_DIAGNOSTIC_UPOLOAD)) {
            this.m_startTime = attributes.getValue(AT_START_TIME);
            this.m_submitTime = attributes.getValue(AT_SUBMIT_TIME);
            this.m_endTime = attributes.getValue(AT_END_TIME);
            this.m_updateTime = attributes.getValue(AT_UPDATE_TIME);
        } else {
            if (string3.equalsIgnoreCase(EL_PACKAGE)) {
                this.m_packageName = attributes.getValue(AT_PACKAGE_NAME);
                this.m_packageDigest = attributes.getValue(AT_PACKAGE_DIGEST);
                try {
                    this.m_packageSize = Long.parseLong(attributes.getValue(AT_PACKAGE_SIZE));
                }
                catch (NumberFormatException numberFormatException) {
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)UploadState.prefixMsg("Failed to convert package size: " + attributes.getValue(AT_PACKAGE_SIZE) + " to number", this.m_stateFile.getAbsolutePath()));
                    }
                    throw new SAXException(numberFormatException.getMessage());
                }
            }
            if (string3.equalsIgnoreCase(EL_UPLOAD)) {
                this.m_state = attributes.getValue(AT_STATE);
                try {
                    this.m_progress = Long.parseLong(attributes.getValue(AT_PROGRESS));
                }
                catch (NumberFormatException numberFormatException) {
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)UploadState.prefixMsg("Failed to convert upload progress: " + attributes.getValue(AT_PROGRESS) + " to number", this.m_stateFile.getAbsolutePath()));
                    }
                    throw new SAXException(numberFormatException.getMessage());
                }
            }
            if (string3.equalsIgnoreCase(EL_PROCESS)) {
                try {
                    this.m_processID = Integer.parseInt(attributes.getValue(AT_PROCESS_ID));
                }
                catch (NumberFormatException numberFormatException) {
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)UploadState.prefixMsg("Failed to convert upload process id: " + attributes.getValue(AT_PROCESS_ID) + " to number", this.m_stateFile.getAbsolutePath()));
                    }
                    throw new SAXException(numberFormatException.getMessage());
                }
            }
            if (string3.equalsIgnoreCase(EL_RESTART)) {
                try {
                    this.m_restartCount = Integer.parseInt(attributes.getValue(AT_COUNT));
                }
                catch (NumberFormatException numberFormatException) {
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)UploadState.prefixMsg("Failed to convert restart count " + attributes.getValue(AT_PROCESS_ID) + " to number", this.m_stateFile.getAbsolutePath()));
                    }
                    throw new SAXException(numberFormatException.getMessage());
                }
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)UploadState.prefixMsg(sAXParseException.getMessage(), this.m_stateFile.getAbsolutePath()));
        }
        throw new SAXException(sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)UploadState.prefixMsg(sAXParseException.getMessage(), this.m_stateFile.getAbsolutePath()));
        }
        throw new SAXException(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)UploadState.prefixMsg(sAXParseException.getMessage(), this.m_stateFile.getAbsolutePath()));
        }
        throw new SAXException(sAXParseException);
    }

    public String getStartTime() {
        return this.m_startTime;
    }

    public String getSubmitTime() {
        return this.m_submitTime;
    }

    public String getEndTime() {
        return this.m_endTime;
    }

    public String getUpdateTime() {
        return this.m_updateTime;
    }

    public String getPackageName() {
        return this.m_packageName;
    }

    public String getPackageDigest() {
        return this.m_packageDigest;
    }

    public long getPackageSize() {
        return this.m_packageSize;
    }

    public int getRestartCount() {
        return this.m_restartCount;
    }

    public int getProcessID() {
        return this.m_processID;
    }

    public String getState() {
        return this.m_state;
    }

    public long getProgress() {
        return this.m_progress;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

