/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.diagnosticUpload;

import HTTPClient.ParseException;
import HTTPClient.URI;
import java.io.File;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.diagnosticUpload.UploadState;
import oracle.sysman.ccr.collector.security.SecurityMgr;
import oracle.sysman.ccr.collector.util.Hostname;
import oracle.sysman.ccr.collector.util.UplinkSystemConfig;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.ResourceID;
import oracle.sysman.ccr.common.exception.CSIMismatchException;
import oracle.sysman.ccr.common.exception.CredentialsNotFoundException;
import oracle.sysman.ccr.common.exception.InternalException;
import oracle.sysman.ccr.common.exception.InvalidCredentialsException;
import oracle.sysman.ccr.common.exception.InvalidEndPointException;
import oracle.sysman.ccr.common.exception.InvalidRequestException;
import oracle.sysman.ccr.common.exception.InvalidSRException;
import oracle.sysman.ccr.common.exception.KeyMismatchException;
import oracle.sysman.ccr.common.exception.MessageFormatException;
import oracle.sysman.ccr.common.exception.NoSuchReqException;
import oracle.sysman.ccr.common.exception.SRClosedException;
import oracle.sysman.ccr.common.exception.network.InvalidResponseException;
import oracle.sysman.ccr.common.exception.network.InvalidSessionException;
import oracle.sysman.ccr.common.exception.network.NotSupportedException;
import oracle.sysman.ccr.common.exception.network.ServerException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.diagnostic.common.DiagnosticUtil;
import oracle.sysman.ccr.diagnostic.common.UploaderMsgID;
import oracle.sysman.ccr.diagnostic.common.exception.AlreadyUploadedException;
import oracle.sysman.ccr.diagnostic.common.exception.DuplicateUploadException;
import oracle.sysman.ccr.diagnostic.common.exception.UploadReqExistsException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.InvalidPackageException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.PackageAccessException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.PackageModifiedException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.PackageNotFoundException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.DiagnosticStateException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.InvalidStateException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.StateAccessException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.StateCreationException;
import oracle.sysman.ccr.netmgr.EndPointAddr;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.ServerAccessException;
import oracle.sysman.ccr.netmgr.SessionTimeoutLimitException;
import oracle.sysman.ccr.netmgr.UploadConnection;
import oracle.sysman.ccr.netmgr.ValidationRequest;
import oracle.sysman.ccr.ocmSDK.diagUpload.DiagUploader;

public class Uploader
extends DiagUploader {
    private static Logger s_logger = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$diagnosticUpload$Uploader == null ? (class$oracle$sysman$ccr$collector$diagnosticUpload$Uploader = Uploader.class$("oracle.sysman.ccr.collector.diagnosticUpload.Uploader")) : class$oracle$sysman$ccr$collector$diagnosticUpload$Uploader));
    private static MessageBundle s_msgBundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.diagnostic.common.Uploader");
    private String m_oracleHome = null;
    private String m_cfgHome = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$diagnosticUpload$Uploader;

    public Uploader(String string, String string2) throws InvalidPackageException, PackageNotFoundException, PackageAccessException, InternalException {
        super(string, string2);
    }

    private EndPointAddr getEndpoint() throws InvalidEndPointException {
        EndPointAddr endPointAddr = null;
        EndPointAddr endPointAddr2 = null;
        URI uRI = null;
        try {
            endPointAddr = UplinkSystemConfig.getOCMServiceEndPoint();
            if (endPointAddr == null) {
                String string = s_msgBundle.getMessage(UploaderMsgID.DIAGNOSTIC_ENDPOINT_ERROR, false);
                throw new InvalidEndPointException(DiagnosticUtil.prefixMsg((String)string, (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
            }
            URI uRI2 = endPointAddr.getURI();
            String string = "/emdiag/upload";
            if (this.restart) {
                string = "/emdiag/restartUpload";
            }
            uRI = new URI(uRI2.getScheme(), uRI2.getHost(), uRI2.getPort(), string);
            endPointAddr2 = new EndPointAddr(null, endPointAddr.getIsRepeater(), uRI);
        }
        catch (ParseException parseException) {
            String string = s_msgBundle.getMessage(UploaderMsgID.DIAGNOSTIC_ENDPOINT_ERROR, false);
            throw new InvalidEndPointException(DiagnosticUtil.prefixMsg((String)string, (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
        }
        return endPointAddr2;
    }

    private void connect() throws InvalidEndPointException, NetworkException, ServerAccessException, KeyMismatchException {
        this.printMesgID(UploaderMsgID.CONNECTING);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)"Retrieving connection parameters for diagnostic upload.", (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
        }
        URI uRI = null;
        boolean bl = false;
        EndPointAddr endPointAddr = this.getEndpoint();
        if (endPointAddr != null) {
            uRI = endPointAddr.getURI();
            bl = endPointAddr.getIsRepeater();
        }
        this.m_oracleHome = Collector.getOracleHome();
        this.m_cfgHome = Collector.getConfigHome();
        this.m_hostName = Hostname.getHostname();
        SecurityMgr securityMgr = SecurityMgr.getInstance();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)("Establishing connection to diagnostic receiver: " + uRI.toExternalForm()), (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
            s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)("host name: " + this.m_hostName + ", oracle home: " + this.m_oracleHome + ", org id: " + securityMgr.getCustomerOrgId() + ", registration key: " + securityMgr.getAuthenticationKeyString()), (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
        }
        this.m_diagCon = new UploadConnection(uRI, this.m_hostName, this.m_oracleHome, this.m_cfgHome, securityMgr.getCustomerOrgId(), securityMgr.getAuthenticationKeyString(), this.m_SRNumber, this.m_diagPkg.getName(), this.m_diagPkg.getSize(), this.m_diagPkg.getDigest(), bl);
    }

    public void start(ValidationRequest validationRequest) throws StateCreationException, StateAccessException, UploadReqExistsException, DuplicateUploadException, InvalidEndPointException, NetworkException, KeyMismatchException, AlreadyUploadedException, PackageAccessException, PackageModifiedException, InvalidResponseException, SessionTimeoutLimitException, InvalidStateException, InvalidRequestException, ServerException, InvalidSessionException, InvalidSRException, MessageFormatException, NoSuchReqException, NotSupportedException, CredentialsNotFoundException, InvalidCredentialsException, UploadReqExistsException, SRClosedException, CSIMismatchException {
        this.restart = false;
        System.out.println(s_msgBundle.getMessage(UploaderMsgID.STARTING_UPLOAD, false));
        this.m_uploadState = new UploadState(this.m_SRNumber, this.m_diagPkg.getName(), this.m_diagPkg.getSize(), this.m_diagPkg.getDigest());
        this.m_progress = 0L;
        this.m_valRequest = validationRequest;
        this.preProcessStartRequest();
        this.connect();
        this.upload();
    }

    private void preProcessStartRequest() throws UploadReqExistsException {
        UploadState uploadState = null;
        File file = null;
        try {
            file = new File(UploadState.getStateFilePath(this.m_SRNumber, this.m_diagPkg.getName()));
            uploadState = new UploadState(file);
        }
        catch (DiagnosticStateException diagnosticStateException) {
            return;
        }
        catch (NoSuchReqException noSuchReqException) {
            return;
        }
        if ("COMPLETED".equals(uploadState.getState())) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)"Old upload request is in COMPLETED state. Overwriting...", (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
            }
        } else if (!Collector.qualifierSpecified("force")) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)"Old upload request is not in COMPLETED state and not forced. Exiting...", (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
            }
            String string = s_msgBundle.getMessage(UploaderMsgID.UPLOAD_REQUEST_EXISTS, false);
            throw new UploadReqExistsException(DiagnosticUtil.prefixMsg((String)string, (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
        }
    }

    private void preProcessRestartRequest() throws InvalidStateException, StateAccessException, NoSuchReqException, PackageModifiedException, AlreadyUploadedException {
        try {
            this.m_uploadState = new UploadState(this.m_SRNumber, this.m_diagPkg.getName());
        }
        catch (NoSuchReqException noSuchReqException) {
            String string = s_msgBundle.getMessage(UploaderMsgID.NO_SUCH_REQ_RESTART, false);
            Throwable throwable = noSuchReqException.getCause();
            throw new NoSuchReqException(DiagnosticUtil.prefixMsg((String)string, (String)this.m_SRNumber, (String)this.m_diagPkg.getName()), throwable);
        }
        if (!this.m_diagPkg.getDigest().equalsIgnoreCase(this.m_uploadState.getPackageDigest())) {
            String string = s_msgBundle.getMessage(UploaderMsgID.PACKAGE_MODIFIED_ERR, false);
            throw new PackageModifiedException(DiagnosticUtil.prefixMsg((String)string, (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
        }
        if ("COMPLETED".equals(this.m_uploadState.getState())) {
            String string = s_msgBundle.getMessage(UploaderMsgID.ALREADY_UPLOADED, false);
            throw new AlreadyUploadedException(DiagnosticUtil.prefixMsg((String)string, (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
        }
        this.m_progress = this.m_uploadState.getProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() throws DuplicateUploadException, InvalidStateException, StateAccessException, NoSuchReqException, PackageModifiedException, AlreadyUploadedException, InvalidEndPointException, NetworkException, ServerAccessException, KeyMismatchException, StateCreationException, PackageAccessException, InvalidResponseException, SessionTimeoutLimitException, InvalidRequestException, ServerException, InvalidSessionException, InvalidSRException, MessageFormatException, NotSupportedException, CredentialsNotFoundException, InvalidCredentialsException, UploadReqExistsException, SRClosedException, CSIMismatchException {
        this.restart = true;
        this.printMesgID(UploaderMsgID.RESTARTING_UPLOAD);
        this.preProcessRestartRequest();
        try {
            this.connect();
        }
        finally {
            this.m_state = "FAILED";
            this.updateState();
        }
        this.upload();
    }

    protected void printMesgID(ResourceID resourceID) {
        System.out.println(s_msgBundle.getMessage(resourceID, false));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

