/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.fetchlets;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.ccr.collector.fetchlets.CommandFailedException;
import oracle.sysman.ccr.collector.fetchlets.Fetchlet;
import oracle.sysman.ccr.collector.fetchlets.FetchletException;
import oracle.sysman.ccr.collector.fetchlets.FetchletMsgID;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.fetchlets.ValueRow;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.Process;

public class OSFetchlet
implements Fetchlet {
    private static Logger s_log = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$fetchlets$OSFetchlet == null ? (class$oracle$sysman$ccr$collector$fetchlets$OSFetchlet = OSFetchlet.class$("oracle.sysman.ccr.collector.fetchlets.OSFetchlet")) : class$oracle$sysman$ccr$collector$fetchlets$OSFetchlet));
    private static MessageBundle s_bundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.fetchlets.Fetchlet");
    private static String s_strTimeoutValue = null;
    static final String COMMAND_NAME = "command";
    static final String SCRIPT_NAME = "script";
    static final String ARGS_NAME = "args";
    static final String ERRSTARTSWITH_NAME = "errStartsWith";
    static final String NUMROWS_NAME = "numrows";
    static final String SORTBY_NAME = "sortByColumn";
    static final String SORTAS_NAME = "sortAs";
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$fetchlets$OSFetchlet;

    public MetricResult getMetric(Properties properties) throws FetchletException {
        String string = properties.getProperty(COMMAND_NAME);
        String string2 = properties.getProperty(SCRIPT_NAME);
        String string3 = properties.getProperty(ERRSTARTSWITH_NAME);
        if (string2 == null && string == null) {
            throw new FetchletException(s_bundle.getMessage(FetchletMsgID.MISSING_ARGS, false, (Object[])new String[]{COMMAND_NAME, SCRIPT_NAME}));
        }
        if (string2 == null) {
            string2 = "";
        } else if (string == null) {
            string = "";
        } else {
            string2 = " " + string2;
        }
        String string4 = properties.getProperty(ARGS_NAME);
        string4 = string4 == null ? "" : " " + string4;
        string = string + string2 + string4;
        String[] stringArray = this.buildEnvironment(properties);
        String[] stringArray2 = this.buildStdInParams(properties);
        String string5 = null;
        MetricResult metricResult = null;
        Object object = null;
        if (s_log.isEnabledFor(Logger.DEBUG)) {
            s_log.debug((Object)("OSFetchlet: getMetric() executing: " + string));
        }
        try {
            string5 = this.executeCommand(string, stringArray, stringArray2, string3);
            metricResult = this.getFromString(string5, properties);
            return metricResult;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object = illegalArgumentException;
        }
        catch (IOException iOException) {
            object = iOException;
        }
        catch (CommandFailedException commandFailedException) {
            object = commandFailedException;
        }
        catch (InterruptedException interruptedException) {
            object = interruptedException;
        }
        catch (Exception exception) {
            object = exception;
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Failure in executing command - \n" + string + "\n" + "Failure reason: " + ((Throwable)object).toString() + "\n" + "\tEnvironment was initialized as:\n"));
            for (int i = 0; i < stringArray.length; ++i) {
                s_log.debug((Object)("\t\t" + stringArray[i] + "\n"));
            }
        }
        throw new FetchletException("Failed to execute command - " + string, (Throwable)object);
    }

    protected InputStream getInputStream(String string, String string2, String string3, String string4, String string5, String string6) throws MalformedURLException, IOException {
        String string7 = "http://" + string + ":" + string2 + "/" + string3;
        URL uRL = new URL(string7);
        return uRL.openStream();
    }

    protected MetricResult getFromString(String string, Properties properties) throws Exception {
        MetricResult metricResult = new MetricResult();
        ValueRow valueRow = metricResult.addValueRow();
        valueRow.setValue(0, string);
        return metricResult;
    }

    protected String[] buildEnvironment(Properties properties) {
        return this.getParams(properties, "ENV");
    }

    protected String[] buildStdInParams(Properties properties) {
        return this.getParams(properties, "STDIN");
    }

    private String[] getParams(Properties properties, String string) {
        Object object;
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            object = null;
            object = properties.getProperty(string2);
            if (object == null) continue;
            string2 = string2.length() <= string.length() ? "" : string2.substring(string.length());
            hashtable.put(string2, (String[])object);
        }
        int n = hashtable.size();
        object = new String[n];
        Enumeration enumeration2 = hashtable.keys();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)enumeration2.nextElement();
            String string4 = (String)hashtable.get(string3);
            StringBuffer stringBuffer = new StringBuffer(string3).append("=").append(string4);
            object[i] = stringBuffer.toString();
        }
        return object;
    }

    protected String executeCommand(String string, String[] stringArray, String[] stringArray2, String string2) throws IOException, InterruptedException, IllegalArgumentException, CommandFailedException {
        StringBuffer stringBuffer;
        if (string.trim().equals("")) {
            throw new IllegalArgumentException("command is empty");
        }
        String[] stringArray3 = OSFetchlet.splitStrIntoStrArray(string);
        Process process = Process.exec((String[])stringArray3, (String[])stringArray, (String[])stringArray2, (String)s_strTimeoutValue);
        int n = process.waitFor(stringBuffer = new StringBuffer());
        if (n != 0) {
            throw new CommandFailedException(this.filterErrStream(stringBuffer.toString(), string2), n);
        }
        return stringBuffer.toString();
    }

    protected String filterErrStream(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (!string3.startsWith(string2)) continue;
                stringBuffer.append(string3.substring(string2.length()));
                stringBuffer.append("\n");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public static void sortString(MetricResult metricResult, int n, boolean bl) {
        Vector vector = metricResult.getValueRows();
        int n2 = vector.size();
        for (int i = n2 / 2; i >= 1; i /= 2) {
            for (int j = i; j < n2; ++j) {
                ValueRow valueRow = (ValueRow)vector.elementAt(j);
                String string = valueRow.getValue(n);
                int n3 = j;
                if (string == null || string.length() == 0) continue;
                double d = 0.0;
                if (bl) {
                    d = Double.parseDouble(string);
                }
                while (n3 >= i) {
                    ValueRow valueRow2 = (ValueRow)vector.elementAt(n3 - i);
                    String string2 = valueRow2.getValue(n);
                    if (string2 != null && string2.length() != 0) {
                        double d2 = 0.0;
                        if (bl ? d <= (d2 = Double.parseDouble(string2)) : string.compareTo(string2) >= 0) break;
                    }
                    vector.setElementAt(valueRow2, n3);
                    n3 -= i;
                }
                vector.setElementAt(valueRow, n3);
            }
        }
    }

    public static String[] splitStrIntoStrArray(String string) throws IllegalArgumentException {
        boolean bl = false;
        boolean bl2 = false;
        String[] stringArray = null;
        boolean bl3 = true;
        int n = 0;
        int n2 = 32;
        Vector<String> vector = null;
        String string2 = null;
        StringBuffer stringBuffer = null;
        boolean bl4 = false;
        if (string.length() <= 0) {
            return null;
        }
        vector = new Vector<String>();
        stringBuffer = new StringBuffer();
        for (n = 0; n < string.length(); ++n) {
            if (!bl) {
                if (Character.isWhitespace(string.charAt(n))) {
                    if (bl3) continue;
                    if (bl4) {
                        stringBuffer.append(string.charAt(n));
                        bl4 = false;
                        continue;
                    }
                    bl3 = true;
                    string2 = stringBuffer.toString();
                    vector.add(string2);
                    stringBuffer = new StringBuffer();
                    continue;
                }
                if (string.charAt(n) == '\"' || string.charAt(n) == '\'') {
                    if (!bl4) {
                        n2 = string.charAt(n);
                        bl = true;
                        continue;
                    }
                    stringBuffer.append(string.charAt(n));
                    bl4 = false;
                    continue;
                }
                if (string.charAt(n) == '\\') {
                    if (bl4) {
                        stringBuffer.append(string.charAt(n));
                        bl4 = false;
                        continue;
                    }
                    bl4 = true;
                    continue;
                }
                stringBuffer.append(string.charAt(n));
                bl4 = false;
                bl3 = false;
                continue;
            }
            if (n2 == string.charAt(n)) {
                n2 = 32;
                bl = false;
                bl3 = false;
                continue;
            }
            stringBuffer.append(string.charAt(n));
            bl3 = false;
        }
        if (bl) {
            throw new IllegalArgumentException("Command '" + string + "' contains unmatched quotes");
        }
        if (!bl3) {
            string2 = stringBuffer.toString();
            vector.add(string2);
        }
        stringArray = new String[vector.size()];
        stringArray = vector.toArray(stringArray);
        return stringArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Config config = UplinkHomeConfig.getInstance();
        s_strTimeoutValue = config.getProperty("ccr.process.timeout");
        if (s_strTimeoutValue != null && s_strTimeoutValue.trim().length() == 0) {
            s_strTimeoutValue = null;
        }
    }
}

