/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.fetchlets;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResult;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.fetchlets.MetricValue;
import org.xml.sax.Attributes;

public class ValueRow
implements Serializable {
    private static final long serialVersionUID = 4840650007219673076L;
    static final String TAGNAME = "ValueRow";
    private Vector m_values = null;
    private MetricResult m_result = null;

    public ValueRow() {
        this.m_values = new Vector();
    }

    public void init(Attributes attributes) {
    }

    public ValueRow(int n) {
        this.m_values = new Vector(n);
        this.m_values.setSize(n);
    }

    public void setResult(MetricResult metricResult) {
        this.m_result = metricResult;
    }

    public void addValue(MetricValue metricValue) {
        this.m_values.addElement(metricValue);
    }

    public void setValue(int n) {
        if (n >= this.m_values.size()) {
            this.m_values.setSize(n + 1);
        }
        this.m_values.setElementAt(new MetricValue(), n);
    }

    public void setValue(int n, String string) {
        if (n >= this.m_values.size()) {
            this.m_values.setSize(n + 1);
        }
        this.m_values.setElementAt(new MetricValue(string), n);
    }

    public void setValue(int n, float f) {
        if (n >= this.m_values.size()) {
            this.m_values.setSize(n + 1);
        }
        this.m_values.setElementAt(new MetricValue(f), n);
    }

    public void setValue(int n, Vector vector) {
        if (n >= this.m_values.size()) {
            this.m_values.setSize(n + 1);
        }
        this.m_values.setElementAt(new MetricValue(vector), n);
    }

    public void setValue(int n, MetricValue metricValue) {
        if (n >= this.m_values.size()) {
            this.m_values.setSize(n + 1);
        }
        this.m_values.setElementAt(metricValue, n);
    }

    public Vector getValues() {
        return this.m_values;
    }

    public MetricValue getMValue(int n) {
        MetricValue metricValue = null;
        int n2 = this.m_values.size();
        if (n >= 0 && n < n2) {
            metricValue = (MetricValue)this.m_values.elementAt(n);
        }
        return metricValue;
    }

    public String getValue(int n) {
        String string = null;
        MetricValue metricValue = this.getMValue(n);
        if (metricValue != null) {
            string = metricValue.getContents();
        }
        return string;
    }

    public String getRowString() {
        return this.getRowString(this.m_values.size());
    }

    public int getRowSize() {
        return this.m_values.size();
    }

    public String getRowString(int n) {
        StringBuffer stringBuffer = null;
        for (int i = 0; i < n; ++i) {
            String string = this.getValue(i);
            if (string == null) continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(string);
                continue;
            }
            stringBuffer.append("|").append(string);
        }
        if (stringBuffer == null) {
            return null;
        }
        return stringBuffer.toString();
    }

    public float getNumValue(int n) throws NumberFormatException {
        String string = this.getValue(n);
        return Float.valueOf(string).floatValue();
    }

    public Vector getNestedValues(int n) {
        Vector vector = null;
        MetricValue metricValue = this.getMValue(n);
        if (metricValue != null) {
            vector = metricValue.getNestedRows();
        }
        return vector;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ValueRow)) {
            return false;
        }
        ValueRow valueRow = (ValueRow)object;
        int n = this.m_values.size();
        if (n != valueRow.m_values.size()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Object e = this.m_values.elementAt(i);
            if (!(e == null ? valueRow.m_values.elementAt(i) != null : !e.equals(valueRow.m_values.elementAt(i)))) continue;
            return false;
        }
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (CollectionResult.s_isOCheckCollection) {
            Vector vector = (Vector)this.m_values.clone();
            this.m_values.setSize(4);
            objectOutputStream.defaultWriteObject();
            this.m_values = vector;
        } else {
            objectOutputStream.defaultWriteObject();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (CollectionResult.s_isOCheckCollection) {
            // empty if block
        }
    }
}

