/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.security;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cmd.RegistrationInfo;
import oracle.sysman.ccr.collector.security.AnonAuthenticationKey;
import oracle.sysman.ccr.collector.security.AuthenticationFailure;
import oracle.sysman.ccr.collector.security.CSIAuthenticationKey;
import oracle.sysman.ccr.collector.security.CSIV2AuthenticationKey;
import oracle.sysman.ccr.collector.security.DisconnectedAuthenticationKey;
import oracle.sysman.ccr.collector.security.EmailAuthenticationKey;
import oracle.sysman.ccr.collector.security.UnregisteredException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.netmgr.RegistrationKeyDoc;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.Host;

public abstract class AuthenticationKey {
    static final String KEY_VERSION_V2 = "2.0";
    static final String KEY_VERSION_V3 = "3.0";
    static final String LIVELINK_REGISTRATION_STORE = "uplinkreg.bin";
    protected static final String KEY_VERSION = "key.version";
    protected static final String KEY_STR = "key.value";
    protected static final String KEY_GCID = "key.id";
    protected static final String KEY_DATE = "key.registered";
    protected static final String KEY_REG_METHOD = "key.registration_method";
    protected static final String KEY_UNIQUE_CSI = "key.registered_w_uniqueCSI";
    static final Logger s_log = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$security$AuthenticationKey == null ? (class$oracle$sysman$ccr$collector$security$AuthenticationKey = AuthenticationKey.class$("oracle.sysman.ccr.collector.security.AuthenticationKey")) : class$oracle$sysman$ccr$collector$security$AuthenticationKey));
    static final SimpleDateFormat s_dateFormatRegistration = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
    private Properties m_props = new Properties();
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$security$AuthenticationKey;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuthenticationKey instantiate() throws AuthenticationFailure {
        void var0_6;
        Object var0 = null;
        s_log.debug((Object)"AuthenticationKey ctor");
        if (!Collector.isDisconnected()) {
            Properties properties = AuthenticationKey.loadKeyFile();
            String string = properties.getProperty(KEY_REG_METHOD);
            if (string != null) {
                if (string.equals(CSIAuthenticationKey.getRegistrationMethodConst())) {
                    CSIAuthenticationKey cSIAuthenticationKey = new CSIAuthenticationKey(properties);
                    return var0_6;
                } else if (string.equals(EmailAuthenticationKey.getRegistrationMethodConst())) {
                    EmailAuthenticationKey emailAuthenticationKey = new EmailAuthenticationKey(properties);
                    return var0_6;
                } else {
                    if (!string.equals(AnonAuthenticationKey.getRegistrationMethodConst())) throw new AuthenticationFailure("Unknown registration method - " + string);
                    AnonAuthenticationKey anonAuthenticationKey = new AnonAuthenticationKey(properties);
                }
                return var0_6;
            } else {
                String string2 = properties.getProperty(KEY_VERSION);
                if (!string2.equals(KEY_VERSION_V2)) return var0_6;
                CSIV2AuthenticationKey cSIV2AuthenticationKey = new CSIV2AuthenticationKey(properties);
            }
            return var0_6;
        } else {
            s_log.debug((Object)" in disconnected mode");
            DisconnectedAuthenticationKey disconnectedAuthenticationKey = new DisconnectedAuthenticationKey();
        }
        return var0_6;
    }

    protected Properties setProperties(RegistrationKeyDoc registrationKeyDoc, RegistrationInfo registrationInfo) throws AuthenticationFailure {
        ((Hashtable)this.m_props).put(KEY_STR, registrationKeyDoc.getKey());
        ((Hashtable)this.m_props).put(KEY_GCID, registrationKeyDoc.getGCID());
        ((Hashtable)this.m_props).put(KEY_DATE, s_dateFormatRegistration.format(new Date()));
        ((Hashtable)this.m_props).put(KEY_UNIQUE_CSI, registrationKeyDoc.holdsUniqueCSI().toString());
        ((Hashtable)this.m_props).put(KEY_VERSION, this.getKeyVersion());
        ((Hashtable)this.m_props).put(KEY_REG_METHOD, this.getRegistrationMethod());
        return this.m_props;
    }

    protected abstract String getKeyVersion();

    abstract String getRegistrationMethod();

    public String getKey() {
        return this.m_props.getProperty(KEY_STR);
    }

    public String getGCID() {
        return this.m_props.getProperty(KEY_GCID);
    }

    public boolean holdsUniqueCSI() {
        return this.m_props.getProperty(KEY_UNIQUE_CSI).equalsIgnoreCase("true");
    }

    protected void initFromProps(Properties properties) throws UnregisteredException, AuthenticationFailure {
        this.m_props = properties;
        s_log.debug((Object)("registration info: GCID:client_key:UniqueCSI" + this.getGCID() + ":" + this.getKey() + ":" + this.m_props.getProperty(KEY_UNIQUE_CSI)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties loadKeyFile() throws UnregisteredException, AuthenticationFailure {
        Properties properties = new Properties();
        String string = FileSpec.catfile((String[])new String[]{Collector.getCCRConfigHome(), "config", "default", LIVELINK_REGISTRATION_STORE});
        FileInputStream fileInputStream = null;
        s_log.debug((Object)("reading authentication data from file " + string));
        try {
            try {
                fileInputStream = new FileInputStream(string);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                properties.load(bufferedInputStream);
            }
            catch (SecurityException securityException) {
                throw new AuthenticationFailure("Unable to open Oracle Configuration Manager registration file", securityException);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new UnregisteredException();
            }
            catch (IOException iOException) {
                throw new AuthenticationFailure("Unable to read Oracle Configuration Manager registration information", iOException);
            }
            Object var5_7 = null;
            if (fileInputStream == null) return properties;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        fileInputStream.close();
        return properties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void persistKeyFile(Properties properties) throws AuthenticationFailure {
        block9: {
            this.validateKey();
            String string = FileSpec.catfile((String[])new String[]{Collector.getCCRConfigHome(), "config", "default", LIVELINK_REGISTRATION_STORE});
            FileOutputStream fileOutputStream = null;
            try {
                try {
                    fileOutputStream = new FileOutputStream(string);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    properties.store(bufferedOutputStream, "");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new AuthenticationFailure("Unable to persist the registration data", fileNotFoundException);
                }
                catch (SecurityException securityException) {
                    throw new AuthenticationFailure("Unable to persist the registration data", securityException);
                }
                catch (IOException iOException) {
                    throw new AuthenticationFailure("Unable to persist the registration data", iOException);
                }
                Object var6_8 = null;
                if (fileOutputStream == null) break block9;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                if (fileOutputStream == null) throw throwable;
                try {
                    fileOutputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            fileOutputStream.close();
        }
        s_log.debug((Object)("registration info (from XML): " + properties.getProperty(KEY_GCID) + ":" + properties.getProperty(KEY_STR)));
    }

    public void persistKeyFile() throws AuthenticationFailure {
        this.persistKeyFile(this.m_props);
    }

    public String getAnonymousColRegInfo(String string, String string2) {
        return this.m_props.getProperty(this.makeAnonymousColRegPropKey(string, string2));
    }

    public String getAnonymousColRegKey(String string) {
        return string.substring(0, string.indexOf("*"));
    }

    public String getAnonymousColRegId(String string) {
        return string.substring(string.indexOf("*") + 1, string.length());
    }

    public void setAnonymousColRegInfo(String string, String string2, String string3, String string4) {
        this.m_props.setProperty(this.makeAnonymousColRegPropKey(string, string2), string3 + "*" + string4);
    }

    protected void validateKey() throws AuthenticationFailure {
        if (this.getKeyVersion() == null) {
            throw new AuthenticationFailure("Incomplete registration. Please register again. Keystate missing KeyID");
        }
        if (this.getKey() == null) {
            throw new AuthenticationFailure("Incomplete registration. Please register again. Keystate missing key");
        }
        if (this.getGCID() == null) {
            throw new AuthenticationFailure("Incomplete registration. Please register again. Keystate missing gcid");
        }
    }

    private String makeAnonymousColRegPropKey(String string, String string2) {
        return "anonymous_collector_reg*" + string + "*" + string2 + "*" + Host.getHostName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

