/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.security;

import java.util.Hashtable;
import java.util.Properties;
import oracle.sysman.ccr.collector.cmd.EmailRegistrationInfo;
import oracle.sysman.ccr.collector.cmd.RegistrationInfo;
import oracle.sysman.ccr.collector.security.AuthenticationFailure;
import oracle.sysman.ccr.collector.security.CipherTextAuthenticationKey;
import oracle.sysman.ccr.collector.security.UnregisteredException;
import oracle.sysman.ccr.netmgr.RegistrationKeyDoc;

public class EmailAuthenticationKey
extends CipherTextAuthenticationKey {
    private static final String KEY_REGISTRATION_METHOD_VAL = "email";
    private static final String KEY_REGISTRATION_MAILID = "key.registration.email.address";
    private String m_strMailId;

    public EmailAuthenticationKey(Properties properties) throws UnregisteredException, AuthenticationFailure {
        this.initFromProps(properties);
        this.m_strMailId = properties.getProperty(KEY_REGISTRATION_MAILID);
        this.validateKey();
    }

    public EmailAuthenticationKey(RegistrationKeyDoc registrationKeyDoc, EmailRegistrationInfo emailRegistrationInfo) throws AuthenticationFailure {
        Properties properties = this.setProperties(registrationKeyDoc, emailRegistrationInfo);
        this.persistKeyFile(properties);
    }

    protected Properties setProperties(RegistrationKeyDoc registrationKeyDoc, RegistrationInfo registrationInfo) throws AuthenticationFailure {
        EmailRegistrationInfo emailRegistrationInfo = (EmailRegistrationInfo)registrationInfo;
        Properties properties = super.setProperties(registrationKeyDoc, registrationInfo);
        this.m_strMailId = emailRegistrationInfo.getMetaLinkEmailID();
        ((Hashtable)properties).put(KEY_REGISTRATION_MAILID, this.m_strMailId);
        return properties;
    }

    public String getEmailId() {
        return this.m_strMailId;
    }

    protected void validateKey() throws AuthenticationFailure {
        super.validateKey();
        if (this.m_strMailId == null) {
            throw new AuthenticationFailure("Incomplete registration. Please register again. Keystate missing EmailID");
        }
    }

    protected String getKeyVersion() {
        return "3.0";
    }

    static String getRegistrationMethodConst() {
        return KEY_REGISTRATION_METHOD_VAL;
    }

    protected String getRegistrationMethod() {
        return EmailAuthenticationKey.getRegistrationMethodConst();
    }
}

