/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.softwareMgr;

import oracle.sysman.ccr.collector.cli.DisableTargetCmd;
import oracle.sysman.ccr.collector.cli.InterruptException;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.softwareMgr.ClientAction;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DisableTargetAction
extends ClientAction {
    private String m_strOracleHome;
    private String m_strTargetName;
    private String m_strTargetType;

    DisableTargetAction(Attributes attributes) throws SAXException {
        this.m_strOracleHome = attributes.getValue("ORACLE_HOME");
        if (this.m_strOracleHome == null || this.m_strOracleHome.length() == 0) {
            throw new SAXException("Missing OracleHome from DisableTargetAction");
        }
        this.m_strTargetName = attributes.getValue("NAME");
        if (this.m_strTargetName == null || this.m_strTargetName.length() == 0) {
            throw new SAXException("Missing TargetName from DisableTargetAction");
        }
        this.m_strTargetType = attributes.getValue("TYPE");
        if (this.m_strTargetType == null || this.m_strTargetType.length() == 0) {
            throw new SAXException("Missing TargetType from DisableTargetAction");
        }
    }

    public void executeAction() throws CommandException {
        try {
            DisableTargetCmd disableTargetCmd = new DisableTargetCmd();
            disableTargetCmd.executeCommand(new String[]{"", this.m_strOracleHome + ":" + this.m_strTargetName + ":" + this.m_strTargetType});
        }
        catch (InterruptException interruptException) {
            // empty catch block
        }
    }
}

