/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.softwareMgr;

import HTTPClient.NVPair;
import HTTPClient.ParseException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Vector;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.security.SecurityMgr;
import oracle.sysman.ccr.collector.softwareMgr.ClientAction;
import oracle.sysman.ccr.collector.softwareMgr.DisableTargetAction;
import oracle.sysman.ccr.collector.softwareMgr.SoftwareMgrMsgId;
import oracle.sysman.ccr.collector.softwareMgr.SoftwareUpdateException;
import oracle.sysman.ccr.collector.softwareMgr.SoftwareUpdatesXMLParser;
import oracle.sysman.ccr.collector.util.Hostname;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.collector.util.UplinkSystemConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.CCRException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.netmgr.EndPointAddr;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.OCMEndPoint;
import oracle.sysman.ccr.ocmSDK.component.Component;
import oracle.sysman.ccr.ocmSDK.component.ComponentStateException;
import oracle.sysman.ccr.ocmSDK.component.ComponentVerificationException;
import oracle.sysman.ccr.ocmSDK.component.InvalidComponentException;
import oracle.sysman.ccr.ocmSDK.component.SignedComponent;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLReaderFactory;

public class SoftwareMgr {
    private static SoftwareMgr s_instance = null;
    private static Vector s_vecComponents = null;
    private static Logger s_log = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$softwareMgr$SoftwareMgr == null ? (class$oracle$sysman$ccr$collector$softwareMgr$SoftwareMgr = SoftwareMgr.class$("oracle.sysman.ccr.collector.softwareMgr.SoftwareMgr")) : class$oracle$sysman$ccr$collector$softwareMgr$SoftwareMgr));
    private static MessageBundle s_msgBundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.softwareMgr.SoftwareMgr");
    private static Component[] s_componentDownloadList = null;
    private static final int K_BLOCKS = 1024;
    public static final String PACKAGES_PENDING_DEPLOYMENT = "pending";
    private static final String JAR_SUFFIX = ".jar";
    private static String s_downloadDest = "";
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$softwareMgr$SoftwareMgr;

    public static boolean autoUpdateEnabled() {
        Config config = UplinkHomeConfig.getInstance();
        return config.getProperty("ccr.autoupdate", true);
    }

    public boolean containsMandatoryComponent(Component[] componentArray) throws ComponentStateException {
        boolean bl = false;
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length && !bl; ++i) {
                bl = componentArray[i].isMandatory();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SoftwareMgr getInstance() {
        if (s_instance == null) {
            Class clazz = class$oracle$sysman$ccr$collector$softwareMgr$SoftwareMgr == null ? (class$oracle$sysman$ccr$collector$softwareMgr$SoftwareMgr = SoftwareMgr.class$("oracle.sysman.ccr.collector.softwareMgr.SoftwareMgr")) : class$oracle$sysman$ccr$collector$softwareMgr$SoftwareMgr;
            synchronized (clazz) {
                if (s_instance == null) {
                    s_instance = new SoftwareMgr();
                }
            }
        }
        return s_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDownloadDest() {
        if (s_downloadDest.length() == 0) {
            Class clazz = class$oracle$sysman$ccr$collector$softwareMgr$SoftwareMgr == null ? (class$oracle$sysman$ccr$collector$softwareMgr$SoftwareMgr = SoftwareMgr.class$("oracle.sysman.ccr.collector.softwareMgr.SoftwareMgr")) : class$oracle$sysman$ccr$collector$softwareMgr$SoftwareMgr;
            synchronized (clazz) {
                Config config = UplinkHomeConfig.getInstance();
                s_downloadDest = config.getProperty("ccr.download_dest", FileSpec.catfile((String[])new String[]{Collector.getCCRRoot(), UplinkPath.INVENTORY_PENDING_DEPLOYMENT_PATH}));
            }
        }
    }

    public Component[] getDeployedComponents() {
        this.inventoryComponents();
        Component[] componentArray = new Component[s_vecComponents.size()];
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i] = (Component)s_vecComponents.get(i);
        }
        return componentArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component[] getComponentDownloadList() throws NetworkException, SoftwareUpdateException {
        if (s_componentDownloadList == null) {
            SoftwareMgr softwareMgr = this;
            synchronized (softwareMgr) {
                if (s_componentDownloadList == null) {
                    Component[] componentArray = this.getDeployedComponents();
                    s_componentDownloadList = this.getComponentDownloadList(componentArray, null);
                }
            }
        }
        return s_componentDownloadList;
    }

    public Component[] getComponentDownloadList(Component[] componentArray, NVPair[] nVPairArray) throws NetworkException, SoftwareUpdateException {
        Vector vector = this.constructInventoryURIParams(componentArray);
        if (nVPairArray != null) {
            for (int i = 0; i < nVPairArray.length; ++i) {
                vector.add(nVPairArray[i]);
            }
        }
        String string = this.sendComponentInventory(vector);
        return this.extractUpdateList(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean downloadUpdates(Component[] componentArray) throws NetworkException, SoftwareUpdateException {
        boolean bl = false;
        EndPointAddr endPointAddr = null;
        try {
            endPointAddr = this.getContentServerAddr();
        }
        catch (MalformedURLException malformedURLException) {
            throw new SoftwareUpdateException("Error constructing URI for update check - " + malformedURLException.getMessage());
        }
        OCMEndPoint oCMEndPoint = new OCMEndPoint(endPointAddr);
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                InputStream inputStream;
                block16: {
                    inputStream = null;
                    inputStream = oCMEndPoint.getFile(componentArray[i].getComponentFilename());
                    if (!this.persistComponent(componentArray[i], inputStream)) break block16;
                    bl = true;
                }
                Object var9_9 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                inputStream = null;
                {
                    continue;
                    catch (FileNotFoundException fileNotFoundException) {
                        if (s_log.isEnabledFor(Logger.WARN)) {
                            s_log.warn(SoftwareMgrMsgId.DOWNLOAD_UNAVAILABLE, (Object[])new String[]{componentArray[i].getComponentFilename()});
                        }
                        var9_9 = null;
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        inputStream = null;
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var9_9 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    inputStream = null;
                    throw throwable;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean persistComponent(Component component, InputStream inputStream) throws SoftwareUpdateException {
        boolean bl;
        block33: {
            IOException iOException2222;
            BufferedOutputStream bufferedOutputStream;
            File file;
            File file2;
            block31: {
                int n;
                this.getDownloadDest();
                file2 = new File(FileSpec.catfile((String[])new String[]{s_downloadDest, component.getComponentName() + JAR_SUFFIX}));
                file = new File(FileSpec.catfile((String[])new String[]{s_downloadDest, component.getComponentName() + ".lk"}));
                this.initDownloadState(file2, file);
                FileOutputStream fileOutputStream = null;
                bufferedOutputStream = null;
                bl = false;
                fileOutputStream = new FileOutputStream(file2);
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                byte[] byArray = new byte[1024];
                while ((n = inputStream.read(byArray)) > 0) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
                inputStream.close();
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                SignedComponent.verify((String)file2.toString());
                Object var11_14 = null;
                if (inputStream == null) break block31;
                try {
                    inputStream.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (bufferedOutputStream != null) {
                try {
                    bufferedOutputStream.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (bl && file2.exists()) {
                file2.delete();
            }
            this.clearDownloadState(file);
            {
                break block33;
                catch (FileNotFoundException fileNotFoundException) {
                    throw new SoftwareUpdateException(s_downloadDest + " is not accessible", fileNotFoundException);
                }
                catch (IOException iOException3) {
                    bl = true;
                    throw new SoftwareUpdateException("Error in streaming data from contentServer", iOException3);
                }
                catch (ComponentVerificationException componentVerificationException) {
                    IOException iOException42222;
                    if (s_log.isEnabledFor(Logger.ERROR)) {
                        s_log.error(SoftwareMgrMsgId.DOWNLOAD_VERIFICATION_FAILURE, (Object[])new String[]{component.getComponentName(), componentVerificationException.getMessage()});
                    }
                    bl = true;
                    Object var11_15 = null;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException42222) {
                            // empty catch block
                        }
                    }
                    if (bufferedOutputStream != null) {
                        try {
                            bufferedOutputStream.close();
                        }
                        catch (IOException iOException42222) {
                            // empty catch block
                        }
                    }
                    if (bl && file2.exists()) {
                        file2.delete();
                    }
                    this.clearDownloadState(file);
                    break block33;
                }
                catch (InvalidComponentException invalidComponentException) {
                    IOException iOException52222;
                    if (s_log.isEnabledFor(Logger.ERROR)) {
                        s_log.error(SoftwareMgrMsgId.DOWNLOAD_VERIFICATION_FAILURE, (Object[])new String[]{component.getComponentName(), invalidComponentException.getMessage()});
                    }
                    bl = true;
                    Object var11_16 = null;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException52222) {
                            // empty catch block
                        }
                    }
                    if (bufferedOutputStream != null) {
                        try {
                            bufferedOutputStream.close();
                        }
                        catch (IOException iOException52222) {
                            // empty catch block
                        }
                    }
                    if (bl && file2.exists()) {
                        file2.delete();
                    }
                    this.clearDownloadState(file);
                }
            }
            catch (Throwable throwable) {
                IOException iOException62222;
                Object var11_17 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException62222) {
                        // empty catch block
                    }
                }
                if (bufferedOutputStream != null) {
                    try {
                        bufferedOutputStream.close();
                    }
                    catch (IOException iOException62222) {
                        // empty catch block
                    }
                }
                if (bl && file2.exists()) {
                    file2.delete();
                }
                this.clearDownloadState(file);
                throw throwable;
            }
        }
        return !bl;
    }

    private void initDownloadState(File file, File file2) throws SoftwareUpdateException {
        if (file.exists() && !file.delete()) {
            throw new SoftwareUpdateException("Unable to remove package staged for installation (" + file.getName() + ")");
        }
        this.clearDownloadState(file2);
        try {
            file2.createNewFile();
        }
        catch (IOException iOException) {
            throw new SoftwareUpdateException("Unable to create package marker file", iOException);
        }
    }

    private void clearDownloadState(File file) throws SoftwareUpdateException {
        if (file.exists() && !file.delete()) {
            throw new SoftwareUpdateException("Unable to remove inprogress package marker " + file.getName());
        }
    }

    private SoftwareMgr() {
    }

    private Vector constructInventoryURIParams(Component[] componentArray) {
        Vector<NVPair> vector = new Vector<NVPair>();
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                String string = componentArray[i].getComponentVersion().toString();
                vector.add(new NVPair(componentArray[i].getComponentHeader(), string));
                String string2 = componentArray[i].getComponentArchitecture();
                if (string2 == null) continue;
                vector.add(new NVPair(componentArray[i].getComponentHeader() + "-ARCH", string2));
            }
        }
        return vector;
    }

    private Component[] extractUpdateList(String string) throws SoftwareUpdateException {
        Object object;
        Object object2;
        SoftwareUpdatesXMLParser softwareUpdatesXMLParser = new SoftwareUpdatesXMLParser();
        try {
            object2 = XMLReaderFactory.createXMLReader("oracle.xml.parser.v2.SAXParser");
            object2.setContentHandler((ContentHandler)((Object)softwareUpdatesXMLParser));
            object = new StringReader(string);
            InputSource inputSource = new InputSource((Reader)object);
            object2.parse(inputSource);
        }
        catch (SAXException sAXException) {
            if (s_log.isEnabledFor(Logger.ERROR)) {
                s_log.error(SoftwareMgrMsgId.CS_RESPONSE_ERR, (Object[])new String[]{sAXException.getMessage(), string});
            }
            throw new SoftwareUpdateException(s_msgBundle.getMessage(SoftwareMgrMsgId.CS_RESPONSE_ERR, false, (Object[])new String[]{sAXException.getMessage(), string}));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object2 = softwareUpdatesXMLParser.getClientActions().elements();
        object = null;
        while (object2.hasMoreElements()) {
            try {
                object = (ClientAction)object2.nextElement();
                ((ClientAction)object).executeAction();
            }
            catch (NetworkException networkException) {
                this.dispatchActionException((CCRException)((Object)networkException));
            }
            catch (CommandException commandException) {
                if (null == object || object instanceof DisableTargetAction) continue;
                this.dispatchActionException(commandException);
            }
        }
        return softwareUpdatesXMLParser.getFilesForDownload();
    }

    void dispatchActionException(CCRException cCRException) throws SoftwareUpdateException {
        if (s_log.isEnabledFor(Logger.ERROR)) {
            s_log.error(SoftwareMgrMsgId.CLIENT_ACTION_ERR);
            Vector vector = cCRException.formatExceptionChain();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                s_log.error(SoftwareMgrMsgId.CLIENT_ACTION_CHAINED_ERR, (Object[])new String[]{string});
            }
        }
        throw new SoftwareUpdateException(s_msgBundle.getMessage(SoftwareMgrMsgId.CLIENT_ACTION_ERR, false), cCRException);
    }

    public static String formatComponentList(Component[] componentArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(componentArray[i].getComponentName());
                stringBuffer.append(" (");
                stringBuffer.append(componentArray[i].getComponentVersion().toString());
                stringBuffer.append(")");
            }
        }
        return stringBuffer.toString();
    }

    private EndPointAddr getContentServerAddr() throws MalformedURLException {
        EndPointAddr endPointAddr;
        try {
            endPointAddr = UplinkSystemConfig.getOCMServiceEndPoint();
            if (endPointAddr == null) {
                throw new MalformedURLException("Oracle Configuration Manager endpoint unknown");
            }
        }
        catch (ParseException parseException) {
            throw new MalformedURLException("Unable to construct URI for Oracle Configuration Manager connection - " + parseException.getMessage());
        }
        return endPointAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inventoryComponents() {
        if (s_vecComponents != null) {
            return;
        }
        Class clazz = class$oracle$sysman$ccr$collector$softwareMgr$SoftwareMgr == null ? (class$oracle$sysman$ccr$collector$softwareMgr$SoftwareMgr = SoftwareMgr.class$("oracle.sysman.ccr.collector.softwareMgr.SoftwareMgr")) : class$oracle$sysman$ccr$collector$softwareMgr$SoftwareMgr;
        synchronized (clazz) {
            if (s_vecComponents == null) {
                s_vecComponents = new Vector();
                String string = FileSpec.catfile((String[])new String[]{Collector.getCCRRoot(), UplinkPath.INVENTORY_PATH});
                String[] stringArray = this.packages(string);
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        File file = new File(FileSpec.catfile((String[])new String[]{string, stringArray[i]}));
                        Component component = new Component(file);
                        s_vecComponents.add(component);
                        if (!s_log.isEnabledFor(Logger.DEBUG)) continue;
                        s_log.debug((Object)("Discovered Component " + component.getComponentName() + ", version: " + component.getComponentVersion().toString() + ", buildDate: " + component.getComponentBuildDate() + ", header: " + component.getComponentHeader()));
                        continue;
                    }
                    catch (InvalidComponentException invalidComponentException) {
                        if (!s_log.isEnabledFor(Logger.WARN)) continue;
                        s_log.warn(SoftwareMgrMsgId.INV_COMPONENT, (Object[])new String[]{stringArray[i]}, (Throwable)invalidComponentException);
                    }
                }
            }
        }
    }

    private String sendComponentInventory(Vector vector) throws NetworkException, SoftwareUpdateException {
        EndPointAddr endPointAddr = null;
        try {
            endPointAddr = this.getContentServerAddr();
        }
        catch (MalformedURLException malformedURLException) {
            throw new SoftwareUpdateException("Error constructing URI for update check - " + malformedURLException.getMessage());
        }
        SecurityMgr securityMgr = SecurityMgr.getInstance();
        String string = securityMgr.getCustomerOrgId();
        String string2 = Hostname.getHostname();
        String string3 = Collector.getCCRRoot();
        String string4 = Collector.getConfigHome();
        OCMEndPoint oCMEndPoint = new OCMEndPoint(endPointAddr);
        return oCMEndPoint.getUpdates(vector, string2, string3, string, securityMgr.getAuthenticationKeyString(), string4);
    }

    private String[] packages(String string) {
        File file = new File(string);
        String[] stringArray = file.list(new _packageFilenameFilter());
        return stringArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class _packageFilenameFilter
    implements FilenameFilter {
        private _packageFilenameFilter() {
        }

        public boolean accept(File file, String string) {
            File file2 = new File(file, string);
            if (file2.isFile()) {
                return string.endsWith(SoftwareMgr.JAR_SUFFIX);
            }
            return false;
        }
    }
}

