/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.targets;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.TargetHomeManager;
import oracle.sysman.ccr.collector.cmd.DiscoveryCommandException;
import oracle.sysman.ccr.collector.util.AgentConfig;
import oracle.sysman.ccr.collector.util.Hostname;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.exception.CCRException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.Process;
import oracle.sysman.ccr.util.UplinkPath;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class DiscoveryEngine {
    private static Logger s_log = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$targets$DiscoveryEngine == null ? (class$oracle$sysman$ccr$collector$targets$DiscoveryEngine = DiscoveryEngine.class$("oracle.sysman.ccr.collector.targets.DiscoveryEngine")) : class$oracle$sysman$ccr$collector$targets$DiscoveryEngine));
    private static final String[] m_collector_env_vars = new String[]{"CCR_HOME", "CCR_JAVA_HOME", "CCR_CONFIG_HOME"};
    private final String ENV_CCR_HOME = "CCR_HOME";
    private final String ENV_CCR_JAVA_HOME = "CCR_JAVA_HOME";
    private final String ENV_EMAGENT_PERL_TRACE_DIR = "EMAGENT_PERL_TRACE_DIR";
    private final String ENV_EMAGENT_PERL_TRACE_LEVEL = "EMAGENT_PERL_TRACE_LEVEL";
    private final String ENV_PERL5LIB = "PERL5LIB";
    private final String ENV_SYSTEMROOT = "SYSTEMROOT";
    private final String ENV_USER_ORACLE_HOME = "USER_ORACLE_HOME";
    private final String ENV_AGENT_HOME = "AGENT_HOME";
    private final String ENV_DISCOVERYROOT = "DISC_ROOT";
    private final String ENV_AGENTPROXYHOME = "AGENTPROXYHOME";
    private final String ENV_JDBC_OCI_SWITCH = "JDBC_OCI_SWITCH";
    private final String ENV_ORACLE_HOME = "ORACLE_HOME";
    private final String ENV_JAVA_HOME = "JAVA_HOME";
    private final String ENV_AGENT_MODE = "AGENT_MODE";
    private final String VALUE_AGENT_MODE_OCM = "OCM";
    private final String PERL_EXE = "perl";
    private final String EXE_EXT = ".exe";
    private static final String ENV_HOME = "HOME";
    private static final String JAVA_HOME_PROP = "user.home";
    private static final String DISCOVERY_LST = "discover.lst";
    private static RE m_discoverLstPattern;
    private static DiscoveryEngine m_instance;
    private static String s_strTimeoutValue;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$targets$DiscoveryEngine;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DiscoveryEngine getInstance() {
        if (m_instance == null) {
            Class clazz = class$oracle$sysman$ccr$collector$targets$DiscoveryEngine == null ? (class$oracle$sysman$ccr$collector$targets$DiscoveryEngine = DiscoveryEngine.class$("oracle.sysman.ccr.collector.targets.DiscoveryEngine")) : class$oracle$sysman$ccr$collector$targets$DiscoveryEngine;
            synchronized (clazz) {
                if (m_instance == null) {
                    m_instance = new DiscoveryEngine();
                }
            }
        }
        return m_instance;
    }

    private DiscoveryEngine() {
    }

    public static final void main(String[] stringArray) {
        DiscoveryEngine discoveryEngine = DiscoveryEngine.getInstance();
        try {
            System.out.println(discoveryEngine.discover(discoveryEngine.getDiscoveryScripts(DiscoveryScriptsFilter.PER_HOST), false).toString());
            System.out.println(discoveryEngine.discover(discoveryEngine.getDiscoveryScripts(DiscoveryScriptsFilter.PER_HOME), false).toString());
        }
        catch (DiscoveryCommandException discoveryCommandException) {
            Object object = discoveryCommandException;
            while (object != null) {
                System.err.println(((Throwable)object).getMessage());
                if (!(object instanceof CCRException)) continue;
                CCRException cCRException = object;
                object = cCRException.getCause();
            }
        }
    }

    private HashMap getCustomEnvVars(String string) {
        Object object;
        String string2 = System.getProperty("PERL5LIB");
        String string3 = this.getDiscoverPath(string);
        String string4 = this.getScriptsPath(string);
        String string5 = this.getDiscoverPath("default");
        String string6 = this.getScriptsPath("default");
        String string7 = System.getProperty("path.separator");
        if (string.equals("ocm")) {
            string2 = System.getProperty("PERL5LIB") + string7 + string3 + string7 + string4;
        } else if (string.equals("default")) {
            string2 = System.getProperty("PERL5LIB") + string7 + string5 + string7 + string6;
        } else if (string.equals("oracle.sysman.db")) {
            object = System.getProperty("file.separator");
            string2 = System.getProperty("PERL5LIB") + string7 + string5 + string7 + string6 + string7 + string3 + (String)object + "discover";
        } else {
            string2 = System.getProperty("PERL5LIB") + string7 + string5 + string7 + string6 + string7 + string3;
        }
        object = new HashMap();
        ((HashMap)object).put("DISC_ROOT", string3);
        ((HashMap)object).put("PERL5LIB", string2);
        return object;
    }

    private String getDiscoverPath(String string) {
        return FileSpec.catfile((String[])new String[]{Collector.getCCRRoot(), UplinkPath.getDiscoverPath((String)string)});
    }

    private String getScriptsPath(String string) {
        return FileSpec.catfile((String[])new String[]{Collector.getCCRRoot(), UplinkPath.getScriptsPath((String)string)});
    }

    public StringBuffer discover(HashMap hashMap, boolean bl) throws DiscoveryCommandException {
        StringBuffer stringBuffer = new StringBuffer();
        Set set = hashMap.keySet();
        HashMap hashMap2 = new HashMap();
        hashMap2.putAll(this.getEnvironmentVars());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            CharSequence charSequence;
            String string = (String)iterator.next();
            Vector vector = (Vector)hashMap.get(string);
            String string2 = this.getDiscoverPath(string);
            hashMap2.putAll(this.getCustomEnvVars(string));
            String[] stringArray = new String[hashMap2.size()];
            Set set2 = hashMap2.keySet();
            Iterator iterator2 = set2.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                charSequence = (String)iterator2.next();
                stringArray[n] = (String)charSequence + "=" + (String)hashMap2.get(charSequence);
                ++n;
            }
            if (s_log.isEnabledFor(Logger.DEBUG)) {
                s_log.debug((Object)("Discovery environment array for Plugin Id " + string + " is:"));
                for (n = 0; n < stringArray.length; ++n) {
                    s_log.debug((Object)("\t" + stringArray[n]));
                }
            }
            for (n = 0; n < vector.size(); ++n) {
                try {
                    charSequence = this.discover(string2, (String)vector.get(n), stringArray);
                    stringBuffer.append(((StringBuffer)charSequence).toString());
                    continue;
                }
                catch (DiscoveryCommandException discoveryCommandException) {
                    if (bl && System.getProperty(TargetHomeManager.ccrtest_do_not_silence_anonymous_central_collector) == null) continue;
                    if (Collector.failOnError()) {
                        throw discoveryCommandException;
                    }
                    Collector.logExceptionChainToStderr(discoveryCommandException);
                }
            }
        }
        return stringBuffer;
    }

    private StringBuffer discover(String string, String string2, String[] stringArray) throws DiscoveryCommandException {
        Config config = UplinkHomeConfig.getInstance();
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = FileSpec.catfile((String[])new String[]{string, string2});
        String string4 = "perl";
        String string5 = System.getProperty("os.name");
        if (string5.startsWith("Windows")) {
            string4 = string4 + ".exe";
        }
        String[] stringArray2 = new String[]{FileSpec.catfile((String[])new String[]{config.getProperty("perlBin"), string4}), string3, FileSpec.catfile((String[])new String[]{Collector.getCCRRoot(), UplinkPath.LIVE_LINK_PATH}), Hostname.getHostname()};
        try {
            int n;
            String string6;
            if (s_log.isEnabledFor(Logger.DEBUG)) {
                s_log.debug((Object)"Executing discovery using cmd: ");
                string6 = "";
                for (n = 0; n < stringArray2.length; ++n) {
                    string6 = string6 + stringArray2[n] + " ";
                }
                s_log.debug((Object)("  " + string6));
            }
            if ((n = (string6 = Process.exec((String[])stringArray2, (String[])stringArray, null, (String)s_strTimeoutValue)).waitFor(stringBuffer)) != 0) {
                throw new DiscoveryCommandException("Unable to perform discovery using " + string2 + " Terminated with " + stringBuffer.toString());
            }
        }
        catch (InterruptedException interruptedException) {
            throw new DiscoveryCommandException("Error in performing discovery using " + string2, (Throwable)interruptedException);
        }
        catch (IOException iOException) {
            throw new DiscoveryCommandException("Error in performing discovery using " + string2, (Throwable)iOException);
        }
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    HashMap getDiscoveryScripts(DiscoveryScriptsFilter discoveryScriptsFilter) {
        HashMap<String, Vector> hashMap;
        block22: {
            String string;
            hashMap = new HashMap<String, Vector>();
            Vector vector = null;
            File file = new File(FileSpec.catfile((String[])new String[]{Collector.getCCRRoot(), UplinkPath.DISCOVER_PATH, DISCOVERY_LST}));
            BufferedReader bufferedReader = null;
            FileReader fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.indexOf("#");
                if (n > 0) {
                    string = string.substring(0, n - 1);
                } else if (n == 0) continue;
                if ((string = string.trim()).length() == 0 || !m_discoverLstPattern.match(string)) continue;
                String string2 = m_discoverLstPattern.getParen(1);
                String string3 = m_discoverLstPattern.getParen(2);
                String string4 = m_discoverLstPattern.getParen(3);
                String string5 = m_discoverLstPattern.getParen(5);
                String string6 = "ocm";
                boolean bl = false;
                if (string2.equals("HOST") || string2.equals("LIVELINK")) {
                    bl = true;
                }
                if (bl && discoveryScriptsFilter.equals(DiscoveryScriptsFilter.PER_HOME) || !bl && discoveryScriptsFilter.equals(DiscoveryScriptsFilter.PER_HOST)) continue;
                if (string5 != null && string5.length() != 0) {
                    string6 = string5;
                }
                if (hashMap.containsKey(string6)) {
                    vector = (Vector)hashMap.get(string6);
                } else {
                    vector = new Vector();
                    hashMap.put(string6, vector);
                }
                vector.add(string3);
            }
            bufferedReader.close();
            Object var16_18 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                break block22;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            break block22;
            {
                catch (FileNotFoundException fileNotFoundException) {
                    HashMap<String, Vector> hashMap2 = hashMap;
                    Object var16_19 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    return hashMap2;
                }
                catch (IOException iOException) {
                    try {
                        iOException.printStackTrace();
                        Object var16_20 = null;
                    }
                    catch (Throwable throwable) {
                        Object var16_21 = null;
                        try {
                            if (bufferedReader != null) {
                                bufferedReader.close();
                            }
                        }
                        catch (IOException iOException2) {
                            iOException2.printStackTrace();
                        }
                        throw throwable;
                    }
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException3) {
                        iOException3.printStackTrace();
                    }
                }
            }
        }
        return hashMap;
    }

    private HashMap getEnvironmentVars() {
        String string;
        Object object;
        String string2;
        String string3;
        String string4;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < m_collector_env_vars.length; ++i) {
            hashMap.put(m_collector_env_vars[i], System.getProperty(m_collector_env_vars[i]));
        }
        TargetHomeManager.getTargetHomeSystemProps(hashMap);
        hashMap.put("AGENT_MODE", "OCM");
        String string5 = null;
        string5 = System.getProperty("USER_ORACLE_HOME");
        if (string5 != null) {
            hashMap.put("USER_ORACLE_HOME", string5);
        }
        hashMap.put("EMAGENT_PERL_TRACE_DIR", FileSpec.catfile((String[])new String[]{AgentConfig.getRootStateDir(), UplinkPath.LOG_PATH}));
        String string6 = System.getProperty("SYSTEMROOT");
        if (string6 != null && string6.length() > 0) {
            hashMap.put("SYSTEMROOT", string6);
        }
        if ((string4 = System.getProperty(JAVA_HOME_PROP)) != null) {
            hashMap.put(ENV_HOME, string4);
        }
        if ((string3 = System.getProperty("EMAGENT_PERL_TRACE_LEVEL")) != null) {
            hashMap.put("EMAGENT_PERL_TRACE_LEVEL", string3);
        }
        if ((string2 = System.getProperty("SHLIB_VAR")) != null) {
            object = new StringTokenizer(string2, "=");
            string = null;
            String string7 = null;
            if (((StringTokenizer)object).countTokens() >= 2) {
                string = ((StringTokenizer)object).nextToken();
                string7 = ((StringTokenizer)object).nextToken();
            }
            hashMap.put(string, string7);
        }
        hashMap.put("AGENT_HOME", "0");
        object = System.getProperty("AGENTPROXYHOME");
        if (object != null && ((String)object).length() > 0) {
            hashMap.put("AGENTPROXYHOME", object);
        }
        if ((string = System.getProperty("JDBC_OCI_SWITCH")) != null && string.length() > 0) {
            hashMap.put("JDBC_OCI_SWITCH", string);
        }
        return hashMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            m_discoverLstPattern = new RE("^(.*?)\\|(.*?)\\|(.*?)(\\|(.*?))?$");
        }
        catch (RESyntaxException rESyntaxException) {
            throw new RuntimeException("Invalid pattern\n" + rESyntaxException.getMessage());
        }
        Config config = UplinkHomeConfig.getInstance();
        s_strTimeoutValue = config.getProperty("ccr.process.timeout");
        if (s_strTimeoutValue != null && s_strTimeoutValue.trim().length() == 0) {
            s_strTimeoutValue = null;
        }
    }

    static class DiscoveryScriptsFilter {
        static final DiscoveryScriptsFilter PER_HOME = new DiscoveryScriptsFilter(1);
        static final DiscoveryScriptsFilter PER_HOST = new DiscoveryScriptsFilter(2);
        private int mId;

        private DiscoveryScriptsFilter() {
            this.mId = 0;
        }

        private DiscoveryScriptsFilter(int n) {
            this.mId = n;
        }

        public boolean equals(Object object) {
            if (object instanceof DiscoveryScriptsFilter) {
                return ((DiscoveryScriptsFilter)object).mId == this.mId;
            }
            return false;
        }

        public int hashCode() {
            return this.mId;
        }
    }
}

