/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.targets;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.TargetHomeManager;
import oracle.sysman.ccr.collector.collectionMgr.XMLUploadWriter;
import oracle.sysman.ccr.collector.gcontext.GCContextManager;
import oracle.sysman.ccr.collector.security.SecurityMgr;
import oracle.sysman.ccr.collector.targets.TargetAssocTargetInstance;
import oracle.sysman.ccr.collector.targets.TargetManager;
import oracle.sysman.ccr.collector.targets.TargetProperty;
import oracle.sysman.ccr.collector.targets.TargetsMsgID;
import oracle.sysman.ccr.collector.targets.metadata.DynamicProperties;
import oracle.sysman.ccr.collector.targets.metadata.TargetMetadata;
import oracle.sysman.ccr.collector.timezone.Timezone;
import oracle.sysman.ccr.collector.util.Hostname;
import oracle.sysman.ccr.collector.util.OutOfPlaceUpgradeClient;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.UplinkPath;
import oracle.sysman.ccr.util.XMLOps;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Target
implements Serializable {
    private static final long serialVersionUID = -7196199441270915507L;
    private transient Logger m_log = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$targets$Target == null ? (class$oracle$sysman$ccr$collector$targets$Target = Target.class$("oracle.sysman.ccr.collector.targets.Target")) : class$oracle$sysman$ccr$collector$targets$Target));
    private transient MessageBundle m_bundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.targets.Targets");
    private transient HashMap m_hashProperties;
    public transient HashMap m_env;
    private HashMap m_targetHomeSpecificEnvVars = new HashMap();
    public transient HashMap m_hashTargetAssocs;
    private String m_strUniqueId;
    private String m_strTargetName;
    private String m_strTargetType;
    private String m_strTimeZone;
    private String m_strDisplayName = "";
    private String m_strOnHost = "";
    private boolean m_bDisabled;
    private String m_strVersion = "";
    private boolean m_bOnHost;
    private String m_oracleHome;
    private String m_configHome;
    private String m_hostName;
    private boolean m_isProxyTarget;
    private boolean m_useCfgHomeForGUID = true;
    private boolean m_isCollectedByAnonymousCentralCollector;
    private String m_fullPath;
    private String m_strGUID;
    public static final String HOST_TARGET = "host";
    private static final String RAC_DATABASE = "rac_database";
    private static final String WEBSPHERE_TARGET = "ibm";
    private static final String BEA_TARGET = "bea";
    private static final String IAS_FARM_TARGET = "oracle_ias_farm";
    private static final String IAS_CLUSTER_TARGET = "oracle_ias_cluster";
    private static final String CLUSTER_TARGET = "cluster";
    private static final String ORACLE_HOME_TARGET = "oracle_home";
    private transient Date m_dateCollection;
    public static final String INSTANCE_PROP_ORACLE_HOME = "OracleHome";
    public static final String INSTANCE_PROP_IS_PROXY_TARGET = "IsProxyTarget";
    public static final String INSTANCE_PROP_OCM_PROXY_HOST = "OcmProxyHost";
    public static final String INSTANCE_PROP_OCM_PROXY_ORACLE_HOME = "OcmProxyOracleHome";
    public static final String INSTANCE_PROP_OCM_PROXY_CONFIG_HOME = "OcmProxyConfigHome";
    public static final String INSTANCE_PROP_OCM_CROSS_HOST = "OCM_CROSS_HOST";
    public static final String INSTANCE_PROP_IS_REMOTE = "IS_REMOTE";
    public static final String INSTANCE_PROP_MULTIPLEXED = "MULTIPLEXED";
    private static final String GUID_PROP = "GUID";
    private static final String CCR_COLLECTION_TIMESTAMP_OVERRIDE = "CCR_COLLECTION_TIMESTAMP_OVERRIDE";
    public static final String ATTR_UNIQUE_ID = "UNIQUE_ID";
    public static final String ATTR_TYPE = "TYPE";
    public static final String ATTR_NAME = "NAME";
    public static final String ATTR_DISPLAY_NAME = "DISPLAY_NAME";
    public static final String ATTR_ON_HOST = "ON_HOST";
    public static final String ATTR_NO_EMD_URL = "NO_EMD_URL";
    public static final String ATTR_TIMEZONE_REGION = "TIMEZONE_REGION";
    public static final String ATTR_DISABLED = "DISABLED";
    public static final String ATTR_VERSION = "VERSION";
    public static final String TARGET = "Target";
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$targets$Target;

    public Target(Attributes attributes, String string, String string2) throws SAXException {
        this(attributes);
        this.m_oracleHome = string;
        this.m_configHome = string2;
    }

    public Target(Attributes attributes) throws SAXException {
        this.m_hashProperties = new HashMap();
        this.m_env = new HashMap();
        this.m_hashTargetAssocs = new HashMap();
        this.m_oracleHome = System.getProperty("ORACLE_HOME");
        this.m_configHome = System.getProperty("ORACLE_CONFIG_HOME");
        if (this.m_configHome == null || this.m_configHome.length() == 0) {
            this.m_useCfgHomeForGUID = false;
        }
        this.m_fullPath = Collector.getFullPath();
        this.m_hostName = Hostname.getHostname();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getQName(i);
            if (string.equals(ATTR_NAME)) {
                this.m_strTargetName = attributes.getValue(i);
                continue;
            }
            if (string.equals(ATTR_TYPE)) {
                this.m_strTargetType = attributes.getValue(i);
                if (!this.m_strTargetType.equalsIgnoreCase(ORACLE_HOME_TARGET)) continue;
                this.m_useCfgHomeForGUID = false;
                continue;
            }
            if (string.equals(ATTR_DISABLED)) {
                this.m_bDisabled = Boolean.valueOf(attributes.getValue(i));
                continue;
            }
            if (string.equals(ATTR_DISPLAY_NAME)) {
                this.m_strDisplayName = attributes.getValue(i);
                continue;
            }
            if (string.equals(ATTR_NO_EMD_URL)) {
                this.m_bOnHost = Boolean.valueOf(attributes.getValue(i));
                continue;
            }
            if (string.equals(ATTR_ON_HOST)) {
                this.addOnHostAttribute(attributes.getValue(i));
                continue;
            }
            if (string.equals(ATTR_TIMEZONE_REGION)) {
                this.m_strTimeZone = attributes.getValue(i);
                continue;
            }
            if (string.equals(ATTR_VERSION)) {
                this.m_strVersion = attributes.getValue(i);
                continue;
            }
            if (string.equals(ATTR_UNIQUE_ID)) {
                this.m_strUniqueId = attributes.getValue(i);
                if (!this.m_strUniqueId.equals("")) continue;
                this.m_strUniqueId = null;
                continue;
            }
            if (!this.m_log.isEnabledFor(Logger.WARN)) continue;
            this.m_log.warn(TargetsMsgID.UNSUPPORTED_TARGET_ATTR, (Object[])new String[]{string});
        }
        this.postCreation(true, null);
    }

    public Target(String string, String string2, boolean bl, String string3, boolean bl2, String string4, String string5, String string6, boolean bl3, String string7, String string8, String string9) throws SAXException {
        this(string, string2, bl, string3, bl2, string4, string5, string6, bl3, string7, string8, string9, null, null);
    }

    public Target(String string, String string2, boolean bl, String string3, boolean bl2, String string4, String string5, String string6, boolean bl3, String string7, String string8, String string9, String string10, Map map) throws SAXException {
        this.m_hashProperties = new HashMap();
        this.m_env = new HashMap();
        if (map != null) {
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string11 = (String)iterator.next();
                String string12 = (String)map.get(string11);
                this.m_hashProperties.put(string11, new TargetProperty(string11, string12));
            }
        }
        this.m_strTargetName = string;
        this.m_strTargetType = string2;
        this.m_bDisabled = bl;
        this.m_strDisplayName = string3;
        this.m_bOnHost = bl2;
        this.m_hostName = string4;
        this.m_useCfgHomeForGUID = true;
        if (string6 == null || string6.length() == 0 || this.m_strTargetType.equalsIgnoreCase(ORACLE_HOME_TARGET)) {
            this.m_useCfgHomeForGUID = false;
        }
        this.m_oracleHome = string5;
        this.m_configHome = string6;
        this.m_isProxyTarget = bl3;
        this.m_strOnHost = string7;
        if (this.m_isProxyTarget) {
            this.m_hostName = this.m_strOnHost == null ? this.m_hostName : this.m_strOnHost.toLowerCase();
            this.addProperty(INSTANCE_PROP_OCM_PROXY_HOST, this.m_hostName);
        }
        this.m_strVersion = string9;
        this.m_strUniqueId = string10;
        if (this.m_strUniqueId == null || this.m_strUniqueId.equals("")) {
            this.m_strUniqueId = null;
        }
        this.postCreation(false, string8);
    }

    public String getTargetHomeSpecificPropterty(String string) {
        return (String)this.m_targetHomeSpecificEnvVars.get(string);
    }

    private void addOnHostAttribute(String string) {
        this.m_strOnHost = string;
        this.m_isProxyTarget = true;
        this.m_configHome = null;
        this.m_useCfgHomeForGUID = false;
        this.m_hostName = string.toLowerCase();
        this.addProperty(INSTANCE_PROP_OCM_PROXY_HOST, this.m_hostName);
    }

    private void postCreation(boolean bl, String string) throws SAXException {
        if (this.m_strTargetName == null || this.m_strTargetType == null) {
            throw new SAXException("TARGET element does not have a NAME or TYPE");
        }
        this.addDefaultInstanceProperties();
        if (bl) {
            this.setTimeZone();
        } else if (string != null) {
            Timezone timezone = Timezone.getInstance();
            this.m_strTimeZone = timezone.findSupportedRegion(string);
        } else {
            this.m_strTimeZone = null;
        }
        if (UplinkPath.isGCMode()) {
            this.generateTargetGUIDProperty();
        }
        this.m_log.info(TargetsMsgID.PROCESSING_TARGET, (Object[])new String[]{this.getTargetName(), this.getTargetType()});
    }

    void addDefaultInstanceProperties() {
        this.addProperty(ATTR_NAME, this.getTargetName());
        this.addProperty(ATTR_TYPE, this.getTargetType());
        this.addProperty(ATTR_DISPLAY_NAME, this.getDisplayName());
        this.addProperty(INSTANCE_PROP_IS_PROXY_TARGET, new Boolean(this.m_isProxyTarget).toString());
        boolean bl = Collector.isRemoteGridAgentMode();
        this.addProperty(INSTANCE_PROP_IS_REMOTE, new Boolean(bl).toString());
    }

    void generateTargetGUIDProperty() throws SAXException {
        this.m_strGUID = this.generateGUID();
        this.m_log.debug((Object)("target GUID is " + this.m_strGUID));
        this.addProperty(GUID_PROP, this.m_strGUID);
    }

    private String getTargetHostForGUID() {
        boolean bl;
        TargetManager targetManager = TargetManager.getInstance();
        TargetMetadata targetMetadata = targetManager.getTargetMetadata(this.getTargetType());
        String string = this.getTargetProperty(INSTANCE_PROP_OCM_CROSS_HOST);
        boolean bl2 = bl = string != null && string.equalsIgnoreCase("TRUE");
        if (targetMetadata.targetTypeCrossesHosts() || bl || this.getTargetType().equals(RAC_DATABASE) || this.getTargetType().equals(CLUSTER_TARGET) || this.getTargetType().equals(IAS_FARM_TARGET) || this.getTargetType().equals(IAS_CLUSTER_TARGET)) {
            return "";
        }
        return this.m_hostName;
    }

    public void setGUID(String string) {
        this.m_strGUID = string;
        this.m_log.debug((Object)("SETGUID target GUID is " + this.m_strGUID));
        this.addProperty(GUID_PROP, this.m_strGUID);
    }

    public void generateGUIDForImport(String string, String string2) throws SAXException {
        this.m_strGUID = this.generateGuid(string, string2);
        this.m_log.debug((Object)("target GUID is " + this.m_strGUID));
        this.addProperty(GUID_PROP, this.m_strGUID);
    }

    private String generateGUID() throws SAXException {
        String string = null;
        if (UplinkPath.isGCMode()) {
            string = GCContextManager.getGCContext().getOrgId();
        } else {
            SecurityMgr securityMgr = SecurityMgr.getInstance();
            string = securityMgr.getCustomerOrgId();
        }
        return this.generateGuid(string, this.getTargetHostForGUID());
    }

    private String generateGuid(String string, String string2) throws SAXException {
        String string3;
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if ((string3 = this.getTargetHomeForGUID()) == null) {
            string3 = "";
        }
        String string4 = this.getTargetName();
        String string5 = this.getUniqueId();
        if (string5 != null && string5.length() > 0) {
            string2 = "";
            string3 = "";
            string4 = string5;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            String string6 = string + ":" + string2;
            string6 = string6.toLowerCase() + ":" + string4 + ":" + string3 + ":" + this.getTargetType().toLowerCase();
            if (this.m_log.isEnabledFor(Logger.DEBUG)) {
                this.m_log.debug((Object)("Target " + this.getTargetName() + "," + this.getTargetType() + " is using a MD5 key of: " + string6));
            }
            byte[] byArray = messageDigest.digest(string6.getBytes());
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray.length; ++i) {
                int n = byArray[i] & 0xFF;
                String string7 = Integer.toHexString(n);
                if (string7.length() == 1) {
                    string7 = "0" + string7;
                }
                stringBuffer.append(string7);
            }
            return stringBuffer.toString().toUpperCase();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SAXException("Unable to get MD5 GUID\n" + noSuchAlgorithmException.getMessage());
        }
    }

    public String generateOldTargetGuid() throws ParserConfigurationException, SAXException, IOException {
        boolean bl;
        boolean bl2;
        String string = this.getTargetHostForGUID();
        String string2 = this.getTargetHomeForGUID();
        String string3 = this.getTargetName();
        String string4 = this.getTargetType();
        String string5 = this.m_configHome;
        String string6 = this.m_oracleHome;
        String string7 = this.getUniqueId();
        boolean bl3 = OutOfPlaceUpgradeClient.parseXml();
        String string8 = OutOfPlaceUpgradeClient.getOldHost();
        String string9 = OutOfPlaceUpgradeClient.getOldOracleConfigHome();
        String string10 = OutOfPlaceUpgradeClient.getOldOracleHome();
        boolean bl4 = bl2 = bl3 && !this.isProxyTarget() && !UplinkPath.isGCMode();
        if (bl2) {
            if (string8 != null && !string8.equals("")) {
                string = string8;
            }
            if (string9 != null && !string9.equals("")) {
                string2 = string9;
            } else if (string10 != null && !string10.equals("")) {
                string2 = string10;
            }
        }
        String string11 = this.getTargetProperty("OLD_NAME");
        String string12 = this.getTargetProperty("OLD_UNIQUE_ID");
        String string13 = this.getTargetProperty("OLD_ORACLE_CONFIG_HOME");
        String string14 = this.getTargetProperty("OLD_ORACLE_HOME");
        String string15 = this.getTargetProperty("OLD_HOST");
        boolean bl5 = string11 != null && !string11.trim().equals("");
        boolean bl6 = string12 != null && !string12.trim().equals("");
        boolean bl7 = string13 != null && !string13.trim().equals("");
        boolean bl8 = string14 != null && !string14.trim().equals("");
        boolean bl9 = bl = string15 != null && !string15.trim().equals("");
        if (bl5 || bl6 || bl7 || bl8 || bl) {
            if (bl5) {
                string3 = string11;
            }
            if (bl6) {
                string7 = string12;
            }
            if (bl8) {
                string2 = string6 = string14;
            }
            if (bl7) {
                string5 = string13;
                string2 = string13;
            }
            if (bl) {
                string = string15;
            }
            string2 = string2 == null ? "" : string2;
            File file = new File(string2);
            string2 = file.getPath();
            Target target = new Target(string3, string4, false, null, false, string, string2, null, true, string, this.m_strTimeZone, this.m_strVersion, string7, null);
            return target.generateGUID();
        }
        if (bl2) {
            if (!(string8 != null && !string8.trim().equals("") || string9 != null && !string9.trim().equals("") || string10 != null && !string10.trim().equals(""))) {
                return null;
            }
            string2 = string2 == null ? "" : string2;
            File file = new File(string2);
            string2 = file.getPath();
            Target target = new Target(string3, string4, false, null, false, string, string2, null, true, string, this.m_strTimeZone, this.m_strVersion, null, null);
            return target.generateGUID();
        }
        return null;
    }

    private String getTargetHomeForGUID() {
        if (this.getTargetType().equalsIgnoreCase(HOST_TARGET) || this.getTargetType().equalsIgnoreCase(BEA_TARGET) || this.getTargetType().equalsIgnoreCase(WEBSPHERE_TARGET) || this.getTargetType().equalsIgnoreCase(IAS_FARM_TARGET) || this.getTargetType().equalsIgnoreCase(IAS_CLUSTER_TARGET)) {
            return "";
        }
        return this.m_useCfgHomeForGUID ? this.m_configHome : this.m_oracleHome;
    }

    public void setCollectionTimestampOverride(Date date) {
        this.m_dateCollection = date;
    }

    public Date getCollectionTimestampOverride() {
        return this.m_dateCollection;
    }

    void addProperty(Attributes attributes) throws SAXException {
        TargetProperty targetProperty = new TargetProperty(attributes);
        this.addPropertyWorker(targetProperty);
    }

    void addProperty(String string, String string2) {
        this.m_hashProperties.put(string, new TargetProperty(string, string2));
        this.setCollectionTimestamp(string, string2);
    }

    void markAsBeingCollectedByDesignatedCollector(TargetHomeManager targetHomeManager, String string, String string2) throws SAXException {
        if (this.getTargetProperty(INSTANCE_PROP_OCM_PROXY_HOST) == null && this.getTargetProperty(INSTANCE_PROP_OCM_PROXY_ORACLE_HOME) == null) {
            this.addOnHostAttribute(string);
            TargetProperty targetProperty = new TargetProperty(INSTANCE_PROP_OCM_PROXY_ORACLE_HOME, string2);
            this.addPropertyWorker(targetProperty);
            String string3 = System.getProperties().getProperty("ORACLE_CONFIG_HOME");
            if (string3 != null && string3.length() > 0) {
                TargetProperty targetProperty2 = new TargetProperty(INSTANCE_PROP_OCM_PROXY_ORACLE_HOME, string3);
                this.addPropertyWorker(targetProperty2);
            }
        }
        this.m_isCollectedByAnonymousCentralCollector = targetHomeManager.isCollectingThisHomeAsAnonymousCollector(string2);
    }

    private void addPropertyWorker(TargetProperty targetProperty) throws SAXException {
        if (this.m_isProxyTarget && targetProperty.getName().equals(INSTANCE_PROP_OCM_PROXY_HOST)) {
            if (this.m_log.isEnabledFor(Logger.WARN)) {
                this.m_log.warn(TargetsMsgID.PROXY_HOST_PROP_IGNORED, (Object[])new String[]{this.m_strTargetName});
            }
            return;
        }
        this.m_hashProperties.put(targetProperty.getName(), targetProperty);
        this.setCollectionTimestamp(targetProperty.getName(), targetProperty.getValue());
        if (this.m_isProxyTarget && targetProperty.getName().equals(INSTANCE_PROP_OCM_PROXY_ORACLE_HOME)) {
            this.m_oracleHome = targetProperty.getValue();
            if (null == this.m_configHome) {
                this.m_useCfgHomeForGUID = false;
            }
        }
        if (this.m_isProxyTarget && targetProperty.getName().equals(INSTANCE_PROP_OCM_PROXY_CONFIG_HOME)) {
            this.m_configHome = targetProperty.getValue();
            this.m_useCfgHomeForGUID = true;
        }
    }

    public void addTargetAssoc(Attributes attributes) throws SAXException {
        TargetAssocTargetInstance targetAssocTargetInstance = new TargetAssocTargetInstance(attributes);
        this.m_hashTargetAssocs.put(targetAssocTargetInstance.getAssocId(), targetAssocTargetInstance);
    }

    public void storeAssocsByTargetKeys() {
        if (this.m_hashTargetAssocs.isEmpty()) {
            return;
        }
        HashMap<String, Vector> hashMap = new HashMap<String, Vector>();
        Iterator iterator = this.m_hashTargetAssocs.keySet().iterator();
        while (iterator.hasNext()) {
            TargetAssocTargetInstance targetAssocTargetInstance = (TargetAssocTargetInstance)this.m_hashTargetAssocs.get(iterator.next());
            Vector vector = Target.getTargetKey(this.getTargetHost(), this.getTargetHome(), targetAssocTargetInstance.getTargetType(), targetAssocTargetInstance.getTargetName());
            hashMap.put(targetAssocTargetInstance.getAssocId(), vector);
            if (!this.m_log.isEnabledFor(Logger.DEBUG)) continue;
            this.m_log.debug((Object)("Association \"" + targetAssocTargetInstance.getAssocId() + "\" stored for target (" + this.getTargetName() + ", " + this.getTargetType() + "). Association = " + this.getTargetKey().toString() + " --> " + vector));
        }
        this.m_hashTargetAssocs = hashMap;
    }

    public boolean assocsDisjointWith(Set set) {
        Collection collection = this.m_hashTargetAssocs.values();
        HashSet hashSet = new HashSet(collection);
        hashSet.retainAll(set);
        return hashSet.isEmpty();
    }

    public boolean hasTargetAssocs() {
        return !this.m_hashTargetAssocs.isEmpty();
    }

    public Vector getAssocTarget(String string) {
        return (Vector)this.m_hashTargetAssocs.get(string);
    }

    private void setCollectionTimestamp(String string, String string2) {
        if (string.equals(CCR_COLLECTION_TIMESTAMP_OVERRIDE)) {
            this.m_dateCollection = XMLUploadWriter.parseCollectionDate(string2);
            if (this.m_dateCollection == null && this.m_log.isEnabledFor(Logger.WARN)) {
                this.m_log.warn(TargetsMsgID.INVALID_COLLECTION_TS_OVERRIDE, (Object[])new String[]{this.m_strTargetName, this.m_strTargetType, string2});
            }
        }
    }

    public Date getCollectionTimestamp() {
        return this.m_dateCollection;
    }

    public final String getUniqueId() {
        return this.m_strUniqueId;
    }

    public final String getTargetName() {
        return this.m_strTargetName;
    }

    public final String getTargetType() {
        return this.m_strTargetType;
    }

    public String getDisplayName() {
        return this.m_strDisplayName;
    }

    public final String getTargetHost() {
        return this.m_hostName;
    }

    public final String getTargetHome() {
        return this.m_oracleHome;
    }

    public final String getConfigHome() {
        return this.m_configHome;
    }

    public final String getFullPath() {
        return this.m_fullPath;
    }

    public boolean isProxyTarget() {
        return this.m_isProxyTarget;
    }

    public Vector getTargetKey() {
        return Target.getTargetKey(this.getTargetHost(), this.getTargetHome(), this.getTargetType(), this.getTargetName());
    }

    public static Vector getTargetKey(String string, String string2, String string3, String string4) {
        Vector<String> vector = new Vector<String>(4);
        vector.addElement(string);
        vector.addElement(string2);
        vector.addElement(string3);
        vector.addElement(string4);
        return vector;
    }

    public static String getTargetType(Vector vector) {
        return (String)vector.get(2);
    }

    public HashMap getTargetAllProperties() {
        return this.m_hashProperties;
    }

    public String getTargetProperty(String string) {
        TargetProperty targetProperty = (TargetProperty)this.m_hashProperties.get(string);
        if (targetProperty == null) {
            String string2 = (String)this.m_env.get(string);
            if (string2 == null && this.m_log.isEnabledFor(Logger.DEBUG)) {
                this.m_log.debug((Object)("Instance Property (" + string + ") not found for target (" + this.getTargetName() + "," + this.getTargetType() + ")"));
            }
            return string2;
        }
        return targetProperty.getValue();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Target (name,value) = ");
        stringBuffer.append(this.m_strTargetName);
        stringBuffer.append(", ");
        stringBuffer.append(this.m_strTargetType);
        stringBuffer.append("\n");
        Set set = this.m_hashProperties.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append("\t\t");
            TargetProperty targetProperty = (TargetProperty)this.m_hashProperties.get(string);
            stringBuffer.append("Name = ");
            stringBuffer.append(targetProperty.getName());
            stringBuffer.append(", Value = ");
            stringBuffer.append(targetProperty.getValue());
            stringBuffer.append(", Encrypted = ");
            stringBuffer.append(targetProperty.isEncrypted());
            stringBuffer.append(", isDynamic = ");
            stringBuffer.append(targetProperty.isDynamic());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String getGUID() {
        if (this.m_strGUID != null) {
            return this.m_strGUID;
        }
        throw new RuntimeException("Target is not fully instatiated!");
    }

    private void setTimeZone() {
        Timezone timezone = Timezone.getInstance();
        this.m_strTimeZone = timezone.getSupportedRegion();
    }

    public String getTimeZone() {
        return this.m_strTimeZone;
    }

    public boolean isDisabled() {
        return this.m_bDisabled;
    }

    public void disable(boolean bl) {
        this.m_bDisabled = bl;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Target ");
        stringBuffer.append(this.getAttributesStr());
        stringBuffer.append(">");
        stringBuffer.append(XMLOps.getEndTag((String)TARGET));
        stringBuffer.append(System.getProperty("line.separator"));
        return stringBuffer.toString();
    }

    private String getAttributesStr() {
        Boolean bl = new Boolean(this.m_bOnHost);
        Boolean bl2 = new Boolean(this.m_bDisabled);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(XMLOps.makeNVPair((String)ATTR_NAME, (String)this.m_strTargetName));
        stringBuffer.append(XMLOps.makeNVPair((String)ATTR_TYPE, (String)this.m_strTargetType));
        if (this.m_isProxyTarget) {
            stringBuffer.append(XMLOps.makeNVPair((String)ATTR_ON_HOST, (String)this.m_hostName));
        }
        stringBuffer.append(XMLOps.makeNVPair((String)ATTR_DISABLED, (String)bl2.toString()));
        return stringBuffer.toString().trim();
    }

    private String getPropertyElmtsStr() {
        Set set = this.m_hashProperties.keySet();
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equals(GUID_PROP)) continue;
            TargetProperty targetProperty = (TargetProperty)this.m_hashProperties.get(string);
            stringBuffer.append(targetProperty.toXML().toString());
        }
        return stringBuffer.toString();
    }

    public boolean equals(Target target) {
        boolean bl = false;
        if (target == null) {
            return bl;
        }
        if (target == this) {
            bl = true;
        } else if (this.m_strTargetName.equals(target.m_strTargetName) && this.m_strTargetType.equals(target.m_strTargetType) && this.m_strDisplayName.equals(target.m_strDisplayName) && this.m_strOnHost.equals(target.m_strOnHost) && this.m_strTimeZone.equals(target.m_strTimeZone) && this.m_strVersion.equals(target.m_strVersion) && this.m_bDisabled == target.m_bDisabled && this.m_bOnHost == target.m_bOnHost) {
            Object object;
            Object object2;
            Object object3;
            Set set = this.m_hashProperties.keySet();
            Set set2 = target.m_hashProperties.keySet();
            Iterator iterator = set.iterator();
            bl = true;
            if (set.size() != set2.size()) {
                bl = false;
            }
            while (iterator.hasNext() && bl) {
                object3 = (String)iterator.next();
                object2 = (TargetProperty)this.m_hashProperties.get(object3);
                object = (TargetProperty)target.m_hashProperties.get(object3);
                bl = ((TargetProperty)object2).equals((TargetProperty)object);
            }
            if (bl) {
                object3 = this.m_env.keySet();
                object2 = target.m_env.keySet();
                object = object3.iterator();
                if (object3.size() != object2.size()) {
                    bl = false;
                }
                while (object.hasNext() && bl) {
                    String string = (String)object.next();
                    String string2 = (String)this.m_env.get(string);
                    String string3 = (String)target.m_env.get(string);
                    bl = string2.equals(string3);
                }
            }
        }
        return bl;
    }

    public void evaluateDynProps(Vector vector) throws SAXException {
        for (int i = 0; i < vector.size(); ++i) {
            DynamicProperties dynamicProperties = (DynamicProperties)vector.get(i);
            dynamicProperties.evaluate(this);
        }
    }

    public boolean isRemote() {
        return this.m_strOnHost != null && this.m_strOnHost.length() > 0;
    }

    public boolean isCollectedByAnonymousCentralCollector() {
        return this.m_isCollectedByAnonymousCentralCollector;
    }

    public boolean isMultiplexed() {
        return Boolean.valueOf(this.getTargetProperty(INSTANCE_PROP_MULTIPLEXED));
    }

    public void saveTargetHomeSpecificEnvVars(HashMap hashMap) {
        this.m_targetHomeSpecificEnvVars = hashMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

