/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.targets;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.TargetHome;
import oracle.sysman.ccr.collector.TargetHomeManager;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.cmd.DiscoveryCommandException;
import oracle.sysman.ccr.collector.targets.CustomTarget;
import oracle.sysman.ccr.collector.targets.CustomTargetsXMLParser;
import oracle.sysman.ccr.collector.targets.DiscoveryEngine;
import oracle.sysman.ccr.collector.targets.Target;
import oracle.sysman.ccr.collector.targets.TargetTypeUndefinedException;
import oracle.sysman.ccr.collector.targets.TargetsMsgID;
import oracle.sysman.ccr.collector.targets.TargetsXMLParser;
import oracle.sysman.ccr.collector.targets.metadata.TargetMetadata;
import oracle.sysman.ccr.collector.targets.metadata.TargetMetadataManager;
import oracle.sysman.ccr.collector.util.AgentConfig;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.CCRException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.dsf.DsfInitializationException;
import oracle.sysman.ccr.dsf.OCMCollector;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;
import oracle.sysman.ccr.util.Utils;
import oracle.sysman.ccr.util.XMLOps;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TargetManager {
    public static final String DISABLE_COL_NAMESPACE = "ccr.metric";
    public static final String DISABLE_COL_DELIM = ".";
    private static String[] m_disableSupportedColumns = new String[]{"ccr.metric.host.ecm_hw_nic.inet_address", "ccr.metric.host.ecm_hw_nic.mac_address", "ccr.metric.host.ecm_hw_nic.broadcast_address"};
    private static String[] m_maskSupportedColumns = new String[]{"ccr.metric.oracle_database.db_users.", "username"};
    public static HashMap m_disabledColumns = null;
    public static HashMap m_maskedColumns = null;
    private static Logger s_log = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$targets$TargetManager == null ? (class$oracle$sysman$ccr$collector$targets$TargetManager = TargetManager.class$("oracle.sysman.ccr.collector.targets.TargetManager")) : class$oracle$sysman$ccr$collector$targets$TargetManager));
    private static MessageBundle s_msgBundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.targets.Targets");
    private static TargetManager m_instance = null;
    private static HashMap m_hashTargets = null;
    private static HashMap m_hashTargetMetadata = null;
    private static HashSet m_targetsWithAssocs = null;
    private static final String TARGETS_XML = "targets.xml";
    private static final String TEMP_TARGETS_XML = "tempTargets.xml";
    public static final String TARGETS = "Targets";
    private TargetHomeManager m_targetHomeManager;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$targets$TargetManager;

    private TargetManager() {
        String string;
        int n;
        Config config = UplinkHomeConfig.getInstance();
        for (n = 0; n < m_disableSupportedColumns.length; ++n) {
            string = m_disableSupportedColumns[n];
            boolean bl = config.getProperty(string, true);
            if (bl) continue;
            m_disabledColumns.put(string, null);
        }
        for (n = 0; n < m_maskSupportedColumns.length; n += 2) {
            string = m_maskSupportedColumns[n] + m_maskSupportedColumns[n + 1];
            String string2 = config.getProperty(string, "true");
            if ((string2 = string2.toLowerCase()).equals("mask")) {
                this.addToHash(m_maskedColumns, m_maskSupportedColumns[n], m_maskSupportedColumns[n + 1]);
                if (s_log.isEnabledFor(Logger.DEBUG)) {
                    s_log.debug((Object)("Identified column to mask by TargetManager : " + string));
                }
                if (!m_maskSupportedColumns[n].equals("ccr.metric.oracle_database.db_users.")) continue;
                this.addToHash(m_maskedColumns, "ccr.metric.rac_database.db_users.", m_maskSupportedColumns[n + 1]);
                continue;
            }
            if (string2.equals("false")) {
                if (m_disabledColumns.containsKey(string)) continue;
                s_log.warn(TargetsMsgID.UNSUPPORTED_METRIC_PROP_VALUE, (Object[])new String[]{string, string2});
                continue;
            }
            if (string2.equals("true")) continue;
            s_log.warn(TargetsMsgID.INVALID_METRIC_PROP_VALUE, (Object[])new String[]{string + "=" + string2});
        }
    }

    private void addToHash(HashMap hashMap, String string, String string2) {
        Vector vector = hashMap.containsKey(string) ? (Vector)hashMap.get(string) : new Vector();
        vector.add(string2);
        hashMap.put(string, vector);
    }

    public static TargetManager getInstance() {
        return m_instance;
    }

    public void processTargets() throws CommandException {
        String string = FileSpec.catfile((String[])new String[]{AgentConfig.getRootStateDir(), UplinkPath.HOST_DEFAULT_CONFIG_PATH, TARGETS_XML});
        File file = new File(string);
        boolean bl = false;
        try {
            if (this.m_targetHomeManager == null) {
                this.m_targetHomeManager = TargetHomeManager.createTargetHomeManager();
                this.m_targetHomeManager.populateTargetHomes(true);
            }
            bl = this.m_targetHomeManager.isDesignatedCollector();
        }
        catch (DsfInitializationException dsfInitializationException) {
            throw new DiscoveryCommandException("Central collector could not determine all target homes", (Throwable)dsfInitializationException);
        }
        catch (IOException iOException) {
            throw new DiscoveryCommandException("Central collector could not determine all target Homes", (Throwable)iOException);
        }
        catch (CCRException cCRException) {
            throw new DiscoveryCommandException("Central collector could not determine all target Homes", (Throwable)cCRException);
        }
        if (bl) {
            this.m_targetHomeManager.prepareForCollection();
        }
        TargetsXMLParser targetsXMLParser = new TargetsXMLParser();
        if (file.isFile() && file.length() != 0L) {
            this.readTargets(string, targetsXMLParser);
        }
        this.processCustomTargets();
    }

    private void processCustomTargets() throws CommandException {
        CustomTargetsXMLParser customTargetsXMLParser = new CustomTargetsXMLParser();
        String string = FileSpec.catfile((String[])new String[]{AgentConfig.getRootStateDir(), UplinkPath.HOST_CONFIG_PATH, TARGETS_XML});
        File file = new File(string);
        if (file.isFile() && file.length() != 0L) {
            this.readTargets(string, customTargetsXMLParser);
        }
    }

    private void processAgentTargets() throws CommandException {
        block3: {
            TargetsXMLParser targetsXMLParser = new TargetsXMLParser();
            String string = FileSpec.catfile((String[])new String[]{AgentConfig.getRootStateDir(), UplinkPath.AGENT_EMD_PATH, TARGETS_XML});
            File file = new File(string);
            if (file.isFile() && file.length() != 0L) {
                try {
                    this.readTargets(string, targetsXMLParser);
                }
                catch (CommandException commandException) {
                    if (!s_log.isEnabledFor(Logger.DEBUG)) break block3;
                    s_log.debug((Object)"Error in parsing agent targets.xml.");
                    s_log.error((Throwable)((Object)commandException));
                }
            }
        }
    }

    private void readTargets(String string, TargetsXMLParser targetsXMLParser) throws CommandException {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("oracle.xml.parser.v2.SAXParser");
            xMLReader.setContentHandler(targetsXMLParser);
            InputSource inputSource = new InputSource(fileInputStream);
            xMLReader.parse(inputSource);
            fileInputStream.close();
        }
        catch (SAXException sAXException) {
            throw new CommandException("Error parsing targets.xml", (Throwable)sAXException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Unable to access ");
            stringBuffer.append(string);
            throw new CommandException(stringBuffer.toString(), (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new CommandException("Error reading targets.xml", (Throwable)iOException);
        }
    }

    void addTarget(Target target) {
        Target target2;
        if (target == null) {
            return;
        }
        HashMap<Vector, Target> hashMap = (HashMap<Vector, Target>)m_hashTargets.get(target.getTargetType());
        if (hashMap == null) {
            hashMap = new HashMap<Vector, Target>();
            m_hashTargets.put(target.getTargetType(), hashMap);
        }
        if ((target2 = (Target)hashMap.get(target.getTargetKey())) == null || !target2.isProxyTarget() && target.isProxyTarget()) {
            hashMap.put(target.getTargetKey(), target);
            if (target2 != null && s_log.isEnabledFor(Logger.DEBUG)) {
                s_log.debug((Object)"Target discovered as both local and proxy. Choosing proxy over local target.");
            }
        } else if (s_log.isEnabledFor(Logger.DEBUG)) {
            s_log.debug((Object)("Ignoring target " + target.getTargetName() + " of type " + target.getTargetType() + " because it has already been discovered"));
        }
    }

    public void processTargetMetadata() throws CommandException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        Set set = m_hashTargets.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            try {
                if (s_log.isEnabledFor(Logger.DEBUG)) {
                    s_log.debug((Object)("Getting the targetMetadata for " + string));
                }
                if (this.addTargetMetadata(string)) continue;
                arrayList.add(string);
            }
            catch (TargetTypeUndefinedException targetTypeUndefinedException) {
                Object object = targetTypeUndefinedException;
                while (object != null) {
                    s_log.error((Throwable)object);
                    if (object instanceof CCRException) {
                        CCRException cCRException = object;
                        object = cCRException.getCause();
                        continue;
                    }
                    object = null;
                }
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            string = (String)arrayList.get(i);
            m_hashTargets.remove(string);
        }
        this.evaluateDynPropsWithAssocs();
    }

    private boolean addTargetMetadata(String string) throws CommandException, TargetTypeUndefinedException {
        TargetMetadata targetMetadata = null;
        try {
            if (!m_hashTargetMetadata.containsKey(string)) {
                targetMetadata = new TargetMetadata(string);
                m_hashTargetMetadata.put(string, targetMetadata);
            } else {
                targetMetadata = (TargetMetadata)m_hashTargetMetadata.get(string);
            }
        }
        catch (SAXException sAXException) {
            s_log.error(TargetsMsgID.ERR_METADATA_PARSE, (Object[])new String[]{string}, (Throwable)sAXException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new TargetTypeUndefinedException(string + " is not a supportable type", fileNotFoundException);
        }
        if (targetMetadata != null) {
            this.evaluateTargetProperties(string, targetMetadata);
            return true;
        }
        return false;
    }

    private void evaluateTargetProperties(String string, TargetMetadata targetMetadata) {
        HashMap hashMap = (HashMap)m_hashTargets.get(string);
        Set set = hashMap.keySet();
        Target target = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                Vector vector = (Vector)iterator.next();
                target = (Target)hashMap.get(vector);
                target.generateTargetGUIDProperty();
                if (target.hasTargetAssocs()) {
                    m_targetsWithAssocs.add(target.getTargetKey());
                    continue;
                }
                if (s_log.isEnabledFor(Logger.DEBUG)) {
                    s_log.debug((Object)("Associations absent: Evaluating dynamic properties for target (" + target.getTargetName() + ", " + target.getTargetType() + ")."));
                }
                target.evaluateDynProps(targetMetadata.getDynProps());
            }
            catch (SAXException sAXException) {
                String string2 = "";
                if (target != null) {
                    string2 = target.getTargetName();
                }
                s_log.error(TargetsMsgID.ERR_EVAL_TARGET_PROPS, (Object[])new String[]{string2, string}, (Throwable)sAXException);
            }
        }
    }

    private void evaluateDynPropsWithAssocs() throws CommandException {
        Object object;
        Object object2;
        Object object3;
        int n;
        HashSet hashSet = (HashSet)m_targetsWithAssocs.clone();
        Vector<Object> vector = new Vector<Object>();
        while (!hashSet.isEmpty()) {
            n = 0;
            object3 = hashSet.iterator();
            while (object3.hasNext()) {
                object2 = (Vector)object3.next();
                object = this.getTargetFromKey((Vector)object2);
                if (!((Target)object).assocsDisjointWith(hashSet)) continue;
                vector.add(object2);
                object3.remove();
                ++n;
            }
            if (n != 0) continue;
            throw new CommandException("Cyclic or invalid target associations detected.");
        }
        for (n = 0; n < vector.size(); ++n) {
            object3 = (Vector)vector.get(n);
            object2 = Target.getTargetType((Vector)object3);
            object = this.getTargetMetadata((String)object2);
            Target target = this.getTargetFromKey((Vector)object3);
            try {
                if (s_log.isEnabledFor(Logger.DEBUG)) {
                    s_log.debug((Object)("Associations present: Evaluating dynamic properties for target (" + target.getTargetName() + ", " + target.getTargetType() + ")."));
                }
                target.evaluateDynProps(((TargetMetadata)object).getDynProps());
                continue;
            }
            catch (SAXException sAXException) {
                String string = "";
                if (target != null) {
                    string = target.getTargetName();
                }
                s_log.error(TargetsMsgID.ERR_EVAL_TARGET_PROPS, (Object[])new String[]{string, object2}, (Throwable)sAXException);
            }
        }
    }

    private Target getTargetFromKey(Vector vector) {
        String string = Target.getTargetType(vector);
        return (Target)((HashMap)m_hashTargets.get(string)).get(vector);
    }

    public Target getAssocTarget(String string, String string2, String string3) {
        Vector vector;
        Target target = null;
        Target target2 = this.getTargetByNameType(string2, string);
        if (target2 != null && (vector = target2.getAssocTarget(string3)) != null) {
            target = this.getTargetFromKey(vector);
        }
        return target;
    }

    public void clearTemporaryCollectionState() {
        String[] stringArray;
        String string;
        block5: {
            string = FileSpec.catfile((String[])new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_TEMP_PATH});
            File file = new File(string);
            stringArray = null;
            try {
                stringArray = file.list();
            }
            catch (SecurityException securityException) {
                if (!s_log.isEnabledFor(Logger.ERROR)) break block5;
                s_log.error(TargetsMsgID.ERR_LISTING_TEMP_DIR, (Object[])new String[]{string}, (Throwable)securityException);
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = FileSpec.catfile((String[])new String[]{string, stringArray[i]});
            File file = new File(string2);
            try {
                file.delete();
                continue;
            }
            catch (SecurityException securityException) {
                if (!s_log.isEnabledFor(Logger.ERROR)) continue;
                s_log.error(TargetsMsgID.ERR_DEL_TEMP_DIR, (Object[])new String[]{string2}, (Throwable)securityException);
                String string3 = s_msgBundle.getMessage(TargetsMsgID.ERR_DEL_TEMP_DIR, false, (Object[])new String[]{string2});
                throw new RuntimeException(string3);
            }
        }
    }

    public String getTargetTypeDisplayName(String string) {
        String string2 = "";
        TargetMetadata targetMetadata = (TargetMetadata)m_hashTargetMetadata.get(string);
        if (targetMetadata != null) {
            string2 = targetMetadata.getTypeDisplayString();
        }
        return string2;
    }

    public TargetMetadata getTargetMetadata(String string) {
        TargetMetadata targetMetadata = null;
        targetMetadata = UplinkPath.isGCMode() ? TargetMetadataManager.getTargetMetadata(string) : (TargetMetadata)m_hashTargetMetadata.get(string);
        return targetMetadata;
    }

    public String[] getTargetTypes() {
        Set set = m_hashTargets.keySet();
        String[] stringArray = new String[set.size()];
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            stringArray[n] = (String)iterator.next();
            ++n;
        }
        return stringArray;
    }

    public Target[] getTargetInstances(String string) {
        Target[] targetArray = new Target[]{};
        HashMap hashMap = (HashMap)m_hashTargets.get(string);
        if (hashMap != null) {
            Collection collection = hashMap.values();
            targetArray = new Target[collection.size()];
            int n = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                targetArray[n] = (Target)iterator.next();
                ++n;
            }
        }
        return targetArray;
    }

    public void discover() throws DiscoveryCommandException {
        DiscoveryEngine discoveryEngine = DiscoveryEngine.getInstance();
        File file = new File(FileSpec.catfile((String[])new String[]{AgentConfig.getRootStateDir(), UplinkPath.HOST_DEFAULT_CONFIG_PATH, TARGETS_XML}));
        try {
            this.m_targetHomeManager = TargetHomeManager.createTargetHomeManager();
            this.m_targetHomeManager.populateTargetHomes(true);
            BufferedWriter bufferedWriter = new BufferedWriter(new PrintWriter(new FileOutputStream(file)));
            bufferedWriter.write("<TargetHomes>\n");
            this.discoverCurrentTargetHome(Collector.getOracleHome(), discoveryEngine, bufferedWriter);
            if (this.m_targetHomeManager.isDesignatedCollector()) {
                this.discoverOtherTargetHomes(discoveryEngine, bufferedWriter);
            }
            bufferedWriter.write("</TargetHomes>\n");
            bufferedWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DiscoveryCommandException("Unable to create list of discovered targets", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new DiscoveryCommandException("Unable to write the targets.xml file", (Throwable)iOException);
        }
        catch (DsfInitializationException dsfInitializationException) {
            throw new DiscoveryCommandException("Unable to discover targets", (Throwable)dsfInitializationException);
        }
        catch (CCRException cCRException) {
            throw new DiscoveryCommandException("Unable to discover targets", (Throwable)cCRException);
        }
    }

    public Vector getTargets(boolean bl) {
        Vector<Target> vector = new Vector<Target>();
        boolean bl2 = false;
        Set set = m_hashTargets.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Target[] targetArray = this.getTargetInstances((String)iterator.next());
            for (int i = 0; i < targetArray.length; ++i) {
                boolean bl3 = bl2 = !targetArray[i].isDisabled();
                if (bl && bl2) {
                    vector.add(targetArray[i]);
                }
                if (bl || bl2) continue;
                vector.add(targetArray[i]);
            }
        }
        return vector;
    }

    public HashMap getAllCustomTargets() {
        HashMap hashMap = new HashMap();
        String[] stringArray = this.getTargetTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            HashMap hashMap2 = (HashMap)m_hashTargets.get(stringArray[i]);
            if (hashMap2 == null) continue;
            Set set = hashMap2.keySet();
            HashMap<Vector, Target> hashMap3 = new HashMap<Vector, Target>();
            boolean bl = true;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Vector vector = (Vector)iterator.next();
                Target target = (Target)hashMap2.get(vector);
                if (!target.isDisabled()) continue;
                hashMap3.put(vector, target);
                bl = false;
            }
            if (bl) continue;
            hashMap.put(stringArray[i], hashMap3);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCustomTargets(HashMap hashMap) throws IOException {
        String string = FileSpec.catfile((String[])new String[]{AgentConfig.getRootStateDir(), UplinkPath.HOST_CONFIG_PATH, TEMP_TARGETS_XML});
        String string2 = FileSpec.catfile((String[])new String[]{AgentConfig.getRootStateDir(), UplinkPath.HOST_CONFIG_PATH, TARGETS_XML});
        FileWriter fileWriter = null;
        File file = new File(string);
        BufferedWriter bufferedWriter = null;
        PrintWriter printWriter = null;
        try {
            fileWriter = new FileWriter(string);
            bufferedWriter = new BufferedWriter(fileWriter);
            printWriter = new PrintWriter(bufferedWriter);
            this.writeTargetsToStream(printWriter, hashMap);
        }
        finally {
            printWriter.close();
            bufferedWriter.close();
            fileWriter.close();
        }
        try {
            File file2 = new File(string2);
            file2.delete();
            if (!file.renameTo(file2)) {
                Utils.copyFile((File)file, (File)file2);
                file.delete();
            }
        }
        catch (IOException iOException) {
            file.delete();
            s_log.error((Throwable)iOException);
            throw iOException;
        }
    }

    private void discoverCurrentTargetHome(String string, DiscoveryEngine discoveryEngine, BufferedWriter bufferedWriter) throws CCRException {
        this.writeOneTargetHomeToDiscoveryFile(string, Collector.getCCRConfigHome(), discoveryEngine, bufferedWriter, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverOtherTargetHomes(final DiscoveryEngine discoveryEngine, final BufferedWriter bufferedWriter) throws CCRException {
        PrintStream printStream = System.err;
        try {
            if (this.m_targetHomeManager.isAnonymousCollector() && System.getProperty(TargetHomeManager.ccrtest_do_not_silence_anonymous_central_collector) == null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                System.setErr(new PrintStream(byteArrayOutputStream));
            }
            this.m_targetHomeManager.processOtherTargetHomesToBeDiscovered(new TargetHomeManager.ITargetHomeCollectionVisitor(){

                public void processTargetHomeDiscovery(TargetHome targetHome, OCMCollector oCMCollector) throws CCRException {
                    String string = targetHome.getLocation();
                    if (oCMCollector != null && oCMCollector.getConfigHome() != null) {
                        string = oCMCollector.getConfigHome();
                    }
                    TargetManager.this.writeOneTargetHomeToDiscoveryFile(targetHome.getLocation(), string, discoveryEngine, bufferedWriter, false, TargetManager.this.m_targetHomeManager.isAnonymousCollector());
                }
            }, false);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (this.m_targetHomeManager.isAnonymousCollector() && System.getProperty(TargetHomeManager.ccrtest_do_not_silence_anonymous_central_collector) == null) {
                System.setErr(printStream);
            }
            throw throwable;
        }
        if (this.m_targetHomeManager.isAnonymousCollector() && System.getProperty(TargetHomeManager.ccrtest_do_not_silence_anonymous_central_collector) == null) {
            System.setErr(printStream);
        }
    }

    private void writeOneTargetHomeToDiscoveryFile(String string, String string2, DiscoveryEngine discoveryEngine, BufferedWriter bufferedWriter, boolean bl, boolean bl2) throws CCRException {
        try {
            bufferedWriter.write("<TargetHome LOCATION=\"" + string + "\"");
            if (string2 != null) {
                bufferedWriter.write(" CCR_CONFIG_HOME=\"" + string2 + "\"");
            }
            bufferedWriter.write(">\n");
            bufferedWriter.write("<Targets>\n");
            if (bl) {
                bufferedWriter.write(discoveryEngine.discover(discoveryEngine.getDiscoveryScripts(DiscoveryEngine.DiscoveryScriptsFilter.PER_HOST), false).toString());
            }
            bufferedWriter.write(discoveryEngine.discover(discoveryEngine.getDiscoveryScripts(DiscoveryEngine.DiscoveryScriptsFilter.PER_HOME), bl2).toString());
            bufferedWriter.write("</Targets>\n");
            bufferedWriter.write("</TargetHome>\n");
        }
        catch (IOException iOException) {
            throw new CCRException("Internal Error", (Throwable)iOException);
        }
        catch (DiscoveryCommandException discoveryCommandException) {
            throw new CCRException("Internal Error", (Throwable)((Object)discoveryCommandException));
        }
    }

    private void writeTargetsToStream(PrintWriter printWriter, HashMap hashMap) {
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        printWriter.println(XMLOps.createXMLDirective((boolean)true));
        HashMap<String, ArrayList<Target>> hashMap2 = new HashMap<String, ArrayList<Target>>();
        Set set = hashMap.keySet();
        Object object5 = set.iterator();
        while (object5.hasNext()) {
            object4 = (String)object5.next();
            object3 = ((HashMap)hashMap.get(object4)).values();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (Target)object2.next();
                if (!((Target)object).isDisabled()) continue;
                serializable = (ArrayList<Target>)hashMap2.get(((Target)object).getTargetHome());
                if (serializable == null) {
                    serializable = new ArrayList<Target>();
                    hashMap2.put(((Target)object).getTargetHome(), (ArrayList<Target>)serializable);
                }
                serializable.add(object);
            }
        }
        printWriter.println(XMLOps.getStartTag((String)"OracleHomes"));
        object5 = hashMap2.keySet();
        object4 = object5.iterator();
        while (object4.hasNext()) {
            object3 = (String)object4.next();
            printWriter.println("<OracleHome LOCATION=\"" + (String)object3 + "\">");
            object2 = (List)hashMap2.get(object3);
            printWriter.println(XMLOps.getStartTag((String)TARGETS));
            object = object2.iterator();
            while (object.hasNext()) {
                serializable = (Target)object.next();
                printWriter.print(((Target)serializable).toXML());
            }
            printWriter.println(XMLOps.getEndTag((String)TARGETS));
            printWriter.println(XMLOps.getEndTag((String)"OracleHome"));
        }
        printWriter.println(XMLOps.getEndTag((String)"OracleHomes"));
    }

    public Target getTargetByNameType(String string, String string2) {
        Target target = null;
        HashMap hashMap = (HashMap)m_hashTargets.get(string2);
        if (hashMap != null) {
            Set set = hashMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                target = (Target)hashMap.get(iterator.next());
                if (!string.equals(target.getTargetName())) continue;
                return target;
            }
        }
        return null;
    }

    public Target getTargetByOracleHomeNameType(String string, String string2, String string3) {
        Target target = null;
        HashMap hashMap = (HashMap)m_hashTargets.get(string3);
        if (hashMap != null) {
            Set set = hashMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                target = (Target)hashMap.get(iterator.next());
                if (!string2.equals(target.getTargetName()) || !target.getTargetHome().equals(string)) continue;
                return target;
            }
        }
        return null;
    }

    public Target getTarget(Vector vector, String string) {
        Target target = null;
        HashMap hashMap = (HashMap)m_hashTargets.get(string);
        if (hashMap != null) {
            target = (Target)hashMap.get(vector);
        }
        return target;
    }

    public boolean overrideTarget(CustomTarget customTarget) {
        boolean bl = false;
        Target target = this.getTarget(customTarget.getTargetKey(), customTarget.getTargetType());
        if (target != null) {
            target.disable(customTarget.isDisabled());
            bl = true;
        }
        return bl;
    }

    public TargetHomeManager getTargetHomeManager() {
        return this.m_targetHomeManager;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        m_disabledColumns = new HashMap();
        m_maskedColumns = new HashMap();
        m_hashTargets = new HashMap();
        m_hashTargetMetadata = new HashMap();
        m_instance = new TargetManager();
        m_targetsWithAssocs = new HashSet();
    }
}

