/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.targets;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import oracle.sysman.ccr.util.Utils;
import oracle.sysman.ccr.util.XMLOps;
import oracle.sysman.ccr.util.crypt.Crypt;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TargetProperty {
    private String m_strName = null;
    private String m_strValue = "";
    private boolean m_bDynamic = false;
    private static HashMap m_hashEncryptValueMap = null;
    public static final int ENCRYPT_FALSE = 0;
    public static final int ENCRYPT_TRUE = 1;
    public static final int ENCRYPT_NOT_APPLICABLE = 2;
    private int m_nEncrypted = 2;
    private static final String ATTR_VALUE = "VALUE";
    private static final String ATTR_NAME = "NAME";
    private static final String ATTR_ENCRYPTED = "ENCRYPTED";
    private static final String ATTR_IS_DYNAMIC = "IS_DYNAMIC";
    private static final String ENCRYPT_TRUE_STR = "TRUE";
    private static final String ENCRYPT_FALSE_STR = "FALSE";
    private static final String ENCRYPT_NA_STR = "NA";
    public static final String PROPERTY = "Property";
    private static boolean gridAgentMode = false;
    private static String m_encryptionKey = null;

    public TargetProperty(TargetProperty targetProperty) {
        this.m_strName = targetProperty.m_strName;
        this.m_strValue = targetProperty.m_strValue;
        this.m_bDynamic = targetProperty.m_bDynamic;
        this.m_nEncrypted = targetProperty.m_nEncrypted;
    }

    public TargetProperty(Attributes attributes) throws SAXException {
        String string = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            string = attributes.getQName(i);
            if (string.equalsIgnoreCase(ATTR_NAME)) {
                this.m_strName = attributes.getValue(i);
                continue;
            }
            if (string.equalsIgnoreCase(ATTR_VALUE)) {
                this.m_strValue = attributes.getValue(i);
                continue;
            }
            if (string.equalsIgnoreCase(ATTR_IS_DYNAMIC)) {
                this.m_bDynamic = attributes.getValue(i).equalsIgnoreCase(ENCRYPT_TRUE_STR);
                continue;
            }
            if (string.equalsIgnoreCase(ATTR_ENCRYPTED)) {
                String string2 = attributes.getValue(i);
                Integer n = (Integer)m_hashEncryptValueMap.get(string2 = string2.toUpperCase());
                if (n != null) {
                    this.m_nEncrypted = n;
                    continue;
                }
                throw new SAXException("Unexpected value to ENCRYPTION property.");
            }
            throw new SAXException("Unknown Target attribute (" + string + ") encountered.");
        }
    }

    public TargetProperty(String string, String string2) {
        this.m_strName = string;
        this.m_strValue = string2;
    }

    public final boolean isDynamic() {
        return this.m_bDynamic;
    }

    public final int isEncrypted() {
        return this.m_nEncrypted;
    }

    public final String getName() {
        return this.m_strName;
    }

    public final String getValue() {
        if (this.m_nEncrypted == 1 && gridAgentMode) {
            return this.decryptValue(this.m_strValue);
        }
        return this.m_strValue;
    }

    public boolean equals(TargetProperty targetProperty) {
        boolean bl = false;
        if (targetProperty != null) {
            if (targetProperty == this) {
                bl = true;
            } else if (this.m_strName != null && this.m_strName.equals(targetProperty.m_strName) && this.m_strValue != null && this.m_strValue.equals(targetProperty.m_strValue) && this.m_bDynamic == targetProperty.m_bDynamic && this.m_nEncrypted == targetProperty.m_nEncrypted) {
                bl = true;
            }
        }
        return bl;
    }

    public StringBuffer toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Property ");
        stringBuffer.append(XMLOps.makeNVPair((String)ATTR_NAME, (String)this.m_strName));
        stringBuffer.append(XMLOps.makeNVPair((String)ATTR_VALUE, (String)this.m_strValue));
        stringBuffer.append(XMLOps.makeNVPair((String)ATTR_IS_DYNAMIC, (String)String.valueOf(this.m_bDynamic)));
        Set set = m_hashEncryptValueMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = (Integer)m_hashEncryptValueMap.get(string);
            if (n != this.m_nEncrypted) continue;
            stringBuffer.append(XMLOps.makeNVPair((String)ATTR_ENCRYPTED, (String)string));
            break;
        }
        stringBuffer.append("/>");
        stringBuffer.append(System.getProperty("line.separator"));
        return stringBuffer;
    }

    private String decryptValue(String string) {
        Crypt crypt = new Crypt();
        byte[] byArray = Utils.asciiStringToByteArray((String)string);
        byte[] byArray2 = crypt.decryptAsByteArray(byArray, m_encryptionKey.getBytes());
        return new String(byArray2).trim();
    }

    static {
        m_hashEncryptValueMap = new HashMap();
        m_hashEncryptValueMap.put(ENCRYPT_FALSE_STR, new Integer(0));
        m_hashEncryptValueMap.put(ENCRYPT_TRUE_STR, new Integer(1));
        m_hashEncryptValueMap.put(ENCRYPT_NA_STR, new Integer(2));
    }
}

