/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.targets;

import java.util.HashMap;
import java.util.Hashtable;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.TargetHome;
import oracle.sysman.ccr.collector.TargetHomeManager;
import oracle.sysman.ccr.collector.targets.Target;
import oracle.sysman.ccr.collector.targets.TargetManager;
import oracle.sysman.ccr.collector.targets.TargetsMsgID;
import oracle.sysman.ccr.collector.util.Hostname;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.CCRException;
import oracle.sysman.ccr.common.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class TargetsXMLParser
extends DefaultHandler {
    private static Logger s_log = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$targets$TargetsXMLParser == null ? (class$oracle$sysman$ccr$collector$targets$TargetsXMLParser = TargetsXMLParser.class$("oracle.sysman.ccr.collector.targets.TargetsXMLParser")) : class$oracle$sysman$ccr$collector$targets$TargetsXMLParser));
    private static MessageBundle s_bundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.targets.Targets");
    private Target m_targetLastFound = null;
    private TargetHome m_targetHomeBeingProcessed;
    private HashMap m_existingEnvVarsForTargetHomeBeingProcessed;
    static final String TARGET = "TARGET";
    static final String PROPERTY = "PROPERTY";
    static final String ASSOC_TARGET_INSTANCE = "AssocTargetInstance";
    private TargetManager mTargetManager;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$targets$TargetsXMLParser;

    TargetsXMLParser() {
    }

    public void endDocument() throws SAXException {
        if (s_log.isEnabledFor(Logger.INFO)) {
            s_log.info(TargetsMsgID.ENDING_PARSE_OF_TARGETS);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("TargetHome")) {
            if (this.mTargetManager.getTargetHomeManager().isDesignatedCollector()) {
                TargetHomeManager.resetemCCRenvSystemProps(this.m_existingEnvVarsForTargetHomeBeingProcessed);
                ((Hashtable)System.getProperties()).remove("CCR_DESIGNATED_COLLECTOR_IS_COLLECTING_OTHER_HOMES");
                ((Hashtable)System.getProperties()).remove("CCR_CENTRAL_PROPERTIES_CCH_FOR_COLLECTOR_IN_OH");
            }
            this.m_targetHomeBeingProcessed = null;
            return;
        }
        if (string3.equalsIgnoreCase(TARGET)) {
            if (this.m_targetLastFound == null) {
                throw new SAXException("End TARGET element encountered without a begin TARGET");
            }
            if (this.m_targetLastFound.isProxyTarget() && this.m_targetLastFound.getTargetProperty("OcmProxyOracleHome") == null) {
                throw new SAXException("Property OcmProxyOracleHome not found for proxy target " + this.m_targetLastFound.getTargetName());
            }
            this.mTargetManager.addTarget(this.m_targetLastFound);
            this.m_targetLastFound.storeAssocsByTargetKeys();
            this.m_targetLastFound = null;
        }
    }

    public void startDocument() throws SAXException {
        if (s_log.isEnabledFor(Logger.INFO)) {
            s_log.info(TargetsMsgID.STARTING_PARSE_OF_TARGETS);
        }
        this.mTargetManager = TargetManager.getInstance();
        if (this.mTargetManager == null) {
            throw new SAXException("TargetManager is not initialized");
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase("TargetHome")) {
            if (this.m_targetHomeBeingProcessed != null) {
                throw new SAXException(s_bundle.getMessage(TargetsMsgID.NESTED_TARGET_HOME_ELEMENT_ERR, false));
            }
            if (this.mTargetManager.getTargetHomeManager().isDesignatedCollector()) {
                String string4 = attributes.getValue("LOCATION");
                String string5 = attributes.getValue("CCR_CONFIG_HOME");
                this.m_targetHomeBeingProcessed = this.mTargetManager.getTargetHomeManager().locationToTargetHome(string4);
                try {
                    this.m_existingEnvVarsForTargetHomeBeingProcessed = this.m_targetHomeBeingProcessed.setemCCRenvSystemProps(string4, string5);
                    if (!string4.equals(Collector.getCCRRoot())) {
                        System.setProperty("CCR_DESIGNATED_COLLECTOR_IS_COLLECTING_OTHER_HOMES", "true");
                        System.setProperty("CCR_CENTRAL_PROPERTIES_CCH_FOR_COLLECTOR_IN_OH", string5);
                    }
                }
                catch (CCRException cCRException) {
                    throw new SAXException(s_bundle.getMessage(TargetsMsgID.TARGET_HOME_ELEMENT_PROCESSING_ERR, false), (Exception)((Object)cCRException));
                }
            }
            return;
        }
        if (string3.equalsIgnoreCase(TARGET)) {
            if (this.m_targetLastFound != null) {
                throw new SAXException(s_bundle.getMessage(TargetsMsgID.NESTED_TARGET_ELEMENT_ERR, false));
            }
            this.m_targetLastFound = this.createTarget(attributes);
            return;
        }
        if (string3.equalsIgnoreCase(PROPERTY)) {
            if (this.m_targetLastFound == null) {
                throw new SAXException("PROPERTY element encountered outside of target");
            }
            this.m_targetLastFound.addProperty(attributes);
            return;
        }
        if (string3.equalsIgnoreCase(ASSOC_TARGET_INSTANCE)) {
            if (this.m_targetLastFound == null) {
                throw new SAXException("AssocTargetInstance element encountered outside of target");
            }
            this.m_targetLastFound.addTargetAssoc(attributes);
        }
    }

    private Target createTarget(Attributes attributes) throws SAXException {
        String string;
        Target target = new Target(attributes);
        if (this.mTargetManager.getTargetHomeManager().isDesignatedCollector() && !(string = this.m_targetHomeBeingProcessed.getLocation()).equals(Collector.getCCRRoot())) {
            String string2 = System.getProperty("oracle.sysman.ccr.hostname");
            if (string2 == null) {
                string2 = Hostname.getHostname();
            }
            target.markAsBeingCollectedByDesignatedCollector(this.mTargetManager.getTargetHomeManager(), string2, string);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            TargetHomeManager.getemCCRenvSystemProps(hashMap);
            hashMap.put("CCR_DESIGNATED_COLLECTOR_IS_COLLECTING_OTHER_HOMES", System.getProperty("CCR_DESIGNATED_COLLECTOR_IS_COLLECTING_OTHER_HOMES"));
            hashMap.put("CCR_CENTRAL_PROPERTIES_CCH_FOR_COLLECTOR_IN_OH", System.getProperty("CCR_CENTRAL_PROPERTIES_CCH_FOR_COLLECTOR_IN_OH"));
            target.saveTargetHomeSpecificEnvVars(hashMap);
        }
        return target;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

