/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.targets.host;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.ccr.collector.targets.host.HostPlatformMapMsgID;
import oracle.sysman.ccr.collector.targets.host.HostPlatformMappingException;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class HostPlatformMap {
    private static final String HOST_PLATFORM_MAP_RESOURCE = "HostPlatformMap.xml";
    private static HostPlatformMap s_instance = null;
    private static HashMap s_platformVersionIDs = new HashMap();
    private static final Logger s_logger = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$targets$host$HostPlatformMap == null ? (class$oracle$sysman$ccr$collector$targets$host$HostPlatformMap = HostPlatformMap.class$("oracle.sysman.ccr.collector.targets.host.HostPlatformMap")) : class$oracle$sysman$ccr$collector$targets$host$HostPlatformMap));
    private static MessageBundle s_msgBundle = null;
    private static final String ELEMENT_DOCROOT = "HostPlatformMap";
    private static final String ELEMENT_PLATFORM = "Platform";
    private static final String ELEMENT_VERSION = "Version";
    private static final String ATTR_PLATFORM_NAME = "platName";
    private static final String ATTR_PLATFORM_ID = "platId";
    private static final String ATTR_PLATVER_REGEX = "regexp";
    private static final String ATTR_PLATVER_NAME = "verName";
    private static final String ATTR_PLATVER_ID = "platVerId";
    private static final String PLATVER_NODATA = "NoData";
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$targets$host$HostPlatformMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HostPlatformMap getInstance() throws HostPlatformMappingException {
        if (s_instance == null) {
            Class clazz = class$oracle$sysman$ccr$collector$targets$host$HostPlatformMap == null ? (class$oracle$sysman$ccr$collector$targets$host$HostPlatformMap = HostPlatformMap.class$("oracle.sysman.ccr.collector.targets.host.HostPlatformMap")) : class$oracle$sysman$ccr$collector$targets$host$HostPlatformMap;
            synchronized (clazz) {
                if (s_instance == null) {
                    s_instance = new HostPlatformMap();
                }
            }
        }
        return s_instance;
    }

    private HostPlatformMap() throws HostPlatformMappingException {
        try {
            s_msgBundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.targets.host.HostPlatformMap");
            Document document = null;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ErrorHandler(){

                public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)("** Fatal, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId() + "\n   " + sAXParseException.getMessage()));
                    }
                    throw sAXParseException;
                }

                public void error(SAXParseException sAXParseException) throws SAXParseException {
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)("** Error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId() + "\n   " + sAXParseException.getMessage()));
                    }
                    throw sAXParseException;
                }

                public void warning(SAXParseException sAXParseException) throws SAXParseException {
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId() + "\n   " + sAXParseException.getMessage()));
                    }
                }
            });
            document = documentBuilder.parse(HostPlatformMap.getHostPlatformMapResource(HOST_PLATFORM_MAP_RESOURCE));
            this.populateHashMap(document);
        }
        catch (SAXException sAXException) {
            String string = s_msgBundle.getMessage(HostPlatformMapMsgID.MALFORMED_XML_RESOURCE, false, (Object[])new String[]{HOST_PLATFORM_MAP_RESOURCE});
            throw new HostPlatformMappingException(string);
        }
        catch (IOException iOException) {
            String string = s_msgBundle.getMessage(HostPlatformMapMsgID.UNKNOWN_ERR, false, (Object[])new String[]{HOST_PLATFORM_MAP_RESOURCE});
            throw new HostPlatformMappingException(string, iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = s_msgBundle.getMessage(HostPlatformMapMsgID.XML_PARSE_ERR, false, (Object[])new String[]{HOST_PLATFORM_MAP_RESOURCE});
            throw new HostPlatformMappingException(string);
        }
    }

    public Integer getPlatformVersionID(String string, String string2, String string3, String string4) {
        Integer n = null;
        try {
            n = new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)"Invalid Platform ID, returning -1");
            }
            return new Integer(-1);
        }
        if (!s_platformVersionIDs.containsKey(n)) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)"Invalid Platform ID, returning -1");
            }
            return new Integer(-1);
        }
        String string5 = "-1";
        Vector vector = (Vector)s_platformVersionIDs.get(n);
        for (int i = 0; i < vector.size(); ++i) {
            Element element = (Element)vector.get(i);
            String string6 = null;
            try {
                String string7 = string2 + "@" + string3 + "@" + string4;
                string6 = element.getAttribute(ATTR_PLATVER_REGEX);
                RE rE = new RE(string6);
                if (!rE.match(string7) && !string6.equals(PLATVER_NODATA)) continue;
                string5 = element.getAttribute(ATTR_PLATVER_ID);
                if (!s_logger.isDebugEnabled()) break;
                s_logger.debug((Object)("Platform Version ID matched: " + string5));
                break;
            }
            catch (RESyntaxException rESyntaxException) {
                s_logger.warn(HostPlatformMapMsgID.REGEXP_ERROR, (Object[])new String[]{string6});
                vector.removeElementAt(i);
                --i;
            }
        }
        return new Integer(string5);
    }

    static InputStream getHostPlatformMapResource(String string) throws HostPlatformMappingException {
        Class clazz;
        ClassLoader classLoader;
        InputStream inputStream = null;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Loading the host platform map from the resource: " + string));
        }
        if ((classLoader = (clazz = class$oracle$sysman$ccr$collector$targets$host$HostPlatformMap == null ? (class$oracle$sysman$ccr$collector$targets$host$HostPlatformMap = HostPlatformMap.class$("oracle.sysman.ccr.collector.targets.host.HostPlatformMap")) : class$oracle$sysman$ccr$collector$targets$host$HostPlatformMap).getClassLoader()) == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((inputStream = classLoader.getResourceAsStream(string)) == null) {
            String string2 = s_msgBundle.getMessage(HostPlatformMapMsgID.HOST_PLATFORM_MAP_RESOURCE_NF, false, (Object[])new String[]{HOST_PLATFORM_MAP_RESOURCE});
            throw new HostPlatformMappingException(string2);
        }
        return inputStream;
    }

    private void populateHashMap(Document document) throws HostPlatformMappingException {
        if (document == null) {
            String string = s_msgBundle.getMessage(HostPlatformMapMsgID.MALFORMED_XML_RESOURCE, false, (Object[])new String[]{HOST_PLATFORM_MAP_RESOURCE});
            throw new HostPlatformMappingException(string);
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)"Populating Hash Map from the resource HostPlatformMap.xml");
        }
        Element element = document.getDocumentElement();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Parsing root node: " + element.getNodeName()));
        }
        NodeList nodeList = element.getElementsByTagName(ELEMENT_PLATFORM);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute(ATTR_PLATFORM_ID);
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Adding Platform Node (" + element2.getAttribute(ATTR_PLATFORM_ID) + "): " + element2.getAttribute(ATTR_PLATFORM_NAME)));
            }
            NodeList nodeList2 = element2.getElementsByTagName(ELEMENT_VERSION);
            Vector<Element> vector = new Vector<Element>();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element3 = (Element)nodeList2.item(j);
                vector.addElement(element3);
            }
            s_platformVersionIDs.put(new Integer(string), vector);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("\n---- HostPlatformMap ----\n");
        Iterator iterator = s_platformVersionIDs.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            stringBuffer.append("\nPlatform ID: " + n + "\n");
            Vector vector = (Vector)s_platformVersionIDs.get(n);
            for (int i = 0; i < vector.size(); ++i) {
                Element element = (Element)vector.get(i);
                stringBuffer.append("    regexp=" + element.getAttribute(ATTR_PLATVER_REGEX) + " verName=" + element.getAttribute(ATTR_PLATVER_NAME) + " platVerId=" + element.getAttribute(ATTR_PLATVER_ID) + "\n");
            }
        }
        stringBuffer.append("\n---- HostPlatformMap ----\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        HostPlatformMap hostPlatformMap = null;
        int n = 1;
        try {
            if (stringArray.length < 4) {
                System.err.println("Invalid number of arguments");
                System.exit(n);
            }
            Properties properties = new Properties();
            ((Hashtable)properties).put("log4j.appender.stderr", "org.apache.log4j.ConsoleAppender");
            ((Hashtable)properties).put("log4j.appender.stderr.target", "System.err");
            ((Hashtable)properties).put("log4j.appender.stderr.layout", "org.apache.log4j.PatternLayout");
            ((Hashtable)properties).put("log4j.appender.stderr.layout.ConversionPattern", "%d [%t] %-5p - %m%n");
            ((Hashtable)properties).put("log4j.rootCategory", "WARN, stderr");
            PropertyConfigurator.configure((Properties)properties);
            hostPlatformMap = HostPlatformMap.getInstance();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)hostPlatformMap.toString());
            }
            Integer n2 = hostPlatformMap.getPlatformVersionID(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
            System.out.println(n2);
        }
        catch (HostPlatformMappingException hostPlatformMappingException) {
            System.err.println(((Throwable)((Object)hostPlatformMappingException)).getMessage());
            System.exit(n);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

