/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.targets.metadata;

import java.io.Serializable;
import java.util.HashMap;
import oracle.sysman.ccr.collector.targets.metadata.TableDescriptor;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ColumnDescriptor
implements Serializable {
    private static final long serialVersionUID = -860975950450755435L;
    static final String TAGNAME = "ColumnDescriptor";
    private static final String ATTR_NAME = "NAME";
    private static final String ATTR_TYPE = "TYPE";
    private static final String ATTR_ISFILENAME = "IS_FILENAME";
    private static final String ATTR_IS_KEY = "IS_KEY";
    private static final String ATTR_TRANSIENT = "TRANSIENT";
    private static final String ATTR_COMPUTE_EXPR = "COMPUTE_EXPR";
    private static final String ATTR_COLUMN_NAME = "COLUMN_NAME";
    private static final String ATTR_LONG_TEXT = "IS_LONG_TEXT";
    private static final String ATTR_IS_DATE = "IS_DATE";
    private static final String ATTR_STATELESS_ALERTS = "STATELESS_ALERTS";
    private static final String ATTR_IS_TIMESTAMP = "IS_TIMESTAMP";
    private String m_name = null;
    private int m_typeId = 1;
    private boolean m_bIsFilename = false;
    private boolean m_bKey = false;
    private boolean m_bTransient = false;
    private String m_computeExpr = null;
    private boolean m_bIsEnabled = true;
    private String m_columnName = null;
    private boolean m_bLongText = false;
    private boolean m_bIsDate = false;
    private boolean m_bStatelessAlerts = false;
    private boolean m_bIsTimestamp = false;
    private TableDescriptor m_nstTblDesc = null;
    static HashMap m_hashColumnTypes = new HashMap();
    private static final String TYPE_NUMBER = "NUMBER";
    private static final String TYPE_STRING = "STRING";
    private static final String TYPE_RAW = "RAW";
    private static final String TYPE_CLOB = "CLOB";
    private static final String TYPE_BLOB = "BLOB";
    private static final int TYPEID_NUMBER = 1;
    private static final int TYPEID_STRING = 2;
    private static final int TYPEID_RAW = 3;
    private static final int TYPEID_CLOB = 4;
    private static final int TYPEID_BLOB = 5;
    public static final String FILE_DIGEST_DELIM = "$FileDigest=";

    public ColumnDescriptor(Element element) throws SAXException {
        String string;
        if (!element.getNodeName().equals(TAGNAME)) {
            throw new SAXException("Invalid element node passed to constructor, not ColumnDescriptor");
        }
        this.m_name = element.getAttribute(ATTR_NAME);
        if (element.hasAttribute(ATTR_TYPE)) {
            this.setColumnType(element.getAttribute(ATTR_TYPE));
        }
        this.m_columnName = element.getAttribute(ATTR_COLUMN_NAME);
        if (element.hasAttribute(ATTR_ISFILENAME)) {
            string = element.getAttribute(ATTR_ISFILENAME);
            this.m_bIsFilename = Boolean.valueOf(string);
        }
        if (element.hasAttribute(ATTR_IS_KEY)) {
            string = element.getAttribute(ATTR_IS_KEY);
            this.m_bKey = Boolean.valueOf(string);
        }
        if (element.hasAttribute(ATTR_COMPUTE_EXPR)) {
            this.m_computeExpr = element.getAttribute(ATTR_COMPUTE_EXPR);
        }
        if (element.hasAttribute(ATTR_TRANSIENT)) {
            string = element.getAttribute(ATTR_TRANSIENT);
            this.m_bTransient = Boolean.valueOf(string);
        }
        if (element.hasAttribute(ATTR_LONG_TEXT)) {
            string = element.getAttribute(ATTR_LONG_TEXT);
            this.m_bLongText = Boolean.valueOf(string);
        }
        if (element.hasAttribute(ATTR_IS_DATE)) {
            string = element.getAttribute(ATTR_IS_DATE);
            this.m_bIsDate = Boolean.valueOf(string);
        }
        if (element.hasAttribute(ATTR_STATELESS_ALERTS)) {
            string = element.getAttribute(ATTR_STATELESS_ALERTS);
            this.m_bStatelessAlerts = Boolean.valueOf(string);
        }
        if (element.hasAttribute(ATTR_IS_TIMESTAMP)) {
            string = element.getAttribute(ATTR_IS_TIMESTAMP);
            this.m_bIsTimestamp = Boolean.valueOf(string);
        }
    }

    public ColumnDescriptor(String string, String string2, String string3, boolean bl) {
        this.m_name = string;
        this.m_columnName = string2;
        Integer n = (Integer)m_hashColumnTypes.get(string3);
        this.m_typeId = n;
        this.m_bKey = bl;
    }

    private void setColumnType(String string) throws SAXException {
        if (!m_hashColumnTypes.containsKey(string)) {
            throw new SAXException("Invalid column type specified - " + string);
        }
        Integer n = (Integer)m_hashColumnTypes.get(string);
        this.m_typeId = n;
    }

    public boolean isToBeReadFromFile() {
        return this.m_bIsFilename && (this.m_typeId == 4 || this.m_typeId == 5);
    }

    public boolean isDate() {
        return this.m_bIsDate;
    }

    public String getName() {
        return this.m_name;
    }

    public String getColumnName() {
        return this.m_columnName;
    }

    public void setColumnName(String string) {
        this.m_columnName = string;
    }

    public boolean isEnabled() {
        return this.m_bIsEnabled;
    }

    public void setEnabledStatus(boolean bl) {
        this.m_bIsEnabled = bl;
    }

    public int getTypeId() {
        return this.m_typeId;
    }

    public boolean isLongText() {
        return this.m_bLongText;
    }

    public boolean isTransient() {
        return this.m_bTransient;
    }

    public String getComputeExpr() {
        return this.m_computeExpr;
    }

    public boolean isComputed() {
        return this.m_computeExpr != null;
    }

    public boolean isKey() {
        return this.m_bKey;
    }

    public TableDescriptor getNestedTblDesc() {
        return this.m_nstTblDesc;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ColumnDescriptor)) {
            return false;
        }
        ColumnDescriptor columnDescriptor = (ColumnDescriptor)object;
        if (this.m_bIsDate != columnDescriptor.m_bIsDate || this.m_bIsFilename != columnDescriptor.m_bIsFilename || this.m_bIsTimestamp != columnDescriptor.m_bIsTimestamp || this.m_bKey != columnDescriptor.m_bKey || this.m_bLongText != columnDescriptor.m_bLongText || this.m_bStatelessAlerts != columnDescriptor.m_bStatelessAlerts || this.m_bTransient != columnDescriptor.m_bTransient || this.m_nstTblDesc != columnDescriptor.m_nstTblDesc || this.m_typeId != columnDescriptor.m_typeId || this.m_bIsEnabled != columnDescriptor.m_bIsEnabled) {
            return false;
        }
        if (this.m_columnName == null ? columnDescriptor.m_columnName != null : !this.m_columnName.equals(columnDescriptor.m_columnName)) {
            return false;
        }
        if (this.m_name == null ? columnDescriptor.m_name != null : !this.m_name.equals(columnDescriptor.m_name)) {
            return false;
        }
        return !(this.m_computeExpr == null ? columnDescriptor.m_computeExpr != null : !this.m_computeExpr.equals(columnDescriptor.m_computeExpr));
    }

    static {
        m_hashColumnTypes = new HashMap();
        m_hashColumnTypes.put(TYPE_NUMBER, new Integer(1));
        m_hashColumnTypes.put(TYPE_STRING, new Integer(2));
        m_hashColumnTypes.put(TYPE_CLOB, new Integer(4));
        m_hashColumnTypes.put(TYPE_BLOB, new Integer(5));
    }
}

