/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.targets.metadata;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.ccr.collector.fetchlets.FetchletException;
import oracle.sysman.ccr.collector.fetchlets.FetchletManager;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.fetchlets.ValueRow;
import oracle.sysman.ccr.collector.targets.Target;
import oracle.sysman.ccr.collector.targets.metadata.QueryDescriptor;
import oracle.sysman.ccr.collector.targets.metadata.TargetMetadata;
import oracle.sysman.ccr.collector.targets.metadata.ValidIf;
import oracle.sysman.ccr.collector.targets.metadata.ValiditySelectorEnabled;
import oracle.sysman.ccr.collector.targets.metadata.ValiditySelectorList;
import oracle.sysman.ccr.common.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DynamicProperties
implements ValiditySelectorEnabled {
    private static Logger s_log = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$targets$metadata$DynamicProperties == null ? (class$oracle$sysman$ccr$collector$targets$metadata$DynamicProperties = DynamicProperties.class$("oracle.sysman.ccr.collector.targets.metadata.DynamicProperties")) : class$oracle$sysman$ccr$collector$targets$metadata$DynamicProperties));
    static final String TAGNAME = "DynamicProperties";
    static final String ATTR_NAME = "NAME";
    static final String ATTR_PROP_LIST = "PROP_LIST";
    static final String ATTR_OPT_PROP_LIST = "OPT_PROP_LIST";
    private Vector m_prop_list = null;
    private ValiditySelectorList m_ValidIfList = new ValiditySelectorList();
    private ValiditySelectorList m_queryDescList = new ValiditySelectorList();
    private String m_name = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$targets$metadata$DynamicProperties;

    public DynamicProperties(Element element) throws SAXException {
        this.m_name = element.getAttribute(ATTR_NAME);
        String string = element.getAttribute(ATTR_PROP_LIST);
        String string2 = element.getAttribute(ATTR_OPT_PROP_LIST);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ";");
        this.m_prop_list = new Vector();
        while (stringTokenizer.hasMoreTokens()) {
            this.m_prop_list.add(stringTokenizer.nextToken());
        }
        while (stringTokenizer2.hasMoreTokens()) {
            this.m_prop_list.add(stringTokenizer2.nextToken());
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NamedNodeMap namedNodeMap;
            Node node;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().equals("ValidIf")) {
                this.m_ValidIfList.add(new ValidIf((Element)node2));
            }
            if (!node2.getNodeName().equals("QueryDescriptor") || (node = (namedNodeMap = node2.getAttributes()).getNamedItem("AGENT_MODE")) == null || !TargetMetadata.isApplicableForOcm(node.getNodeValue())) continue;
            this.m_queryDescList.add(new QueryDescriptor((Element)node2));
        }
    }

    public boolean areAllApplicableFetchletIdsSupported() throws SAXException {
        if (this.m_queryDescList.size() == 0) {
            return false;
        }
        try {
            QueryDescriptor queryDescriptor = null;
            FetchletManager fetchletManager = FetchletManager.getInstance();
            for (int i = 0; i < this.m_queryDescList.size(); ++i) {
                queryDescriptor = (QueryDescriptor)this.m_queryDescList.get(i);
                if (queryDescriptor != null && fetchletManager.isValidFetchlet(queryDescriptor.getFetchletId())) continue;
                return false;
            }
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SAXException("Error instantiating Fetchlet Manager");
        }
        catch (IOException iOException) {
            throw new SAXException("Error instantiating Fetchlet Manager");
        }
        catch (FetchletException fetchletException) {
            throw new SAXException("Error getting fetchlet registry for " + this.m_name + " dynamic property");
        }
    }

    public boolean isElementValid(Target target) throws SAXException {
        return this.m_ValidIfList.isValid(target);
    }

    public void evaluate(Target target) throws SAXException {
        MetricResult metricResult = null;
        Vector vector = null;
        ValueRow valueRow = null;
        String string = null;
        HashMap hashMap = target.m_env;
        boolean bl = false;
        if (s_log.isEnabledFor(Logger.DEBUG)) {
            s_log.debug((Object)("Evaluating dynamic property element \"" + this.m_name + "\" for target (" + target.getTargetName() + ", " + target.getTargetType() + ")."));
        }
        if (this.isElementValid(target)) {
            block10: {
                QueryDescriptor queryDescriptor = (QueryDescriptor)this.m_queryDescList.getValidElement(target);
                if (queryDescriptor != null) {
                    try {
                        metricResult = queryDescriptor.getFetchletId().equals("VersionRangeComputer") ? queryDescriptor.collect(target, false) : queryDescriptor.collect(target);
                    }
                    catch (FetchletException fetchletException) {
                        bl = true;
                        metricResult = null;
                        if (!s_log.isEnabledFor(Logger.DEBUG)) break block10;
                        s_log.debug((Object)("DEV-WARN: FetchletException while computing DynamicProperty \"" + this.m_name + "\": " + ((Throwable)((Object)fetchletException)).getMessage() + ". Setting those properties as NULL."));
                    }
                }
            }
            if (metricResult != null) {
                vector = metricResult.getValueRows();
            }
            if (vector != null && vector.size() >= 1) {
                valueRow = (ValueRow)vector.get(0);
            }
            for (int i = 0; i < this.m_prop_list.size(); ++i) {
                String string2 = (String)this.m_prop_list.get(i);
                string = valueRow != null ? valueRow.getValue(i) : null;
                if (!hashMap.containsKey(string2)) {
                    if (metricResult != null || bl) {
                        hashMap.put(string2, string);
                        if (!s_log.isEnabledFor(Logger.DEBUG)) continue;
                        s_log.debug((Object)("Set Dynamic Property \"" + string2 + "\" = \"" + string + "\"."));
                        continue;
                    }
                    if (!s_log.isEnabledFor(Logger.DEBUG)) continue;
                    s_log.debug((Object)("DEV-WARN: Property \"" + string2 + "\" was not computed."));
                    continue;
                }
                if (!s_log.isEnabledFor(Logger.DEBUG)) continue;
                s_log.debug((Object)("Property \"" + string2 + "\" already present. Value = \"" + (String)hashMap.get(string2) + "\"."));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

