/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.targets.metadata;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.fetchlets.FetchletException;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.fetchlets.ValueRow;
import oracle.sysman.ccr.collector.targets.Target;
import oracle.sysman.ccr.collector.targets.metadata.ColumnDescriptor;
import oracle.sysman.ccr.collector.targets.metadata.QueryDescriptor;
import oracle.sysman.ccr.collector.targets.metadata.TableDescriptor;
import oracle.sysman.ccr.collector.targets.metadata.TargetMetadata;
import oracle.sysman.ccr.collector.targets.metadata.TargetsMetadataMsgID;
import oracle.sysman.ccr.collector.targets.metadata.ValidIf;
import oracle.sysman.ccr.collector.targets.metadata.ValidMidTierVersions;
import oracle.sysman.ccr.collector.targets.metadata.ValiditySelectorEnabled;
import oracle.sysman.ccr.collector.targets.metadata.ValiditySelectorList;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.Utils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Metric
implements ValiditySelectorEnabled {
    static final Logger s_log = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$targets$metadata$Metric == null ? (class$oracle$sysman$ccr$collector$targets$metadata$Metric = Metric.class$("oracle.sysman.ccr.collector.targets.metadata.Metric")) : class$oracle$sysman$ccr$collector$targets$metadata$Metric));
    static MessageBundle s_bundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.targets.metadata.TargetsMetadata");
    static final String TAGNAME = "Metric";
    private static final String ATTR_ID = "NAME";
    private static final String ATTR_TYPE = "TYPE";
    private static final String ATTR_USAGETYPE = "USAGE_TYPE";
    private static final String ATTR_REPOS_PLSQL = "REPOS_PLSQL";
    private static final String ATTR_CUSTOM = "CUSTOM";
    private static final String ATTR_INCREMENTAL = "INCREMENTAL";
    private static final String ATTR_CMDB_FORMAT = "CMDB_FORMAT";
    static final int TYPEID_INVALID = -1;
    static final int TYPEID_NUMBER = 0;
    static final int TYPEID_STRING = 1;
    static final int TYPEID_TABLE = 2;
    static final int TYPEID_RAW = 3;
    static final int TYPEID_EXTERNAL = 4;
    static final int TYPEID_REPOSITORY_TABLE = 5;
    static final int TYPEID_REPOSITORY_NUMBER = 6;
    static final int TYPEID_REPOSITORY_STRING = 7;
    private static final String TYPE_NUMBER = "NUMBER";
    private static final String TYPE_STRING = "STRING";
    private static final String TYPE_TABLE = "TABLE";
    private static final String TYPE_RAW = "RAW";
    private static final String TYPE_EXTERNAL = "EXTERNAL";
    private static final String TYPE_REPOSITORY_TABLE = "REPOSITORY_TABLE";
    private static final String TYPE_REPOSITORY_NUMBER = "REPOSITORY_NUMBER";
    private static final String TYPE_REPOSITORY_STRING = "REPOSITORY_STRING";
    static final int USAGETYPEID_INVALID = -1;
    static final int USAGETYPEID_VIEW_COLLECT = 0;
    static final int USAGETYPEID_DISPLAY_ONLY = 1;
    static final int USAGETYPEID_MULTI_KEY = 2;
    static final int USAGETYPEID_COLLECT_ONLY = 3;
    static final String USAGETYPE_VIEW_COLLECT = "VIEW_COLLECT";
    static final String USAGETYPE_DISPLAY_ONLY = "DISPLAY_ONLY";
    static final String USAGETYPE_MULTI_KEY = "MULTI_KEY";
    static final String USAGETYPE_COLLECT_ONLY = "COLLECT_ONLY";
    static final int COLUMN_NOT_EXIST = -1;
    public static final String[] TYPES = new String[]{"NUMBER", "STRING", "TABLE", "RAW", "EXTERNAL", "REPOSITORY_TABLE", "REPOSITORY_NUMBER", "REPOSITORY_STRING"};
    static final String[] USAGE_TYPES = new String[]{"VIEW_COLLECT", "DISPLAY_ONLY", "MULTI_KEY", "COLLECT_ONLY"};
    private String m_metricId = null;
    private int m_typeId = 0;
    private int m_usageTypeId = 0;
    private boolean m_isIncremental = false;
    private String m_reposPlSql = null;
    private String m_custom = null;
    private ValiditySelectorList m_ValidIfList = new ValiditySelectorList();
    private ValiditySelectorList m_ValidMidTierVerList = new ValiditySelectorList();
    private TableDescriptor m_tblDesc = null;
    private ValiditySelectorList m_queryDescList = new ValiditySelectorList();
    private Vector m_colDescs = new Vector();
    private Element m_metricElement = null;
    private boolean m_isCmdbFormat = false;
    private boolean m_applicableForGC = false;
    private static HashMap m_hashMetricElements = null;
    private static final int UNKNOWN_ELEMENT = -1;
    private static final int IGNORED_ELEMENT = 0;
    private static final int SUPPORTED_ELEMENT = 1;
    private static final int UNSUPPORTED_ELEMENT = 2;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$targets$metadata$Metric;

    public Metric(Element element) throws SAXException {
        Object object;
        this.m_metricId = element.getAttribute(ATTR_ID);
        if (s_log.isEnabledFor(Logger.DEBUG)) {
            s_log.debug((Object)("Working on metric " + this.m_metricId));
        }
        if (element.getAttribute(ATTR_INCREMENTAL).equalsIgnoreCase("true")) {
            this.m_isIncremental = true;
        }
        if (element.getAttribute(ATTR_CMDB_FORMAT).equalsIgnoreCase("true")) {
            this.m_isCmdbFormat = true;
        }
        if (element.hasAttribute("AGENT_MODE") && Collector.isApplicableForGC((String)(object = element.getAttribute("AGENT_MODE")))) {
            this.m_applicableForGC = true;
        }
        this.m_metricElement = element;
        object = element.getChildNodes();
        boolean bl = false;
        for (int i = 0; i < object.getLength(); ++i) {
            NamedNodeMap namedNodeMap;
            Node node;
            Node node2 = object.item(i);
            if (node2.getNodeType() != 1) continue;
            String string = node2.getNodeName();
            int n = this.validateElement(string);
            if (n == 2 || n == -1) {
                bl = true;
            }
            if (node2.getNodeName().equals("ValidIf")) {
                this.m_ValidIfList.add(new ValidIf((Element)node2));
            }
            if (node2.getNodeName().equals("ValidMidTierVersions")) {
                this.m_ValidMidTierVerList.add(new ValidMidTierVersions((Element)node2));
            }
            if (node2.getNodeName().equals("QueryDescriptor") && (node = (namedNodeMap = node2.getAttributes()).getNamedItem("AGENT_MODE")) != null && TargetMetadata.isApplicableForOcm(node.getNodeValue())) {
                this.m_queryDescList.add(new QueryDescriptor((Element)node2));
            }
            if (!node2.getNodeName().equals("TableDescriptor")) continue;
            this.setTblDesc(new TableDescriptor((Element)node2));
        }
        if (bl) {
            throw new SAXException("Unexpected ELEMENT encountered");
        }
    }

    public Metric(String string, boolean bl, boolean bl2, TableDescriptor tableDescriptor, QueryDescriptor queryDescriptor) {
        this.m_metricId = string;
        this.m_isIncremental = bl;
        this.m_isCmdbFormat = bl2;
        this.m_queryDescList.add(queryDescriptor);
        this.setTblDesc(tableDescriptor);
    }

    public void init(Attributes attributes) throws SAXException {
        this.m_metricId = attributes.getValue(ATTR_ID);
        this.m_typeId = Metric.getTypeId(attributes.getValue(ATTR_TYPE));
        this.m_usageTypeId = Metric.getUsageTypeId(attributes.getValue(ATTR_USAGETYPE));
        this.m_reposPlSql = attributes.getValue(ATTR_REPOS_PLSQL);
        this.m_custom = attributes.getValue(ATTR_CUSTOM);
        if (this.m_metricId == null || this.m_metricId.equals("")) {
            throw new SAXException("Invalid value for NAME in Metric");
        }
        if (!(this.m_typeId != 5 && this.m_typeId != 6 && this.m_typeId != 7 || this.m_reposPlSql != null && !this.m_reposPlSql.equals(""))) {
            throw new SAXException("Invalid value for REPOS_PLSQL in Metric:" + this.m_metricId);
        }
        if (this.m_typeId == -1) {
            throw new SAXException("Invalid value for type  : " + attributes.getValue(ATTR_TYPE) + " in " + TAGNAME + ":" + this.m_metricId);
        }
        if (this.m_usageTypeId == -1) {
            throw new SAXException("Invalid value for usage type  : " + attributes.getValue(ATTR_USAGETYPE) + " in " + TAGNAME + ":" + this.m_metricId);
        }
    }

    public String getCustomString() {
        return this.m_custom;
    }

    public static int getTypeId(String string) {
        int n = -1;
        for (int i = 0; i < TYPES.length; ++i) {
            if (!TYPES[i].equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public static int getUsageTypeId(String string) {
        int n = -1;
        if (string == null || string.length() == 0) {
            return 0;
        }
        for (int i = 0; i < USAGE_TYPES.length; ++i) {
            if (!USAGE_TYPES[i].equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public String getMetricId() {
        return this.m_metricId;
    }

    public String getDisplayLabel() {
        return this.m_metricId;
    }

    public int getTypeId() {
        return this.m_typeId;
    }

    public int getUsageTypeId() {
        return this.m_usageTypeId;
    }

    public String getReposPlSql() {
        return this.m_reposPlSql;
    }

    private void setTblDesc(TableDescriptor tableDescriptor) {
        this.m_tblDesc = tableDescriptor;
        if (tableDescriptor == null) {
            return;
        }
        this.m_colDescs = tableDescriptor.getColDescs();
    }

    public TableDescriptor getTblDesc() {
        return this.m_tblDesc;
    }

    private QueryDescriptor getValidQueryDesc(Target target) {
        return (QueryDescriptor)this.m_queryDescList.getValidElement(target);
    }

    public boolean isSimpleMetric() {
        return this.getTypeId() == 0 || this.getTypeId() == 1 || this.getTypeId() == 4;
    }

    public boolean isCmdbFormat() {
        return this.m_isCmdbFormat;
    }

    public boolean isRawMetric() {
        return this.getTypeId() == 3;
    }

    public String getTableName() {
        if (this.m_tblDesc == null) {
            return null;
        }
        return this.m_tblDesc.getTableName();
    }

    public Vector getPrimaryKey(ColumnDescriptor columnDescriptor) {
        if (this.m_tblDesc == null) {
            return null;
        }
        Vector<String> vector = null;
        for (int i = 0; i < this.m_colDescs.size(); ++i) {
            ColumnDescriptor columnDescriptor2 = (ColumnDescriptor)this.m_colDescs.elementAt(i);
            if (!columnDescriptor2.isKey()) continue;
            if (vector == null) {
                vector = new Vector<String>();
            }
            vector.addElement(columnDescriptor2.getColumnName());
        }
        if (columnDescriptor != null) {
            Vector vector2 = columnDescriptor.getNestedTblDesc().getColDescs();
            for (int i = 0; i < vector2.size(); ++i) {
                ColumnDescriptor columnDescriptor3 = (ColumnDescriptor)vector2.elementAt(i);
                if (!columnDescriptor3.isKey()) continue;
                if (vector == null) {
                    vector = new Vector();
                }
                vector.addElement(columnDescriptor3.getColumnName());
            }
        }
        return vector;
    }

    public int findColumnId(String string) {
        if (this.m_colDescs == null) {
            return -1;
        }
        for (int i = 0; i < this.m_colDescs.size(); ++i) {
            ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.m_colDescs.elementAt(i);
            if (!string.equals(columnDescriptor.getName())) continue;
            return i;
        }
        return -1;
    }

    public String getKeyName() {
        String string = null;
        if (this.m_colDescs == null) {
            return null;
        }
        for (int i = 0; i < this.m_colDescs.size(); ++i) {
            ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.m_colDescs.elementAt(i);
            if (!columnDescriptor.isKey()) continue;
            string = columnDescriptor.getName();
            break;
        }
        return string;
    }

    public int getKeyColumnId() {
        if (this.m_colDescs == null) {
            return -1;
        }
        for (int i = 0; i < this.m_colDescs.size(); ++i) {
            ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.m_colDescs.elementAt(i);
            if (!columnDescriptor.isKey()) continue;
            return i;
        }
        return -1;
    }

    public int[] getKeyColumnIds() {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this.m_colDescs.size(); ++i) {
            ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.m_colDescs.elementAt(i);
            if (!columnDescriptor.isKey()) continue;
            vector.addElement(new Integer(i));
        }
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.elementAt(i);
        }
        return nArray;
    }

    public String getKeyValue(ValueRow valueRow) {
        String string = null;
        if (this.m_colDescs == null) {
            return null;
        }
        for (int i = 0; i < this.m_colDescs.size(); ++i) {
            ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.m_colDescs.elementAt(i);
            if (!columnDescriptor.isKey()) continue;
            string = valueRow.getValue(i);
            break;
        }
        return string;
    }

    public String getKeyValue(ValueRow valueRow, int[] nArray) {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            string = valueRow.getValue(nArray[i]);
            if (string == null) continue;
            stringBuffer.append(string);
            if (i >= nArray.length - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public int getColumnNumber() {
        if (this.isSimpleMetric()) {
            return 1;
        }
        return this.m_colDescs.size();
    }

    public boolean isKeyColumn(int n) {
        if (this.isSimpleMetric()) {
            return false;
        }
        if (n < 0 || n >= this.m_colDescs.size()) {
            return false;
        }
        ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.m_colDescs.elementAt(n);
        return columnDescriptor.isKey();
    }

    public boolean hasComputedColumn() {
        return this.m_tblDesc != null && this.m_tblDesc.hasComputedColumn();
    }

    public boolean isTransientColumn(int n) {
        if (this.isSimpleMetric()) {
            return false;
        }
        if (n < 0 || n >= this.m_colDescs.size()) {
            return false;
        }
        ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.m_colDescs.elementAt(n);
        return columnDescriptor.isTransient();
    }

    public boolean isLongText(int n) {
        if (this.isSimpleMetric()) {
            return false;
        }
        if (n < 0 || n >= this.m_colDescs.size()) {
            return false;
        }
        ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.m_colDescs.elementAt(n);
        return columnDescriptor.isLongText();
    }

    public String getColumnName(int n) {
        if (this.isSimpleMetric()) {
            return null;
        }
        ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.m_colDescs.elementAt(n);
        return columnDescriptor.getColumnName();
    }

    public int getColumnType(int n) {
        if (this.isSimpleMetric()) {
            return this.getTypeId();
        }
        ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.m_colDescs.elementAt(n);
        return columnDescriptor.getTypeId();
    }

    public boolean isForSummaryUI(int n) {
        return false;
    }

    public String getColumnShortName(int n) {
        return null;
    }

    public String getColumnDisplayUnitName(int n) {
        return "";
    }

    public String getColumnDisplayName(int n) {
        return this.getDisplayLabel();
    }

    public TableDescriptor getColumnNestedTblDesc(int n) {
        if (this.isSimpleMetric()) {
            return null;
        }
        ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.m_colDescs.elementAt(n);
        return columnDescriptor.getNestedTblDesc();
    }

    public Vector getDateColumns(ColumnDescriptor columnDescriptor) {
        if (!this.isRawMetric() || this.m_colDescs == null) {
            return null;
        }
        Vector vector = this.m_colDescs;
        if (columnDescriptor != null) {
            vector = columnDescriptor.getNestedTblDesc().getColDescs();
        }
        if (vector == null) {
            return null;
        }
        Vector<String> vector2 = null;
        for (int i = 0; i < vector.size(); ++i) {
            ColumnDescriptor columnDescriptor2 = (ColumnDescriptor)vector.elementAt(i);
            if (columnDescriptor2 == null || !columnDescriptor2.isDate()) continue;
            if (vector2 == null) {
                vector2 = new Vector<String>();
            }
            vector2.addElement(columnDescriptor2.getColumnName());
        }
        return vector2;
    }

    private int validateElement(String string) {
        int n = -1;
        Integer n2 = (Integer)m_hashMetricElements.get(string);
        if (n2 != null) {
            n = n2;
            switch (n2) {
                case 2: {
                    if (!s_log.isEnabledFor(Logger.WARN)) break;
                    s_log.warn(TargetsMetadataMsgID.UNSUPPORTED_METRIC_CHILD, (Object[])new String[]{string});
                    break;
                }
                case 0: {
                    if (!s_log.isEnabledFor(Logger.DEBUG)) break;
                    s_log.debug((Object)s_bundle.getMessage(TargetsMetadataMsgID.IGNORED_METRIC_CHILD, false, (Object[])new String[]{string}));
                    break;
                }
                case 1: {
                    if (!s_log.isEnabledFor(Logger.DEBUG)) break;
                    s_log.debug((Object)s_bundle.getMessage(TargetsMetadataMsgID.SUPPORTED_METRIC_CHILD, false, (Object[])new String[]{string}));
                }
            }
        } else {
            s_log.error(TargetsMetadataMsgID.UNEXPECTED_METRIC_CHILD, (Object[])new String[]{string});
        }
        return n;
    }

    public boolean isIncremental() {
        return this.m_isIncremental;
    }

    public MetricResult collect(Target target) throws SAXException, FetchletException {
        MetricResult metricResult = null;
        QueryDescriptor queryDescriptor = this.getValidQueryDesc(target);
        if (queryDescriptor != null) {
            metricResult = queryDescriptor.collect(target);
            this.addDigestToFileNameCols(metricResult);
        }
        return metricResult;
    }

    private void addDigestToFileNameCols(MetricResult metricResult) {
        Vector vector = this.m_tblDesc.getColDescs();
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            ColumnDescriptor columnDescriptor = (ColumnDescriptor)vector.get(i);
            if (!columnDescriptor.isToBeReadFromFile()) continue;
            Vector vector2 = metricResult.getValueRows();
            if (vector2 == null) {
                return;
            }
            for (int j = 0; j < vector2.size(); ++j) {
                ValueRow valueRow = (ValueRow)vector2.get(j);
                String string = valueRow.getValue(i);
                if (string == null) continue;
                File file = new File(string);
                String string2 = new Date().toString();
                try {
                    string2 = Utils.getDigest((File)file);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                string = string + "$FileDigest=" + string2;
                valueRow.setValue(i, string);
            }
        }
    }

    public boolean isElementValid(Target target) throws SAXException {
        return this.m_ValidIfList.isValid(target);
    }

    public boolean isMidTierValid() throws SAXException {
        return this.m_ValidMidTierVerList.isValid(null);
    }

    public boolean isApplicableForGC() {
        return this.m_applicableForGC;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        m_hashMetricElements = new HashMap();
        m_hashMetricElements.put("ValidIf", new Integer(1));
        m_hashMetricElements.put("ValidMidTierVersions", new Integer(1));
        m_hashMetricElements.put("Display", new Integer(0));
        m_hashMetricElements.put("CategoryValue", new Integer(0));
        m_hashMetricElements.put("TableDescriptor", new Integer(1));
        m_hashMetricElements.put("QueryDescriptor", new Integer(1));
        m_hashMetricElements.put("ExecutionDescriptor", new Integer(1));
        m_hashMetricElements.put("PushDescriptor", new Integer(1));
    }
}

