/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.targets.metadata;

import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Property
implements Cloneable {
    static final String TAGNAME = "Property";
    static final int SCOPEID_INVALID = -1;
    static final int SCOPEID_GLOBAL = 0;
    static final int SCOPEID_INSTANCE = 1;
    static final int SCOPEID_USER = 2;
    static final int SCOPEID_SYSGLOB = 3;
    static final int SCOPEID_HOST = 4;
    static final int SCOPEID_RUNTIME = 5;
    static final int SCOPEID_CONDITION = 6;
    static final int SCOPEID_ENV = 7;
    static final int MIN_SCOPEID = 0;
    static final int MAX_SCOPEID = 7;
    private static final String SCOPE_GLOBAL = "GLOBAL";
    private static final String SCOPE_INSTANCE = "INSTANCE";
    private static final String SCOPE_USER = "USER";
    private static final String SCOPE_SYSGLOB = "SYSTEMGLOBAL";
    private static final String SCOPE_HOST = "HOST";
    private static final String SCOPE_RUNTIME = "RUNTIME";
    private static final String SCOPE_CONDITION = "CONDITION";
    private static final String SCOPE_ENV = "ENV";
    static HashMap m_scopeTable = null;
    private static final String ATTR_NAME = "NAME";
    private static final String ATTR_SCOPE = "SCOPE";
    private static final String ATTR_OPTIONAL = "OPTIONAL";
    private String m_name = null;
    private int m_scopeId = 0;
    private boolean m_optional = false;
    private String m_contents = null;

    public Property(String string, int n) throws SAXException {
        this.setName(string);
        this.setScopeId(n);
    }

    public Property(String string, String string2, String string3) throws SAXException {
        this.setName(string);
        this.setScopeId(string2);
        this.setContents(string3);
    }

    public Property(Element element) throws SAXException {
        this.setName(element.getAttribute(ATTR_NAME));
        this.setScopeId(element.getAttribute(ATTR_SCOPE));
        if (element.hasAttribute(ATTR_OPTIONAL)) {
            this.setOptional(element.getAttribute(ATTR_OPTIONAL));
        }
        this.setContents(element);
    }

    private void setScopeId(String string) throws SAXException {
        if (!m_scopeTable.containsKey(string)) {
            throw new SAXException("Invalid Property SCOPE specified, " + string);
        }
        Integer n = (Integer)m_scopeTable.get(string);
        this.setScopeId(n);
    }

    private void setOptional(String string) {
        this.m_optional = string != null && string.equalsIgnoreCase("TRUE");
    }

    private int getScopeId(String string) {
        int n = -1;
        if (m_scopeTable.containsKey(string)) {
            Integer n2 = (Integer)m_scopeTable.get(string);
            n = n2;
        }
        return n;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) throws SAXException {
        if (string == null || string.equals("")) {
            throw new SAXException("Invalid value for NAME in Property");
        }
        this.m_name = string;
    }

    public int getScopeId() {
        return this.m_scopeId;
    }

    public void setScopeId(int n) throws SAXException {
        if (n < 0 || n > 7) {
            throw new SAXException("Invalid value for scope : " + n + " in " + TAGNAME);
        }
        this.m_scopeId = n;
    }

    public void setOptional(boolean bl) {
        this.m_optional = bl;
    }

    public boolean isOptional() {
        return this.m_optional;
    }

    public void setContents(String string) {
        this.m_contents = string;
    }

    public void setContents(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            this.setContents(node.getNodeValue());
        }
    }

    public String getContents() {
        return this.m_contents == null ? "" : this.m_contents;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    static {
        m_scopeTable = new HashMap();
        m_scopeTable.put(SCOPE_GLOBAL, new Integer(0));
        m_scopeTable.put(SCOPE_INSTANCE, new Integer(1));
        m_scopeTable.put(SCOPE_USER, new Integer(2));
        m_scopeTable.put(SCOPE_SYSGLOB, new Integer(3));
        m_scopeTable.put(SCOPE_HOST, new Integer(4));
        m_scopeTable.put(SCOPE_RUNTIME, new Integer(5));
        m_scopeTable.put(SCOPE_CONDITION, new Integer(6));
        m_scopeTable.put(SCOPE_ENV, new Integer(7));
    }
}

