/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.targets.metadata;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.fetchlets.Fetchlet;
import oracle.sysman.ccr.collector.fetchlets.FetchletException;
import oracle.sysman.ccr.collector.fetchlets.FetchletManager;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.targets.Target;
import oracle.sysman.ccr.collector.targets.TargetManager;
import oracle.sysman.ccr.collector.targets.metadata.Property;
import oracle.sysman.ccr.collector.targets.metadata.TargetsMetadataMsgID;
import oracle.sysman.ccr.collector.targets.metadata.ValidIf;
import oracle.sysman.ccr.collector.targets.metadata.ValiditySelectorEnabled;
import oracle.sysman.ccr.collector.targets.metadata.ValiditySelectorList;
import oracle.sysman.ccr.collector.util.AgentConfig;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.PluginsMetadata;
import oracle.sysman.ccr.util.UplinkPath;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class QueryDescriptor
implements ValiditySelectorEnabled {
    static Logger s_log = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$targets$metadata$QueryDescriptor == null ? (class$oracle$sysman$ccr$collector$targets$metadata$QueryDescriptor = QueryDescriptor.class$("oracle.sysman.ccr.collector.targets.metadata.QueryDescriptor")) : class$oracle$sysman$ccr$collector$targets$metadata$QueryDescriptor));
    static MessageBundle s_bundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.targets.metadata.TargetsMetadata");
    static final String TAGNAME = "QueryDescriptor";
    private static final String ATTR_FETCHLETID = "FETCHLET_ID";
    private String m_fetchletId = null;
    private Vector m_properties = null;
    private Element m_elementQD = null;
    private ValiditySelectorList m_ValidIfList = new ValiditySelectorList();
    private static RE s_propMatch = null;
    private static RE m_varExpression = null;
    static final String ENV_PREFIX = "ENV";
    static final String ENV_LD_PRELOAD = "LD_PRELOAD";
    static final String ENV_PROP_PERL5LIB = "PERL5LIB";
    static final String ENV_PROP_EMDROOT = "EMDROOT";
    static final String ENV_PROP_ORACLE_HOME = "ORACLE_HOME";
    static final String ENV_PROP_CCR_CONFIG_HOME = "CCR_CONFIG_HOME";
    static final String ENV_EMAGENT_PERL_TRACE_DIR = "EMAGENT_PERL_TRACE_DIR";
    static final String ENV_EMAGENT_PERL_TRACE_LEVEL = "EMAGENT_PERL_TRACE_LEVEL";
    static final String ENV_AGENT_HOME = "AGENT_HOME";
    static final String ENV_EMSTATE = "EMSTATE";
    static final String TNS_ADMIN = "TNS_ADMIN";
    static final String ENV_CCR_HOME = "CCR_HOME";
    static final String ENV_CCR_JAVA_HOME = "CCR_JAVA_HOME";
    static final String ENV_CRS_HOME = "CRS_HOME";
    static final String ENV_USER_ORACLE_HOME = "USER_ORACLE_HOME";
    static final String ENV_COMSPEC = "COMSPEC";
    static final String ENV_SYSTEMROOT = "SYSTEMROOT";
    static final String ENV_TZ = "TZ";
    static final String ENV_AGENTPROXYHOME = "AGENTPROXYHOME";
    static final String ENV_JDBC_OCI_SWITCH = "JDBC_OCI_SWITCH";
    private final String ENV_WL_HOME = "WL_HOME";
    private final String ENV_BEA_HOME = "BEA_HOME";
    private final String ENV_ORACLE_INSTANCE = "ORACLE_INSTANCE";
    static final String ENV_JAVA_HOME = "JAVA_HOME";
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$targets$metadata$QueryDescriptor;

    public QueryDescriptor(Element element) throws SAXException {
        this.m_properties = new Vector();
        this.m_elementQD = element;
        NamedNodeMap namedNodeMap = element.getAttributes();
        Attr attr = (Attr)namedNodeMap.getNamedItem(ATTR_FETCHLETID);
        if (attr != null) {
            this.m_fetchletId = attr.getValue();
            if (this.m_fetchletId == null || this.m_fetchletId.equals("")) {
                throw new SAXException("Invalid value for FETCHLET_ID in QueryDescriptor");
            }
        } else {
            throw new SAXException("Invalid value for FETCHLET_ID in QueryDescriptor");
        }
        this.addProperties();
        this.addValidIfs();
    }

    public QueryDescriptor(String string, Vector vector) {
        this.m_fetchletId = string;
        this.m_properties = vector;
    }

    private void getDefaultProperties(Properties properties, Target target) {
        TargetManager targetManager = TargetManager.getInstance();
        ((Hashtable)properties).put("TYPE_DISPLAY_NAME", targetManager.getTargetTypeDisplayName(target.getTargetType()));
    }

    private void getDefaultEnvProperties(Target target, Properties properties) {
        String string = null;
        string = System.getProperty(ENV_LD_PRELOAD);
        if (string != null) {
            ((Hashtable)properties).put("ENVLD_PRELOAD", string);
        }
        String string2 = null;
        string2 = System.getProperty(ENV_CCR_JAVA_HOME);
        if (string2 != null) {
            ((Hashtable)properties).put("ENVCCR_JAVA_HOME", string2);
        }
        ((Hashtable)properties).put("ENVCCR_HOME", FileSpec.catfile((String[])new String[]{Collector.getCCRRoot(), UplinkPath.LIVE_LINK_PATH}));
        String string3 = System.getProperty("SHLIB_VAR");
        if (string3 != null && s_propMatch.match(string3)) {
            ((Hashtable)properties).put(ENV_PREFIX + s_propMatch.getParen(1), s_propMatch.getParen(2));
        }
        ((Hashtable)properties).put("ENVCCR_CONFIG_HOME", Collector.getCCRConfigHome());
        ((Hashtable)properties).put("ENVEMDROOT", FileSpec.catfile((String[])new String[]{Collector.getCCRRoot(), UplinkPath.LIVE_LINK_PATH}));
        ((Hashtable)properties).put("ENVEMAGENT_PERL_TRACE_DIR", FileSpec.catfile((String[])new String[]{AgentConfig.getRootStateDir(), UplinkPath.LOG_PATH}));
        String string4 = null;
        string4 = System.getProperty(ENV_EMAGENT_PERL_TRACE_LEVEL);
        if (string4 != null) {
            ((Hashtable)properties).put("ENVEMAGENT_PERL_TRACE_LEVEL", string4);
        }
        String string5 = null;
        string5 = System.getProperty(ENV_SYSTEMROOT);
        if (string5 != null) {
            ((Hashtable)properties).put("ENVSYSTEMROOT", string5);
        }
        this.setTargetInstanceSpecificEnvVar(target, properties, TNS_ADMIN);
        this.setTargetInstanceSpecificEnvVar(target, properties, ENV_CRS_HOME);
        this.setTargetInstanceSpecificEnvVar(target, properties, ENV_PROP_ORACLE_HOME);
        this.setTargetInstanceSpecificEnvVar(target, properties, ENV_USER_ORACLE_HOME);
        this.setTargetInstanceSpecificEnvVar(target, properties, ENV_COMSPEC);
        this.setTargetInstanceSpecificEnvVar(target, properties, ENV_EMSTATE);
        this.setTargetInstanceSpecificEnvVar(target, properties, ENV_TZ);
        this.setTargetInstanceSpecificEnvVar(target, properties, "WL_HOME");
        this.setTargetInstanceSpecificEnvVar(target, properties, "BEA_HOME");
        this.setTargetInstanceSpecificEnvVar(target, properties, "ORACLE_INSTANCE");
        this.setTargetInstanceSpecificEnvVar(target, properties, "CCR_DESIGNATED_COLLECTOR_IS_COLLECTING_OTHER_HOMES");
        this.setTargetInstanceSpecificEnvVar(target, properties, "CCR_CENTRAL_PROPERTIES_CCH_FOR_COLLECTOR_IN_OH");
        if (System.getProperty("CCR_I_AM_CENTRAL_COLLECTOR") != null) {
            ((Hashtable)properties).put("ENVCCR_I_AM_CENTRAL_COLLECTOR", "true");
        }
        ((Hashtable)properties).put("ENVAGENT_HOME", "0");
        String string6 = null;
        string6 = System.getProperty(ENV_AGENTPROXYHOME);
        if (string6 != null) {
            ((Hashtable)properties).put("ENVAGENTPROXYHOME", string6);
        }
        String string7 = null;
        string7 = System.getProperty(ENV_JDBC_OCI_SWITCH);
        if (string7 != null) {
            ((Hashtable)properties).put("ENVJDBC_OCI_SWITCH", string7);
        }
    }

    private void setTargetInstanceSpecificEnvVar(Target target, Properties properties, String string) {
        String string2 = target.getTargetHomeSpecificPropterty(string);
        if (string2 == null) {
            string2 = System.getProperty(string);
        }
        if (string2 != null) {
            ((Hashtable)properties).put(ENV_PREFIX + string, string2);
        }
    }

    private void getCustomEnvProperties(Properties properties, Target target) throws FetchletException {
        String string = null;
        try {
            string = PluginsMetadata.getPluginId((String)target.getTargetType());
        }
        catch (RuntimeException runtimeException) {
            throw new FetchletException("Error reading plugins metadata for type \"" + target.getTargetType() + "\". " + runtimeException.getMessage(), runtimeException);
        }
        String string2 = System.getProperty(ENV_PROP_PERL5LIB);
        String string3 = FileSpec.catfile((String[])new String[]{Collector.getCCRRoot(), UplinkPath.getDiscoverPath((String)string)});
        String string4 = FileSpec.catfile((String[])new String[]{Collector.getCCRRoot(), UplinkPath.getScriptsPath((String)string)});
        String string5 = FileSpec.catfile((String[])new String[]{Collector.getCCRRoot(), UplinkPath.getDiscoverPath((String)"default")});
        String string6 = FileSpec.catfile((String[])new String[]{Collector.getCCRRoot(), UplinkPath.getScriptsPath((String)"default")});
        String string7 = System.getProperty("path.separator");
        string2 = string.equals("ocm") ? System.getProperty(ENV_PROP_PERL5LIB) + string7 + string3 + string7 + string4 : (string.equals("default") ? System.getProperty(ENV_PROP_PERL5LIB) + string7 + string5 + string7 + string6 : System.getProperty(ENV_PROP_PERL5LIB) + string7 + string5 + string7 + string6 + string7 + string4);
        if (string2 != null) {
            ((Hashtable)properties).put("ENVPERL5LIB", string2);
        }
    }

    private void addValidIfs() throws SAXException {
        NodeList nodeList = this.m_elementQD.getElementsByTagName("ValidIf");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            this.m_ValidIfList.add(new ValidIf((Element)node));
        }
    }

    private void addProperties() throws SAXException {
        NodeList nodeList = this.m_elementQD.getElementsByTagName("Property");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                this.addProperty(new Property((Element)node));
                continue;
            }
            if (!s_log.isEnabledFor(Logger.DEBUG)) continue;
            s_log.debug((Object)"Encountered a non-element Property node");
        }
    }

    public String getFetchletId() {
        return this.m_fetchletId;
    }

    public void addProperty(Property property) {
        this.m_properties.add(property);
    }

    public MetricResult collect(Target target, boolean bl) throws FetchletException {
        Fetchlet fetchlet = this.getFetchletInstance();
        Properties properties = new Properties();
        if (bl) {
            this.getDefaultProperties(properties, target);
            this.getDefaultEnvProperties(target, properties);
            this.getCustomEnvProperties(properties, target);
        }
        if (!this.getProperties(properties, target)) {
            return null;
        }
        return fetchlet.getMetric(properties);
    }

    public MetricResult collect(Target target) throws FetchletException {
        return this.collect(target, true);
    }

    private boolean getProperties(Properties properties, Target target) throws FetchletException {
        String string = null;
        try {
            string = PluginsMetadata.getPluginId((String)target.getTargetType());
        }
        catch (RuntimeException runtimeException) {
            throw new FetchletException("Error reading plugins metadata for type \"" + target.getTargetType() + "\". " + runtimeException.getMessage(), runtimeException);
        }
        String string2 = FileSpec.catfile((String[])new String[]{Collector.getCCRRoot(), UplinkPath.getScriptsPath((String)string)});
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("scriptsDir", string2);
        Config config = UplinkHomeConfig.getInstance();
        for (int i = 0; i < this.m_properties.size(); ++i) {
            Property property = (Property)this.m_properties.get(i);
            String string3 = property.getName();
            String string4 = property.getContents();
            this.logDuplicateEncountered(properties, string4);
            String string5 = null;
            switch (property.getScopeId()) {
                case 3: {
                    string5 = config.getProperty(string4);
                    if (string5 == null) {
                        string5 = (String)hashMap.get(string4);
                    }
                    if (string5 != null) break;
                    throw new FetchletException("Unable to locate Oracle Configuration Manager SYSTEMGLOBAL property " + string4);
                }
                case 1: {
                    string5 = target.getTargetProperty(string4);
                    break;
                }
                case 4: {
                    TargetManager targetManager = TargetManager.getInstance();
                    Target target2 = null;
                    Target[] targetArray = targetManager.getTargetInstances("host");
                    for (int j = 0; j < targetArray.length; ++j) {
                        if (!target.getTargetHost().equals(targetArray[j].getTargetName())) continue;
                        target2 = targetArray[j];
                        break;
                    }
                    if (target2 == null) {
                        throw new FetchletException("Unable to locate Oracle Configuration Manager HOST scope property " + string4 + " for target " + target.getTargetName());
                    }
                    string5 = target2.getTargetProperty(string4);
                    break;
                }
                case 0: 
                case 7: {
                    string5 = string4;
                    break;
                }
                default: {
                    throw new FetchletException("Unsupported QueryDescriptor (" + property.getScopeId() + ") encountered");
                }
            }
            if (string5 != null) {
                string4 = this.replaceVariables(string5, properties, target);
                ((Hashtable)properties).put(string3, string4);
            }
            if (null != string5) continue;
            if (property.isOptional()) {
                ((Hashtable)properties).put(string3, "");
                continue;
            }
            return false;
        }
        return true;
    }

    private void logDuplicateEncountered(Properties properties, String string) {
        if (((Hashtable)properties).containsKey(string) && s_log.isEnabledFor(Logger.WARN)) {
            s_log.warn(TargetsMetadataMsgID.DUPLICATE_QUERY_DESCRIPTOR, (Object[])new String[]{string});
        }
    }

    private Fetchlet getFetchletInstance() throws FetchletException {
        FetchletManager fetchletManager = null;
        try {
            fetchletManager = FetchletManager.getInstance();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FetchletException("Unable to load fetchlets registry", fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new FetchletException("Error in reading fetchlet registry", iOException);
        }
        return fetchletManager.getFetchlet(this.getFetchletId());
    }

    private String getReplacementForProperty(String string, Properties properties, Target target) {
        String string2 = (String)((Hashtable)properties).get(string);
        if (string2 != null || (string2 = target.getTargetProperty(string)) != null || (string2 = UplinkHomeConfig.getInstance().getProperty(string)) == null) {
            // empty if block
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String replaceVariables(String string, Properties properties, Target target) throws FetchletException {
        int n = 0;
        String string2 = string;
        RE rE = m_varExpression;
        synchronized (rE) {
            while (m_varExpression.match(string2, n)) {
                String string3 = m_varExpression.getParen(0);
                String string4 = m_varExpression.getParen(1);
                String string5 = this.getReplacementForProperty(string4, properties, target);
                if (string5 != null) {
                    RE rE2 = null;
                    try {
                        rE2 = new RE(string3);
                        string2 = rE2.subst(string2, string5);
                    }
                    catch (RESyntaxException rESyntaxException) {
                        throw new FetchletException("Invalid variable name encountered in the variable substitution (" + string3 + ")");
                    }
                    n = m_varExpression.getParenStart(0) + string5.length();
                    continue;
                }
                n = m_varExpression.getParenEnd(0);
            }
        }
        return string2;
    }

    public boolean isElementValid(Target target) throws SAXException {
        return this.m_ValidIfList.isValid(target);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            s_propMatch = new RE("^([^=]*)=(.*)$");
            m_varExpression = new RE("%([^%]+)%");
        }
        catch (RESyntaxException rESyntaxException) {
            throw new RuntimeException("Error with creating regular expression - " + rESyntaxException.getMessage());
        }
    }
}

