/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.targets.metadata;

import java.io.Serializable;
import java.util.Vector;
import oracle.sysman.ccr.collector.targets.metadata.ColumnDescriptor;
import oracle.sysman.ccr.collector.targets.metadata.CustomTableMapper;
import oracle.sysman.ccr.collector.targets.metadata.Metric;
import oracle.sysman.ccr.common.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TableDescriptor
implements Serializable {
    private static final long serialVersionUID = 2415265895404834949L;
    private static Logger s_log = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$targets$metadata$TableDescriptor == null ? (class$oracle$sysman$ccr$collector$targets$metadata$TableDescriptor = TableDescriptor.class$("oracle.sysman.ccr.collector.targets.metadata.TableDescriptor")) : class$oracle$sysman$ccr$collector$targets$metadata$TableDescriptor));
    static final String TAGNAME = "TableDescriptor";
    static final String ATTR_TABLE_NAME = "TABLE_NAME";
    static final String ATTR_SKIP_TARGET_COLUMN = "SKIP_TARGET_COLUMN";
    static final String ATTR_SKIP_METRIC_COLUMN = "SKIP_METRIC_COLUMN";
    static final String ATTR_SKIP_COLLTIME_PK = "SKIP_COLLTIME_PK";
    static final String ATTR_SKIP_COLLTIME_COLUMN = "SKIP_COLLTIME_COLUMN";
    static final String ATTR_CMDB_PACKAGE_NAME = "PACKAGE_NAME";
    static final String ATTR_CMDB_TYPE_NAME = "TYPE_NAME";
    static final String ATTR_CMDB_MODEL_TYPE = "MODEL_TYPE";
    private Vector m_colDescs = null;
    private CustomTableMapper m_customTableMapper = null;
    private boolean m_hasKeyColumn = false;
    private boolean m_hasComputedColumn = false;
    private String m_tableName = null;
    private String m_cmdbPkgName = null;
    private String m_cmdbTypeName = null;
    private String m_cmdbModelType = null;
    private boolean m_bSkipTargetColumn = false;
    private boolean m_bSkipMetricColumn = false;
    private boolean m_bSkipCollTimeColumn = false;
    private boolean m_bSkipCollTimePK = false;
    private transient Metric m_metricRef = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$targets$metadata$TableDescriptor;

    public String getTableName() {
        return this.m_tableName;
    }

    public TableDescriptor(Element element) throws SAXException {
        if (!element.getNodeName().equals(TAGNAME)) {
            throw new SAXException("Invalid element node passed to constructor, not TableDescriptor");
        }
        this.m_tableName = element.getAttribute(ATTR_TABLE_NAME);
        String string = null;
        if (element.hasAttribute(ATTR_SKIP_TARGET_COLUMN)) {
            string = element.getAttribute(ATTR_SKIP_TARGET_COLUMN);
            this.m_bSkipTargetColumn = Boolean.valueOf(string);
        }
        if (element.hasAttribute(ATTR_CMDB_PACKAGE_NAME)) {
            this.m_cmdbPkgName = element.getAttribute(ATTR_CMDB_PACKAGE_NAME);
        }
        if (element.hasAttribute(ATTR_CMDB_TYPE_NAME)) {
            this.m_cmdbTypeName = element.getAttribute(ATTR_CMDB_TYPE_NAME);
        }
        if (element.hasAttribute(ATTR_CMDB_MODEL_TYPE)) {
            this.m_cmdbModelType = element.getAttribute(ATTR_CMDB_MODEL_TYPE);
        }
        if (element.hasAttribute(ATTR_SKIP_METRIC_COLUMN)) {
            string = element.getAttribute(ATTR_SKIP_METRIC_COLUMN);
            this.m_bSkipMetricColumn = Boolean.valueOf(string);
        }
        if (element.hasAttribute(ATTR_SKIP_COLLTIME_COLUMN)) {
            string = element.getAttribute(ATTR_SKIP_COLLTIME_COLUMN);
            this.m_bSkipCollTimeColumn = Boolean.valueOf(string);
        }
        if (element.hasAttribute(ATTR_SKIP_COLLTIME_PK)) {
            string = element.getAttribute(ATTR_SKIP_COLLTIME_PK);
            this.m_bSkipCollTimePK = Boolean.valueOf(string);
        }
        NodeList nodeList = element.getElementsByTagName("ColumnDescriptor");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.addColDesc(new ColumnDescriptor((Element)nodeList.item(i)));
        }
        NodeList nodeList2 = element.getElementsByTagName("CustomTableMapper");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            CustomTableMapper customTableMapper = new CustomTableMapper((Element)nodeList2.item(i));
            if (!customTableMapper.isMidTierValid()) continue;
            this.m_customTableMapper = customTableMapper;
            break;
        }
        if (this.m_customTableMapper != null) {
            this.m_tableName = this.m_customTableMapper.getTableName();
            s_log.debug((Object)("Valid CustomTableMapper found with REP_TABLE_NAME = " + this.m_tableName));
            this.mapColumns();
        }
    }

    public TableDescriptor(String string) {
        this.m_tableName = string;
    }

    public void addColumnDesc(ColumnDescriptor columnDescriptor) {
        try {
            this.addColDesc(columnDescriptor);
        }
        catch (SAXException sAXException) {
            s_log.debug((Object)("Adding Column Descriptor error:" + sAXException.getMessage()));
        }
    }

    private void mapColumns() {
        for (int i = 0; i < this.m_colDescs.size(); ++i) {
            ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.m_colDescs.elementAt(i);
            String string = columnDescriptor.getColumnName();
            String string2 = this.m_customTableMapper.getMappedColumnName(string);
            if (string2 != null) {
                s_log.debug((Object)("Mapping column " + string + " to " + string2));
                columnDescriptor.setColumnName(string2);
                continue;
            }
            columnDescriptor.setEnabledStatus(false);
        }
    }

    private void addColDesc(ColumnDescriptor columnDescriptor) throws SAXException {
        if (this.m_colDescs == null) {
            this.m_colDescs = new Vector();
        }
        this.m_colDescs.addElement(columnDescriptor);
        if (columnDescriptor.isKey()) {
            if (this.m_hasKeyColumn && this.m_metricRef != null && this.m_metricRef.getTypeId() == 2 && this.m_metricRef.getUsageTypeId() != 1 && this.m_metricRef.getUsageTypeId() != 2) {
                throw new SAXException("Support for tables with multiple key columns not yet available");
            }
            if (columnDescriptor.isTransient() || columnDescriptor.isComputed()) {
                throw new SAXException("Key columns cannot be transient or computed");
            }
            this.m_hasKeyColumn = true;
        }
        if (columnDescriptor.isComputed()) {
            this.m_hasComputedColumn = true;
        } else if (this.m_hasComputedColumn) {
            throw new SAXException("Computed columns can be specified only after other columns");
        }
    }

    public Vector getColDescs() {
        return this.m_colDescs;
    }

    public boolean hasKeyColumn() {
        return this.m_hasKeyColumn;
    }

    public boolean hasComputedColumn() {
        return this.m_hasComputedColumn;
    }

    public void setMetricRef(Metric metric) {
        this.m_metricRef = metric;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TableDescriptor)) {
            return false;
        }
        TableDescriptor tableDescriptor = (TableDescriptor)object;
        if (this.m_bSkipCollTimeColumn != tableDescriptor.m_bSkipCollTimeColumn || this.m_bSkipCollTimePK != tableDescriptor.m_bSkipCollTimePK || this.m_bSkipMetricColumn != tableDescriptor.m_bSkipMetricColumn || this.m_bSkipTargetColumn != tableDescriptor.m_bSkipTargetColumn || this.m_hasComputedColumn != tableDescriptor.m_hasComputedColumn || this.m_hasKeyColumn != tableDescriptor.m_hasKeyColumn || !this.m_tableName.equals(tableDescriptor.m_tableName)) {
            return false;
        }
        if (this.m_customTableMapper != null) {
            if (tableDescriptor.m_customTableMapper == null) {
                return false;
            }
            if (!this.m_customTableMapper.equals(tableDescriptor.m_customTableMapper)) {
                return false;
            }
        }
        if (this.m_colDescs != null) {
            if (tableDescriptor.m_colDescs == null) {
                return false;
            }
            if (this.m_colDescs.size() != tableDescriptor.m_colDescs.size()) {
                return false;
            }
            for (int i = 0; i < this.m_colDescs.size(); ++i) {
                ColumnDescriptor columnDescriptor;
                ColumnDescriptor columnDescriptor2 = (ColumnDescriptor)this.m_colDescs.get(i);
                if (columnDescriptor2.equals(columnDescriptor = (ColumnDescriptor)tableDescriptor.m_colDescs.get(i))) continue;
                return false;
            }
        } else if (tableDescriptor.m_colDescs != null) {
            return false;
        }
        return true;
    }

    public boolean isCmdbConfigurationItem() {
        return this.m_cmdbPkgName != null && this.m_cmdbTypeName != null && this.m_cmdbModelType != null;
    }

    public String getCmdbPackageName() {
        return this.m_cmdbPkgName;
    }

    public String getCmdbTypeName() {
        return this.m_cmdbTypeName;
    }

    public String getCmdbModelType() {
        return this.m_cmdbModelType;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

