/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.targets.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.targets.Target;
import oracle.sysman.ccr.collector.targets.metadata.Display;
import oracle.sysman.ccr.collector.targets.metadata.DynamicProperties;
import oracle.sysman.ccr.collector.targets.metadata.InstanceProperty;
import oracle.sysman.ccr.collector.targets.metadata.Metric;
import oracle.sysman.ccr.collector.targets.metadata.TargetsMetadataMsgID;
import oracle.sysman.ccr.collector.targets.metadata.ValiditySelectorList;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.PluginsMetadata;
import oracle.sysman.ccr.util.UplinkPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TargetMetadata {
    private static Logger s_log = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$targets$metadata$TargetMetadata == null ? (class$oracle$sysman$ccr$collector$targets$metadata$TargetMetadata = TargetMetadata.class$("oracle.sysman.ccr.collector.targets.metadata.TargetMetadata")) : class$oracle$sysman$ccr$collector$targets$metadata$TargetMetadata));
    private static MessageBundle s_bundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.targets.metadata.TargetsMetadata");
    private String m_strTargetType = null;
    private String m_metadataVersion = null;
    private Element m_elementMetadataRoot = null;
    private HashMap m_hashConfigMetrics = null;
    private HashMap m_typeProperties = null;
    private Vector m_dynamicProps = null;
    private Vector m_instanceProps = null;
    private Display m_displayNode = null;
    private boolean m_bCollectedAcrossNodes = false;
    private static final String ATTR_META_VER = "META_VER";
    private static final String ATTR_OCM_GC_MERGED = "OCM_GC_MERGED";
    protected static final String XML_ATTR_AGENT_MODE = "AGENT_MODE";
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$targets$metadata$TargetMetadata;

    public TargetMetadata(String string) throws SAXException, FileNotFoundException {
        this(string, false);
    }

    public TargetMetadata(String string, boolean bl) throws SAXException, FileNotFoundException {
        this.m_strTargetType = string;
        if (s_log.isEnabledFor(Logger.DEBUG)) {
            s_log.debug((Object)("Parsing metadata for \"" + string + "\""));
        }
        this.m_elementMetadataRoot = this.getTargetMetadata(bl);
        this.setDisplayNode();
        this.setTargetMetadataVersion();
        this.m_typeProperties = this.typeProps();
        this.m_dynamicProps = this.dynamicProps();
        this.m_instanceProps = this.instanceProps();
        this.m_hashConfigMetrics = this.configMetricDefns();
    }

    protected static boolean isApplicableForOcm(String string) {
        return Collector.isApplicableForOcm(string);
    }

    private HashMap typeProps() throws SAXException {
        Node node;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NodeList nodeList = this.m_elementMetadataRoot.getElementsByTagName("TypeProperties");
        if (nodeList.getLength() > 0 && (node = nodeList.item(0)).getNodeType() == 1) {
            NodeList nodeList2 = node.getChildNodes();
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node2 = nodeList2.item(i);
                if (node2.getNodeType() != 1 || !node2.getNodeName().equals("TypeProperty")) continue;
                NamedNodeMap namedNodeMap = node2.getAttributes();
                Node node3 = namedNodeMap.getNamedItem("PROPERTY_NAME");
                Node node4 = namedNodeMap.getNamedItem("PROPERTY_VALUE");
                if (node3 == null || node4 == null) continue;
                s_log.debug((Object)("Recording type property (" + node3.getNodeValue() + ", " + node4.getNodeValue() + ") for target type " + this.m_strTargetType));
                hashMap.put(node3.getNodeValue(), node4.getNodeValue());
            }
        }
        return hashMap;
    }

    public boolean getIsUniqueIdReqd() {
        String string = (String)this.m_typeProperties.get("is_unique_id_required");
        return string != null && string.equals("1");
    }

    private Vector instanceProps() throws SAXException {
        Node node;
        Vector<InstanceProperty> vector = new Vector<InstanceProperty>();
        NodeList nodeList = this.m_elementMetadataRoot.getElementsByTagName("InstanceProperties");
        if (nodeList.getLength() > 0 && (node = nodeList.item(0)).getNodeType() == 1) {
            NodeList nodeList2 = node.getChildNodes();
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node2 = nodeList2.item(i);
                if (node2.getNodeType() != 1 || !node2.getNodeName().equals("InstanceProperty")) continue;
                InstanceProperty instanceProperty = new InstanceProperty((Element)node2);
                vector.add(instanceProperty);
            }
        }
        return vector;
    }

    private Vector dynamicProps() throws SAXException {
        Node node;
        Vector<DynamicProperties> vector = new Vector<DynamicProperties>();
        NodeList nodeList = this.m_elementMetadataRoot.getElementsByTagName("InstanceProperties");
        if (nodeList.getLength() > 0 && (node = nodeList.item(0)).getNodeType() == 1) {
            NodeList nodeList2 = node.getChildNodes();
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                DynamicProperties dynamicProperties;
                Node node2 = nodeList2.item(i);
                if (node2.getNodeType() != 1 || !node2.getNodeName().equals("DynamicProperties")) continue;
                NamedNodeMap namedNodeMap = node2.getAttributes();
                Node node3 = namedNodeMap.getNamedItem("PROP_LIST");
                Node node4 = namedNodeMap.getNamedItem(XML_ATTR_AGENT_MODE);
                if (node3 == null || node4 == null || !TargetMetadata.isApplicableForOcm(node4.getNodeValue()) || !(dynamicProperties = new DynamicProperties((Element)node2)).areAllApplicableFetchletIdsSupported()) continue;
                vector.add(dynamicProperties);
            }
        }
        return vector;
    }

    public boolean isMetadataConverged() {
        if (this.m_elementMetadataRoot.hasAttribute(ATTR_OCM_GC_MERGED)) {
            return Boolean.valueOf(this.m_elementMetadataRoot.getAttribute(ATTR_OCM_GC_MERGED));
        }
        return false;
    }

    private void setTargetMetadataVersion() {
        if (this.m_elementMetadataRoot.hasAttribute(ATTR_META_VER)) {
            this.m_metadataVersion = this.m_elementMetadataRoot.getAttribute(ATTR_META_VER);
        } else if (s_log.isEnabledFor(Logger.WARN)) {
            s_log.warn(TargetsMetadataMsgID.META_VER_MISSING, (Object[])new String[]{this.getTypeDisplayString()});
        }
    }

    private Element getTargetMetadata(boolean bl) throws SAXException, FileNotFoundException {
        Element element = null;
        String string = null;
        try {
            string = bl ? "ocm" : PluginsMetadata.getPluginId((String)this.m_strTargetType);
        }
        catch (RuntimeException runtimeException) {
            throw new SAXException("Error reading plugins metadata for type \"" + this.m_strTargetType + "\". " + runtimeException.getMessage(), runtimeException);
        }
        String[] stringArray = new String[]{Collector.getCCRRoot(), UplinkPath.getMetadataPath((String)string), this.m_strTargetType + ".xml"};
        String string2 = FileSpec.catfile((String[])stringArray);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setCoalescing(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            FileInputStream fileInputStream = new FileInputStream(string2);
            InputSource inputSource = new InputSource(fileInputStream);
            inputSource.setSystemId(this.getMetadataSystemId(string));
            Document document = documentBuilder.parse(inputSource);
            fileInputStream.close();
            Document document2 = this.makeNewSimpleDoc(document);
            element = this.findMetadataRoot(document2);
            document = null;
            documentBuilder = null;
            documentBuilderFactory = null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            throw new SAXException("Error reading target metadata file for type " + this.m_strTargetType, iOException);
        }
        catch (SAXException sAXException) {
            throw new SAXException("Error parsing target metadata file for " + this.m_strTargetType, sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException("Error creating DOM document for parsing metadata", parserConfigurationException);
        }
        return element;
    }

    private Document makeNewSimpleDoc(Document document) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document2 = documentBuilder.newDocument();
        Element element = (Element)document.getDocumentElement().cloneNode(false);
        Node node = document2.importNode(element, true);
        document2.appendChild(node);
        NodeList nodeList = document.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2;
            Node node3 = nodeList.item(i);
            if (node3.getNodeType() != 1) continue;
            if ("Metric".equals(node3.getNodeName())) {
                node2 = node3.getAttributes().getNamedItem(XML_ATTR_AGENT_MODE);
                if (node2 == null || !TargetMetadata.isApplicableForOcm(node2.getNodeValue())) continue;
                Node node4 = document2.importNode(node3, true);
                node.appendChild(node4);
                continue;
            }
            if (!"Display".equals(node3.getNodeName()) && !"TypeProperties".equals(node3.getNodeName()) && !"InstanceProperties".equals(node3.getNodeName())) continue;
            node2 = document2.importNode(node3, true);
            node.appendChild(node2);
        }
        return document2;
    }

    private Element findMetadataRoot(Document document) throws SAXException {
        Element element = null;
        NodeList nodeList = document.getChildNodes();
        for (int i = 0; i < nodeList.getLength() && element == null; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals("TargetMetadata")) continue;
            element = (Element)node;
        }
        if (element == null) {
            throw new SAXException("Unable to locate TargetMetadata element.");
        }
        return element;
    }

    private String getMetadataSystemId(String string) throws SAXException {
        String string2 = null;
        try {
            String[] stringArray = new String[]{Collector.getCCRRoot(), UplinkPath.getMetadataPath((String)string)};
            File file = new File(FileSpec.catfile((String[])stringArray));
            string2 = file.toURL().toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            throw new SAXException("Error in constructing URL for metadata SystemID", malformedURLException);
        }
        return string2;
    }

    private HashMap configMetricDefns() throws SAXException {
        HashMap<String, ValiditySelectorList> hashMap = new HashMap<String, ValiditySelectorList>();
        ValiditySelectorList validitySelectorList = null;
        NodeList nodeList = this.m_elementMetadataRoot.getElementsByTagName("Metric");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Metric metric;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("NAME");
            Node node3 = namedNodeMap.getNamedItem("CONFIG");
            Node node4 = namedNodeMap.getNamedItem(XML_ATTR_AGENT_MODE);
            Node node5 = namedNodeMap.getNamedItem("COLLECT_ON_ALL_NODES");
            if (node4 == null || !TargetMetadata.isApplicableForOcm(node4.getNodeValue()) || !(metric = new Metric((Element)node)).isMidTierValid()) continue;
            String string2 = node2.getNodeValue();
            if (hashMap.containsKey(string2)) {
                validitySelectorList = (ValiditySelectorList)hashMap.get(string2);
                validitySelectorList.add(metric);
            } else {
                validitySelectorList = new ValiditySelectorList();
                validitySelectorList.add(metric);
                hashMap.put(string2, validitySelectorList);
            }
            if (node5 == null || !Boolean.valueOf(string = node5.getNodeValue()).booleanValue()) continue;
            this.m_bCollectedAcrossNodes = true;
        }
        return hashMap;
    }

    public boolean supportsConfigMetrics() {
        return this.m_hashConfigMetrics.size() > 0;
    }

    private void setDisplayNode() throws SAXException {
        this.m_displayNode = null;
        NodeList nodeList = this.m_elementMetadataRoot.getChildNodes();
        for (int i = 0; i < nodeList.getLength() && this.m_displayNode == null; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals("Display")) continue;
            this.m_displayNode = new Display((Element)node);
        }
    }

    public String getTypeDisplayString() {
        if (this.m_displayNode != null) {
            return this.m_displayNode.getDisplayName();
        }
        return this.m_strTargetType;
    }

    public String getMetadataVersion() {
        return this.m_metadataVersion;
    }

    public Metric getMetric(String string, Target target) {
        Object var3_3 = null;
        ValiditySelectorList validitySelectorList = (ValiditySelectorList)this.m_hashConfigMetrics.get(string);
        if (validitySelectorList == null) {
            return null;
        }
        return (Metric)validitySelectorList.getValidElement(target);
    }

    public Metric getMetric(String string) {
        Object var2_2 = null;
        ValiditySelectorList validitySelectorList = (ValiditySelectorList)this.m_hashConfigMetrics.get(string);
        if (validitySelectorList == null || validitySelectorList.size() < 1) {
            return null;
        }
        return (Metric)validitySelectorList.get(0);
    }

    public Vector getDynProps() {
        return this.m_dynamicProps;
    }

    public boolean targetTypeCrossesHosts() {
        return this.m_bCollectedAcrossNodes;
    }

    public Vector getInstanceProps() {
        return this.m_instanceProps;
    }

    public InstanceProperty getInstanceProperty(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < this.m_instanceProps.size(); ++i) {
            InstanceProperty instanceProperty = (InstanceProperty)this.m_instanceProps.elementAt(i);
            if (!instanceProperty.getName().equals(string)) continue;
            return instanceProperty;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

