/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.timezone;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TimeZone;
import oracle.sysman.ccr.collector.timezone.TimezoneMsgID;
import oracle.sysman.ccr.collector.util.AgentConfig;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;

public class Timezone {
    private static Timezone s_instance = null;
    public static String FILENAME = "timezones.properties";
    private String m_strSupportedRegion = null;
    private Properties m_properties;
    private String m_strTZDefaultRegion = null;
    private TimeZone m_TZ = null;
    private static int NULL_OFFSET = -999;
    private int m_nOffset = NULL_OFFSET;
    private static Logger s_log = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$timezone$Timezone == null ? (class$oracle$sysman$ccr$collector$timezone$Timezone = Timezone.class$("oracle.sysman.ccr.collector.timezone.Timezone")) : class$oracle$sysman$ccr$collector$timezone$Timezone));
    private static final MessageBundle s_msgBundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.timezone.Timezone");
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$timezone$Timezone;

    public Timezone() {
        this.m_TZ = TimeZone.getDefault();
        this.m_strTZDefaultRegion = this.m_TZ.getID();
        int n = this.m_TZ.getRawOffset() / 1000;
        Calendar calendar = Calendar.getInstance();
        this.m_nOffset = this.m_TZ.getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), calendar.get(14)) / 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timezone getInstance() {
        if (s_instance == null) {
            Class clazz = class$oracle$sysman$ccr$collector$timezone$Timezone == null ? (class$oracle$sysman$ccr$collector$timezone$Timezone = Timezone.class$("oracle.sysman.ccr.collector.timezone.Timezone")) : class$oracle$sysman$ccr$collector$timezone$Timezone;
            synchronized (clazz) {
                if (s_instance == null) {
                    s_instance = new Timezone();
                }
            }
        }
        return s_instance;
    }

    public int getOffset() {
        return this.m_nOffset;
    }

    public String findSupportedRegion(String string) {
        this.m_strSupportedRegion = null;
        if (this.m_properties == null) {
            this.m_properties = this.load();
        }
        if (this.m_properties != null) {
            this.m_strSupportedRegion = (String)((Hashtable)this.m_properties).get(string);
        }
        return this.m_strSupportedRegion;
    }

    public String getSupportedRegion(String string) {
        this.findSupportedRegion(string);
        if (this.m_strSupportedRegion == null) {
            this.m_strSupportedRegion = this.calculateOffsetRegion(this.m_nOffset);
        }
        return this.m_strSupportedRegion;
    }

    public String getSupportedRegion() {
        if (this.m_strSupportedRegion == null) {
            this.m_strSupportedRegion = this.getSupportedRegion(this.m_strTZDefaultRegion);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Supported TZ Region = " + this.m_strSupportedRegion + "\n"));
            }
        }
        return this.m_strSupportedRegion;
    }

    private String calculateOffsetRegion(int n) {
        boolean bl;
        String string = null;
        boolean bl2 = bl = n < 0;
        if (bl) {
            n = -n;
        }
        int n2 = n / 60;
        int n3 = n2 / 60;
        n2 %= 60;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("-");
        } else {
            stringBuffer.append("+");
        }
        if (n3 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n3).append(":");
        if (n2 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n2);
        string = stringBuffer.toString();
        return string;
    }

    public static String getTimezonesFilename() {
        return UplinkPath.omsMode() ? FileSpec.catfile((String[])new String[]{UplinkPath.omsConfigDir(), FILENAME}) : FileSpec.catfile((String[])new String[]{AgentConfig.getCCRRootConfigDir(), UplinkPath.DEFAULT_CONFIG_PATH, FILENAME});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties load() {
        Properties properties = new Properties();
        String string = Timezone.getTimezonesFilename();
        BufferedInputStream bufferedInputStream = null;
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        bufferedInputStream = new BufferedInputStream(fileInputStream);
        properties.load(bufferedInputStream);
        bufferedInputStream.close();
        Object var7_8 = null;
        if (bufferedInputStream == null) return properties;
        try {
            bufferedInputStream.close();
            return properties;
        }
        catch (IOException iOException) {}
        return properties;
        {
            catch (FileNotFoundException fileNotFoundException) {
                s_log.error(TimezoneMsgID.TIMEZONE_DATA_FNF, (Object[])new String[]{string}, (Throwable)fileNotFoundException);
                properties = null;
                Object var7_9 = null;
                if (bufferedInputStream == null) return properties;
                try {
                    bufferedInputStream.close();
                    return properties;
                }
                catch (IOException iOException) {}
                return properties;
            }
            catch (IOException iOException) {
                s_log.error(TimezoneMsgID.TIMEZONE_READERR, (Object[])new String[]{string}, (Throwable)iOException);
                properties = null;
                Object var7_10 = null;
                if (bufferedInputStream == null) return properties;
                try {
                    bufferedInputStream.close();
                    return properties;
                }
                catch (IOException iOException2) {}
                return properties;
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (bufferedInputStream == null) throw throwable;
            try {
                bufferedInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

