/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.gcagent.addon.fetchlet;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.ccr.collector.fetchlets.FetchletException;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.fetchlets.MetricValue;
import oracle.sysman.ccr.collector.fetchlets.ValueRow;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.gcagent.addon.fetchlet.FetchletDiagException;
import oracle.sysman.gcagent.addon.fetchlet.GCFetchletMsgID;
import oracle.sysman.gcagent.addon.fetchlet.InterruptibleFetchlet;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class SQLFetchlet
implements InterruptibleFetchlet {
    private static Logger s_log = Logger.getInstance((Class)(class$oracle$sysman$gcagent$addon$fetchlet$SQLFetchlet == null ? (class$oracle$sysman$gcagent$addon$fetchlet$SQLFetchlet = SQLFetchlet.class$("oracle.sysman.gcagent.addon.fetchlet.SQLFetchlet")) : class$oracle$sysman$gcagent$addon$fetchlet$SQLFetchlet));
    private static MessageBundle s_bundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.fetchlets.GCFetchlet");
    static final String MACHINE_NAME = "MachineName";
    static final String PORT = "Port";
    static final String SID = "SID";
    static final String SERVICE_NAME = "ServiceName";
    static final String OID_REP_SCHEMA_NAME = "OidRepSchemaName";
    static final String ORACLE_HOME = "OracleHome";
    static final String USER_NAME = "UserName";
    static final String PASSWORD = "password";
    static final String ROLE = "Role";
    static final String STATEMENT = "STATEMENT";
    static final String FILE_NAME = "FILENAME";
    static final String NUMROWS = "NUMROWS";
    static final String SQLINPARAM = "SQLINPARAM";
    static final String SQLOUTPARAMPOS = "SQLOUTPARAMPOS";
    static final String SQLOUTPARAMTYPE = "SQLOUTPARAMTYPE";
    static final String TRANSPOSE = "transpose";
    static final String REF_CURSOR = "SQL_CURSOR";
    private static final String ORACLE_JDBC_DRIVER = "oracle.jdbc.OracleDriver";
    private static final String SQL_COMMENT_TOKEN = "--";
    private static final String NEWLINE_TOKEN = System.getProperty("line.separator");
    private Connection m_connection = null;
    private String m_machineName = null;
    private int m_port = -1;
    private String m_sid = null;
    private String m_serviceName = null;
    private String m_oidRepSchemaName = null;
    private String m_oracleHome = null;
    private String m_userName = null;
    private String m_password;
    private String m_role = null;
    private String m_statement = null;
    private String m_fileName = null;
    private int m_numRows = -1;
    private Hashtable m_sqlInParam = null;
    private int m_sqlOutParamPos = 0;
    private int m_sqlOutParamType = -1;
    private String m_sqlOutParamTypeStr = null;
    private boolean m_transpose = false;
    static /* synthetic */ Class class$oracle$sysman$gcagent$addon$fetchlet$SQLFetchlet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricResult getMetric(Properties properties) throws FetchletException {
        MetricResult metricResult;
        MetricResult metricResult2 = null;
        if (s_log.isEnabledFor(Logger.DEBUG)) {
            s_log.debug((Object)"SQLFetchlet: getMetric() invoked.");
        }
        try {
            if (s_log.isEnabledFor(Logger.DEBUG)) {
                s_log.debug((Object)"Retrieving input params.");
            }
            this.getInputParams(properties);
            if (s_log.isEnabledFor(Logger.DEBUG)) {
                s_log.debug((Object)"Connecting to the database.");
            }
            this.getConnection();
            if (s_log.isEnabledFor(Logger.DEBUG)) {
                s_log.debug((Object)"Executing SQL statement.");
            }
            metricResult = metricResult2 = this.runQuery();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                if (this.m_connection != null) {
                    this.m_connection.close();
                }
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        try {
            if (this.m_connection != null) {
                this.m_connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return metricResult;
    }

    private void getInputParams(Properties properties) throws FetchletException {
        block25: {
            String string;
            this.m_machineName = properties.getProperty(MACHINE_NAME);
            if (this.m_machineName == null) {
                try {
                    this.m_machineName = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    String string2 = s_bundle.getMessage(GCFetchletMsgID.MISSING_PARAM, false, (Object[])new String[]{"\"MachineName\""});
                    throw new FetchletException(string2 + ":" + unknownHostException.getMessage());
                }
            }
            try {
                string = properties.getProperty(PORT);
                if (string == null) {
                    String string3 = s_bundle.getMessage(GCFetchletMsgID.MISSING_PARAM, false, (Object[])new String[]{"\"Port\""});
                    throw new FetchletDiagException(string3, 0);
                }
                this.m_port = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                String string4 = s_bundle.getMessage(GCFetchletMsgID.INVALID_VALUE, false, (Object[])new String[]{"\"" + properties.getProperty(PORT) + "\"", "\"Port\""});
                throw new FetchletException(string4, numberFormatException);
            }
            this.m_serviceName = properties.getProperty(SERVICE_NAME);
            this.m_userName = properties.getProperty(USER_NAME);
            if (this.m_userName == null) {
                string = s_bundle.getMessage(GCFetchletMsgID.MISSING_PARAM, false, (Object[])new String[]{"\"UserName\""});
                throw new FetchletDiagException(string, 0);
            }
            this.m_password = properties.getProperty(PASSWORD);
            if (this.m_password == null) {
                string = s_bundle.getMessage(GCFetchletMsgID.MISSING_PARAM, false, (Object[])new String[]{"\"password\""});
                throw new FetchletDiagException(string, 0);
            }
            string = properties.getProperty(TRANSPOSE);
            if (string != null && string.toLowerCase().equals("true")) {
                this.m_transpose = true;
            }
            this.m_statement = properties.getProperty(STATEMENT);
            this.m_fileName = properties.getProperty(FILE_NAME);
            this.m_sid = properties.getProperty(SID);
            if (this.m_sid == null && this.m_serviceName == null) {
                String string5 = s_bundle.getMessage(GCFetchletMsgID.MISSING_BOTH_PARAMS, false, (Object[])new String[]{"\"SID\"", "\"ServiceName\""});
                throw new FetchletDiagException(string5, 0);
            }
            this.m_role = properties.getProperty(ROLE);
            if (this.m_statement == null && this.m_fileName == null) {
                String string6 = s_bundle.getMessage(GCFetchletMsgID.MISSING_BOTH_PARAMS, false, (Object[])new String[]{"\"STATEMENT\"", "\"FILENAME\""});
                throw new FetchletException(string6);
            }
            String string7 = null;
            try {
                string7 = properties.getProperty(NUMROWS);
                this.m_numRows = string7 != null ? Integer.parseInt(string7) : Integer.MAX_VALUE;
            }
            catch (NumberFormatException numberFormatException) {
                String string8 = s_bundle.getMessage(GCFetchletMsgID.INVALID_VALUE, false, (Object[])new String[]{"\"" + string7 + "\"", "\"NUMROWS\""});
                throw new FetchletException(string8, numberFormatException);
            }
            try {
                this.m_sqlOutParamPos = Integer.parseInt(properties.getProperty(SQLOUTPARAMPOS));
                this.m_sqlOutParamTypeStr = properties.getProperty(SQLOUTPARAMTYPE).toUpperCase();
                if (this.m_sqlOutParamTypeStr != null) {
                    this.m_sqlOutParamType = this.m_sqlOutParamTypeStr.equals(REF_CURSOR) ? -10 : 2003;
                    break block25;
                }
                String string9 = s_bundle.getMessage(GCFetchletMsgID.INVALID_VALUE, false, (Object[])new String[]{"\"" + this.m_sqlOutParamTypeStr + "\"", "\"SQLOUTPARAMTYPE\""});
                throw new FetchletException(string9);
            }
            catch (NumberFormatException numberFormatException) {
                this.m_sqlOutParamPos = 0;
            }
        }
        if (this.m_sqlInParam == null) {
            this.m_sqlInParam = new Hashtable();
        }
        int n = 0;
        int n2 = 0;
        Iterator iterator = null;
        try {
            iterator = ((Hashtable)properties).keySet().iterator();
            if (iterator == null) {
                throw new FetchletException("Property set is null.");
            }
        }
        catch (Exception exception) {
            throw new FetchletException("SQLFetchlet: Error in extracting the property set. " + exception.getMessage());
        }
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            if (!string.startsWith(SQLINPARAM)) continue;
            try {
                n2 = Integer.parseInt(string.substring(SQLINPARAM.length()));
            }
            catch (Exception exception) {
                continue;
            }
            if (n2 <= n) continue;
            n = n2;
        }
        for (int i = 1; i <= n; ++i) {
            if (i == this.m_sqlOutParamPos) continue;
            if (((Hashtable)properties).containsKey(SQLINPARAM + i)) {
                this.m_sqlInParam.put(Integer.toString(i), properties.getProperty(SQLINPARAM + i));
                continue;
            }
            this.m_sqlInParam.put(Integer.toString(i), "");
        }
    }

    private void getConnection() throws FetchletException {
        String string = null;
        if (this.m_serviceName != null) {
            string = "jdbc:oracle:thin:@" + this.m_machineName + ":" + this.m_port + "/" + this.m_serviceName;
        } else if (this.m_sid != null) {
            string = "jdbc:oracle:thin:@" + this.m_machineName + ":" + this.m_port + ":" + this.m_sid;
        } else {
            String string2 = s_bundle.getMessage(GCFetchletMsgID.MISSING_BOTH_PARAMS, false, (Object[])new String[]{"\"SID\"", "\"ServiceName\""});
            throw new FetchletException(string2);
        }
        try {
            if (s_log.isEnabledFor(Logger.DEBUG)) {
                s_log.debug((Object)("SQLFetchlet: Connecting to URL: " + string + " as user: " + this.m_userName));
            }
            Class<?> clazz = Class.forName(ORACLE_JDBC_DRIVER);
            Properties properties = new Properties();
            ((Hashtable)properties).put("user", this.m_userName);
            ((Hashtable)properties).put(PASSWORD, this.m_password);
            this.m_password = null;
            if (this.m_role != null) {
                ((Hashtable)properties).put("internal_logon", this.m_role);
            }
            this.m_connection = DriverManager.getConnection(string, properties);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string3 = s_bundle.getMessage(GCFetchletMsgID.CLASS_NOT_FOUND, false, (Object[])new String[]{"\"oracle.jdbc.OracleDriver\""});
            throw new FetchletException(string3, classNotFoundException);
        }
        catch (SQLException sQLException) {
            String string4 = s_bundle.getMessage(GCFetchletMsgID.DB_CONNECT_ERR, false, (Object[])new String[]{"\"" + this.m_userName + "\""});
            if (sQLException.getErrorCode() == 1017 || sQLException.getErrorCode() == 28000 || sQLException.getErrorCode() == 28001) {
                throw new FetchletDiagException(string4 + ":" + sQLException.getMessage(), 2);
            }
            throw new FetchletException(string4, sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MetricResult runQuery() throws FetchletException {
        MetricResult metricResult2;
        Statement statement = null;
        Statement statement2 = null;
        ResultSet resultSet = null;
        MetricResult metricResult = null;
        try {
            try {
                if (this.m_sqlOutParamPos == 0) {
                    if (this.m_statement == null) {
                        if (s_log.isEnabledFor(Logger.DEBUG)) {
                            s_log.debug((Object)("Running SQL query from external file: " + this.m_fileName));
                        }
                        this.m_statement = this.getExternalSQL(false);
                    }
                    if (s_log.isEnabledFor(Logger.DEBUG)) {
                        s_log.debug((Object)("Running SQL statement: " + this.m_statement));
                    }
                    statement = this.m_connection.prepareStatement(this.m_statement);
                    this.setInputParams((PreparedStatement)statement);
                    resultSet = statement.executeQuery();
                    if (s_log.isEnabledFor(Logger.DEBUG)) {
                        s_log.debug((Object)"Converting resultset into MetricResult.");
                    }
                    metricResult = this.formMetricResult(resultSet);
                } else {
                    if (this.m_statement == null) {
                        if (s_log.isEnabledFor(Logger.DEBUG)) {
                            s_log.debug((Object)("Running PL/SQL query from external file: " + this.m_fileName));
                        }
                        this.m_statement = this.getExternalSQL(true);
                    }
                    if (s_log.isEnabledFor(Logger.DEBUG)) {
                        s_log.debug((Object)("Running PL/SQL statement: " + this.m_statement));
                    }
                    statement2 = this.m_connection.prepareCall(this.m_statement);
                    if (this.m_sqlOutParamType == 2003) {
                        if (s_log.isEnabledFor(Logger.DEBUG)) {
                            s_log.debug((Object)("Register output parameter as an SQL Array of type: " + this.m_sqlOutParamTypeStr + " at position: " + this.m_sqlOutParamPos));
                        }
                        statement2.registerOutParameter(this.m_sqlOutParamPos, this.m_sqlOutParamType, this.m_sqlOutParamTypeStr);
                    } else {
                        if (s_log.isEnabledFor(Logger.DEBUG)) {
                            s_log.debug((Object)("Register output parameter as an SQL CURSOR at position: " + this.m_sqlOutParamPos));
                        }
                        statement2.registerOutParameter(this.m_sqlOutParamPos, this.m_sqlOutParamType);
                    }
                    this.setInputParams((PreparedStatement)statement2);
                    statement2.execute();
                    if (this.m_sqlOutParamType == 2003) {
                        if (s_log.isEnabledFor(Logger.DEBUG)) {
                            s_log.debug((Object)"Converting SQL Array object into MetricResult.");
                        }
                        metricResult = this.formMetricResult(statement2.getArray(this.m_sqlOutParamPos));
                    } else if (this.m_sqlOutParamType == -10) {
                        if (s_log.isEnabledFor(Logger.DEBUG)) {
                            s_log.debug((Object)"Converting SQL Cursor into MetricResult.");
                        }
                        metricResult = this.formMetricResult((ResultSet)statement2.getObject(this.m_sqlOutParamPos));
                    }
                }
                metricResult2 = metricResult;
                Object var8_7 = null;
            }
            catch (SQLException sQLException) {
                String string = s_bundle.getMessage(GCFetchletMsgID.SQL_ERROR, false, (Object[])new String[]{"\"" + this.m_statement + "\""});
                throw new FetchletException(string, sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (statement2 == null) throw throwable;
                statement2.close();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return metricResult2;
        }
        if (resultSet != null) {
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (statement2 == null) return metricResult2;
        statement2.close();
        return metricResult2;
    }

    private void setInputParams(PreparedStatement preparedStatement) throws SQLException, FetchletException {
        if (this.m_sqlInParam == null) {
            return;
        }
        String string = this.stripSQLComments();
        if (string.indexOf("?") != -1) {
            Iterator iterator = this.m_sqlInParam.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().toString();
                int n = Integer.parseInt(string2);
                String string3 = (String)this.m_sqlInParam.get(string2);
                if (s_log.isEnabledFor(Logger.DEBUG)) {
                    s_log.debug((Object)("Setting input param by position. Position = " + string2 + " , Value = " + string3));
                }
                preparedStatement.setString(n, string3);
            }
        } else {
            int n;
            Object object;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            Iterator iterator = this.m_sqlInParam.keySet().iterator();
            while (iterator.hasNext()) {
                String string4;
                object = iterator.next().toString();
                int n2 = 0;
                while ((n = string.indexOf(string4 = ":" + (String)object, n2)) != -1) {
                    hashtable.put(Integer.toString(n), object);
                    n2 = n + string4.length();
                }
            }
            object = hashtable.keySet().iterator();
            int[] nArray = new int[hashtable.size()];
            int n3 = 0;
            while (object.hasNext()) {
                nArray[n3++] = Integer.parseInt(object.next().toString());
            }
            Arrays.sort(nArray);
            for (n = 0; n < nArray.length; ++n) {
                int n4 = n + 1;
                String string5 = (String)hashtable.get(Integer.toString(nArray[n]));
                String string6 = (String)this.m_sqlInParam.get(string5);
                if (s_log.isEnabledFor(Logger.DEBUG)) {
                    s_log.debug((Object)("Setting input param by name. Position = " + n4 + ", Var = :" + string5 + ", Value = " + string6));
                }
                preparedStatement.setString(n4, string6);
            }
        }
    }

    private String stripSQLComments() throws FetchletException {
        if (this.m_statement.indexOf(SQL_COMMENT_TOKEN) == -1) {
            return this.m_statement;
        }
        String string = null;
        try {
            RE rE = new RE("--.*" + NEWLINE_TOKEN);
            string = rE.subst(this.m_statement, NEWLINE_TOKEN);
        }
        catch (RESyntaxException rESyntaxException) {
            // empty catch block
        }
        if (string == null) {
            throw new FetchletException("Error stripping SQL comments from statement: " + this.m_statement);
        }
        return string;
    }

    private MetricResult formMetricResult(ResultSet resultSet) throws FetchletException {
        MetricResult metricResult = null;
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            for (int i = 0; resultSet.next() && i != this.m_numRows; ++i) {
                if (metricResult == null) {
                    metricResult = new MetricResult();
                }
                ValueRow valueRow = new ValueRow();
                for (int j = 1; j <= n; ++j) {
                    MetricValue metricValue = new MetricValue(resultSet.getString(j));
                    valueRow.addValue(metricValue);
                }
                metricResult.addValueRow(valueRow);
            }
            if (this.m_transpose) {
                return this.transpose(metricResult);
            }
            return metricResult;
        }
        catch (SQLException sQLException) {
            String string = s_bundle.getMessage(GCFetchletMsgID.SQL_RESULT_ERROR, false);
            throw new FetchletException(string, sQLException);
        }
    }

    private MetricResult formMetricResult(Array array) throws FetchletException {
        MetricResult metricResult = null;
        try {
            ResultSet resultSet = array.getResultSet();
            for (int i = 0; resultSet.next() && i != this.m_numRows; ++i) {
                if (metricResult == null) {
                    metricResult = new MetricResult();
                }
                Struct struct = (Struct)resultSet.getObject(2);
                Object[] objectArray = struct.getAttributes();
                ValueRow valueRow = new ValueRow();
                for (int j = 0; j < objectArray.length; ++j) {
                    MetricValue metricValue = new MetricValue(objectArray[j].toString());
                    valueRow.addValue(metricValue);
                }
                metricResult.addValueRow(valueRow);
            }
            if (this.m_transpose) {
                return this.transpose(metricResult);
            }
            return metricResult;
        }
        catch (SQLException sQLException) {
            String string = s_bundle.getMessage(GCFetchletMsgID.SQL_RESULT_ERROR, false);
            throw new FetchletException(string, sQLException);
        }
    }

    private MetricResult transpose(MetricResult metricResult) {
        MetricResult metricResult2 = null;
        if (metricResult != null) {
            Vector vector = metricResult.getValueRows();
            metricResult2 = new MetricResult();
            ValueRow valueRow = (ValueRow)vector.get(0);
            int n = valueRow.getValues().size();
            for (int i = 0; i < n; ++i) {
                ValueRow valueRow2 = new ValueRow();
                for (int j = 0; j < vector.size(); ++j) {
                    valueRow = (ValueRow)vector.get(j);
                    valueRow2.addValue(valueRow.getMValue(i));
                }
                metricResult2.addValueRow(valueRow2);
            }
        }
        return metricResult2;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getExternalSQL(boolean var1_1) throws FetchletException {
        block19: {
            var2_2 = null;
            var3_3 = null;
            var4_4 = new StringBuffer("");
            try {
                try {
                    var2_2 = new FileReader(this.m_fileName);
                    var3_3 = new BufferedReader(var2_2);
                    var5_5 = null;
                    if (!var1_1) {
                        while ((var5_5 = var3_3.readLine()) != null) {
                            var6_8 = var5_5.indexOf(";");
                            if (var6_8 >= 0) {
                                var4_4 = var4_4.append(SQLFetchlet.NEWLINE_TOKEN).append(var5_5.substring(0, var6_8));
                                break;
                            }
                            var4_4 = var4_4.append(SQLFetchlet.NEWLINE_TOKEN).append(var5_5);
                        }
                    } else {
                        while ((var5_5 = var3_3.readLine()) != null) {
                            if (var5_5.length() <= 0) continue;
                            var4_4 = var4_4.append(SQLFetchlet.NEWLINE_TOKEN).append(var5_5);
                        }
                    }
                    var6_9 = var4_4.toString();
                    var8_12 = null;
                    if (var3_3 == null) break block19;
                }
                catch (FileNotFoundException var5_6) {
                    var6_10 = SQLFetchlet.s_bundle.getMessage(GCFetchletMsgID.FILE_NOT_FOUND, false, (Object[])new String[]{"\"" + this.m_fileName + "\""});
                    throw new FetchletException(var6_10, var5_6);
                }
                catch (IOException var5_7) {
                    var6_11 = SQLFetchlet.s_bundle.getMessage(GCFetchletMsgID.FILE_READ_ERR, false, (Object[])new String[]{"\"" + this.m_fileName + "\""});
                    throw new FetchletException(var6_11, var5_7);
                }
            }
            catch (Throwable var7_16) {
                var8_13 = null;
                if (var3_3 != null) {
                    try {
                        var3_3.close();
                    }
                    catch (IOException var9_15) {
                        // empty catch block
                    }
                }
                if (var2_2 == null) throw var7_16;
                try {
                    var2_2.close();
                    throw var7_16;
                }
                catch (IOException var9_15) {
                    throw var7_16;
                }
            }
            ** try [egrp 2[TRYBLOCK] [4 : 292->299)] { 
lbl52:
            // 1 sources

            var3_3.close();
            break block19;
lbl54:
            // 1 sources

            catch (IOException var9_14) {
                // empty catch block
            }
        }
        if (var2_2 == null) return var6_9;
        try {}
        catch (IOException var9_14) {
            // empty catch block
            return var6_9;
        }
        var2_2.close();
        return var6_9;
    }

    public boolean interruptFetchlet() throws FetchletException {
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

