/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.gcagent.addon.ocheck;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.ccr.collector.fetchlets.FetchletException;
import oracle.sysman.ccr.collector.fetchlets.FetchletMsgID;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.fetchlets.ValueRow;
import oracle.sysman.ccr.collector.targets.Target;
import oracle.sysman.ccr.collector.targets.TargetManager;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;
import oracle.sysman.gcagent.addon.fetchlet.CallerContext;
import oracle.sysman.gcagent.addon.fetchlet.FetchletDiagException;
import oracle.sysman.gcagent.addon.ocheck.DiagCheckerException;
import oracle.sysman.gcagent.addon.ocheck.DiagCheckerMsgID;
import oracle.sysman.gcagent.addon.ocheck.DiagExclusions;
import oracle.sysman.gcagent.addon.ocheck.DiagParser;
import oracle.sysman.gcagent.addon.ocheck.DiagParserException;
import oracle.sysman.gcagent.addon.ocheck.DiagVersionChecker;
import oracle.sysman.gcagent.addon.ocheck.jaxb.diagcheck.Key;
import oracle.sysman.gcagent.addon.ocheck.jaxb.diagcheck.PlatformChoice;
import oracle.sysman.gcagent.addon.ocheck.jaxb.diagcheck.Property;
import oracle.sysman.gcagent.addon.ocheck.jaxb.diagcheck.VerRange;
import oracle.sysman.gcagent.addon.ocheck.jaxb.diaggroup.DiagGroup;
import oracle.sysman.gcagent.addon.ocheck.jaxb.diaggroup.DiagMetadata;
import oracle.sysman.gcagent.addon.ocheck.jaxb.diaggroup.TargetVersionRule;
import oracle.sysman.gcagent.addon.ocheck.ocm.OCMConfigReader;
import oracle.sysman.gcagent.addon.ocheck.ocm.OCMExecuteFetchlet;
import oracle.sysman.gcagent.addon.ocheck.ocm.OCMResultOperations;

public class DiagChecker {
    private static Logger s_log = Logger.getInstance((Class)(class$oracle$sysman$gcagent$addon$ocheck$DiagChecker == null ? (class$oracle$sysman$gcagent$addon$ocheck$DiagChecker = DiagChecker.class$("oracle.sysman.gcagent.addon.ocheck.DiagChecker")) : class$oracle$sysman$gcagent$addon$ocheck$DiagChecker));
    private static MessageBundle s_bundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.fetchlets.Fetchlet");
    private static boolean s_diagErrBackUp = false;
    private List m_timingdata = new ArrayList();
    private Set m_listOfDiagCheckNames = new HashSet();
    private String m_diagCheckErrFile = null;
    private Set m_errorCodes = new HashSet();
    private boolean m_stopFlag = false;
    private int authExOccured = 0;
    static final String DIAGCHECKS_ERRFILE = "diagchecks.err";
    static final String DIAGCHECKS_ERRFILE_BAK = ".bak";
    public static final String USER_SCRIPTS = new String("diagScriptsDir");
    private static final String DIAGCHECKS_DIR = "diagchecks";
    private static final String SCRIPTS_DIR = "scripts";
    private static final String LIB_DIR = "Lib";
    static /* synthetic */ Class class$oracle$sysman$gcagent$addon$ocheck$DiagChecker;

    public MetricResult evalChecks(String string, String string2, String string3, Properties properties, OCMExecuteFetchlet oCMExecuteFetchlet, OCMResultOperations oCMResultOperations) throws DiagCheckerException, DiagParserException {
        String string4;
        String[] stringArray;
        Object object;
        Object object2;
        String string5;
        Target target;
        String string6;
        String string7;
        block46: {
            String string8 = properties.getProperty("ENVCCR_CONFIG_HOME");
            string7 = properties.getProperty("NAME");
            string6 = properties.getProperty("TYPE");
            target = TargetManager.getInstance().getTargetByNameType(string7, string6);
            this.m_diagCheckErrFile = FileSpec.catfile((String[])new String[]{string8, UplinkPath.STATE_PREVIOUS_PATH, DIAGCHECKS_ERRFILE});
            string5 = FileSpec.catfile((String[])new String[]{string8, UplinkPath.STATE_UPLOAD_PATH, properties.getProperty("GUID")});
            String string9 = properties.getProperty("ENVCCR_HOME");
            String string10 = FileSpec.catfile((String[])new String[]{string9, DIAGCHECKS_DIR, SCRIPTS_DIR});
            String string11 = FileSpec.catfile((String[])new String[]{string9, DIAGCHECKS_DIR, SCRIPTS_DIR, LIB_DIR});
            String string12 = FileSpec.catfile((String[])new String[]{string, string3});
            String string13 = string10 + File.pathSeparator + string11 + File.pathSeparator + string12;
            System.setProperty("python.home", string9);
            System.setProperty("python.path", string13);
            if (s_log.isEnabledFor(Logger.DEBUG)) {
                s_log.debug((Object)("python.home set to:" + string9));
                s_log.debug((Object)("python.path set to:" + string13));
            }
            System.setProperty("python.cachedir.skip", "true");
            CallerContext.setContextTarget(string7, string6);
            try {
                DiagChecker.backUpFile(this.m_diagCheckErrFile);
            }
            catch (IOException iOException) {
                if (!s_log.isEnabledFor(Logger.DEBUG)) break block46;
                s_log.debug((Object)"Error backing up file:diagchecks.err");
            }
        }
        DiagMetadata diagMetadata = DiagParser.parseDiagMetadata(string, string2, string3);
        if (diagMetadata == null) {
            return null;
        }
        MetricResult metricResult = new MetricResult();
        List list = null;
        DiagExclusions diagExclusions = DiagParser.parseDiagExclusions(string2, string3);
        if (diagExclusions != null && diagExclusions.isExcludeAll() && s_log.isDebugEnabled()) {
            s_log.debug((Object)("Diagchecks have been disabled for target type: " + string3));
        }
        String string14 = diagMetadata.getVERSION();
        List list2 = DiagParser.getDiagGroups();
        Iterator iterator = list2.iterator();
        String string15 = null;
        String string16 = null;
        String string17 = null;
        TargetVersionRule targetVersionRule = diagMetadata.getTargetVersionRule();
        int n = OCMConfigReader.getPlatformId(string5);
        if (targetVersionRule != null) {
            string16 = targetVersionRule.getVERSIONPROP();
            if (string16 != null) {
                string17 = properties.getProperty(string16);
                if (s_log.isEnabledFor(Logger.DEBUG)) {
                    s_log.debug((Object)("Looking up version for [" + string7 + "," + string6 + "," + string16 + "] : " + string17));
                }
            }
            if (string17 == null && (string15 = targetVersionRule.getCONFIGPATH()) != null) {
                object2 = new StringTokenizer(string15, "/");
                object = new Vector();
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    ((Vector)object).addElement(((StringTokenizer)object2).nextToken());
                }
                stringArray = new String[]{};
                if ((stringArray = ((Vector)object).toArray(stringArray)).length >= 3) {
                    string4 = string5 + "-" + stringArray[0] + ".ser";
                    string17 = OCMConfigReader.getTargetVersion(string4, target, stringArray[0], stringArray[1], stringArray[2]);
                    if (s_log.isEnabledFor(Logger.DEBUG)) {
                        s_log.debug((Object)("Looking up version based on [" + string7 + "," + string6 + "," + string15 + "(" + stringArray[0] + "," + stringArray[1] + "," + stringArray[2] + ")] : " + string17));
                    }
                } else {
                    s_log.warn(DiagCheckerMsgID.INVALID_VERSION_CFGPATH, (Object[])new String[]{string7, string6, string15});
                }
            }
        }
        block10: while (iterator.hasNext()) {
            object2 = (DiagGroup)iterator.next();
            list = DiagParser.getDiagChecks((DiagGroup)object2);
            object = list.iterator();
            while (object.hasNext()) {
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                if (this.m_stopFlag) break block10;
                stringArray = (String[])object.next();
                if (s_log.isEnabledFor(Logger.DEBUG)) {
                    s_log.debug((Object)("DiagChecker [" + string7 + "," + string6 + "," + object2.getNAME() + "," + stringArray.getNAME() + "]"));
                }
                if (this.m_listOfDiagCheckNames.contains(stringArray.getNAME())) {
                    s_log.warn(DiagCheckerMsgID.DUPLICATE_CHECK, (Object[])new String[]{string7, string6, stringArray.getNAME(), object2.getNAME()});
                    continue;
                }
                this.m_listOfDiagCheckNames.add(stringArray.getNAME());
                if (stringArray.getPlatformCheck() != null && this.isNotSupportedPlatform(stringArray.getPlatformCheck().getPlatformChoice(), n)) {
                    s_log.debug((Object)("Skipping DiagCheck [" + string7 + "," + string6 + "," + object2.getNAME() + "," + stringArray.getNAME() + "]: does not match platform " + n));
                    continue;
                }
                if (stringArray.getVersionCheck() != null && this.isNotSupportedTargetVersion(stringArray.getVersionCheck().getVerRange(), string17)) {
                    s_log.debug((Object)("Skipping DiagCheck [" + string7 + "," + string6 + "," + object2.getNAME() + "," + stringArray.getNAME() + "]: does not match tgtver " + string17));
                    continue;
                }
                CallerContext.setContextCheck(stringArray.getNAME());
                string4 = stringArray.getQueryDescriptor().getFETCHLETID();
                List list3 = stringArray.getKeyList().getKey();
                StringBuffer stringBuffer = new StringBuffer("");
                if (list3.isEmpty()) {
                    object6 = stringArray.getNAME() + "_key";
                    list3.add(object6);
                }
                object6 = list3.iterator();
                while (object6.hasNext()) {
                    if (!stringBuffer.toString().equals("")) {
                        stringBuffer = stringBuffer.append(",");
                    }
                    object5 = (Key)object6.next();
                    object4 = object5.getValue();
                    stringBuffer = stringBuffer.append((String)object4);
                }
                ((Hashtable)properties).put(new String("keylist"), stringBuffer.toString());
                if (diagExclusions.isGroupExcluded(object2.getNAME()) || diagExclusions.isCheckExcluded(stringArray.getNAME())) {
                    s_log.debug((Object)("Diagcheck [" + stringArray.getNAME() + "] for target [" + string6 + ", " + string7 + "] skipped because of exclusion."));
                    oCMResultOperations.addExceptionRow(metricResult, stringArray.getNAME(), 1, new String("skipError"), new String("DiagCheck Skipped"));
                    continue;
                }
                if (this.authExOccured != 0 && string4.startsWith("SQL")) {
                    s_log.debug((Object)("Diagcheck [" + stringArray.getNAME() + "] for target [" + string6 + ", " + string7 + "] skipped because of authentication failure."));
                    oCMResultOperations.addExceptionRow(metricResult, stringArray.getNAME(), 1, new String("skip on auth failure"), new String("DiagCheck Skipped as Auth to DB failed."));
                    continue;
                }
                object5 = new Vector();
                object4 = stringArray.getQueryDescriptor().getProperty().iterator();
                while (object4.hasNext()) {
                    String string18;
                    Property property = (Property)object4.next();
                    if (property.getSCOPE().equals("GLOBAL")) {
                        object3 = property.getNAME();
                        string18 = property.getValue();
                        string18 = this.replaceVariables(string18, properties, string4);
                        ((Hashtable)properties).put(object3, string18);
                        if (!s_log.isEnabledFor(Logger.DEBUG)) continue;
                        s_log.debug((Object)("Adding to propList name=" + (String)object3 + ", valueLen=" + (string18 != null ? string18.length() : 0)));
                        continue;
                    }
                    if (!property.getSCOPE().equals("INSTANCE")) continue;
                    object3 = null;
                    string18 = null;
                    String string19 = null;
                    object3 = property.getNAME();
                    string18 = property.getValue();
                    if (string18 != null) {
                        string19 = properties.getProperty(string18);
                    }
                    if (object3 != null && string19 != null) {
                        ((Hashtable)properties).put(object3, string19);
                    } else if (string18 != null && string19 == null && !property.isOPTIONAL()) {
                        ((Vector)object5).addElement(string18);
                    }
                    if (!s_log.isEnabledFor(Logger.DEBUG)) continue;
                    s_log.debug((Object)("Adding to propList name=" + (String)object3 + ", valueLen=" + (string19 != null ? string19.length() : 0)));
                }
                if (!((Vector)object5).isEmpty()) {
                    s_log.warn(FetchletMsgID.MISSING_PROPERTIES, (Object[])new String[]{string7, string6, stringArray.getNAME(), ((Vector)object5).toString()});
                    oCMResultOperations.addExceptionRow(metricResult, stringArray.getNAME(), 0, "Missing properties", ((Vector)object5).toString());
                    try {
                        this.writeToErr(string6 + " " + string7 + " " + 0);
                    }
                    catch (IOException iOException) {
                        s_log.warn(DiagCheckerMsgID.DIAGERR_WRITE_FAILURE, (Object[])new String[]{string7, string6, stringArray.getNAME(), String.valueOf(0)});
                    }
                    continue;
                }
                try {
                    Vector vector;
                    long l = System.currentTimeMillis();
                    if (s_log.isEnabledFor(Logger.DEBUG)) {
                        s_log.debug((Object)("**** STARTED FOR DIAGNOSTIC CHECK **** " + stringArray.getNAME()));
                    }
                    object3 = oCMExecuteFetchlet.executeFetchlet(string4, properties);
                    long l2 = System.currentTimeMillis();
                    long l3 = (l2 - l) / 1000L;
                    if (s_log.isEnabledFor(Logger.DEBUG)) {
                        s_log.debug((Object)("**** ENDED FOR DIAGNOSTIC CHECK **** " + stringArray.getNAME() + " : TIME[ms] : " + l3));
                    }
                    this.m_timingdata.add(stringArray.getNAME());
                    this.m_timingdata.add(new Long(l3));
                    ArrayList<ValueRow> arrayList = new ArrayList<ValueRow>();
                    if (object3 == null) {
                        object3 = new MetricResult();
                    }
                    if ((vector = ((MetricResult)object3).getValueRows()) == null) {
                        vector = new Vector();
                    }
                    Iterator iterator2 = ((AbstractList)vector).iterator();
                    while (iterator2.hasNext()) {
                        ValueRow valueRow = (ValueRow)iterator2.next();
                        String string20 = valueRow.getValue(0);
                        if (list3.contains(string20)) continue;
                        s_log.warn(DiagCheckerMsgID.INVALID_KEY, (Object[])new String[]{string7, string6, stringArray.getNAME(), string20});
                        arrayList.add(valueRow);
                    }
                    vector.removeAll(arrayList);
                    ((MetricResult)object3).setValueRows(vector);
                    oCMResultOperations.addDataRows(metricResult, (MetricResult)object3, stringArray.getNAME());
                }
                catch (FetchletDiagException fetchletDiagException) {
                    s_log.warn(DiagCheckerMsgID.DCHECK_EXCEPTION, (Object[])new String[]{string7, string6, stringArray.getNAME(), String.valueOf(fetchletDiagException.getError()), ((Throwable)((Object)fetchletDiagException)).getMessage()});
                    if (fetchletDiagException.getError() == 0 || fetchletDiagException.getError() == 2) {
                        if (this.m_errorCodes.add(new Integer(fetchletDiagException.getError()))) {
                            try {
                                this.writeToErr(string6 + " " + string7 + " " + fetchletDiagException.getError());
                            }
                            catch (IOException iOException) {
                                s_log.warn(DiagCheckerMsgID.DIAGERR_WRITE_FAILURE, (Object[])new String[]{string7, string6, stringArray.getNAME(), String.valueOf(fetchletDiagException.getError())});
                            }
                        }
                        if (fetchletDiagException.getError() == 2) {
                            this.authExOccured = 1;
                        }
                    }
                    oCMResultOperations.addExceptionRow(metricResult, stringArray.getNAME(), fetchletDiagException.getError(), ((Throwable)((Object)fetchletDiagException)).getMessage(), ((Throwable)((Object)fetchletDiagException)).getMessage());
                }
                catch (FetchletException fetchletException) {
                    s_log.debug((Object)("Error while executing fetchlet for target [" + string6 + ", " + string7 + "]: " + ((Throwable)((Object)fetchletException)).getMessage()), (Throwable)((Object)fetchletException));
                    oCMResultOperations.addExceptionRow(metricResult, stringArray.getNAME(), 5, ((Throwable)((Object)fetchletException)).getMessage(), ((Throwable)((Object)fetchletException)).getMessage());
                }
            }
        }
        return metricResult;
    }

    public void stopChecks() {
        this.m_stopFlag = true;
    }

    public String replaceVariables(String string, Properties properties, String string2) {
        String string3 = string;
        StringBuffer stringBuffer = new StringBuffer("");
        int n = -1;
        while ((n = string3.indexOf("%")) != -1) {
            int n2 = string3.substring(n + 1).indexOf("%");
            int n3 = string3.substring(n + 1).indexOf(" ");
            if (n2 != -1 && (n3 > n2 || n3 == -1)) {
                String string4 = string3.substring(n + 1, n + n2 + 1);
                String string5 = null;
                string5 = (String)((Hashtable)properties).get(string4);
                stringBuffer = string5 != null ? stringBuffer.append(string3.substring(0, n)).append(string5) : stringBuffer.append(string3.substring(0, n + n2 + 2));
                string3 = string3.substring(n + n2 + 2);
                continue;
            }
            stringBuffer = stringBuffer.append(string3.substring(0, n + 1));
            string3 = string3.substring(n + 1);
        }
        stringBuffer = stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    public String getMetadataVersion() {
        return DiagParser.s_version;
    }

    public static void main(String[] stringArray) {
        DiagChecker diagChecker = new DiagChecker();
        OCMExecuteFetchlet oCMExecuteFetchlet = new OCMExecuteFetchlet();
        OCMResultOperations oCMResultOperations = new OCMResultOperations();
        try {
            MetricResult metricResult = diagChecker.evalChecks(stringArray[0], stringArray[1], "host", null, oCMExecuteFetchlet, oCMResultOperations);
        }
        catch (DiagParserException diagParserException) {
        }
        catch (DiagCheckerException diagCheckerException) {
            // empty catch block
        }
    }

    public List getTimingData() {
        return this.m_timingdata;
    }

    public String getTimingDataStr() {
        int n = 0;
        int n2 = 0;
        if (this.m_timingdata != null) {
            n = this.m_timingdata.size();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < n; n2 += 2) {
            String string = (String)this.m_timingdata.get(n2);
            int n3 = ((Long)this.m_timingdata.get(n2 + 1)).intValue();
            stringBuffer.append(string);
            stringBuffer.append(':');
            stringBuffer.append(n3);
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    private static void backUpFile(String string) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        if (s_diagErrBackUp) {
            return;
        }
        s_diagErrBackUp = true;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string + DIAGCHECKS_ERRFILE_BAK));
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            bufferedWriter.write(string2);
            bufferedWriter.newLine();
        }
        BufferedWriter bufferedWriter2 = new BufferedWriter(new FileWriter(file));
        bufferedWriter2.close();
        bufferedReader.close();
        bufferedWriter.close();
        DiagChecker.deleteFile(string);
    }

    private void writeToErr(String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.m_diagCheckErrFile, true));
        bufferedWriter.write(string);
        bufferedWriter.newLine();
        bufferedWriter.close();
    }

    private static boolean deleteFile(String string) throws IOException {
        File file = new File(string);
        return file.delete();
    }

    private boolean isNotSupportedPlatform(List list, int n) {
        boolean bl = true;
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = list.iterator();
        while (object.hasNext()) {
            PlatformChoice platformChoice = (PlatformChoice)object.next();
            arrayList.add(platformChoice.getPLATFORM());
        }
        if (n != 0) {
            object = String.valueOf(n);
            if (list != null && !arrayList.contains(object)) {
                bl = false;
            }
        }
        return !bl;
    }

    private boolean isNotSupportedTargetVersion(List list, String string) {
        String[] stringArray = new String[2];
        boolean bl = false;
        if (list == null || list.isEmpty()) {
            return false;
        }
        if (string == null) {
            return true;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            VerRange verRange = (VerRange)iterator.next();
            String string2 = verRange.getSTARTVER();
            String string3 = verRange.getENDVER();
            if (s_log.isEnabledFor(Logger.DEBUG)) {
                s_log.debug((Object)("startVersion:" + string2 + ", endVersion: " + string3 + ", targetVersion: " + string));
            }
            bl |= DiagVersionChecker.isInRangeCheck(string2, string3, string);
        }
        return !bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

