/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.gcagent.addon.ocheck;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.Validator;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;
import oracle.sysman.gcagent.addon.ocheck.DiagCheckerMsgID;
import oracle.sysman.gcagent.addon.ocheck.DiagExclusions;
import oracle.sysman.gcagent.addon.ocheck.DiagParserException;
import oracle.sysman.gcagent.addon.ocheck.jaxb.diagcheck.DiagnosticCheck;
import oracle.sysman.gcagent.addon.ocheck.jaxb.diagcheck.DiagnosticChecks;
import oracle.sysman.gcagent.addon.ocheck.jaxb.diagcheck.Key;
import oracle.sysman.gcagent.addon.ocheck.jaxb.diagcheck.Property;
import oracle.sysman.gcagent.addon.ocheck.jaxb.diaggroup.DiagGroup;
import oracle.sysman.gcagent.addon.ocheck.jaxb.diaggroup.DiagMetadata;

public class DiagParser {
    private static Logger s_log = Logger.getInstance((Class)(class$oracle$sysman$gcagent$addon$ocheck$DiagParser == null ? (class$oracle$sysman$gcagent$addon$ocheck$DiagParser = DiagParser.class$("oracle.sysman.gcagent.addon.ocheck.DiagParser")) : class$oracle$sysman$gcagent$addon$ocheck$DiagParser));
    private static MessageBundle s_dbundle = MessageBundle.getInstance((String)"oracle.sysman.gcagent.addon.ocheck.DiagChecker");
    private static String s_xmlFilesDirPath = null;
    private static String s_targetType = null;
    static DiagExclusions s_diagExclusions = null;
    private static final String DIAGMETADATA = "DiagMetadata.xml";
    private static DiagMetadata s_diagMetadata = null;
    private static HashMap s_diagnosticCheckMap = new HashMap();
    public static String s_version = null;
    static /* synthetic */ Class class$oracle$sysman$gcagent$addon$ocheck$DiagParser;

    public static DiagMetadata parseDiagMetadata(String string, String string2, String string3) throws DiagParserException {
        String[] stringArray = new String[]{string, string3, DIAGMETADATA};
        String string4 = FileSpec.catfile((String[])stringArray);
        stringArray = new String[]{string, string3};
        s_xmlFilesDirPath = FileSpec.catfile((String[])stringArray);
        File file = new File(s_xmlFilesDirPath);
        if (!file.exists()) {
            return null;
        }
        try {
            FileReader fileReader = new FileReader(string4);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string5 = s_dbundle.getMessage(DiagCheckerMsgID.MISSING_DIAGMETA_FILE, false, (Object[])new String[]{string3, string4});
            throw new DiagParserException(string5);
        }
        if (s_targetType == null || !s_targetType.equalsIgnoreCase(string3)) {
            s_diagMetadata = null;
            s_diagnosticCheckMap.clear();
        }
        s_targetType = string3;
        if (s_diagMetadata == null) {
            s_diagMetadata = DiagParser.unmarshallXMLDocumentDiagMetadata(new File(string4));
        }
        if (s_log.isEnabledFor(Logger.DEBUG)) {
            s_log.debug((Object)(" REFERENCE s_diagMetadata " + s_diagMetadata));
            s_log.debug((Object)(" REFERENCE s_diagnosticCheckMap " + s_diagnosticCheckMap));
            s_log.debug((Object)(" CFG PATH " + string2));
        }
        return s_diagMetadata;
    }

    public static DiagExclusions parseDiagExclusions(String string, String string2) {
        s_diagExclusions = new DiagExclusions(string, string2);
        return s_diagExclusions;
    }

    public static List getDiagChecks(DiagGroup diagGroup) {
        String string = diagGroup.getNAME();
        String string2 = diagGroup.getFILENAME();
        String[] stringArray = new String[]{s_xmlFilesDirPath, string2};
        String string3 = FileSpec.catfile((String[])stringArray);
        if (s_log.isEnabledFor(Logger.DEBUG)) {
            s_log.debug((Object)("getDiagChecks " + string3));
        }
        List list = null;
        if (s_diagnosticCheckMap.get(string) == null) {
            list = new ArrayList();
            File file = new File(string3);
            if (!file.exists()) {
                s_log.warn(DiagCheckerMsgID.MISSING_DIAGCHECK_FILE, (Object[])new String[]{s_targetType, string, string2});
            } else {
                try {
                    list = DiagParser.unmarshallXMLDocumentDiagChecks(file);
                }
                catch (DiagParserException diagParserException) {
                    s_log.warn(DiagCheckerMsgID.PARSING_ERROR_DIAGCHECKS, (Object[])new String[]{s_targetType, string, string2, diagParserException.getMessage()});
                }
            }
            s_diagnosticCheckMap.put(string, list);
        } else {
            list = (List)s_diagnosticCheckMap.get(string);
        }
        return list;
    }

    public static DiagMetadata getDiagMetadata() {
        return s_diagMetadata;
    }

    private static List unmarshallXMLDocumentDiagChecks(File file) throws DiagParserException {
        List list = null;
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((String)"oracle.sysman.gcagent.addon.ocheck.jaxb.diagcheck");
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            DiagnosticChecks diagnosticChecks = (DiagnosticChecks)unmarshaller.unmarshal(file);
            String string = FileSpec.catfile((String[])new String[]{Collector.getCCRRoot(), UplinkPath.DIAGCHECKS_PATH, "DiagCheck.xsd"});
            Validator validator = jAXBContext.createValidator();
            validator.setProperty("schema-location", (Object)string);
            validator.validateRoot((Object)diagnosticChecks);
            list = diagnosticChecks.getDiagnosticCheck();
            if (s_log.isEnabledFor(Logger.DEBUG)) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    DiagnosticCheck diagnosticCheck = (DiagnosticCheck)iterator.next();
                    s_log.debug((Object)("unmarshalXMLDocumentDiagChecks" + diagnosticCheck.getNAME()));
                }
            }
        }
        catch (UnmarshalException unmarshalException) {
            s_log.debug((Object)unmarshalException, (Throwable)unmarshalException);
            throw new DiagParserException(unmarshalException.getMessage());
        }
        catch (JAXBException jAXBException) {
            s_log.debug((Object)jAXBException, (Throwable)jAXBException);
            throw new DiagParserException(jAXBException.getMessage());
        }
        return list;
    }

    private static DiagMetadata unmarshallXMLDocumentDiagMetadata(File file) throws DiagParserException {
        try {
            Object object;
            List list;
            JAXBContext jAXBContext = JAXBContext.newInstance((String)"oracle.sysman.gcagent.addon.ocheck.jaxb.diaggroup");
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            if (s_diagMetadata == null) {
                s_diagMetadata = (DiagMetadata)unmarshaller.unmarshal(file);
                list = jAXBContext.createValidator();
                object = FileSpec.catfile((String[])new String[]{Collector.getCCRRoot(), UplinkPath.DIAGCHECKS_PATH, "DiagMetadata.xsd"});
                list.setProperty("schema-location", object);
                list.validateRoot(s_diagMetadata);
            }
            list = s_diagMetadata.getDiagGroup();
            object = s_diagMetadata.getTargetVersionRule();
            s_version = s_diagMetadata.getVERSION();
            if (object != null) {
                String string = object.getCONFIGPATH();
            }
        }
        catch (UnmarshalException unmarshalException) {
            String string = s_dbundle.getMessage(DiagCheckerMsgID.PARSING_ERROR_DIAGMETA, false, (Object[])new String[]{s_targetType, unmarshalException.getMessage()});
            throw new DiagParserException(string);
        }
        catch (JAXBException jAXBException) {
            String string = s_dbundle.getMessage(DiagCheckerMsgID.PARSING_ERROR_DIAGMETA, false, (Object[])new String[]{s_targetType, jAXBException.getMessage()});
            throw new DiagParserException(string);
        }
        return s_diagMetadata;
    }

    public static void removeDuplicateWithOrder(List list) {
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<DiagGroup> arrayList = new ArrayList<DiagGroup>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            DiagGroup diagGroup = null;
            diagGroup = (DiagGroup)e;
            if (!hashSet.add(diagGroup.getNAME())) continue;
            arrayList.add(diagGroup);
        }
        list.clear();
        list.addAll(arrayList);
    }

    public static List getDiagGroups() {
        List list = DiagParser.getDiagMetadata().getDiagGroup();
        DiagParser.removeDuplicateWithOrder(list);
        return list;
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            List list = null;
            DiagMetadata diagMetadata = DiagParser.parseDiagMetadata(stringArray[0], stringArray[1], stringArray[2]);
            List list2 = DiagParser.getDiagGroups();
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                object = (DiagGroup)iterator.next();
                list = DiagParser.getDiagChecks((DiagGroup)object);
            }
            diagMetadata = DiagParser.parseDiagMetadata(stringArray[0], stringArray[1], stringArray[2]);
            list2 = DiagParser.getDiagGroups();
            iterator = list2.iterator();
            while (iterator.hasNext()) {
                object = (DiagGroup)iterator.next();
                list = DiagParser.getDiagChecks((DiagGroup)object);
            }
            object = list.iterator();
            while (object.hasNext()) {
                Object object2;
                DiagnosticCheck diagnosticCheck = (DiagnosticCheck)object.next();
                System.out.println(diagnosticCheck.getNAME() + " " + s_diagExclusions.isCheckExcluded(diagnosticCheck.getNAME()));
                System.out.println(diagnosticCheck.getQueryDescriptor().getFETCHLETID());
                Iterator iterator2 = diagnosticCheck.getQueryDescriptor().getProperty().iterator();
                while (iterator2.hasNext()) {
                    object2 = (Property)iterator2.next();
                    System.out.println("VALUES" + object2.getNAME() + " " + object2.getSCOPE() + " " + object2.getValue());
                }
                iterator2 = diagnosticCheck.getKeyList().getKey().iterator();
                while (iterator2.hasNext()) {
                    object2 = (Key)iterator2.next();
                    System.out.println("KEYS" + object2.getValue());
                }
            }
        }
        catch (DiagParserException diagParserException) {
            System.err.println(diagParserException.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

