/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.install;

import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import oracle.sysman.ccr.collector.install.ConfigCommandException;
import oracle.sysman.ccr.collector.install.ConfigResponseCommand;
import oracle.sysman.ccr.collector.install.ConfigResponseException;
import oracle.sysman.ccr.collector.install.ConfigResponseExitConsts;
import oracle.sysman.ccr.collector.install.ConfigResponseMsgID;
import oracle.sysman.ccr.collector.install.ConflictingQualifierException;
import oracle.sysman.ccr.collector.install.CreateCSIResponseCommand;
import oracle.sysman.ccr.collector.install.CreateMetaLinkEmailResponseCommand;
import oracle.sysman.ccr.collector.install.CreateResponseCommand;
import oracle.sysman.ccr.collector.install.DisplayResponseCommand;
import oracle.sysman.ccr.collector.install.ExportResponseCommand;
import oracle.sysman.ccr.collector.install.ImportResponseCommand;
import oracle.sysman.ccr.collector.install.InsufficientArgumentsException;
import oracle.sysman.ccr.collector.install.LicenseAgreement;
import oracle.sysman.ccr.collector.install.MarkInstallationAsDerivedCommand;
import oracle.sysman.ccr.collector.install.NetworkConfiguration;
import oracle.sysman.ccr.collector.install.OCMRegistrationPrincipal;
import oracle.sysman.ccr.collector.install.QueryResponseCommand;
import oracle.sysman.ccr.collector.install.SyntaxException;
import oracle.sysman.ccr.collector.install.UsageCommand;
import oracle.sysman.ccr.collector.install.VerifyResponseCommand;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.collector.util.UplinkSystemConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.common.network.JCEInitializationException;
import org.apache.log4j.PropertyConfigurator;

public class ConfigResponse
implements ConfigResponseExitConsts {
    static MessageBundle s_msgBundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.install.ConfigResponse");
    static final String OCM_LOG_LEVEL = "OCM_LOG_LEVEL";
    static final String DEFAULT_LOG_LEVEL = "WARN";
    static final String RESPONSE_OUTPUT_QUAL = "-output";
    static final String SILENT_QUAL = "-no_banner";
    static final String USAGE_QUAL = "-help";
    static final String INSTALL_CODEPATH = "-InstallPath";
    static final String QUERY_QUAL = "-query";
    static final String RESPONSE_INPUT_QUAL = "-response_file";
    static final String RECONFIG_QUAL = "-reconfig";
    static final String LICENSE_QUAL = "-license";
    static final String VERBOSE_QUAL = "-verbose";
    static final String EXPORT_QUAL = "-export";
    static final String IMPORT_QUAL = "-import";
    static final String REPEATER_QUAL = "-repeater";
    static final String VERIFY_QUAL = "-verify";
    static final String DERIVED_QUAL = "-derived";
    private static final String DEFAULT_RESPONSE_FILENAME = "ocm.rsp";
    private static final String OCM_ROOT = "OCM_ROOT";
    private static String s_strOCMRoot;
    private static Logger s_logger;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$install$ConfigResponse;

    public static void init() {
        if (!Logger.isLoggingConfigured()) {
            Properties properties = new Properties();
            ((Hashtable)properties).put("log4j.appender.Console", "org.apache.log4j.ConsoleAppender");
            ((Hashtable)properties).put("log4j.appender.Console.layout", "org.apache.log4j.PatternLayout");
            ((Hashtable)properties).put("log4j.appender.Console.layout.ConversionPattern", "%d [%t] %-5p - %m%n");
            String string = System.getProperty(OCM_LOG_LEVEL);
            if (string == null) {
                string = DEFAULT_LOG_LEVEL;
            }
            ((Hashtable)properties).put("log4j.rootCategory", string + ", Console");
            PropertyConfigurator.configure((Properties)properties);
        }
        System.setProperty("ocm.keystore_resource", "true");
        System.setProperty("ocm.countrymap_resource", "true");
        s_strOCMRoot = System.getProperty(OCM_ROOT);
        s_logger = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$install$ConfigResponse == null ? (class$oracle$sysman$ccr$collector$install$ConfigResponse = ConfigResponse.class$("oracle.sysman.ccr.collector.install.ConfigResponse")) : class$oracle$sysman$ccr$collector$install$ConfigResponse));
    }

    public static void main(String[] stringArray) {
        int n = 0;
        try {
            ConfigResponseCommand configResponseCommand = null;
            configResponseCommand = ConfigResponse.parseCommand(stringArray);
            if (configResponseCommand.displayBanner()) {
                System.out.println(s_msgBundle.getMessage(ConfigResponseMsgID.OCM_RESPONSE_BANNER, false));
            }
            configResponseCommand.execute();
        }
        catch (SyntaxException syntaxException) {
            try {
                System.err.println(syntaxException.getMessage());
                new UsageCommand().execute();
                n = syntaxException.exitCode();
            }
            catch (ConfigCommandException configCommandException) {
                n = configCommandException.exitCode();
            }
        }
        catch (ConfigCommandException configCommandException) {
            System.err.println(configCommandException.getMessage());
            n = configCommandException.exitCode();
        }
        catch (JCEInitializationException jCEInitializationException) {
            System.err.println(jCEInitializationException.getMessage());
            n = 1;
        }
        System.exit(n);
    }

    private static ConfigResponseCommand parseCommand(String[] stringArray) throws ConfigCommandException {
        int n;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ConfigResponseCommand configResponseCommand = null;
        int n2 = 0;
        int n3 = -1;
        String[] stringArray2 = new String[2];
        String[] stringArray3 = new String[stringArray2.length];
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals(USAGE_QUAL)) {
                configResponseCommand = new UsageCommand();
                break;
            }
            if (stringArray[n].equals(INSTALL_CODEPATH)) {
                hashMap.put(INSTALL_CODEPATH, new Boolean(true));
                continue;
            }
            if (stringArray[n].equals(LICENSE_QUAL)) {
                hashMap.put(LICENSE_QUAL, new Boolean(true));
                continue;
            }
            if (stringArray[n].equals(SILENT_QUAL)) {
                hashMap.put(SILENT_QUAL, new Boolean(true));
                continue;
            }
            if (stringArray[n].equals(DERIVED_QUAL)) {
                hashMap.put(DERIVED_QUAL, new Boolean(true));
                ++n2;
                continue;
            }
            if (stringArray[n].equals(RECONFIG_QUAL)) {
                hashMap.put(RECONFIG_QUAL, new Boolean(true));
                Config config = UplinkSystemConfig.getInstance();
                String string = config.getProperty("ccr.registration_mode");
                if (string == null || string.equals("csi")) {
                    stringArray3[0] = config.getProperty("ccr.support_id");
                    stringArray3[1] = config.getProperty("ccr.metalink_id");
                }
                if ((string = (config = UplinkHomeConfig.getInstance()).getProperty("ccr.agreement_signer")) == null) continue;
                hashMap.put(LICENSE_QUAL, new Boolean(true));
                continue;
            }
            if (stringArray[n].equals(RESPONSE_OUTPUT_QUAL)) {
                if (n == stringArray.length - 1) {
                    throw new InsufficientArgumentsException();
                }
                hashMap.put(RESPONSE_OUTPUT_QUAL, stringArray[++n]);
                ++n2;
                continue;
            }
            if (stringArray[n].equals(EXPORT_QUAL)) {
                if (n == stringArray.length - 1) {
                    throw new InsufficientArgumentsException();
                }
                hashMap.put(EXPORT_QUAL, stringArray[++n]);
                ++n2;
                continue;
            }
            if (stringArray[n].equals(IMPORT_QUAL)) {
                if (n == stringArray.length - 1) {
                    throw new InsufficientArgumentsException();
                }
                hashMap.put(IMPORT_QUAL, stringArray[++n]);
                ++n2;
                continue;
            }
            if (stringArray[n].equals(QUERY_QUAL)) {
                if (n == stringArray.length - 1) {
                    throw new InsufficientArgumentsException();
                }
                hashMap.put(QUERY_QUAL, stringArray[++n]);
                continue;
            }
            if (stringArray[n].equals(RESPONSE_INPUT_QUAL)) {
                if (n == stringArray.length - 1) {
                    throw new InsufficientArgumentsException();
                }
                hashMap.put(RESPONSE_INPUT_QUAL, stringArray[++n]);
                continue;
            }
            if (stringArray[n].equals(VERBOSE_QUAL)) {
                if (n == stringArray.length - 1) {
                    throw new InsufficientArgumentsException();
                }
                hashMap.put(VERBOSE_QUAL, stringArray[++n]);
                ++n2;
                continue;
            }
            if (stringArray[n].equals(REPEATER_QUAL)) {
                if (n == stringArray.length - 1) {
                    throw new InsufficientArgumentsException();
                }
                hashMap.put(REPEATER_QUAL, stringArray[++n]);
                continue;
            }
            if (stringArray[n].equals(VERIFY_QUAL)) {
                if (n == stringArray.length - 1) {
                    throw new InsufficientArgumentsException();
                }
                hashMap.put(VERIFY_QUAL, stringArray[++n]);
                ++n2;
                continue;
            }
            if (stringArray[n].startsWith("-")) {
                throw new SyntaxException();
            }
            if (n3 == stringArray2.length - 1 && bl) {
                throw new SyntaxException();
            }
            if (n3 == stringArray2.length - 1) {
                bl = true;
                continue;
            }
            stringArray2[++n3] = stringArray[n];
        }
        if (n2 > 1) {
            throw new ConflictingQualifierException();
        }
        String string = (String)hashMap.get(VERBOSE_QUAL);
        if (string != null) {
            configResponseCommand = new DisplayResponseCommand(string);
        } else {
            string = (String)hashMap.get(EXPORT_QUAL);
            if (string != null) {
                configResponseCommand = new ExportResponseCommand(string);
            } else {
                string = (String)hashMap.get(IMPORT_QUAL);
                if (string != null) {
                    configResponseCommand = new ImportResponseCommand(string);
                } else if (hashMap.get(DERIVED_QUAL) != null) {
                    configResponseCommand = new MarkInstallationAsDerivedCommand();
                } else {
                    string = (String)hashMap.get(QUERY_QUAL);
                    if (string != null) {
                        configResponseCommand = new QueryResponseCommand(string, (String)hashMap.get(RESPONSE_INPUT_QUAL));
                    } else {
                        string = (String)hashMap.get(VERIFY_QUAL);
                        if (string != null) {
                            configResponseCommand = new VerifyResponseCommand(string);
                        } else if (n3 >= 0) {
                            string = (String)hashMap.get(RESPONSE_OUTPUT_QUAL);
                            if (string == null) {
                                string = DEFAULT_RESPONSE_FILENAME;
                            }
                            configResponseCommand = new CreateCSIResponseCommand(string, s_strOCMRoot, stringArray2[0], stringArray2[1], stringArray3[0], stringArray3[1]);
                        } else {
                            string = (String)hashMap.get(RESPONSE_OUTPUT_QUAL);
                            if (string != null) {
                                configResponseCommand = new CreateMetaLinkEmailResponseCommand(string, s_strOCMRoot);
                            }
                        }
                    }
                }
            }
        }
        if (configResponseCommand == null) {
            configResponseCommand = new CreateMetaLinkEmailResponseCommand(DEFAULT_RESPONSE_FILENAME, s_strOCMRoot);
        }
        if (s_logger != null && s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("CLI Qualifiers found are: " + hashMap));
            s_logger.debug((Object)("Found " + (n3 + 1) + " command line arguments"));
            for (n = 0; n <= n3; ++n) {
                s_logger.debug((Object)("  arg[" + n + "] = " + stringArray2[n]));
            }
        }
        configResponseCommand.setQualifiers(hashMap);
        return configResponseCommand;
    }

    public static void createResponseFile(String string, LicenseAgreement licenseAgreement, NetworkConfiguration networkConfiguration, OCMRegistrationPrincipal oCMRegistrationPrincipal) throws IOException {
        CreateResponseCommand.createResponseFile(string, licenseAgreement, networkConfiguration, oCMRegistrationPrincipal);
    }

    public static void createResponseFile(String string, NetworkConfiguration networkConfiguration, OCMRegistrationPrincipal oCMRegistrationPrincipal) throws IOException {
        CreateResponseCommand.createResponseFile(string, new LicenseAgreement(true), networkConfiguration, oCMRegistrationPrincipal);
    }

    public static void createResponseFile(String string, String string2) throws ConfigResponseException, IOException {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put(INSTALL_CODEPATH, new Boolean(true));
        CreateMetaLinkEmailResponseCommand createMetaLinkEmailResponseCommand = new CreateMetaLinkEmailResponseCommand(string, string2);
        createMetaLinkEmailResponseCommand.setQualifiers(hashMap);
        createMetaLinkEmailResponseCommand.setNoConfirmationMsg();
        createMetaLinkEmailResponseCommand.execute();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ConfigResponse.init();
    }
}

