/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.install;

import HTTPClient.ParseException;
import HTTPClient.URI;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.net.ssl.SSLPeerUnverifiedException;
import oracle.sysman.ccr.collector.install.AnonymousMailRegistrationPrincipal;
import oracle.sysman.ccr.collector.install.AnonymousRegistrationPrincipal;
import oracle.sysman.ccr.collector.install.ConfigCommandException;
import oracle.sysman.ccr.collector.install.ConfigResponse;
import oracle.sysman.ccr.collector.install.ConfigResponseCommand;
import oracle.sysman.ccr.collector.install.ConfigResponseExitConsts;
import oracle.sysman.ccr.collector.install.ConfigResponseMsgID;
import oracle.sysman.ccr.collector.install.ConnectionException;
import oracle.sysman.ccr.collector.install.CreateCommandException;
import oracle.sysman.ccr.collector.install.InvalidEndPointException;
import oracle.sysman.ccr.collector.install.InvalidRepeaterException;
import oracle.sysman.ccr.collector.install.InvalidValueException;
import oracle.sysman.ccr.collector.install.LicenseAgreement;
import oracle.sysman.ccr.collector.install.NetworkConfiguration;
import oracle.sysman.ccr.collector.install.OCMRegistrationPrincipal;
import oracle.sysman.ccr.collector.install.ResponseFile;
import oracle.sysman.ccr.collector.install.UnexpectedException;
import oracle.sysman.ccr.collector.util.TestConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.ResourceID;
import oracle.sysman.ccr.common.TestMap;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.netmgr.EndPoint;
import oracle.sysman.ccr.netmgr.HTTPServerException;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.SecurePrompter;

class CreateResponseCommand
extends ConfigResponseCommand
implements ConfigResponseExitConsts {
    private static final String LICENSE_DOC = "license.txt";
    protected static int PROMPT_LIMIT = 3;
    protected static final int TEST_PROMPT_LIMIT = 5;
    static final String ORACLE_CCR_TESTS = "ORACLE_CCR_TESTS";
    protected static Logger s_logger = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$install$CreateResponseCommand == null ? (class$oracle$sysman$ccr$collector$install$CreateResponseCommand = CreateResponseCommand.class$("oracle.sysman.ccr.collector.install.CreateResponseCommand")) : class$oracle$sysman$ccr$collector$install$CreateResponseCommand));
    private static TestMap s_testMap = null;
    private String m_strFilename;
    private String m_strOCMRoot;
    private boolean m_bNoConfirmation = false;
    private static final String SUBTEST_NO_PRINCIPAL_PROMPT = "noprincipal_prompting";
    private static final String SUBTEST_NO_DIRECT_CONNECTION = "noDirectConnection";
    private static final String SUBTEST_PROXY_REQD = "proxyreqd";
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$install$CreateResponseCommand;

    CreateResponseCommand(String string, String string2) {
        this.m_strFilename = string;
        this.m_strOCMRoot = string2;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("CreateResponseCommand created: (" + this.m_strFilename + "," + this.m_strOCMRoot + ")"));
        }
    }

    static void createResponseFile(String string, LicenseAgreement licenseAgreement, NetworkConfiguration networkConfiguration, OCMRegistrationPrincipal oCMRegistrationPrincipal) throws IOException {
        ResponseFile responseFile = new ResponseFile(licenseAgreement, networkConfiguration, oCMRegistrationPrincipal);
        responseFile.concentrateResponseFile(string);
    }

    protected void execute() throws ConfigCommandException {
        NetworkConfiguration networkConfiguration = null;
        OCMRegistrationPrincipal oCMRegistrationPrincipal = null;
        EndPoint endPoint = null;
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        while (!(bl || bl3 || bl2 || n++ >= PROMPT_LIMIT)) {
            oCMRegistrationPrincipal = this.promptForPrincipal();
            if (oCMRegistrationPrincipal == null) {
                bl3 = true;
                continue;
            }
            if (networkConfiguration == null && (endPoint = (networkConfiguration = this.determineNetworkPath()).getConnection()) == null) {
                bl2 = true;
            }
            try {
                if (bl2) continue;
                oCMRegistrationPrincipal.validatePrincipal(endPoint, networkConfiguration);
                bl = true;
            }
            catch (HTTPServerException hTTPServerException) {
                throw new CreateCommandException((Exception)((Object)hTTPServerException), 11);
            }
            catch (NetworkException networkException) {
                Vector vector = networkException.formatExceptionChain();
                Iterator iterator = ((AbstractList)vector).iterator();
                while (iterator.hasNext()) {
                    ConfigResponseCommand.Stderr.println((String)iterator.next());
                }
                ConfigResponseCommand.Stderr.println();
            }
        }
        if (oCMRegistrationPrincipal != null && (!bl || bl2)) {
            String string = oCMRegistrationPrincipal.getMetaLinkPrincipal();
            if (oCMRegistrationPrincipal.getAttemptedRegistrationMethod().equals("csi")) {
                bl4 = true;
            }
            if ((oCMRegistrationPrincipal = string != null ? new AnonymousMailRegistrationPrincipal(string) : null) != null && !bl && !bl2) {
                if (bl4) {
                    ConfigResponseCommand.displayWrappedLines(this.s_msgBundle.getMessage(ConfigResponseMsgID.ERR_MAX_MLUSERCSI_PROMPT_EXCEEDED, false));
                } else {
                    ConfigResponseCommand.displayWrappedLines(this.s_msgBundle.getMessage(ConfigResponseMsgID.ERR_MAX_MLUSERPWD_PROMPT_EXCEEDED, false));
                }
            }
        }
        if (oCMRegistrationPrincipal == null && !bl3) {
            if (!bl2) {
                ConfigResponseCommand.displayWrappedLines(this.s_msgBundle.getMessage(ConfigResponseMsgID.ERR_MAX_MLUSERCSI_PROMPT_EXCEEDED, false));
            }
            oCMRegistrationPrincipal = new AnonymousRegistrationPrincipal();
        }
        try {
            if (bl3) {
                ConfigResponse.createResponseFile(this.m_strFilename, new LicenseAgreement(false), null, null);
            } else {
                ConfigResponse.createResponseFile(this.m_strFilename, new LicenseAgreement(true), networkConfiguration, oCMRegistrationPrincipal);
            }
        }
        catch (IOException iOException) {
            throw new CreateCommandException(ConfigResponseMsgID.OCM_RESPONSE_NONWRITEABLE, new String[]{this.m_strFilename}, 11);
        }
        if (!(this.qualifierSet("-InstallPath") || this.qualifierSet("-reconfig") || this.m_bNoConfirmation)) {
            ConfigResponseCommand.displayLine(this.s_msgBundle.getMessage(ConfigResponseMsgID.OCM_RESPONSE_FILE_CREATED, false, (Object[])new String[]{this.m_strFilename}));
        }
    }

    void setNoConfirmationMsg() {
        this.m_bNoConfirmation = true;
    }

    protected void promptForSupportPolicy() throws UnexpectedException {
        if (this.qualifierSet("-license")) {
            return;
        }
        String string = "";
        try {
            try {
                string = this.promptForInput(this.s_msgBundle.getMessage(ConfigResponseMsgID.OCM_LICENSE_PROMPT, false));
                ConfigResponseCommand.displayWrappedLines();
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Response is " + string));
                }
                if (string == null) {
                    string = "";
                }
                if ((string = string.trim().toUpperCase()).length() == 0) {
                    string = "N";
                }
                if (string.substring(0, 1).equals("Y")) {
                    this.displayAgreement();
                    ConfigResponseCommand.displayWrappedLines();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new UnexpectedException(this.s_msgBundle.getMessage(ConfigResponseMsgID.ERR_LICENSE_AGREEMENT_NOT_FOUND, false));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displayAgreement() throws FileNotFoundException {
        String string = FileSpec.catfile((String[])new String[]{this.m_strOCMRoot, "doc", LICENSE_DOC});
        FileReader fileReader = new FileReader(string);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() == 0) {
                    ConfigResponseCommand.displayWrappedLines();
                    continue;
                }
                ConfigResponseCommand.displayWrappedLines(string2);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private NetworkConfiguration determineNetworkPath() throws CreateCommandException {
        boolean bl;
        boolean bl2;
        NetworkConfiguration networkConfiguration;
        block19: {
            networkConfiguration = null;
            try {
                networkConfiguration = new NetworkConfiguration();
            }
            catch (RuntimeException runtimeException) {
                if (runtimeException.getMessage().startsWith("HTTPClient.ParseException:")) {
                    throw new CreateCommandException(ConfigResponseMsgID.INVALID_ENDPOINT_URL, new Object[]{runtimeException.getMessage()}, 11);
                }
                throw runtimeException;
            }
            bl2 = this.processRptrQualifier(networkConfiguration);
            bl = true;
            try {
                if (!s_testMap.isUnderTest(SUBTEST_NO_DIRECT_CONNECTION) && bl2 && (networkConfiguration.isDisconnectedNetConfig() || networkConfiguration.testExtendedConnection() != null)) {
                    return networkConfiguration;
                }
            }
            catch (InvalidRepeaterException invalidRepeaterException) {
                ConfigResponseCommand.Stderr.println(this.s_msgBundle.getMessage(ConfigResponseMsgID.INVALID_REPEATER_ADDRESS, false, (Object[])new String[]{networkConfiguration.getStrRepeaterURI()}));
                bl2 = false;
            }
            catch (InvalidEndPointException invalidEndPointException) {
                ConfigResponseCommand.Stderr.println(invalidEndPointException.getMessage());
                bl = false;
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                ConfigResponseCommand.Stderr.println(this.s_msgBundle.getMessage(ConfigResponseMsgID.UNRECOVERABLE_NETWORK_ERR, false));
                ConfigResponseCommand.Stderr.println(sSLPeerUnverifiedException.getMessage());
                bl2 = false;
                if (!networkConfiguration.getIsRepeater()) {
                    bl = false;
                }
            }
            catch (UnknownHostException unknownHostException) {
                ConfigResponseCommand.Stderr.println(this.s_msgBundle.getMessage(ConfigResponseMsgID.ERR_UNKNOWN_HOST, false, (Object[])new String[]{networkConfiguration.getEndPointString()}));
                if (!networkConfiguration.getIsRepeater()) {
                    bl = false;
                }
            }
            catch (SocketException socketException) {
                String string = null;
                if (this.qualifierSet("-repeater")) {
                    string = this.qualifierValue("-repeater");
                } else {
                    string = networkConfiguration.getEndPointString();
                    bl = false;
                }
                ConfigResponseCommand.Stderr.println(this.s_msgBundle.getMessage(ConfigResponseMsgID.CONNECTION_ERR, false, (Object[])new String[]{string}));
                ConfigResponseCommand.Stderr.println(socketException.getMessage());
            }
            catch (IOException iOException) {
                bl2 = false;
                if (networkConfiguration.getIsRepeater()) break block19;
                bl = false;
            }
        }
        if (this.qualifierSet("-repeater") && bl2) {
            this.promptForProxy(networkConfiguration);
            if (networkConfiguration.isDisconnectedNetConfig()) {
                String string = this.qualifierValue("-repeater");
                if (string.equals("NONE")) {
                    return networkConfiguration;
                }
                this.promptForRepeaterURL(networkConfiguration, bl);
            }
        } else {
            this.promptForRepeaterURL(networkConfiguration, bl);
        }
        return networkConfiguration;
    }

    private boolean processRptrQualifier(NetworkConfiguration networkConfiguration) {
        if (!this.qualifierSet("-repeater")) {
            return true;
        }
        String string = this.qualifierValue("-repeater");
        try {
            if (string.equals("NONE")) {
                networkConfiguration.declineRepeater();
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)this.s_msgBundle.getMessage(ConfigResponseMsgID.NO_REPEATER_SPECIFIED_AT_CMD_LINE, false));
                }
            } else {
                URI uRI = new URI(string);
                networkConfiguration.setRepeaterURI(uRI);
            }
            return true;
        }
        catch (InvalidValueException invalidValueException) {
            ConfigResponseCommand.Stderr.println(this.s_msgBundle.getMessage(ConfigResponseMsgID.INVALID_REPEATER_ADDRESS, false, (Object[])new String[]{string}));
            return false;
        }
        catch (ParseException parseException) {
            ConfigResponseCommand.Stderr.println(this.s_msgBundle.getMessage(ConfigResponseMsgID.INVALID_REPEATER_ADDRESS, false, (Object[])new String[]{string}));
            return false;
        }
    }

    private void promptForRepeaterURL(NetworkConfiguration networkConfiguration, boolean bl) {
        String string = "";
        boolean bl2 = false;
        int n = 0;
        String string2 = System.getProperty(ORACLE_CCR_TESTS);
        while (!bl2) {
            block25: {
                if (n >= 5 && string2 != null) {
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)"In a test environment maximum number of Support Hub attempts are liimted to 5");
                    }
                    ConfigResponseCommand.Stderr.println("Number of Support Hub trials in a Test environment are exceeded: Aborting Installation");
                    System.exit(11);
                }
                networkConfiguration.declineRepeater();
                networkConfiguration.resetProxyInformation();
                try {
                    ConfigResponseCommand.displayWrappedLines();
                    ConfigResponseCommand.displayWrappedLines(this.s_msgBundle.getMessage(ConfigResponseMsgID.OCM_NO_NETWORK_CONNECTION, false));
                    string = this.promptForInput(this.s_msgBundle.getMessage(ConfigResponseMsgID.OCM_REPEATER_URL_PROMPT, false));
                    if (string.trim().equals("NONE")) {
                        networkConfiguration.declineRepeater();
                        if (!s_testMap.isUnderTest(SUBTEST_PROXY_REQD) && bl && networkConfiguration.testExtendedConnection() != null) {
                            bl2 = true;
                        } else {
                            this.promptForProxy(networkConfiguration);
                            bl2 = true;
                        }
                    } else {
                        URI uRI = new URI(string);
                        networkConfiguration.setRepeaterURI(uRI);
                        if (!s_testMap.isUnderTest(SUBTEST_PROXY_REQD) && networkConfiguration.testExtendedConnection() != null) {
                            bl2 = true;
                        } else {
                            this.promptForProxy(networkConfiguration);
                            if (!networkConfiguration.isDisconnectedNetConfig()) {
                                bl2 = true;
                            }
                        }
                    }
                }
                catch (ParseException parseException) {
                    ConfigResponseCommand.Stderr.println(this.s_msgBundle.getMessage(ConfigResponseMsgID.INVALID_REPEATER_ADDRESS, false, (Object[])new String[]{string}));
                }
                catch (InvalidValueException invalidValueException) {
                    ConfigResponseCommand.Stderr.println(this.s_msgBundle.getMessage(ConfigResponseMsgID.INVALID_REPEATER_ADDRESS, false, (Object[])new String[]{string}));
                }
                catch (InvalidRepeaterException invalidRepeaterException) {
                    ConfigResponseCommand.Stderr.println(this.s_msgBundle.getMessage(ConfigResponseMsgID.INVALID_REPEATER_ADDRESS, false, (Object[])new String[]{string}));
                }
                catch (InvalidEndPointException invalidEndPointException) {
                    ConfigResponseCommand.Stderr.println(invalidEndPointException.getMessage());
                    this.promptForProxy(networkConfiguration);
                    bl2 = true;
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    ConfigResponseCommand.Stderr.println(this.s_msgBundle.getMessage(ConfigResponseMsgID.UNRECOVERABLE_NETWORK_ERR, false));
                    ConfigResponseCommand.Stderr.println(sSLPeerUnverifiedException.getMessage());
                    if (!networkConfiguration.getIsRepeater()) {
                        bl = false;
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    ConfigResponseCommand.Stderr.println(this.s_msgBundle.getMessage(ConfigResponseMsgID.ERR_UNKNOWN_HOST, false, (Object[])new String[]{networkConfiguration.getEndPointString()}));
                    this.promptForProxy(networkConfiguration);
                    bl2 = true;
                }
                catch (SocketException socketException) {
                    String string3 = null;
                    if (networkConfiguration.getIsRepeater()) {
                        string3 = string;
                    } else {
                        string3 = networkConfiguration.getEndPointString();
                        bl = false;
                    }
                    ConfigResponseCommand.Stderr.println(this.s_msgBundle.getMessage(ConfigResponseMsgID.CONNECTION_ERR, false, (Object[])new String[]{string3}));
                    ConfigResponseCommand.Stderr.println(socketException.getMessage());
                    this.promptForProxy(networkConfiguration);
                    if (!networkConfiguration.isDisconnectedNetConfig() || !networkConfiguration.getIsRepeater()) {
                        bl2 = true;
                    }
                }
                catch (ConnectionException connectionException) {
                    ConfigResponseCommand.Stderr.println(connectionException.getMessage());
                    if (!networkConfiguration.getIsRepeater()) {
                        bl = false;
                    }
                }
                catch (IOException iOException) {
                    ConfigResponseCommand.Stderr.println(iOException.getMessage());
                    if (networkConfiguration.getIsRepeater()) break block25;
                    bl = false;
                }
            }
            ++n;
        }
    }

    private void promptForProxy(NetworkConfiguration networkConfiguration) {
        boolean bl = false;
        int n = 0;
        String string = System.getProperty(ORACLE_CCR_TESTS);
        while (!bl) {
            block18: {
                if (n >= 5 && string != null) {
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)"In a test environment maximum number of proxy attempts are liimted to 5");
                    }
                    ConfigResponseCommand.Stderr.println("Number of Proxy trials in a Test environment are exceeded: Aborting Installation");
                    System.exit(11);
                }
                try {
                    ResourceID resourceID = null;
                    resourceID = networkConfiguration.getIsRepeater() ? ConfigResponseMsgID.OCM_ASK_FOR_LOCAL_PROXY : ConfigResponseMsgID.OCM_ASK_FOR_INTERNET_PROXY;
                    ConfigResponseCommand.displayWrappedLines();
                    ConfigResponseCommand.displayWrappedLines(this.s_msgBundle.getMessage(resourceID, false));
                    String string2 = this.promptForInput(this.s_msgBundle.getMessage(ConfigResponseMsgID.OCM_PROXY_PROMPT, false));
                    if (!this.validProxySpec(networkConfiguration, string2)) break block18;
                    if (networkConfiguration.requiresProxyPwd()) {
                        char[] cArray;
                        Object object;
                        if (System.getProperty("ccrtest_get_clear_password") != null) {
                            object = this.promptForInput("password: ");
                            cArray = ((String)object).toCharArray();
                        } else {
                            cArray = SecurePrompter.readResponse((String)this.s_msgBundle.getMessage(ConfigResponseMsgID.OCM_PROXY_PWD_PROMPT, false));
                        }
                        object = new byte[cArray.length];
                        for (int i = 0; i < ((Object)object).length; ++i) {
                            object[i] = (byte)cArray[i];
                        }
                        networkConfiguration.setProxyCreds((byte[])object);
                    }
                    try {
                        if (networkConfiguration.testProxyConnection() != null) {
                            if (s_logger.isDebugEnabled()) {
                                s_logger.debug((Object)"Proxy specification passed");
                            }
                            bl = true;
                            ConfigResponseCommand.Stdout.println(this.s_msgBundle.getMessage(ConfigResponseMsgID.OCM_PROXY_CONFIG_CONFIRMED, false));
                        } else if (networkConfiguration.isDisconnectedNetConfig()) {
                            if (s_logger.isDebugEnabled()) {
                                s_logger.debug((Object)"Proxy specification passed");
                            }
                            bl = true;
                        }
                    }
                    catch (ConnectionException connectionException) {
                        ConfigResponseCommand.Stderr.println(connectionException.getMessage());
                    }
                }
                catch (IOException iOException) {
                    ConfigResponseCommand.Stderr.println(iOException.getMessage());
                }
            }
            ++n;
        }
        ConfigResponseCommand.displayWrappedLines();
        if (!bl) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)"No valid proxy specified - and completed the proxy loop");
            }
            networkConfiguration.setNoProxy();
        }
    }

    protected boolean validProxySpec(NetworkConfiguration networkConfiguration, String string) {
        boolean bl = false;
        try {
            networkConfiguration.setProxySpecification(string);
            bl = true;
        }
        catch (InvalidValueException invalidValueException) {
            ConfigResponseCommand.Stderr.println(this.s_msgBundle.getMessage(ConfigResponseMsgID.INVALID_PROXY_PORT, false));
        }
        catch (java.text.ParseException parseException) {
            ConfigResponseCommand.Stderr.println(this.s_msgBundle.getMessage(ConfigResponseMsgID.INVALID_PROXY_SPECIFICATION, false));
        }
        catch (UnknownHostException unknownHostException) {
            ConfigResponseCommand.Stderr.println(unknownHostException.getMessage());
        }
        return bl;
    }

    protected OCMRegistrationPrincipal getRegistrationPrincipal(EndPoint endPoint, NetworkConfiguration networkConfiguration) throws ConfigCommandException {
        return null;
    }

    protected OCMRegistrationPrincipal promptForPrincipal() throws ConfigCommandException {
        return null;
    }

    protected String authenticateUser(OCMRegistrationPrincipal oCMRegistrationPrincipal, EndPoint endPoint, NetworkConfiguration networkConfiguration) {
        return "";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Config config = null;
        try {
            config = TestConfig.getInstance();
        }
        catch (IOException iOException) {
            config = null;
        }
        s_testMap = new TestMap(class$oracle$sysman$ccr$collector$install$CreateResponseCommand == null ? (class$oracle$sysman$ccr$collector$install$CreateResponseCommand = CreateResponseCommand.class$("oracle.sysman.ccr.collector.install.CreateResponseCommand")) : class$oracle$sysman$ccr$collector$install$CreateResponseCommand, config);
        if (s_testMap.isUnderTest(SUBTEST_NO_PRINCIPAL_PROMPT)) {
            PROMPT_LIMIT = 1;
        }
    }
}

