/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.install;

import java.io.FileNotFoundException;
import oracle.sysman.ccr.collector.install.ConfigCommandException;
import oracle.sysman.ccr.collector.install.ConfigReadException;
import oracle.sysman.ccr.collector.install.ConfigResponseCommand;
import oracle.sysman.ccr.collector.install.ConfigWriteException;
import oracle.sysman.ccr.collector.install.LicenseAgreement;
import oracle.sysman.ccr.collector.install.NetworkConfiguration;
import oracle.sysman.ccr.collector.install.OCMRegistrationPrincipal;
import oracle.sysman.ccr.collector.install.ResponseFile;
import oracle.sysman.ccr.collector.install.ResponseNotFoundException;
import oracle.sysman.ccr.collector.util.UplinkHomeConfigWriter;
import oracle.sysman.ccr.collector.util.UplinkSystemConfigWriter;
import oracle.sysman.ccr.common.ConfigWriter;
import oracle.sysman.ccr.common.FileReadException;
import oracle.sysman.ccr.common.FileWriteException;

class ExportResponseCommand
extends ConfigResponseCommand {
    private String m_strResponseFile;

    ExportResponseCommand(String string) {
        this.m_strResponseFile = string;
    }

    void execute() throws ConfigCommandException {
        ResponseFile responseFile;
        try {
            responseFile = ResponseFile.reconstituteResponseFile(this.m_strResponseFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ResponseNotFoundException(new String[]{this.m_strResponseFile, fileNotFoundException.getMessage()});
        }
        LicenseAgreement licenseAgreement = responseFile.getLicenseInstance();
        NetworkConfiguration networkConfiguration = responseFile.getNetworkConfig();
        OCMRegistrationPrincipal oCMRegistrationPrincipal = responseFile.getRegistrationPrincipal();
        ConfigWriter configWriter = null;
        ConfigWriter configWriter2 = null;
        try {
            configWriter = UplinkSystemConfigWriter.getInstance();
            configWriter2 = UplinkHomeConfigWriter.getInstance();
        }
        catch (FileReadException fileReadException) {
            throw new ConfigReadException(fileReadException.getMessage());
        }
        catch (FileWriteException fileWriteException) {
            throw new ConfigWriteException(fileWriteException.getMessage());
        }
        LicenseAgreement.filterConfigurationProperties(configWriter, configWriter2, licenseAgreement);
        NetworkConfiguration.filterConfigurationProperties(configWriter, configWriter2, networkConfiguration);
        OCMRegistrationPrincipal.filterConfigurationProperties(configWriter, configWriter2, oCMRegistrationPrincipal);
        licenseAgreement.addConfigurationProperties(configWriter, configWriter2);
        if (networkConfiguration != null) {
            networkConfiguration.addConfigurationProperties(configWriter, configWriter2);
        }
        if (oCMRegistrationPrincipal != null) {
            oCMRegistrationPrincipal.addConfigurationProperties(configWriter, configWriter2);
        }
        try {
            configWriter.persistProperties();
            configWriter2.persistProperties();
        }
        catch (FileWriteException fileWriteException) {
            throw new ConfigWriteException(fileWriteException.getMessage());
        }
    }
}

