/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.install;

import HTTPClient.AuthorizationInfo;
import HTTPClient.AuthorizationPrompter;
import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.ProtocolNotSuppException;
import HTTPClient.URI;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.SSLPeerUnverifiedException;
import oracle.sysman.ccr.collector.install.ConfigResponseMsgID;
import oracle.sysman.ccr.collector.install.ConfigurationResponseInfo;
import oracle.sysman.ccr.collector.install.ConnectionException;
import oracle.sysman.ccr.collector.install.InvalidEndPointException;
import oracle.sysman.ccr.collector.install.InvalidRepeaterException;
import oracle.sysman.ccr.collector.install.InvalidValueException;
import oracle.sysman.ccr.collector.install.ProxyInfo;
import oracle.sysman.ccr.collector.install.RepeaterEndPoint;
import oracle.sysman.ccr.collector.install.UnexpectedException;
import oracle.sysman.ccr.collector.util.TestConfig;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.collector.util.UplinkSystemConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.ConfigWriter;
import oracle.sysman.ccr.common.TestMap;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.netmgr.EndPoint;
import oracle.sysman.ccr.netmgr.EndPointAddr;
import oracle.sysman.ccr.netmgr.SSLInitializationException;
import oracle.sysman.ccr.ocmSDK.common.FileSpec;
import oracle.sysman.ccr.util.Host;
import oracle.sysman.ccr.util.OCMProxySpec;
import oracle.sysman.ccr.util.OCMProxySpecException;
import oracle.sysman.ccr.util.Process;
import oracle.sysman.ccr.util.crypt.OCMCrypt;
import oracle.sysman.ccr.util.crypt.OCMEncryptedObject;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class NetworkConfiguration
extends ConfigurationResponseInfo
implements AuthorizationPrompter {
    static final long serialVersionUID = 879263700195084067L;
    public static final String NO_PROXY = "NONE";
    private static final int DEFAULT_PROXY_PORT = 80;
    private static final int SEC_15 = 15000;
    private static final int MAX_PORT_NUMBER = 65535;
    static final String NO_REPEATER = "NONE";
    public static final String PROXY_HOST = "http.proxyHost";
    public static final String PROXY_PORT = "http.proxyPort";
    public static final String PROXY_USER = "http.proxyUser";
    public static final String PROXY_PWD = "http.proxyPassword";
    private static final String PROXY_PASSWORD_BYTEARRAY = "proxy.passwordbytearray";
    public static final String PROXY_SEED = "ccr.proxypswd.seed";
    public static final String PROXY_SEED_V2 = "ccr.proxypswd.seed.v2";
    public static final String DISCONNECTED = "ccr.disconnected";
    public static final int HTTP_INTERNAL_ERROR = 500;
    private static final String SUBTEST_NO_DIRECT_CONNECTION = "noDirectConnection";
    private static final String SUBTEST_PROXY_REQD = "proxyreqd";
    private static RE s_emctlRegExp;
    private static RE s_emctlRegExp1;
    private static RE s_emctlRegExp2;
    private static int s_nDefaultConnectionTimeout;
    private static Logger s_logger;
    private static TestMap s_testMap;
    private transient EndPointAddr m_endPointAddr;
    private boolean m_bProxyNONE;
    private String m_strHost;
    private int m_nPort;
    private String m_strUsername;
    private transient byte[] m_arrayChPwd;
    private String m_strProxySeed;
    private String m_strProxySeed_v2;
    private String m_strProxyPwdObfuscated;
    private String m_strRepeaterURI;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$install$NetworkConfiguration;

    public NetworkConfiguration() {
        this.m_bProxyNONE = false;
        this.m_strHost = "";
        this.m_nPort = 80;
        this.m_strUsername = null;
        this.m_arrayChPwd = null;
        this.m_strProxySeed = null;
        this.m_strProxySeed_v2 = null;
        this.m_strProxyPwdObfuscated = null;
        this.m_strRepeaterURI = null;
        try {
            this.m_endPointAddr = UplinkSystemConfig.getOCMServiceEndPoint();
        }
        catch (ParseException parseException) {
            throw new RuntimeException("HTTPClient.ParseException: " + parseException.getMessage());
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("EndPoint configured as: " + this.m_endPointAddr.getURI() + " is_repeater = " + this.m_endPointAddr.getIsRepeater()));
        }
        this.resetProxyInformation();
        oracle.sysman.ccr.common.network.EndPoint.setAuthorizationHandler((AuthorizationPrompter)this);
    }

    NetworkConfiguration(NetworkConfiguration networkConfiguration) {
        block12: {
            this.m_bProxyNONE = false;
            this.m_strHost = "";
            this.m_nPort = 80;
            this.m_strUsername = null;
            this.m_arrayChPwd = null;
            this.m_strProxySeed = null;
            this.m_strProxySeed_v2 = null;
            this.m_strProxyPwdObfuscated = null;
            this.m_strRepeaterURI = null;
            this.m_bProxyNONE = networkConfiguration.m_bProxyNONE;
            this.m_nPort = networkConfiguration.m_nPort;
            if (networkConfiguration.m_strHost != null && networkConfiguration.m_strHost.length() > 0) {
                this.m_strHost = new String(networkConfiguration.m_strHost);
            }
            if (networkConfiguration.m_strUsername != null && networkConfiguration.m_strUsername.length() > 0) {
                this.m_strUsername = new String(networkConfiguration.m_strUsername);
            }
            if (networkConfiguration.m_strProxySeed != null && networkConfiguration.m_strProxySeed.length() > 0) {
                this.m_strProxySeed = new String(networkConfiguration.m_strProxySeed);
            }
            if (networkConfiguration.m_strProxySeed_v2 != null && networkConfiguration.m_strProxySeed_v2.length() > 0) {
                this.m_strProxySeed_v2 = new String(networkConfiguration.m_strProxySeed_v2);
            }
            if (networkConfiguration.m_strProxyPwdObfuscated != null && networkConfiguration.m_strProxyPwdObfuscated.length() > 0) {
                this.m_strProxyPwdObfuscated = new String(networkConfiguration.m_strProxyPwdObfuscated);
            }
            if (networkConfiguration.m_strRepeaterURI != null && networkConfiguration.m_strRepeaterURI.length() > 0) {
                this.m_strRepeaterURI = new String(networkConfiguration.m_strRepeaterURI);
            }
            OCMCrypt oCMCrypt = new OCMCrypt();
            if (this.m_strProxyPwdObfuscated != null) {
                try {
                    this.m_arrayChPwd = oCMCrypt.decrypt(this.m_strProxyPwdObfuscated, this.m_strProxySeed, this.m_strProxySeed_v2).getBytes();
                }
                catch (GeneralSecurityException generalSecurityException) {
                    if (!s_logger.isDebugEnabled()) break block12;
                    s_logger.debug((Object)"Error while decrypting the proxy password");
                }
            }
        }
        try {
            this.m_endPointAddr = this.m_strRepeaterURI != null && !this.m_strRepeaterURI.equals("NONE") ? new EndPointAddr(this.m_strRepeaterURI, true) : UplinkSystemConfig.getOCMServiceEndPoint();
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException.getMessage());
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("EndPoint configured as: " + this.m_endPointAddr.getURI() + " is_repeater = " + this.m_endPointAddr.getIsRepeater()));
        }
        oracle.sysman.ccr.common.network.EndPoint.setAuthorizationHandler((AuthorizationPrompter)this);
    }

    public NetworkConfiguration(Properties properties) {
        this.m_bProxyNONE = false;
        this.m_strHost = "";
        this.m_nPort = 80;
        this.m_strUsername = null;
        this.m_arrayChPwd = null;
        this.m_strProxySeed = null;
        this.m_strProxySeed_v2 = null;
        this.m_strProxyPwdObfuscated = null;
        this.m_strRepeaterURI = null;
        String string = properties.getProperty("ccr.endpoint");
        String string2 = properties.getProperty("ccr.endpoint.is_repeater");
        String string3 = properties.getProperty(PROXY_USER);
        String string4 = properties.getProperty(PROXY_PWD);
        String string5 = properties.getProperty(PROXY_HOST);
        String string6 = properties.getProperty(PROXY_PORT);
        String string7 = properties.getProperty(PROXY_SEED);
        String string8 = properties.getProperty(PROXY_SEED_V2);
        this.resetProxyInformation();
        this.m_nPort = 0;
        if (string6 != null && string6.length() != 0) {
            try {
                this.setProxyPort(Integer.parseInt(string6));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.m_strHost = "";
        if (string5 != null && string5.length() != 0) {
            try {
                this.setProxyHost(string5);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (string3 != null && string3.length() != 0) {
            byte[] byArray;
            block14: {
                this.m_strProxySeed = string7 == null || string7.length() == 0 ? null : string7;
                this.m_strProxySeed_v2 = string8 == null || string8.length() == 0 ? null : string8;
                this.m_strProxyPwdObfuscated = string4 == null || string4.length() == 0 ? null : string4;
                byArray = new byte[]{0};
                OCMCrypt oCMCrypt = new OCMCrypt();
                if (this.m_strProxyPwdObfuscated != null) {
                    try {
                        byArray = oCMCrypt.decrypt(this.m_strProxyPwdObfuscated, this.m_strProxySeed, this.m_strProxySeed_v2).getBytes();
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        if (!s_logger.isDebugEnabled()) break block14;
                        s_logger.debug((Object)"Error while decrypting the proxy password");
                    }
                }
            }
            this.setProxyCreds(string3, byArray);
        }
        if (UplinkHomeConfig.isDisconnected()) {
            this.m_bProxyNONE = true;
        }
        this.m_strRepeaterURI = string2 == null || string2.equalsIgnoreCase("false") ? null : string;
        try {
            this.m_endPointAddr = this.m_strRepeaterURI != null && !this.m_strRepeaterURI.equals("NONE") ? new EndPointAddr(this.m_strRepeaterURI, true) : UplinkSystemConfig.getOCMServiceEndPoint();
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException.getMessage());
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("EndPoint configured as: " + this.m_endPointAddr.getURI() + " is_repeater = " + this.m_endPointAddr.getIsRepeater()));
        }
        oracle.sysman.ccr.common.network.EndPoint.setAuthorizationHandler((AuthorizationPrompter)this);
    }

    public void setProxyHost(String string) throws UnknownHostException {
        if (string.equals("NONE")) {
            this.setNoProxy();
        } else {
            if (!Host.isValidHostname((String)string)) {
                throw new UnknownHostException(ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.ERR_UNKNOWN_PROXY_HOST, false, (Object[])new String[]{string}));
            }
            this.m_bProxyNONE = false;
            this.m_strHost = string;
        }
    }

    public void setNoProxy() {
        this.resetProxyInformation();
        this.m_bProxyNONE = true;
    }

    public void setProxyPort(int n) throws InvalidValueException {
        if (n <= 0 || n > 65535) {
            throw new InvalidValueException(ConfigResponseMsgID.INVALID_PROXY_PORT);
        }
        this.m_bProxyNONE = false;
        this.m_nPort = n;
    }

    public void setProxyCreds(String string, byte[] byArray) {
        this.m_bProxyNONE = false;
        this.m_strUsername = string;
        this.m_arrayChPwd = byArray;
    }

    void setProxyCreds(byte[] byArray) {
        this.m_bProxyNONE = false;
        this.m_arrayChPwd = byArray;
    }

    public static void getProxyInfo(String[] stringArray) {
        UplinkSystemConfig.reload();
        NetworkConfiguration networkConfiguration = new NetworkConfiguration(UplinkSystemConfig.getInstance().getProperties());
        if (networkConfiguration.m_bProxyNONE) {
            return;
        }
        stringArray[0] = networkConfiguration.m_strHost;
        stringArray[1] = String.valueOf(networkConfiguration.m_nPort);
        stringArray[2] = networkConfiguration.m_strUsername;
        stringArray[3] = networkConfiguration.m_strProxyPwdObfuscated;
        stringArray[4] = networkConfiguration.m_strProxySeed;
        stringArray[5] = networkConfiguration.m_strProxySeed_v2;
    }

    public void resetProxyInformation() {
        this.m_strHost = "";
        this.m_nPort = 80;
        this.m_strUsername = null;
        this.m_arrayChPwd = null;
        this.m_bProxyNONE = false;
    }

    void setProxySpecification(String string) throws InvalidValueException, java.text.ParseException, UnknownHostException {
        boolean bl = false;
        OCMProxySpec oCMProxySpec = new OCMProxySpec();
        try {
            oCMProxySpec.validateAndParse(string);
        }
        catch (OCMProxySpecException oCMProxySpecException) {
            switch (oCMProxySpecException.getRetCode()) {
                case 1: {
                    throw new java.text.ParseException(ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.INVALID_PROXY_SPECIFICATION, false), 0);
                }
                case 2: {
                    throw new UnknownHostException(ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.ERR_UNKNOWN_PROXY_HOST, false, (Object[])new String[]{oCMProxySpecException.getParsedValue()}));
                }
                case 3: {
                    throw new InvalidValueException(ConfigResponseMsgID.INVALID_PROXY_PORT);
                }
            }
            throw new java.text.ParseException(ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.INVALID_PROXY_SPECIFICATION, false), 0);
        }
        this.m_bProxyNONE = oCMProxySpec.isProxyNone();
        this.m_nPort = oCMProxySpec.getProxyPort();
        this.m_strHost = oCMProxySpec.getProxyHost();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Proxy host set to: " + this.m_strHost));
        }
        this.m_strUsername = oCMProxySpec.getProxyUser();
        if (this.m_strUsername != null) {
            this.m_strUsername = this.m_strUsername.trim();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Proxy username specified with value of: " + this.m_strUsername));
            }
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Connection properties will be: " + this.populateProxyProperties()));
        }
        this.m_arrayChPwd = null;
    }

    public boolean requiresProxyPwd() {
        boolean bl = false;
        if (this.m_strUsername != null && this.m_strUsername.trim().length() > 0 && this.m_arrayChPwd == null) {
            bl = true;
        }
        return bl;
    }

    public void setRepeaterURI(URI uRI) throws InvalidValueException {
        if (NetworkConfiguration.validateRepeaterURI(uRI)) {
            this.m_strRepeaterURI = uRI.toExternalForm();
            try {
                this.m_endPointAddr = new EndPointAddr(this.m_strRepeaterURI, true);
            }
            catch (ParseException parseException) {
                throw new RuntimeException(parseException.getMessage());
            }
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("EndPoint set to: " + this.m_endPointAddr.getURI() + " is_repeater = " + this.m_endPointAddr.getIsRepeater()));
            }
        }
    }

    private static boolean validateRepeaterURI(URI uRI) throws InvalidValueException {
        String string = uRI.getScheme();
        if (!oracle.sysman.ccr.common.network.EndPoint.isValidScheme((String)string)) {
            throw new InvalidValueException(ConfigResponseMsgID.INVALID_REPEATER_SCHEME);
        }
        String string2 = uRI.getHost();
        if (string2 == null || string2.equals("") || !Host.isValidHostname((String)string2)) {
            throw new InvalidValueException(ConfigResponseMsgID.ERR_UNKNOWN_REPEATER_HOST, new String[]{string2});
        }
        int n = uRI.getPort();
        if (n != -1 && (n <= 0 || n > 65535)) {
            throw new InvalidValueException(ConfigResponseMsgID.INVALID_REPEATER_PORT);
        }
        String string3 = uRI.getPathAndQuery();
        if (string3 != null && string3.length() > 0) {
            throw new InvalidValueException(ConfigResponseMsgID.INVALID_REPEATER_PATH);
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Support Hub URL - Scheme:" + string + " Host:" + string2 + " Port:" + n));
        }
        return true;
    }

    public void resetRepeaterURI() {
        this.m_strRepeaterURI = null;
        try {
            this.m_endPointAddr = UplinkSystemConfig.getOCMServiceEndPoint();
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException.getMessage());
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("EndPoint reset to: " + this.m_endPointAddr.getURI() + " is_repeater = " + this.m_endPointAddr.getIsRepeater()));
        }
    }

    public void declineRepeater() {
        this.m_strRepeaterURI = "NONE";
        Config config = UplinkSystemConfig.getInstance();
        if (config.getProperty("ccr.endpoint.is_repeater", false)) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)"Reloading UplinkSystemConfig files, without highest level ccr.endpoint* properties");
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("ccr.endpoint.is_repeater", null);
            hashMap.put("ccr.endpoint", null);
            UplinkSystemConfig.reloadExcludingProps(hashMap);
        }
        try {
            this.m_endPointAddr = new EndPointAddr(UplinkSystemConfig.getOCMServiceEndPoint().getEndPointString(), false);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException.getMessage());
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("EndPoint set to: " + this.m_endPointAddr.getURI() + " is_repeater = " + this.m_endPointAddr.getIsRepeater()));
        }
    }

    public boolean getIsRepeater() {
        return this.m_endPointAddr.getIsRepeater();
    }

    public String getStrRepeaterURI() {
        return this.m_strRepeaterURI;
    }

    public String getEndPointString() {
        return this.m_endPointAddr.getEndPointString();
    }

    private static void validateEndPoint(EndPoint endPoint) throws InvalidRepeaterException, InvalidEndPointException {
        if (endPoint == null) {
            throw new InvalidEndPointException(ConfigResponseMsgID.ENDPOINT_URI_IS_NULL);
        }
        String string = "/em/upload";
        boolean bl = false;
        if (endPoint.getIsRepeater()) {
            bl = true;
            string = "/ocmrepeater/testIt";
        }
        try {
            HTTPResponse hTTPResponse = null;
            hTTPResponse = endPoint.get(string);
            int n = hTTPResponse.getStatusCode();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Returned from the get " + string + " with a status code of: " + n));
            }
            if (n >= 300) {
                switch (n) {
                    case 408: {
                        if (bl) {
                            throw new InvalidRepeaterException(ConfigResponseMsgID.HTTP_CLIENT_TIMEOUT_REPEATER);
                        }
                        throw new InvalidEndPointException(ConfigResponseMsgID.HTTP_CLIENT_TIMEOUT_ENDPOINT);
                    }
                    case 403: {
                        if (bl) {
                            throw new InvalidRepeaterException(ConfigResponseMsgID.HTTP_FORBIDDEN_REPEATER);
                        }
                        throw new InvalidEndPointException(ConfigResponseMsgID.HTTP_FORBIDDEN_ENDPOINT);
                    }
                    case 500: {
                        if (bl) {
                            throw new InvalidRepeaterException(ConfigResponseMsgID.HTTP_INTERNAL_ERROR_REPEATER, new Object[]{new Integer(n)});
                        }
                        throw new InvalidEndPointException(ConfigResponseMsgID.HTTP_INTERNAL_ERROR_ENDPOINT, new Object[]{new Integer(n)});
                    }
                    case 502: {
                        if (bl) {
                            throw new InvalidRepeaterException(ConfigResponseMsgID.HTTP_BAD_GATEWAY_REPEATER, new Object[]{new Integer(n)});
                        }
                        throw new InvalidEndPointException(ConfigResponseMsgID.HTTP_BAD_GATEWAY_ENDPOINT, new Object[]{new Integer(n)});
                    }
                    case 404: {
                        if (bl) {
                            throw new InvalidRepeaterException(ConfigResponseMsgID.HTTP_NOT_FOUND_REPEATER, new Object[]{new Integer(n)});
                        }
                        throw new InvalidEndPointException(ConfigResponseMsgID.HTTP_NOT_FOUND_ENDPOINT, new Object[]{new Integer(n)});
                    }
                    case 504: {
                        if (bl) {
                            throw new InvalidRepeaterException(ConfigResponseMsgID.HTTP_GATEWAY_TIMEOUT_REPEATER, new Object[]{endPoint.getConnectionURL().toExternalForm()});
                        }
                        throw new InvalidEndPointException(ConfigResponseMsgID.HTTP_GATEWAY_TIMEOUT_ENDPOINT, new Object[]{endPoint.getConnectionURL().toExternalForm()});
                    }
                    case 407: {
                        if (bl) {
                            throw new InvalidRepeaterException(ConfigResponseMsgID.HTTP_PROXY_AUTH);
                        }
                        throw new InvalidEndPointException(ConfigResponseMsgID.HTTP_PROXY_AUTH);
                    }
                }
                if (bl) {
                    throw new InvalidRepeaterException(ConfigResponseMsgID.HTTP_UNKNOWN, new Object[]{new Integer(n), hTTPResponse.getText()});
                }
                throw new InvalidEndPointException(ConfigResponseMsgID.HTTP_UNKNOWN, new Object[]{new Integer(n), hTTPResponse.getText()});
            }
        }
        catch (IOException iOException) {
            if (iOException.getMessage().startsWith("Bug in authorization handling: server refused the given info")) {
                if (bl) {
                    throw new InvalidRepeaterException(ConfigResponseMsgID.HTTP_PROXY_AUTH);
                }
                throw new InvalidEndPointException(ConfigResponseMsgID.HTTP_PROXY_AUTH);
            }
            if (bl) {
                throw new InvalidRepeaterException(ConfigResponseMsgID.UNEXPECTED_ERR, new Object[]{iOException.getMessage()});
            }
            throw new InvalidEndPointException(ConfigResponseMsgID.UNEXPECTED_ERR, new Object[]{iOException.getMessage()});
        }
        catch (ModuleException moduleException) {
            if (bl) {
                throw new InvalidRepeaterException(ConfigResponseMsgID.UNEXPECTED_ERR, new Object[]{moduleException.getMessage()});
            }
            throw new InvalidEndPointException(ConfigResponseMsgID.UNEXPECTED_ERR, new Object[]{moduleException.getMessage()});
        }
        catch (ParseException parseException) {
            if (bl) {
                throw new InvalidRepeaterException(ConfigResponseMsgID.UNEXPECTED_ERR, new Object[]{parseException.getMessage()});
            }
            throw new InvalidEndPointException(ConfigResponseMsgID.UNEXPECTED_ERR, new Object[]{parseException.getMessage()});
        }
    }

    public EndPoint testConnection() throws UnknownHostException, SSLPeerUnverifiedException, IOException {
        EndPoint endPoint = null;
        try {
            endPoint = this.testConnection(true, false);
        }
        catch (InvalidEndPointException invalidEndPointException) {
            throw new RuntimeException("Unexpected exception thrown from testConnection(), testConnection() called with no repeater validation");
        }
        catch (InvalidRepeaterException invalidRepeaterException) {
            throw new RuntimeException("Unexpected exception thrown from testConnection(), testConnection() called with no repeater validation");
        }
        return endPoint;
    }

    public EndPoint testExtendedConnection() throws UnknownHostException, SSLPeerUnverifiedException, IOException, InvalidEndPointException, InvalidRepeaterException {
        return this.testConnection(true, true);
    }

    public static Boolean testExtendedConnectionRefresh() throws SSLPeerUnverifiedException, UnknownHostException, InvalidEndPointException, InvalidRepeaterException, IOException {
        UplinkSystemConfig.reload();
        NetworkConfiguration networkConfiguration = new NetworkConfiguration(UplinkSystemConfig.getInstance().getProperties());
        return new Boolean(networkConfiguration.testExtendedConnection() != null);
    }

    private EndPoint testConnection(boolean bl, boolean bl2) throws UnknownHostException, SSLPeerUnverifiedException, IOException, InvalidEndPointException, InvalidRepeaterException {
        EndPoint endPoint = null;
        if (this.m_strRepeaterURI == null && bl && s_testMap.isUnderTest(SUBTEST_NO_DIRECT_CONNECTION) || this.m_bProxyNONE || bl && s_testMap.isUnderTest(SUBTEST_PROXY_REQD)) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Returning a NULL to a testConnnection request. ProxyNone: " + this.m_bProxyNONE + ", subTestEnabled: " + bl + ", underTest (noDirectConnection): " + s_testMap.isUnderTest(SUBTEST_NO_DIRECT_CONNECTION) + ", underTest (proxyreqd): " + s_testMap.isUnderTest(SUBTEST_PROXY_REQD)));
            }
            endPoint = null;
        } else {
            endPoint = this.connect();
            if (endPoint != null && bl2) {
                NetworkConfiguration.validateEndPoint(endPoint);
            }
        }
        return endPoint;
    }

    private EndPoint connect() throws SSLPeerUnverifiedException, UnknownHostException, IOException {
        EndPoint endPoint = null;
        try {
            if (this.m_strHost == null || this.m_strHost.length() == 0) {
                HTTPConnection.setProxyServer(null, (int)0);
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)"Proxy host is empty; resetting underlying HTTPConnection proxy settings");
                }
            }
            HTTPConnection.setDefaultTimeout((int)15000);
            HTTPConnection.setDefaultConnectionTimeout((int)15000);
            endPoint = new EndPoint(this.m_endPointAddr, this.populateProxyProperties());
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)"Endpoint created for connection");
            }
        }
        catch (SSLInitializationException sSLInitializationException) {
            throw new RuntimeException(((Throwable)((Object)sSLInitializationException)).getMessage());
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException.getMessage());
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException.getMessage());
        }
        catch (ProtocolNotSuppException protocolNotSuppException) {
            throw new RuntimeException(protocolNotSuppException.getMessage());
        }
        finally {
            HTTPConnection.setDefaultConnectionTimeout((int)s_nDefaultConnectionTimeout);
        }
        return endPoint;
    }

    public Properties populateProxyProperties() {
        Properties properties = new Properties();
        if (!this.m_bProxyNONE && this.m_strHost != null && this.m_strHost.length() > 0) {
            ((Hashtable)properties).put(PROXY_HOST, this.m_strHost);
            if (this.m_strUsername != null) {
                ((Hashtable)properties).put(PROXY_USER, this.m_strUsername);
            }
        }
        if (this.m_nPort != 80) {
            ((Hashtable)properties).put(PROXY_PORT, Integer.toString(this.m_nPort));
        }
        return properties;
    }

    public EndPoint getConnection() {
        EndPoint endPoint = null;
        try {
            endPoint = this.testConnection(false, true);
        }
        catch (InvalidEndPointException invalidEndPointException) {
            endPoint = null;
        }
        catch (InvalidRepeaterException invalidRepeaterException) {
            endPoint = null;
        }
        catch (IOException iOException) {
            endPoint = null;
        }
        return endPoint;
    }

    public EndPoint testProxyConnection() throws ConnectionException {
        EndPoint endPoint = null;
        if (this.m_bProxyNONE) {
            return null;
        }
        try {
            endPoint = this.connect();
            if (endPoint != null) {
                NetworkConfiguration.validateEndPoint(endPoint);
            }
        }
        catch (IOException iOException) {
            if (iOException.getMessage().startsWith("Bug in authorization handling: server refused the given info")) {
                throw new InvalidEndPointException(ConfigResponseMsgID.HTTP_PROXY_AUTH);
            }
            return null;
        }
        return endPoint;
    }

    public NVPair getUsernamePassword(AuthorizationInfo authorizationInfo, boolean bl) {
        NVPair nVPair = null;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)"Proxy Authorization being requested");
        }
        if (this.m_strUsername != null && this.m_arrayChPwd != null) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)(this.getClass().getName() + " returning proxy credentials (" + this.m_strUsername + ", ******)"));
            }
            nVPair = new NVPair(this.m_strUsername, new String(this.m_arrayChPwd));
        }
        return nVPair;
    }

    Vector verboseDisplay() {
        CharSequence charSequence;
        Vector<String> vector = new Vector<String>();
        String string = this.m_bProxyNONE ? ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.VERBOSE_NET_STATE_DISCONNECTED, false) : ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.VERBOSE_NET_STATE_CONNECTED, false);
        vector.add(ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.VERBOSE_NET_CONNSTATE, false, (Object[])new String[]{string}));
        if (!this.m_bProxyNONE) {
            charSequence = new StringBuffer();
            if (this.m_strUsername != null && this.m_strUsername.length() > 0) {
                ((StringBuffer)charSequence).append(this.m_strUsername);
                ((StringBuffer)charSequence).append("/********@");
            }
            if (this.m_strHost != null && this.m_strHost.length() > 0) {
                ((StringBuffer)charSequence).append(this.m_strHost);
                if (this.m_nPort != 80) {
                    ((StringBuffer)charSequence).append(":" + this.m_nPort);
                }
            }
            if (((StringBuffer)charSequence).length() == 0) {
                ((StringBuffer)charSequence).append(ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.VERBOSE_NET_PROXY_UNSPECIFIED, false));
            }
            vector.add(ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.VERBOSE_NET_PROXY_CONFIG, false, (Object[])new String[]{((StringBuffer)charSequence).toString()}));
        }
        if (this.m_strRepeaterURI != null) {
            charSequence = this.m_strRepeaterURI;
            if (((String)charSequence).equals("NONE")) {
                charSequence = ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.VERBOSE_REPEATER_DISABLED, false);
            }
            vector.add(ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.VERBOSE_REPEATER_CONFIG, false, (Object[])new String[]{charSequence}));
        }
        return vector;
    }

    public boolean isDisconnectedNetConfig() {
        return this.m_bProxyNONE;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.m_strUsername != null && this.m_strUsername.trim().length() > 0) {
            OCMCrypt oCMCrypt = new OCMCrypt();
            OCMEncryptedObject oCMEncryptedObject = null;
            String string = oCMCrypt.genOCMProxyKey();
            oCMEncryptedObject = oCMCrypt.encrypt(new String(this.m_arrayChPwd), string);
            this.m_strProxyPwdObfuscated = oCMEncryptedObject.getencryptData();
            if (oCMEncryptedObject.getencryptMechanism() == oCMEncryptedObject.getAesAlg()) {
                this.m_strProxySeed_v2 = string;
            } else if (oCMEncryptedObject.getencryptMechanism() == oCMEncryptedObject.getDesAlg()) {
                this.m_strProxySeed = string;
            }
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        OCMCrypt oCMCrypt = new OCMCrypt();
        objectInputStream.defaultReadObject();
        try {
            if (this.m_strProxyPwdObfuscated != null) {
                this.m_arrayChPwd = oCMCrypt.decrypt(this.m_strProxyPwdObfuscated, this.m_strProxySeed, this.m_strProxySeed_v2).getBytes();
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IOException("Error while decrypting password" + generalSecurityException);
        }
    }

    void addConfigurationProperties(ConfigWriter configWriter, ConfigWriter configWriter2) {
        if (this.m_bProxyNONE) {
            configWriter2.setProperty(DISCONNECTED, new Boolean(true).toString());
        } else if (this.m_strHost.trim().length() > 0) {
            configWriter.setProperty(PROXY_HOST, this.m_strHost.trim());
            if (this.m_nPort > 0 && this.m_nPort != 80) {
                configWriter.setProperty(PROXY_PORT, Integer.toString(this.m_nPort));
            }
            if (this.m_strUsername != null && this.m_strUsername.trim().length() > 0) {
                configWriter.setProperty(PROXY_USER, this.m_strUsername);
                if (this.m_strProxySeed_v2 != null && this.m_strProxySeed_v2.length() > 0) {
                    configWriter.setProperty(PROXY_SEED_V2, this.m_strProxySeed_v2);
                    if (this.m_strProxyPwdObfuscated != null && this.m_strProxyPwdObfuscated.length() > 0) {
                        configWriter.setProperty(PROXY_PWD, this.m_strProxyPwdObfuscated);
                    }
                } else if (this.m_strProxySeed != null && this.m_strProxySeed.length() > 0) {
                    configWriter.setProperty(PROXY_SEED, this.m_strProxySeed);
                    if (this.m_strProxyPwdObfuscated != null && this.m_strProxyPwdObfuscated.length() > 0) {
                        configWriter.setProperty(PROXY_PWD, this.m_strProxyPwdObfuscated);
                    }
                } else {
                    OCMCrypt oCMCrypt = new OCMCrypt();
                    OCMEncryptedObject oCMEncryptedObject = null;
                    String string = oCMCrypt.genOCMProxyKey();
                    oCMEncryptedObject = oCMCrypt.encrypt(new String(this.m_arrayChPwd), string);
                    String string2 = oCMEncryptedObject.getencryptData();
                    if (oCMEncryptedObject.getencryptMechanism() == oCMEncryptedObject.getAesAlg()) {
                        if (s_logger.isDebugEnabled()) {
                            s_logger.debug((Object)"AES key ccr.proxypswd.seed.v2 is being stored here");
                        }
                        String string3 = string;
                        configWriter.setProperty(PROXY_SEED_V2, string3);
                        if (configWriter.propertyValue(PROXY_SEED) != null) {
                            configWriter.removeProperty(PROXY_SEED);
                        }
                    } else if (oCMEncryptedObject.getencryptMechanism() == oCMEncryptedObject.getDesAlg()) {
                        if (s_logger.isDebugEnabled()) {
                            s_logger.debug((Object)"DES key ccr.proxypswd.seed is being stored here");
                        }
                        String string4 = string;
                        configWriter.setProperty(PROXY_SEED, string4);
                        if (configWriter.propertyValue(PROXY_SEED_V2) != null) {
                            configWriter.removeProperty(PROXY_SEED_V2);
                        }
                    }
                    if (string2 != null) {
                        configWriter.setProperty(PROXY_PWD, string2);
                    }
                }
            }
        }
        if (this.m_strRepeaterURI != null && !this.m_strRepeaterURI.equals("NONE")) {
            configWriter.setProperty("ccr.endpoint", this.m_strRepeaterURI);
            configWriter.setProperty("ccr.endpoint.is_repeater", Boolean.TRUE.toString());
        }
    }

    static void filterConfigurationProperties(ConfigWriter configWriter, ConfigWriter configWriter2, ConfigurationResponseInfo configurationResponseInfo) {
        boolean bl;
        NetworkConfiguration networkConfiguration = null;
        if (configurationResponseInfo instanceof NetworkConfiguration) {
            networkConfiguration = (NetworkConfiguration)configurationResponseInfo;
        }
        configWriter2.removeProperty(DISCONNECTED);
        configWriter.removeProperty(PROXY_SEED_V2);
        configWriter.removeProperty(PROXY_SEED);
        configWriter.removeProperty(PROXY_HOST);
        configWriter.removeProperty(PROXY_PORT);
        configWriter.removeProperty(PROXY_USER);
        configWriter.removeProperty(PROXY_PWD);
        String string = configWriter.propertyValue("ccr.endpoint.is_repeater");
        if (string != null && (bl = Boolean.valueOf(string).booleanValue()) && networkConfiguration.m_strRepeaterURI != null) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)"The System Config indicates a repeater property.Removing the endpoint and the is_repeater properties.");
            }
            configWriter.removeProperty("ccr.endpoint.is_repeater");
            configWriter.removeProperty("ccr.endpoint");
        }
    }

    public static ProxyInfo getProxyInfoForAgent(String string) {
        String string2;
        File file;
        ProxyInfo proxyInfo = null;
        String string3 = "";
        if (System.getProperty("os.name").startsWith("Windows")) {
            string3 = ".bat";
        }
        if (!(file = new File(string2 = FileSpec.catfile(new String[]{string, "bin", "emctl"}) + string3)).exists()) {
            return null;
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            Process process = Process.exec((String[])new String[]{string2, "config", "agent", "getproxyhostport"}, null, null, null);
            stringBuffer.setLength(0);
            int n = process.waitFor(stringBuffer);
            if (n == 0) {
                String string4 = stringBuffer.toString();
                StringTokenizer stringTokenizer = new StringTokenizer(string4, "\n\r");
                String string5 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    string5 = stringTokenizer.nextToken();
                }
                if (s_emctlRegExp2.match(string5)) {
                    String string6 = s_emctlRegExp2.getParen(1);
                    String string7 = s_emctlRegExp2.getParen(2);
                    int n2 = Integer.parseInt(string7);
                    proxyInfo = ProxyInfo.getInstance(string6, n2);
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return proxyInfo;
    }

    public static RepeaterEndPoint[] getRepeaterEndPoints(String[] stringArray) {
        Vector<Object> vector = new Vector<Object>();
        String string = System.getProperty("os.name").startsWith("Windows") ? ".bat" : "";
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = FileSpec.catfile(new String[]{stringArray[i], "bin", "emctl"}) + string;
            File file = new File(string2);
            if (!file.exists()) continue;
            StringBuffer stringBuffer = new StringBuffer();
            int n = -1;
            try {
                Process process = Process.exec((String[])new String[]{string2, "config", "agent", "getreposurl"}, null, null, null);
                n = process.waitFor(stringBuffer);
                if (n != 0) continue;
                try {
                    Object object;
                    String string3 = stringBuffer.toString();
                    String string4 = null;
                    if (s_emctlRegExp.match(string3)) {
                        string4 = s_emctlRegExp.getParen(1);
                    } else if (s_emctlRegExp1.match(string3)) {
                        string4 = s_emctlRegExp1.getParen(1);
                    }
                    if (string4 == null) continue;
                    EndPointAddr endPointAddr = new EndPointAddr(string4, true);
                    Properties properties = new Properties();
                    Process process2 = Process.exec((String[])new String[]{string2, "config", "agent", "getproxyhostport"}, null, null, null);
                    stringBuffer.setLength(0);
                    int n2 = process2.waitFor(stringBuffer);
                    if (n2 == 0) {
                        string3 = stringBuffer.toString();
                        object = new StringTokenizer(string3, "\n\r");
                        String string5 = "";
                        while (((StringTokenizer)object).hasMoreTokens()) {
                            string5 = ((StringTokenizer)object).nextToken();
                        }
                        if (s_emctlRegExp2.match(string5)) {
                            String string6 = s_emctlRegExp2.getParen(1);
                            ((Hashtable)properties).put(PROXY_HOST, string6);
                            String string7 = s_emctlRegExp2.getParen(2);
                            try {
                                int n3 = Integer.parseInt(string7);
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new UnexpectedException(numberFormatException.getMessage());
                            }
                            ((Hashtable)properties).put(PROXY_PORT, string7);
                        }
                    }
                    object = new RepeaterEndPoint(endPointAddr, properties);
                    NetworkConfiguration.validateEndPoint((EndPoint)object);
                    vector.add(object);
                }
                catch (UnexpectedException unexpectedException) {
                }
                catch (InvalidEndPointException invalidEndPointException) {
                }
                catch (InvalidRepeaterException invalidRepeaterException) {
                }
                catch (ParseException parseException) {
                }
                catch (SSLInitializationException sSLInitializationException) {}
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        RepeaterEndPoint[] repeaterEndPointArray = new RepeaterEndPoint[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            repeaterEndPointArray[i] = (RepeaterEndPoint)vector.elementAt(i);
        }
        return repeaterEndPointArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        s_logger = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$install$NetworkConfiguration == null ? (class$oracle$sysman$ccr$collector$install$NetworkConfiguration = NetworkConfiguration.class$("oracle.sysman.ccr.collector.install.NetworkConfiguration")) : class$oracle$sysman$ccr$collector$install$NetworkConfiguration));
        s_testMap = null;
        Config config = null;
        try {
            config = TestConfig.getInstance();
        }
        catch (IOException iOException) {
            config = null;
        }
        s_testMap = new TestMap(class$oracle$sysman$ccr$collector$install$NetworkConfiguration == null ? (class$oracle$sysman$ccr$collector$install$NetworkConfiguration = NetworkConfiguration.class$("oracle.sysman.ccr.collector.install.NetworkConfiguration")) : class$oracle$sysman$ccr$collector$install$NetworkConfiguration, config);
        s_nDefaultConnectionTimeout = HTTPConnection.getDefaultConnectionTimeout();
        try {
            s_emctlRegExp = new RE(".*(http.*)/em/upload");
            s_emctlRegExp1 = new RE(".*(http.*)/empbs/upload");
            s_emctlRegExp2 = new RE("^(.*):(.*)$");
        }
        catch (RESyntaxException rESyntaxException) {
            // empty catch block
        }
    }
}

