/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.install;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import oracle.sysman.ccr.collector.install.ConfigResponseMsgID;
import oracle.sysman.ccr.collector.install.CorruptResponseFileException;
import oracle.sysman.ccr.collector.install.LicenseAgreement;
import oracle.sysman.ccr.collector.install.NetworkConfiguration;
import oracle.sysman.ccr.collector.install.OCMRegistrationPrincipal;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.network.JCEInitializationException;

class ResponseFile
implements Serializable {
    private static MessageBundle s_msgBundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.install.ConfigResponse");
    static final long serialVersionUID = 9090483824440652733L;
    private static final String RESPONSE_FILE_VER = "10.3.0.0.0";
    private static final String OS_USER = "user.name";
    private static final String UNKNOWN = "UNKNOWN";
    private LicenseAgreement m_license;
    private NetworkConfiguration m_networkConfig;
    private OCMRegistrationPrincipal m_principal;
    private String m_strResponseVersion = "10.3.0.0.0";
    private Date m_dateCreation = null;
    private String m_strCreator = "UNKNOWN";

    ResponseFile(LicenseAgreement licenseAgreement, NetworkConfiguration networkConfiguration, OCMRegistrationPrincipal oCMRegistrationPrincipal) {
        this.m_license = licenseAgreement;
        this.m_networkConfig = networkConfiguration;
        this.m_principal = oCMRegistrationPrincipal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void concentrateResponseFile(String string) throws IOException {
        File file = null;
        FileOutputStream fileOutputStream = null;
        try {
            this.m_dateCreation = new Date();
            this.m_strCreator = System.getProperty(OS_USER);
            file = new File(string);
            fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static ResponseFile reconstituteResponseFile(String string) throws FileNotFoundException, CorruptResponseFileException {
        ResponseFile responseFile = null;
        File file = new File(string);
        if (file.isDirectory()) {
            String string2 = s_msgBundle.getMessage(ConfigResponseMsgID.OCM_RESPONSE_ISDIR, false, new Object[]{string});
            throw new FileNotFoundException(string2);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                responseFile = (ResponseFile)objectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new CorruptResponseFileException(string);
            }
            catch (JCEInitializationException jCEInitializationException) {
                throw jCEInitializationException;
            }
            catch (IOException iOException) {
                throw new CorruptResponseFileException(string);
            }
            catch (RuntimeException runtimeException) {
                throw new CorruptResponseFileException(string);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                if (fileInputStream == null) throw throwable;
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (fileInputStream == null) return responseFile;
        fileInputStream.close();
        return responseFile;
    }

    String getCreationDate() {
        if (this.m_dateCreation != null) {
            return DateFormat.getDateTimeInstance().format(this.m_dateCreation);
        }
        return UNKNOWN;
    }

    String getCreator() {
        return this.m_strCreator;
    }

    String getVersion() {
        return this.m_strResponseVersion;
    }

    LicenseAgreement getLicenseInstance() {
        return this.m_license;
    }

    NetworkConfiguration getNetworkConfig() {
        return this.m_networkConfig;
    }

    OCMRegistrationPrincipal getRegistrationPrincipal() {
        return this.m_principal;
    }
}

